"use strict";

var t = _interopRequireWildcard(require("io-ts"));

var _create_server_route_repository = require("./create_server_route_repository");

var _decode_request_params = require("./decode_request_params");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function assertType(value) {
  return value;
} // Generic arguments for createServerRouteRepository should be set,
// if not, registering routes should not be allowed


(0, _create_server_route_repository.createServerRouteRepository)().add({
  // @ts-expect-error
  endpoint: 'any_endpoint',
  // @ts-expect-error
  handler: async ({
    params
  }) => {}
}); // If a params codec is not set, its type should not be available in
// the request handler.

(0, _create_server_route_repository.createServerRouteRepository)().add({
  endpoint: 'endpoint_without_params',
  handler: async resources => {
    // @ts-expect-error Argument of type '{}' is not assignable to parameter of type '{ params: any; }'.
    assertType(resources);
  }
}); // If a params codec is set, its type _should_ be available in the
// request handler.

(0, _create_server_route_repository.createServerRouteRepository)().add({
  endpoint: 'endpoint_with_params',
  params: t.type({
    path: t.type({
      serviceName: t.string
    })
  }),
  handler: async resources => {
    assertType(resources);
  }
}); // Resources should be passed to the request handler.

(0, _create_server_route_repository.createServerRouteRepository)().add({
  endpoint: 'endpoint_with_params',
  params: t.type({
    path: t.type({
      serviceName: t.string
    })
  }),
  handler: async ({
    context
  }) => {
    const spaceId = context.getSpaceId();
    assertType(spaceId);
  }
}); // Create options are available when registering a route.

(0, _create_server_route_repository.createServerRouteRepository)().add({
  endpoint: 'endpoint_with_params',
  params: t.type({
    path: t.type({
      serviceName: t.string
    })
  }),
  options: {
    tags: []
  },
  handler: async resources => {
    assertType(resources);
  }
});
const repository = (0, _create_server_route_repository.createServerRouteRepository)().add({
  endpoint: 'endpoint_without_params',
  handler: async () => {
    return {
      noParamsForMe: true
    };
  }
}).add({
  endpoint: 'endpoint_with_params',
  params: t.type({
    path: t.type({
      serviceName: t.string
    })
  }),
  handler: async () => {
    return {
      yesParamsForMe: true
    };
  }
}).add({
  endpoint: 'endpoint_with_optional_params',
  params: t.partial({
    query: t.partial({
      serviceName: t.string
    })
  }),
  handler: async () => {
    return {
      someParamsForMe: true
    };
  }
});
// EndpointOf should return all valid endpoints of a repository
assertType(['endpoint_with_params', 'endpoint_without_params', 'endpoint_with_optional_params']); // @ts-expect-error Type '"this_endpoint_does_not_exist"' is not assignable to type '"endpoint_without_params" | "endpoint_with_params" | "endpoint_with_optional_params"'

assertType(['this_endpoint_does_not_exist']); // ReturnOf should return the return type of a request handler.

assertType({
  noParamsForMe: true
});
const noParamsInvalid = {
  // @ts-expect-error type '{ paramsForMe: boolean; }' is not assignable to type '{ noParamsForMe: boolean; }'.
  paramsForMe: true
}; // RouteRepositoryClient

const client = {}; // It should respect any additional create options.
// @ts-expect-error Property 'timeout' is missing

client({
  endpoint: 'endpoint_without_params'
});
client({
  endpoint: 'endpoint_without_params',
  timeout: 1
}); // It does not allow params for routes without a params codec

client({
  endpoint: 'endpoint_without_params',
  // @ts-expect-error Object literal may only specify known properties, and 'params' does not exist in type
  params: {},
  timeout: 1
}); // It requires params for routes with a params codec

client({
  endpoint: 'endpoint_with_params',
  params: {
    // @ts-expect-error property 'serviceName' is missing in type '{}'
    path: {}
  },
  timeout: 1
}); // Params are optional if the codec has no required keys

client({
  endpoint: 'endpoint_with_optional_params',
  timeout: 1
}); // If optional, an error will still occur if the params do not match

client({
  endpoint: 'endpoint_with_optional_params',
  timeout: 1,
  params: {
    // @ts-expect-error Object literal may only specify known properties, and 'path' does not exist in type
    path: ''
  }
}); // The return type is correctly inferred

client({
  endpoint: 'endpoint_with_params',
  params: {
    path: {
      serviceName: ''
    }
  },
  timeout: 1
}).then(res => {
  assertType(res);
  assertType(res);
}); // decodeRequestParams should return the type of the codec that is passed

assertType((0, _decode_request_params.decodeRequestParams)({
  params: {
    serviceName: 'serviceName'
  },
  body: undefined,
  query: undefined
}, t.type({
  path: t.type({
    serviceName: t.string
  })
})));
assertType( // @ts-expect-error The types of 'path.serviceName' are incompatible between these types.
(0, _decode_request_params.decodeRequestParams)({
  params: {
    serviceName: 'serviceName'
  },
  body: undefined,
  query: undefined
}, t.type({
  path: t.type({
    serviceName: t.string
  })
})));