"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatRequest = formatRequest;

var _parse_endpoint = require("./parse_endpoint");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function formatRequest(endpoint, pathParams = {}) {
  const {
    method,
    pathname: rawPathname
  } = (0, _parse_endpoint.parseEndpoint)(endpoint); // replace template variables with path params

  const pathname = Object.keys(pathParams).reduce((acc, paramName) => {
    return acc.replace(`{${paramName}}`, pathParams[paramName]);
  }, rawPathname);
  return {
    method,
    pathname
  };
}