/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { getGeneralFilters } from '../get_general_filters';
import { getSavedObjectTypes } from '../get_saved_object_types';
import { getTrustedAppsFilter } from '../get_trusted_apps_filter';
import { getEventFiltersFilter } from '../get_event_filters_filter';
import { getHostIsolationExceptionsFilter } from '../get_host_isolation_exceptions_filter';
export var getFilters = function getFilters(_ref) {
  var filters = _ref.filters,
      namespaceTypes = _ref.namespaceTypes,
      showTrustedApps = _ref.showTrustedApps,
      showEventFilters = _ref.showEventFilters,
      showHostIsolationExceptions = _ref.showHostIsolationExceptions;
  var namespaces = getSavedObjectTypes({
    namespaceType: namespaceTypes
  });
  var generalFilters = getGeneralFilters(filters, namespaces);
  var trustedAppsFilter = getTrustedAppsFilter(showTrustedApps, namespaces);
  var eventFiltersFilter = getEventFiltersFilter(showEventFilters, namespaces);
  var hostIsolationExceptionsFilter = getHostIsolationExceptionsFilter(showHostIsolationExceptions, namespaces);
  return [generalFilters, trustedAppsFilter, eventFiltersFilter, hostIsolationExceptionsFilter].filter(function (filter) {
    return filter.trim() !== '';
  }).join(' AND ');
};