/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';

/**
 * Types the NonEmptyString as:
 *   - A string that is not empty
 */
export var NonEmptyString = new t.Type('NonEmptyString', t.string.is, function (input, context) {
  if (typeof input === 'string' && input.trim() !== '') {
    return t.success(input);
  } else {
    return t.failure(input, context);
  }
}, t.identity);