/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';

/**
 * Types the nonEmptyOrNullableStringArray as:
 *   - An array of non empty strings of length 1 or greater
 *   - This differs from NonEmptyStringArray in that both input and output are type array
 *
 */
export var nonEmptyOrNullableStringArray = new t.Type('NonEmptyOrNullableStringArray', t.array(t.string).is, function (input, context) {
  var emptyValueFound = Array.isArray(input) && input.some(function (value) {
    return value === '';
  });
  var nonStringValueFound = Array.isArray(input) && input.some(function (value) {
    return typeof value !== 'string';
  });

  if (Array.isArray(input) && (emptyValueFound || nonStringValueFound || input.length === 0)) {
    return t.failure(input, context);
  } else {
    return t.array(t.string).validate(input, context);
  }
}, t.identity);