/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';
import { DefaultUuid } from '@kbn/securitysolution-io-ts-types';
import { DefaultCreateCommentsArray } from '../../common/default_create_comments_array';
import { osTypeArrayOrUndefined } from '../../common/os_type';
import { description } from '../../common/description';
import { list_id } from '../../common/list_id';
import { name } from '../../common/name';
import { exceptionListItemType } from '../../common/exception_list_item_type';
import { meta } from '../../common/meta';
import { namespace_type } from '../../common/namespace_type';
import { tags } from '../../common/tags';
import { nonEmptyEntriesArray } from '../../common/non_empty_entries_array';
export var createExceptionListItemSchema = t.intersection([t.exact(t.type({
  description: description,
  entries: nonEmptyEntriesArray,
  list_id: list_id,
  name: name,
  type: exceptionListItemType
})), t.exact(t.partial({
  comments: DefaultCreateCommentsArray,
  // defaults to empty array if not set during decode
  item_id: DefaultUuid,
  // defaults to GUID (uuid v4) if not set during decode
  meta: meta,
  // defaults to undefined if not set during decode
  namespace_type: namespace_type,
  // defaults to 'single' if not set during decode
  os_types: osTypeArrayOrUndefined,
  // defaults to empty array if not set during decode
  tags: tags // defaults to empty array if not set during decode

}))]);