"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.patchListSchema = void 0;

var t = _interopRequireWildcard(require("io-ts"));

var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");

var _id = require("../../common/id");

var _underscore_version = require("../../common/underscore_version");

var _meta = require("../../common/meta");

var _name = require("../../common/name");

var _description = require("../../common/description");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const patchListSchema = t.intersection([t.exact(t.type({
  id: _id.id
})), t.exact(t.partial({
  _version: _underscore_version._version,
  // is undefined if not set during decode
  description: _description.description,
  // is undefined if not set during decode
  meta: _meta.meta,
  // is undefined if not set during decode
  name: _name.name,
  // is undefined if not set during decode
  version: _securitysolutionIoTsTypes.version // is undefined if not set during decode

}))]);
exports.patchListSchema = patchListSchema;