"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findListItemSchema = void 0;

var t = _interopRequireWildcard(require("io-ts"));

var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");

var _filter = require("../../common/filter");

var _cursor = require("../../common/cursor");

var _sort_field = require("../../common/sort_field");

var _sort_order = require("../../common/sort_order");

var _list_id = require("../../common/list_id");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const findListItemSchema = t.intersection([t.exact(t.type({
  list_id: _list_id.list_id
})), t.exact(t.partial({
  cursor: _cursor.cursor,
  // defaults to undefined if not set during decode
  filter: _filter.filter,
  // defaults to undefined if not set during decode
  page: _securitysolutionIoTsTypes.StringToPositiveNumber,
  // defaults to undefined if not set during decode
  per_page: _securitysolutionIoTsTypes.StringToPositiveNumber,
  // defaults to undefined if not set during decode
  sort_field: _sort_field.sort_field,
  // defaults to undefined if not set during decode
  sort_order: _sort_order.sort_order // defaults to undefined if not set during decode

}))]);
exports.findListItemSchema = findListItemSchema;