/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/* eslint-disable @typescript-eslint/naming-convention */
import * as t from 'io-ts';
import { operator } from '@kbn/securitysolution-io-ts-types';
import { severity } from '../severity';
export var severity_mapping_field = t.string;
export var severity_mapping_value = t.string;
export var severity_mapping_item = t.exact(t.type({
  field: severity_mapping_field,
  operator: operator,
  value: severity_mapping_value,
  severity: severity
}));
export var severity_mapping = t.array(severity_mapping_item);
export var severityMappingOrUndefined = t.union([severity_mapping, t.undefined]);