/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';

/**
 * Types the ReferencesDefaultArray as:
 *   - If null or undefined, then a default array will be set
 */
export var ReferencesDefaultArray = new t.Type('referencesWithDefaultArray', t.array(t.string).is, function (input, context) {
  return input == null ? t.success([]) : t.array(t.string).validate(input, context);
}, t.identity);