/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';
import { parseScheduleDates } from '@kbn/securitysolution-io-ts-utils';

var stringValidator = function stringValidator(input) {
  return typeof input === 'string';
};

export var from = new t.Type('From', t.string.is, function (input, context) {
  if (stringValidator(input) && parseScheduleDates(input) == null) {
    return t.failure(input, context, 'Failed to parse "from" on rule param');
  }

  return t.string.validate(input, context);
}, t.identity);
export var fromOrUndefined = t.union([from, t.undefined]);