"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.legacyLoggingConfigSchema = void 0;

var _configSchema = require("@kbn/config-schema");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const legacyLoggingConfigSchema = _configSchema.schema.object({
  silent: _configSchema.schema.boolean({
    defaultValue: false
  }),
  quiet: _configSchema.schema.conditional(_configSchema.schema.siblingRef('silent'), true, _configSchema.schema.boolean({
    defaultValue: true,
    validate: quiet => {
      if (!quiet) {
        return 'must be true when `silent` is  true';
      }
    }
  }), _configSchema.schema.boolean({
    defaultValue: false
  })),
  verbose: _configSchema.schema.conditional(_configSchema.schema.siblingRef('quiet'), true, _configSchema.schema.boolean({
    defaultValue: false,
    validate: verbose => {
      if (verbose) {
        return 'must be false when `quiet` is  true';
      }
    }
  }), _configSchema.schema.boolean({
    defaultValue: false
  })),
  events: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any(), {
    defaultValue: {}
  }),
  dest: _configSchema.schema.string({
    defaultValue: 'stdout'
  }),
  filter: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any(), {
    defaultValue: {}
  }),
  json: _configSchema.schema.conditional(_configSchema.schema.siblingRef('dest'), 'stdout', _configSchema.schema.boolean({
    defaultValue: !process.stdout.isTTY
  }), _configSchema.schema.boolean({
    defaultValue: true
  })),
  timezone: _configSchema.schema.maybe(_configSchema.schema.string()),
  rotate: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    }),
    everyBytes: _configSchema.schema.number({
      min: 1048576,
      // > 1MB
      max: 1073741825,
      // < 1GB
      defaultValue: 10485760 // 10MB

    }),
    keepFiles: _configSchema.schema.number({
      min: 2,
      max: 1024,
      defaultValue: 7
    }),
    pollingInterval: _configSchema.schema.number({
      min: 5000,
      max: 3600000,
      defaultValue: 10000
    }),
    usePolling: _configSchema.schema.boolean({
      defaultValue: false
    })
  })
});

exports.legacyLoggingConfigSchema = legacyLoggingConfigSchema;