"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metadataSymbol = exports.isEventData = exports.getLogEventData = exports.attachMetaData = void 0;

var _lodash = require("lodash");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const metadataSymbol = Symbol('log message with metadata');
exports.metadataSymbol = metadataSymbol;

const isEventData = eventData => {
  return Boolean((0, _lodash.isPlainObject)(eventData) && eventData[metadataSymbol]);
};

exports.isEventData = isEventData;

const getLogEventData = eventData => {
  const {
    message,
    metadata
  } = eventData[metadataSymbol];
  return { ...metadata,
    message
  };
};

exports.getLogEventData = getLogEventData;

const attachMetaData = (message, metadata = {}) => {
  return {
    [metadataSymbol]: {
      message,
      metadata
    }
  };
};

exports.attachMetaData = attachMetaData;