/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import moment from 'moment-timezone';

/** @internal */
export function getTimeZoneFromSettings(dateFormatTZ) {
  var detectedTimezone = moment.tz.guess();
  return dateFormatTZ === 'Browser' ? detectedTimezone : dateFormatTZ;
}
export function isDataViewFieldSubtypeNested(field) {
  var _subTypeNested$nested;

  var subTypeNested = field === null || field === void 0 ? void 0 : field.subType;
  return !!(subTypeNested !== null && subTypeNested !== void 0 && (_subTypeNested$nested = subTypeNested.nested) !== null && _subTypeNested$nested !== void 0 && _subTypeNested$nested.path);
}
export function getDataViewFieldSubtypeNested(field) {
  return isDataViewFieldSubtypeNested(field) ? field.subType : undefined;
}
export function isDataViewFieldSubtypeMulti(field) {
  var _subTypeNested$multi;

  var subTypeNested = field === null || field === void 0 ? void 0 : field.subType;
  return !!(subTypeNested !== null && subTypeNested !== void 0 && (_subTypeNested$multi = subTypeNested.multi) !== null && _subTypeNested$multi !== void 0 && _subTypeNested$multi.parent);
}
export function getDataViewFieldSubtypeMulti(field) {
  return isDataViewFieldSubtypeMulti(field) ? field.subType : undefined;
}