/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import _ from 'lodash';
import * as ast from '../ast';
import { nodeTypes } from '../node_types';
export function buildNode(name, value) {
  var argumentNode = _.get(value, 'type') === 'literal' ? value : nodeTypes.literal.buildNode(value);
  return {
    type: 'namedArg',
    name: name,
    value: argumentNode
  };
}
export function toElasticsearchQuery(node) {
  return ast.toElasticsearchQuery(node.value);
}