import _objectSpread from "@babel/runtime/helpers/objectSpread2";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import _ from 'lodash';
import { functions } from '../functions';
export function buildNode(functionName) {
  var kueryFunction = functions[functionName];

  if (_.isUndefined(kueryFunction)) {
    throw new Error("Unknown function \"".concat(functionName, "\""));
  }

  for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    args[_key - 1] = arguments[_key];
  }

  return _objectSpread({
    type: 'function',
    "function": functionName
  }, kueryFunction.buildNodeParams.apply(kueryFunction, args));
} // Mainly only useful in the grammar where we'll already have real argument nodes in hand

export function buildNodeWithArgumentNodes(functionName, args) {
  if (_.isUndefined(functions[functionName])) {
    throw new Error("Unknown function \"".concat(functionName, "\""));
  }

  return {
    type: 'function',
    "function": functionName,
    arguments: args
  };
}
export function toElasticsearchQuery(node, indexPattern, config, context) {
  var kueryFunction = functions[node["function"]];
  return kueryFunction.toElasticsearchQuery(node, indexPattern, config, context);
}