import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _createSuper from "@babel/runtime/helpers/createSuper";
import _wrapNativeSuper from "@babel/runtime/helpers/wrapNativeSuper";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { repeat, uniq } from 'lodash';
import { i18n } from '@kbn/i18n';
var endOfInputText = i18n.translate('esQuery.kql.errors.endOfInputText', {
  defaultMessage: 'end of input'
});
var grammarRuleTranslations = {
  fieldName: i18n.translate('esQuery.kql.errors.fieldNameText', {
    defaultMessage: 'field name'
  }),
  value: i18n.translate('esQuery.kql.errors.valueText', {
    defaultMessage: 'value'
  }),
  literal: i18n.translate('esQuery.kql.errors.literalText', {
    defaultMessage: 'literal'
  }),
  whitespace: i18n.translate('esQuery.kql.errors.whitespaceText', {
    defaultMessage: 'whitespace'
  })
};

var getItemText = function getItemText(item) {
  if (item.type === 'other') {
    return item.description;
  } else if (item.type === 'literal') {
    return "\"".concat(item.text, "\"");
  } else if (item.type === 'end') {
    return 'end of input';
  } else {
    return item.text || item.description || '';
  }
};

/**
 * A type of error indicating KQL syntax errors
 * @public
 */
export var KQLSyntaxError = /*#__PURE__*/function (_Error) {
  _inherits(KQLSyntaxError, _Error);

  var _super = _createSuper(KQLSyntaxError);

  function KQLSyntaxError(error, expression) {
    var _this;

    _classCallCheck(this, KQLSyntaxError);

    var message = error.message;

    if (error.expected) {
      var translatedExpectations = error.expected.map(function (expected) {
        var key = getItemText(expected);
        return grammarRuleTranslations[key] || key;
      });
      var translatedExpectationText = uniq(translatedExpectations).filter(function (item) {
        return item !== undefined;
      }).sort().join(', ');
      message = i18n.translate('esQuery.kql.errors.syntaxError', {
        defaultMessage: 'Expected {expectedList} but {foundInput} found.',
        values: {
          expectedList: translatedExpectationText,
          foundInput: error.found ? "\"".concat(error.found, "\"") : endOfInputText
        }
      });
    }

    var fullMessage = [message, expression, repeat('-', error.location.start.offset) + '^'].join('\n');
    _this = _super.call(this, fullMessage);

    _defineProperty(_assertThisInitialized(_this), "shortMessage", void 0);

    _this.name = 'KQLSyntaxError';
    _this.shortMessage = message;
    return _this;
  }

  return KQLSyntaxError;
}( /*#__PURE__*/_wrapNativeSuper(Error));