import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _objectSpread from "@babel/runtime/helpers/objectSpread2";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { getFields } from './get_fields';
import { getDataViewFieldSubtypeNested } from '../../../utils';
export function getFullFieldNameNode(rootNameNode, indexPattern, nestedPath) {
  var fullFieldNameNode = _objectSpread(_objectSpread({}, rootNameNode), {}, {
    value: nestedPath ? "".concat(nestedPath, ".").concat(rootNameNode.value) : rootNameNode.value
  }); // Wildcards can easily include nested and non-nested fields. There isn't a good way to let
  // users handle this themselves so we automatically add nested queries in this scenario and skip the
  // error checking below.


  if (!indexPattern || fullFieldNameNode.type === 'wildcard' && !nestedPath) {
    return fullFieldNameNode;
  }

  var fields = getFields(fullFieldNameNode, indexPattern);
  var errors = fields.reduce(function (acc, field) {
    var subTypeNested = getDataViewFieldSubtypeNested(field);
    var nestedPathFromField = subTypeNested === null || subTypeNested === void 0 ? void 0 : subTypeNested.nested.path;

    if (nestedPath && !nestedPathFromField) {
      return [].concat(_toConsumableArray(acc), ["".concat(field.name, " is not a nested field but is in nested group \"").concat(nestedPath, "\" in the KQL expression.")]);
    }

    if (nestedPathFromField && !nestedPath) {
      return [].concat(_toConsumableArray(acc), ["".concat(field.name, " is a nested field, but is not in a nested group in the KQL expression.")]);
    }

    if (nestedPathFromField !== nestedPath) {
      return [].concat(_toConsumableArray(acc), ["Nested field ".concat(field.name, " is being queried with the incorrect nested path. The correct path is ").concat(subTypeNested === null || subTypeNested === void 0 ? void 0 : subTypeNested.nested.path, ".")]);
    }

    return acc;
  }, []);

  if (errors.length > 0) {
    throw new Error(errors.join('\n'));
  }

  return fullFieldNameNode;
}