/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { filter } from 'lodash';
import { compareFilters, COMPARE_ALL_OPTIONS } from './compare_filters';

var isEnabled = function isEnabled(f) {
  return f && f.meta && !f.meta.disabled;
};
/**
 * Checks to see if only disabled filters have been changed
 * @returns {bool} Only disabled filters
 *
 * @public
 */


export var onlyDisabledFiltersChanged = function onlyDisabledFiltersChanged(newFilters, oldFilters) {
  // If it's the same - compare only enabled filters
  var newEnabledFilters = filter(newFilters || [], isEnabled);
  var oldEnabledFilters = filter(oldFilters || [], isEnabled);
  return compareFilters(oldEnabledFilters, newEnabledFilters, COMPARE_ALL_OPTIONS);
};