/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { filter, find } from 'lodash';
import { compareFilters } from './compare_filters';
/**
 * Combine 2 filter collections, removing duplicates
 *
 * @param {object} existingFilters - The filters to compare to
 * @param {object} filters - The filters being added
 * @param {object} comparatorOptions - Parameters to use for comparison
 *
 * @returns {object} An array of filters that were not in existing
 *
 * @internal
 */

export var dedupFilters = function dedupFilters(existingFilters, filters) {
  var comparatorOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

  if (!Array.isArray(filters)) {
    filters = [filters];
  }

  return filter(filters, function (f) {
    return !find(existingFilters, function (existingFilter) {
      return compareFilters(existingFilter, f, comparatorOptions);
    });
  });
};