"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildCustomFilter = buildCustomFilter;

var _types = require("./types");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 *
 * @param indexPatternString
 * @param queryDsl
 * @param disabled
 * @param negate
 * @param alias
 * @param store
 * @returns
 *
 * @public
 */
function buildCustomFilter(indexPatternString, queryDsl, disabled, negate, alias, store) {
  const meta = {
    index: indexPatternString,
    type: _types.FILTERS.CUSTOM,
    disabled,
    negate,
    alias
  };
  const filter = { ...queryDsl,
    meta
  };
  filter.$state = {
    store
  };
  return filter;
}