"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildEmptyFilter = void 0;

var _types = require("./types");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const buildEmptyFilter = (isPinned, index) => {
  const meta = {
    disabled: false,
    negate: false,
    alias: null,
    index
  };
  const $state = {
    store: isPinned ? _types.FilterStateStore.GLOBAL_STATE : _types.FilterStateStore.APP_STATE
  };
  return {
    meta,
    $state
  };
};

exports.buildEmptyFilter = buildEmptyFilter;