/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Export types separately to the actual run-time objects
export { createUiCounterMetric } from './ui_counter';
export { trackUsageAgent } from './user_agent';
export { createApplicationUsageMetric } from './application_usage';
export var METRIC_TYPE;

(function (METRIC_TYPE) {
  METRIC_TYPE["COUNT"] = "count";
  METRIC_TYPE["LOADED"] = "loaded";
  METRIC_TYPE["CLICK"] = "click";
  METRIC_TYPE["USER_AGENT"] = "user_agent";
  METRIC_TYPE["APPLICATION_USAGE"] = "application_usage";
})(METRIC_TYPE || (METRIC_TYPE = {}));