"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.COLORS = exports.TYPES = exports.appendIconComponentCache = exports.EuiIcon = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiIcon = function EuiIcon(_ref) {
  var type = _ref.type,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["type"]);
  return /*#__PURE__*/_react.default.createElement("span", (0, _extends2.default)({
    "data-euiicon-type": typeof type === 'string' ? type : type.displayName || type.name
  }, rest));
};

exports.EuiIcon = EuiIcon;

var appendIconComponentCache = function appendIconComponentCache(_) {// manually appending to the internal EuiIcon cache is out-of-scope of this test environment
};

exports.appendIconComponentCache = appendIconComponentCache;
var TYPES = [];
exports.TYPES = TYPES;
var COLORS = [];
exports.COLORS = COLORS;
var SIZES = [];
exports.SIZES = SIZES;