"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiHeaderAlert = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _flex = require("../../flex");

var _services = require("../../../services");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiHeaderAlert = function EuiHeaderAlert(_ref) {
  var action = _ref.action,
      className = _ref.className,
      date = _ref.date,
      text = _ref.text,
      title = _ref.title,
      badge = _ref.badge,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["action", "className", "date", "text", "title", "badge"]);
  var classes = (0, _classnames.default)('euiHeaderAlert', className);
  var ariaId = (0, _services.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement("article", (0, _extends2.default)({
    "aria-labelledby": "".concat(ariaId, "-title"),
    className: classes
  }, rest), /*#__PURE__*/_react.default.createElement(_flex.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_flex.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "euiHeaderAlert__date"
  }, date)), badge && /*#__PURE__*/_react.default.createElement(_flex.EuiFlexItem, {
    grow: false
  }, badge)), /*#__PURE__*/_react.default.createElement("h3", {
    id: "".concat(ariaId, "-title"),
    className: "euiHeaderAlert__title"
  }, title), /*#__PURE__*/_react.default.createElement("div", {
    className: "euiHeaderAlert__text"
  }, text), action && /*#__PURE__*/_react.default.createElement("div", {
    className: "euiHeaderAlert__action euiLink"
  }, action));
};

exports.EuiHeaderAlert = EuiHeaderAlert;
EuiHeaderAlert.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * Adds a link to the alert.
       */
  action: _propTypes.default.node,
  date: _propTypes.default.node.isRequired,
  text: _propTypes.default.node,
  title: _propTypes.default.node.isRequired,

  /**
       * Accepts an `EuiBadge` that displays on the alert
       */
  badge: _propTypes.default.node
};