function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
import url from 'url';
import { AbstractEmsService } from './ems_service';
import * as topojson from 'topojson-client';
export var EMSFormatType;

(function (EMSFormatType) {
  EMSFormatType["geojson"] = "geojson";
  EMSFormatType["topojson"] = "topojson";
})(EMSFormatType || (EMSFormatType = {}));

export var FileLayer = /*#__PURE__*/function (_AbstractEmsService) {
  _inherits(FileLayer, _AbstractEmsService);

  var _super = _createSuper(FileLayer);

  function FileLayer(config, emsClient, proxyPath) {
    var _this;

    _classCallCheck(this, FileLayer);

    _this = _super.call(this, config, emsClient, proxyPath);

    _defineProperty(_assertThisInitialized(_this), "_config", void 0);

    _this._config = config;
    return _this;
  }

  _createClass(FileLayer, [{
    key: "getGeoJson",
    value: function () {
      var _getGeoJson = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var cachedGeoJson, format, fetchUrl, geojson, fetchedJson, _meta$feature_collect, meta, featureCollectionPath;

        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                cachedGeoJson = this._emsClient.getCachedGeoJson(this.getId());

                if (!cachedGeoJson) {
                  _context.next = 3;
                  break;
                }

                return _context.abrupt("return", cachedGeoJson);

              case 3:
                format = this.getDefaultFormatType();
                fetchUrl = this.getDefaultFormatUrl();
                _context.next = 7;
                return this._emsClient.getManifest(fetchUrl);

              case 7:
                fetchedJson = _context.sent;

                if (!fetchedJson) {
                  _context.next = 22;
                  break;
                }

                if (!(format === 'geojson')) {
                  _context.next = 13;
                  break;
                }

                geojson = fetchedJson;
                _context.next = 20;
                break;

              case 13:
                if (!(format === 'topojson')) {
                  _context.next = 19;
                  break;
                }

                meta = this.getDefaultFormatMeta();
                featureCollectionPath = (_meta$feature_collect = meta === null || meta === void 0 ? void 0 : meta.feature_collection_path) !== null && _meta$feature_collect !== void 0 ? _meta$feature_collect : 'data'; // @ts-expect-error see https://github.com/DefinitelyTyped/DefinitelyTyped/pull/52156

                geojson = topojson.feature(fetchedJson, featureCollectionPath);
                _context.next = 20;
                break;

              case 19:
                return _context.abrupt("return");

              case 20:
                this._emsClient.cacheGeoJson(this.getId(), geojson);

                return _context.abrupt("return", geojson);

              case 22:
                return _context.abrupt("return");

              case 23:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function getGeoJson() {
        return _getGeoJson.apply(this, arguments);
      }

      return getGeoJson;
    }()
  }, {
    key: "getFields",
    value: function getFields() {
      return this._config.fields;
    }
  }, {
    key: "getFieldsInLanguage",
    value: function getFieldsInLanguage() {
      var _this2 = this;

      return this.getFields().map(function (field) {
        return {
          type: field.type,
          name: field.id,
          description: _this2._emsClient.getValueInLanguage(field.label)
        };
      });
    }
  }, {
    key: "getDisplayName",
    value: function getDisplayName() {
      var layerName = this._emsClient.getValueInLanguage(this._config.layer_name);

      return layerName ? layerName : '';
    }
  }, {
    key: "getId",
    value: function getId() {
      return this._config.layer_id;
    }
  }, {
    key: "hasId",
    value: function hasId(id) {
      var matchesLegacyId = this._config.legacy_ids.indexOf(id) >= 0;
      return this._config.layer_id === id || matchesLegacyId;
    }
  }, {
    key: "getEMSHotLink",
    value: function getEMSHotLink() {
      var landingPageString = this._emsClient.getLandingPageUrl();

      var urlObject = url.parse(landingPageString, true);
      urlObject.hash = "file/".concat(this.getId());
      urlObject.query = _objectSpread(_objectSpread({}, urlObject.query), {}, {
        locale: this._emsClient.getLocale()
      });
      return url.format(urlObject);
    }
  }, {
    key: "getDefaultFormatType",
    value: function getDefaultFormatType() {
      var format = this._getDefaultFormat();

      return format.type;
    }
  }, {
    key: "getFormatOfType",
    value: function getFormatOfType(type) {
      var format = this._getFormatOfType(type);

      return format.type;
    }
  }, {
    key: "getDefaultFormatMeta",
    value: function getDefaultFormatMeta() {
      var format = this._getDefaultFormat();

      return this._getFormatMeta(format);
    }
  }, {
    key: "getFormatOfTypeMeta",
    value: function getFormatOfTypeMeta(type) {
      var format = this._getFormatOfType(type);

      return this._getFormatMeta(format);
    }
  }, {
    key: "getDefaultFormatUrl",
    value: function getDefaultFormatUrl() {
      var format = this._getDefaultFormat();

      return this._getFormatUrl(format);
    }
  }, {
    key: "getFormatOfTypeUrl",
    value: function getFormatOfTypeUrl(type) {
      var format = this._getFormatOfType(type);

      return this._getFormatUrl(format);
    }
  }, {
    key: "getCreatedAt",
    value: function getCreatedAt() {
      return this._config.created_at;
    }
  }, {
    key: "getApiUrl",
    value: function getApiUrl() {
      return this._emsClient.getFileApiUrl();
    }
  }, {
    key: "_getFormatUrl",
    value: function _getFormatUrl(format) {
      var url = this._proxyPath + this._getAbsoluteUrl(format.url);

      return this._emsClient.extendUrlWithParams(url);
    }
  }, {
    key: "_getFormatMeta",
    value: function _getFormatMeta(format) {
      if ('meta' in format) {
        return format.meta;
      } else {
        return;
      }
    }
  }, {
    key: "_getDefaultFormat",
    value: function _getDefaultFormat() {
      var defaultFormat = this._config.formats.find(function (format) {
        return format.legacy_default;
      });

      if (defaultFormat) {
        return defaultFormat;
      }

      return this._config.formats[0];
    }
  }, {
    key: "_getFormatOfType",
    value: function _getFormatOfType(type) {
      var requestedFormat = this._config.formats.find(function (format) {
        return format.type === type;
      });

      return requestedFormat || this._getDefaultFormat();
    }
  }]);

  return FileLayer;
}(AbstractEmsService);