"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getExternalTooltipType = exports.getShowNullValues = exports.getTooltipType = exports.isFollowTooltipType = exports.isCrosshairTooltipType = exports.isTooltipType = exports.isTooltipProps = exports.isPointerOverEvent = exports.isPointerOutEvent = exports.Settings = void 0;
var spec_factory_1 = require("../state/spec_factory");
var constants_1 = require("./constants");
exports.Settings = (0, spec_factory_1.getConnect)()((0, spec_factory_1.specComponentFactory)(constants_1.DEFAULT_SETTINGS_SPEC));
function isPointerOutEvent(event) {
    return (event === null || event === void 0 ? void 0 : event.type) === constants_1.PointerEventType.Out;
}
exports.isPointerOutEvent = isPointerOutEvent;
function isPointerOverEvent(event) {
    return (event === null || event === void 0 ? void 0 : event.type) === constants_1.PointerEventType.Over;
}
exports.isPointerOverEvent = isPointerOverEvent;
function isTooltipProps(config) {
    return typeof config === 'object';
}
exports.isTooltipProps = isTooltipProps;
function isTooltipType(config) {
    return typeof config !== 'object';
}
exports.isTooltipType = isTooltipType;
function isCrosshairTooltipType(type) {
    return type === constants_1.TooltipType.VerticalCursor || type === constants_1.TooltipType.Crosshairs;
}
exports.isCrosshairTooltipType = isCrosshairTooltipType;
function isFollowTooltipType(type) {
    return type === constants_1.TooltipType.Follow;
}
exports.isFollowTooltipType = isFollowTooltipType;
function getTooltipType(settings, externalTooltip) {
    if (externalTooltip === void 0) { externalTooltip = false; }
    var defaultType = constants_1.TooltipType.VerticalCursor;
    if (externalTooltip)
        return getExternalTooltipType(settings);
    var tooltip = settings.tooltip;
    if (tooltip === undefined || tooltip === null)
        return defaultType;
    if (isTooltipType(tooltip))
        return tooltip;
    if (isTooltipProps(tooltip))
        return tooltip.type || defaultType;
    return defaultType;
}
exports.getTooltipType = getTooltipType;
function getShowNullValues(settings) {
    var _a;
    var tooltip = settings.tooltip;
    if (tooltip === undefined || tooltip === null)
        return constants_1.DEFAULT_TOOLTIP_CONFIG.showNullValues;
    if (isTooltipType(tooltip))
        return constants_1.DEFAULT_TOOLTIP_CONFIG.showNullValues;
    if (isTooltipProps(tooltip))
        return (_a = tooltip.showNullValues) !== null && _a !== void 0 ? _a : constants_1.DEFAULT_TOOLTIP_CONFIG.showNullValues;
}
exports.getShowNullValues = getShowNullValues;
function getExternalTooltipType(_a) {
    var visible = _a.externalPointerEvents.tooltip.visible;
    return visible ? constants_1.TooltipType.VerticalCursor : constants_1.TooltipType.None;
}
exports.getExternalTooltipType = getExternalTooltipType;
//# sourceMappingURL=settings.js.map