"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getBrushedHighlightedShapesSelector = void 0;
var create_selector_1 = require("../../../../state/create_selector");
var geometries_1 = require("./geometries");
function getCurrentPointerStates(state) {
    return state.interactions.pointer;
}
exports.getBrushedHighlightedShapesSelector = (0, create_selector_1.createCustomCachedSelector)([geometries_1.geometries, getCurrentPointerStates], function (geoms, pointerStates) {
    if (!pointerStates.dragging || !pointerStates.down) {
        return null;
    }
    return geoms.pickDragShape([pointerStates.down.position, pointerStates.current.position]);
});
//# sourceMappingURL=get_brushed_highlighted_shapes.js.map