"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.isRasterTimeScale = exports.shapeViewModel = void 0;
var d3_array_1 = require("d3-array");
var d3_scale_1 = require("d3-scale");
var color_library_wrappers_1 = require("../../../../common/color_library_wrappers");
var fill_text_color_1 = require("../../../../common/fill_text_color");
var text_utils_1 = require("../../../../common/text_utils");
var scales_1 = require("../../../../scales");
var constants_1 = require("../../../../scales/constants");
var canvas_text_bbox_calculator_1 = require("../../../../utils/bbox/canvas_text_bbox_calculator");
var elasticsearch_1 = require("../../../../utils/chrono/elasticsearch");
var common_1 = require("../../../../utils/common");
var logger_1 = require("../../../../utils/logger");
function getValuesInRange(values, startValue, endValue) {
    var startIndex = values.indexOf(startValue);
    var endIndex = Math.min(values.indexOf(endValue) + 1, values.length);
    return values.slice(startIndex, endIndex);
}
function estimatedNonOverlappingTickCount(chartWidth, _a) {
    var formatter = _a.formatter, padding = _a.padding, fontSize = _a.fontSize, fontFamily = _a.fontFamily;
    return (0, canvas_text_bbox_calculator_1.withTextMeasure)(function (textMeasure) {
        var labelSample = formatter(Date.now());
        var width = textMeasure(labelSample, padding, fontSize, fontFamily).width;
        var maxTicks = chartWidth / width;
        return Math.floor(maxTicks / 2);
    });
}
function shapeViewModel(textMeasure, spec, config, settingsSpec, chartDimensions, heatmapTable, colorScale, bandsToHide, _a, theme) {
    var _b, _c;
    var height = _a.height, pageSize = _a.pageSize;
    var gridStrokeWidth = (_b = config.grid.stroke.width) !== null && _b !== void 0 ? _b : 1;
    var table = heatmapTable.table, yValues = heatmapTable.yValues, xValues = heatmapTable.xValues;
    var boxedYValues = yValues.map(function (value) { return (__assign({ text: config.yAxisLabel.formatter(value), value: value, isValue: false }, config.yAxisLabel)); });
    var yScale = (0, d3_scale_1.scaleBand)().domain(yValues).range([0, height]);
    var yInvertedScale = (0, d3_scale_1.scaleQuantize)().domain([0, height]).range(yValues);
    var xScale = (0, d3_scale_1.scaleBand)().domain(xValues).range([0, chartDimensions.width]);
    var xInvertedScale = (0, d3_scale_1.scaleQuantize)().domain([0, chartDimensions.width]).range(xValues);
    var cellWidth = config.cell.maxWidth !== 'fill' && xScale.bandwidth() > config.cell.maxWidth
        ? config.cell.maxWidth
        : xScale.bandwidth();
    var cellHeight = yScale.bandwidth();
    var currentGridHeight = cellHeight * pageSize;
    var textXValues = getXTicks(spec, config, chartDimensions, xScale, heatmapTable, currentGridHeight);
    var padding = config.yAxisLabel.padding;
    var rightPadding = typeof padding === 'number' ? padding : (_c = padding.right) !== null && _c !== void 0 ? _c : 0;
    var textYValues = boxedYValues.map(function (d) {
        return __assign(__assign({}, d), { x: chartDimensions.left - rightPadding, y: cellHeight / 2 + (yScale(d.value) || 0) });
    });
    var cellWidthInner = cellWidth - gridStrokeWidth * 2;
    var cellHeightInner = cellHeight - gridStrokeWidth * 2;
    if ((0, color_library_wrappers_1.colorToRgba)(theme.background.color)[3] < 1) {
        logger_1.Logger.expected("Text contrast requires a opaque background color, using white as fallback", 'an opaque color', theme.background.color);
    }
    var cellMap = table.reduce(function (acc, d) {
        var x = xScale(String(d.x));
        var y = yScale(String(d.y)) + gridStrokeWidth;
        var yIndex = yValues.indexOf(d.y);
        if (x === undefined || y === undefined || yIndex === -1) {
            return acc;
        }
        var cellBackgroundColor = colorScale(d.value);
        var cellKey = getCellKey(d.x, d.y);
        var formattedValue = spec.valueFormatter(d.value);
        var fontSize = (0, text_utils_1.maximiseFontSize)(textMeasure, formattedValue, config.cell.label, config.cell.label.minFontSize, config.cell.label.maxFontSize, cellWidthInner - 6, cellHeightInner - 6);
        acc[cellKey] = {
            x: (config.cell.maxWidth !== 'fill' ? x + xScale.bandwidth() / 2 - config.cell.maxWidth / 2 : x) + gridStrokeWidth,
            y: y,
            yIndex: yIndex,
            width: cellWidthInner,
            height: cellHeightInner,
            datum: d,
            fill: {
                color: (0, color_library_wrappers_1.colorToRgba)(cellBackgroundColor),
            },
            stroke: {
                color: (0, color_library_wrappers_1.colorToRgba)(config.cell.border.stroke),
                width: config.cell.border.strokeWidth,
            },
            value: d.value,
            visible: !isValueHidden(d.value, bandsToHide),
            formatted: formattedValue,
            fontSize: fontSize,
            textColor: (0, fill_text_color_1.fillTextColor)(cellBackgroundColor, theme.background.color),
        };
        return acc;
    }, {});
    var pickQuads = function (x, y) {
        if (x > 0 && x < chartDimensions.left && y > chartDimensions.top && y < chartDimensions.height) {
            var yLabelKey_1 = yInvertedScale(y);
            var yLabelValue = textYValues.find(function (v) { return v.value === yLabelKey_1; });
            if (yLabelValue) {
                return yLabelValue;
            }
        }
        if (x < chartDimensions.left || y < chartDimensions.top) {
            return [];
        }
        if (x > chartDimensions.width + chartDimensions.left || y > chartDimensions.height) {
            return [];
        }
        var xValue = xInvertedScale(x - chartDimensions.left);
        var yValue = yInvertedScale(y);
        if (xValue === undefined || yValue === undefined) {
            return [];
        }
        var cellKey = getCellKey(xValue, yValue);
        var cell = cellMap[cellKey];
        if (cell) {
            return [cell];
        }
        return [];
    };
    var pickDragArea = function (bound) {
        var _a = __read(bound, 2), start = _a[0], end = _a[1];
        var left = chartDimensions.left, top = chartDimensions.top, width = chartDimensions.width;
        var topLeft = [Math.min(start.x, end.x) - left, Math.min(start.y, end.y) - top];
        var bottomRight = [Math.max(start.x, end.x) - left, Math.max(start.y, end.y) - top];
        var startX = xInvertedScale((0, common_1.clamp)(topLeft[0], 0, width));
        var endX = xInvertedScale((0, common_1.clamp)(bottomRight[0], 0, width));
        var startY = yInvertedScale((0, common_1.clamp)(topLeft[1], 0, currentGridHeight - 1));
        var endY = yInvertedScale((0, common_1.clamp)(bottomRight[1], 0, currentGridHeight - 1));
        var allXValuesInRange = getValuesInRange(xValues, startX, endX);
        var allYValuesInRange = getValuesInRange(yValues, startY, endY);
        var invertedXValues = isRasterTimeScale(spec.xScale) && typeof endX === 'number'
            ? [startX, (0, elasticsearch_1.addIntervalToTime)(endX, spec.xScale.interval, config.timeZone)]
            : __spreadArray([], __read(allXValuesInRange), false);
        var cells = [];
        allXValuesInRange.forEach(function (x) {
            allYValuesInRange.forEach(function (y) {
                var cellKey = getCellKey(x, y);
                cells.push(cellMap[cellKey]);
            });
        });
        return {
            cells: cells.filter(Boolean),
            x: invertedXValues,
            y: allYValuesInRange,
        };
    };
    var pickHighlightedArea = function (x, y) {
        var startValue = x[0];
        var endValue = x[x.length - 1];
        var leftIndex = typeof startValue === 'number' ? (0, d3_array_1.bisectLeft)(xValues, startValue) : xValues.indexOf(startValue);
        var rightIndex = typeof endValue === 'number' ? (0, d3_array_1.bisectLeft)(xValues, endValue) : xValues.indexOf(endValue) + 1;
        var isRightOutOfRange = rightIndex > xValues.length - 1 || rightIndex < 0;
        var isLeftOutOfRange = leftIndex > xValues.length - 1 || leftIndex < 0;
        var startFromScale = xScale(isLeftOutOfRange ? xValues[0] : xValues[leftIndex]);
        var endFromScale = xScale(isRightOutOfRange ? xValues[xValues.length - 1] : xValues[rightIndex]);
        if (startFromScale === undefined || endFromScale === undefined) {
            return null;
        }
        var xStart = chartDimensions.left + startFromScale;
        var width = endFromScale - startFromScale + (isRightOutOfRange || isLeftOutOfRange ? cellWidth : 0);
        var _a = y
            .filter(function (v) { return yValues.includes(v); })
            .reduce(function (acc, current, i) {
            if (i === 0) {
                acc.y = yScale(current) || 0;
            }
            acc.totalHeight += cellHeight;
            return acc;
        }, { y: 0, totalHeight: 0 }), yStart = _a.y, totalHeight = _a.totalHeight;
        return {
            x: xStart,
            y: yStart,
            width: width,
            height: totalHeight,
        };
    };
    var pickDragShape = function (bound) {
        var area = pickDragArea(bound);
        return pickHighlightedArea(area.x, area.y);
    };
    var xLines = Array.from({ length: xValues.length + 1 }, function (d, i) { return ({
        x1: chartDimensions.left + i * cellWidth,
        x2: chartDimensions.left + i * cellWidth,
        y1: chartDimensions.top,
        y2: currentGridHeight,
    }); });
    var yLines = Array.from({ length: pageSize + 1 }, function (d, i) { return ({
        x1: chartDimensions.left,
        x2: chartDimensions.left + chartDimensions.width,
        y1: i * cellHeight,
        y2: i * cellHeight,
    }); });
    var cells = Object.values(cellMap);
    var tableMinFontSize = cells.reduce(function (acc, _a) {
        var fontSize = _a.fontSize;
        return Math.min(acc, fontSize);
    }, Infinity);
    return {
        config: config,
        heatmapViewModel: {
            gridOrigin: {
                x: chartDimensions.left,
                y: chartDimensions.top,
            },
            gridLines: {
                x: xLines,
                y: yLines,
                stroke: {
                    color: (0, color_library_wrappers_1.colorToRgba)(config.grid.stroke.color),
                    width: gridStrokeWidth,
                },
            },
            pageSize: pageSize,
            cells: cells,
            cellFontSize: function (cell) { return (config.cell.label.useGlobalMinFontSize ? tableMinFontSize : cell.fontSize); },
            xValues: textXValues,
            yValues: textYValues,
        },
        pickQuads: pickQuads,
        pickDragArea: pickDragArea,
        pickDragShape: pickDragShape,
        pickHighlightedArea: pickHighlightedArea,
    };
}
exports.shapeViewModel = shapeViewModel;
function getCellKey(x, y) {
    return [String(x), String(y)].join('&_&');
}
function isValueHidden(value, rangesToHide) {
    return rangesToHide.some(function (_a) {
        var _b = __read(_a, 2), min = _b[0], max = _b[1];
        return min <= value && value < max;
    });
}
function isRasterTimeScale(scale) {
    return scale.type === constants_1.ScaleType.Time;
}
exports.isRasterTimeScale = isRasterTimeScale;
function getXTicks(spec, config, chartDimensions, xScale, _a, gridHeight) {
    var xValues = _a.xValues, xNumericExtent = _a.xNumericExtent;
    var getTextValue = function (formatter, scaleCallback) { return function (value) {
        var _a;
        return __assign(__assign({ text: formatter(value), value: value, isValue: false }, config.xAxisLabel), { x: chartDimensions.left + ((_a = scaleCallback(value)) !== null && _a !== void 0 ? _a : 0), y: gridHeight + config.xAxisLabel.fontSize / 2 + config.xAxisLabel.padding });
    }; };
    if (isRasterTimeScale(spec.xScale)) {
        var timeScale_1 = new scales_1.ScaleContinuous({
            type: constants_1.ScaleType.Time,
            domain: xNumericExtent,
            range: [0, chartDimensions.width],
            nice: false,
        }, {
            desiredTickCount: estimatedNonOverlappingTickCount(chartDimensions.width, config.xAxisLabel),
            timeZone: config.timeZone,
        });
        return timeScale_1.ticks().map(getTextValue(config.xAxisLabel.formatter, function (x) { return timeScale_1.scale(x); }));
    }
    return xValues.map(function (textBox) {
        return __assign(__assign({}, getTextValue(config.xAxisLabel.formatter, xScale)(textBox)), { x: chartDimensions.left + (xScale(textBox) || 0) + xScale.bandwidth() / 2 });
    });
}
//# sourceMappingURL=viewmodel.js.map