/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : dim nov  7 11:19:47 CET 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : dupoux@dupoux.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kgraphspace.h"

#include <kaboutdata.h>
#include <kcmdlineargs.h> 

static KCmdLineOptions options[] =
{
    {"+[Directory]", I18N_NOOP("Directory to explore"), 0},
    {0,0,0}
};

KApplication *g_app;

int main(int argc, char *argv[])
{
    QString strDir;

    KAboutData about("kgraphspace", "KGraphSpace", VERSION, I18N_NOOP("Draw graph of disk space"), KAboutData::License_GPL, "Francois Dupoux", 0, "http://kgraphspace.sourceforge.net/", "dupoux@dupoux.com");

    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions(options);
    
    KApplication app;
    g_app = &app;
    
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    
    if ((args->count()) && (args->arg(0)))
    	strDir.sprintf("%s", args->arg(0));
 
    KGraphSpaceApp *kgraphspace = new KGraphSpaceApp(strDir);
    kgraphspace->show();

    args -> clear();
    return app.exec();
}  
