/***************************************************************************
                          ktypesstats.h  -  description
                             -------------------
    begin                : Tue Dec 28 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : dupoux@dupoux.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTYPESSTATS_H
#define KTYPESSTATS_H

// QT includes
#include <string.h>
#include <qlist.h>

// App includes
#include "resource.h"

// -------------------------------------
class KTypeItem
{
public:
    KTypeItem(QString type) {nCount = 0; llUsedSize = 0LL; llDataSize = 0LL; strType = type;}

public: // data
    QString strType;
    int nCount;
    LLSIZE llDataSize;
    LLSIZE llUsedSize;
};

// -------------------------------------
class KTypesStats // : public Q 
{
public: 
    KTypesStats() {m_list.setAutoDelete(true);}
    int addFile(const char *szFilename, LLSIZE llUsedSize, LLSIZE llDataSize);
    int removeFile(const char *szFilename, LLSIZE llUsedSize, LLSIZE llDataSize);

private: // data
    QList<KTypeItem> m_list;

private: // Data of configuration
    QString getFileType(const char *szFilename);	

public: // Functions of access to datas
    QList<KTypeItem> *getData() {return &m_list;}

};

#endif // KTYPESSTATS_H
