/***************************************************************************
                          ktypesstats.cpp  -  description
                             -------------------
    begin                : Tue Dec 28 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : dupoux@dupoux.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// App includes
#include "kgraphspace.h"
#include "ktypesstats.h"

// Standard includes
#include <stdio.h>

// ===========================================================================================================================
int KTypesStats::addFile(const char *szFilename, LLSIZE llUsedSize, LLSIZE llDataSize)
{
    QString strType;
    KTypeItem *item;
    
    if (*szFilename == 0)
	return -1;

    strType = getFileType(szFilename);
    if (strType == QString::null)
	return -1;

    // If type already exists ==> Increase
    for (item = m_list.first(); item != 0; item = m_list.next())
    {	
	if (strType == item->strType)
	{
	    item->nCount++;
	    item->llDataSize += llDataSize;
	    item->llUsedSize += llUsedSize;
	    //fprintf(stderr,"*********** ADDING >> %s: nb=%ld and size=%lld\n", strType.data(), item->nCount, item->llUsedSize);
	    return 1;	
	}    
    }

    // Type was not found
    item = new KTypeItem(strType);
    item->llDataSize = llDataSize;
    item->llUsedSize = llUsedSize;
    item->nCount = 1;
    m_list.append(item);
    return 2;
}

// ===========================================================================================================================
int KTypesStats::removeFile(const char *szFilename, LLSIZE llUsedSize, LLSIZE llDataSize)
{
	QString strType;
	KTypeItem *item;
    
	if (*szFilename == 0)
		return -1;

	strType = getFileType(szFilename);
	if (strType == QString::null)
		return -1;

	// If type already exists ==> Increase
	for (item = m_list.first(); item != 0; item = m_list.next())
	{	
		if (strType == item->strType)
		{
			item->nCount--;
			item->llDataSize -= llDataSize;
			item->llUsedSize -= llUsedSize;
			//fprintf(stderr,"*********** DELETE >> %s: nb=%ld and size=%lld\n", strType.data(), item->nCount, item->llUsedSize);
			return 0;	
		}
	}

	// Type was not found
	return -1;
}
	
// ===========================================================================================================================
QString KTypesStats::getFileType(const char *szFilename)
{
	// Empty filename or config file
	if ((*szFilename == 0) || (*szFilename == '.'))
		return QString::null;
	
	// 1. Tarball files
	char *szExt;
	const char *szGzip = "tar.gz";
	const char *szBzip2 = "tar.bz2";
	
	szExt = (char *) szFilename + (strlen(szFilename) - strlen(szGzip));
	if (strcmp(szExt, szGzip) == 0)
		return QString(szGzip);
		
	szExt = (char *) szFilename + (strlen(szFilename) - strlen(szBzip2));
	if (strcmp(szExt, szBzip2) == 0)
		return QString(szBzip2);
		
	// 2. Regular filename
	char *cPoint;
	cPoint = strrchr(szFilename, '.');
	
	if (!cPoint) // '.' not found
		return QString::null;
	else
		return QString(cPoint+1);	
}
