/***************************************************************************
                          ktreeview.h  -  description
                             -------------------
    begin                : Thu Nov 11 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : dupoux@dupoux.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTREEVIEW_H
#define KTREEVIEW_H

#include <kapp.h>
#include <qlistview.h>

#include "ktreeitem.h"

class KDrawView;
class KGraphSpaceApp;
class KGraphSpaceView;
class QListViewItem;

class KTreeView : public QListView
{
	Q_OBJECT

public: 
	KTreeView( QWidget *parent = 0, const char *name = 0);
	~KTreeView();
	/** Select a child of current item in the tree view  */
	int selectChild(QString strChild);
	QString getPathFromLvi(QListViewItem *);
	QListViewItem *getLviFromPath(const char *szPath);
	KTreeItem *currentDirectory(); // item to draw pie chart from
	QString currentPath(); // full patch of the current selected directory
	void setCurrentDirectory(KTreeItem *kti);

public slots:
	void slotMouseButtonClicked (int, QListViewItem *, const QPoint &, int);

private:
    KGraphSpaceApp *m_app;
    KDrawView* getDrawView();
    KGraphSpaceView *getMainView();
    KTreeItem *m_ktiCurrent;

};

#endif


