/***************************************************************************
                          ktreeview.cpp  -  description
                             -------------------
    begin                : Thu Nov 11 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : dupoux@dupoux.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ktreeview.h"
#include "kgraphspace.h"
#include "kdrawview.h"
#include "kgraphspaceview.h"
#include "ktreeitem.h"
#include "kgraphspacedoc.h"

#include <kpopupmenu.h>

#include <qlistview.h>
#include <stdio.h>
#include <sys/param.h>

//===========================================================================================================================
KTreeView::KTreeView( QWidget *parent, const char *name): QListView( parent, name )
{
   // Main application class
   m_app = (KGraphSpaceApp *) parentWidget() -> parentWidget();
   m_ktiCurrent = NULL;

   // Tree properties
   setSorting(-1);
   addColumn(i18n("Name"), -1 );
   setColumnWidthMode( 0, QListView::Maximum );
   setColumnAlignment( 0, 1 );
   addColumn(i18n("Size"), -1 );
   setColumnWidthMode( 1, QListView::Maximum );
   setColumnAlignment( 1, 1 );
   setFrameStyle(QFrame::Panel | QFrame::Sunken);
   setLineWidth(2);

   connect(this, SIGNAL(mouseButtonClicked (int, QListViewItem *, const QPoint &, int)), this, SLOT(slotMouseButtonClicked (int, QListViewItem *, const QPoint &, int)));
}

//===========================================================================================================================
KTreeView::~KTreeView()
{
}

//===========================================================================================================================
void KTreeView::slotMouseButtonClicked (int nButton, QListViewItem *lvi, const QPoint &pos, int /*column*/)
{
   KTreeItem *kti;
   LLSIZE llTest;
   int nType;
	
   // Don't look at events while working
   if (g_bThreadRunning)
      return;

   // get item
   if (lvi == 0) // No item selected
      return;
	
   kti = (KTreeItem *) lvi;
   if (kti->getType(&nType) == false)
      return;

   // LEFT BUTTON
   if (nButton == QMouseEvent::LeftButton)
   {
      // set current directory: if this is an no-empty directory
      if ((kti -> childCount() > 0) && (kti->getDataSize(&llTest)) && (llTest > 0) && (nType == KTreeItem::Directory)) // If childs (else keep existing item)
      {	m_ktiCurrent = kti;
      }
      else // keep old valid directory
      {	setCurrentItem(m_ktiCurrent);
      //setSelected (m_ktiCurrent, true);
      }	
		
      getDrawView() -> update();
      m_app -> updateCommands();
   }

   // RIGHT BUTTON
   if (nButton == QMouseEvent::RightButton)
   {
      KPopupMenu *popup;

      if (nType == KTreeItem::Directory)
	 popup = getMainView()->getFolderPopup();
      else
	 popup = getMainView()->getFilePopup();

      (getMainView()->getDocument())->setCurrentItem(getPathFromLvi(lvi),lvi->text(0),nType);
	
      popup->popup(pos);
   }	
}

//===========================================================================================================================
QString KTreeView::getPathFromLvi(QListViewItem *lvi)
{
   if (lvi == 0)
      return QString::null;

   QString strPath;
    
   do
   {
      if (lvi->text(0) != "/")
	 strPath.insert(0,"/");
      strPath.insert(0,lvi->text(0));
   }
   while ((lvi = lvi->parent()));
    
   return strPath;
}

//===========================================================================================================================
QListViewItem *KTreeView::getLviFromPath(const char *szOriginalPath)
{
   QListViewItem *lviCurrent, *lviGood = NULL;
   char szCurrent[MAXPATHLEN];
   char szFullPath[MAXPATHLEN];
   char *szPath;
   int i;
    
   memset(szFullPath, 0, sizeof(szFullPath));
   strcpy(szFullPath, szOriginalPath);

   // Check searched path is not the root item of the tree
   if (strcmp(szOriginalPath, firstChild()->text(0).data())==0)
      return firstChild();
    
   // Pass the main directory path
   szPath = szFullPath + firstChild()->text(0).length()+1;
   lviCurrent = firstChild()->firstChild();
    
   while (*szPath)
   {
      // Copy name of the current searched directory
      for (i=0; szPath[i] && (szPath[i] != '/' || i == 0); i++)
	 szCurrent[i] = szPath[i];
      szCurrent[i]=0;
      szPath+=i+1;
		        
      // Search directory in all childs
      lviGood = NULL;
	
      while ((lviCurrent) && (!lviGood))
      {	
	 if ( strcmp(lviCurrent->text(0).data(), szCurrent) == 0) // Found
	    lviGood = lviCurrent;
	 else // Not found
	    lviCurrent = lviCurrent->nextSibling();	
      }
	
      if (!lviGood) // Error: path not found
	 return NULL;
	    
      lviCurrent = lviGood->firstChild();
   }
    
   return lviGood;
}

// /** Select a child of current item in the tree view  */
// ===========================================================================================================================
int KTreeView::selectChild(QString strChild)
{
   QListViewItem *lviCurrent, *lviFirst, *lviCurSelected;

   lviCurSelected = currentItem();
   if (lviCurSelected == 0)
      return -1;
	
   lviCurrent = lviFirst = lviCurSelected -> firstChild();
   if (lviCurrent == NULL)
   {	return -1;
   }

   do
   {	
      if (strcmp(lviCurrent -> text(0), strChild.data()) == 0)
      {	lviCurSelected -> setOpen(true);
      setCurrentDirectory((KTreeItem*)lviCurrent);
      //setSelected(lviCurrent, true);
      return 0;
      }

      lviCurrent = lviCurrent -> nextSibling();
	
   } while(lviCurrent && lviCurrent != lviFirst);
   return 0;
}

//===========================================================================================================================
KDrawView *KTreeView::getDrawView()
{	
   return m_app->getDrawView();
}

//===========================================================================================================================
KGraphSpaceView *KTreeView::getMainView()
{	
   return m_app->getMainView();
}

// ===========================================================================================================================
KTreeItem *KTreeView::currentDirectory()
{
   return m_ktiCurrent;
}

// ===========================================================================================================================
void KTreeView::setCurrentDirectory(KTreeItem *kti)
{
   m_ktiCurrent = kti;
   setCurrentItem(m_ktiCurrent);
}

// ===========================================================================================================================
QString KTreeView::currentPath()
{
	return getPathFromLvi(currentDirectory());
}
