/***************************************************************************
                          ktreeitem.h  -  description
                             -------------------
    begin                : Thu Nov 11 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : dupoux@dupoux.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTREEITEM_H
#define KTREEITEM_H

#include <qlistview.h>
#include <qdialog.h>
#include <qlistview.h>
#include "resource.h"

/**
  *@author Franois Dupoux
  */

// Data size: size of the file (ex: 513)
// Used size: size used on disk. (ex: with 512 bytes cluster, the last file use 1024 bytes = 2 clusters)

class KTreeItem : public QListViewItem
{
    public: 
	KTreeItem(QListView *lv);
	KTreeItem(QListViewItem *lvi);
	~KTreeItem();
	void setDataSize(LLSIZE llSize);
	void setUsedSize(LLSIZE llSize);
	void setType(int nType);
	int getDataSize(LLSIZE *llSize);
	int getUsedSize(LLSIZE *llSize);
	int getLosenSize(LLSIZE *llSize);
	int getType(int *nType);
	void decreaseUsedSize(LLSIZE llSize);
	void decreaseDataSize(LLSIZE llSize);
	void increaseUsedSize(LLSIZE llSize);
	void increaseDataSize(LLSIZE llSize);
	void increaseSizeInAllParents(LLSIZE llUsedSize, LLSIZE llDataSize);
	void decreaseSizeInAllParents(LLSIZE llUsedSize, LLSIZE llDataSize);

	void showSizes();

	enum {Directory, File};

    private:
	long long m_llDataSize;
	long long m_llUsedSize;
	int m_nType;
	bool m_bDataSizeValid;
	bool m_bUsedSizeValid;
	bool m_bTypeValid;

};

#endif

