/***************************************************************************
                          ktreeitem.cpp  -  description
                             -------------------
    begin                : Thu Nov 11 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : dupoux@dupoux.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ktreeitem.h"
#include "kgraphspace.h"
#include "ktreeview.h"
#include "kdrawview.h"
#include "filelib.h"

#include <stdio.h>

// ===========================================================================================================================
KTreeItem::KTreeItem(QListViewItem *lvi):QListViewItem(lvi)
{	m_llDataSize = 0LL;
	m_llUsedSize = 0LL;
	m_bDataSizeValid = false;
	m_bUsedSizeValid = false;
}

// ===========================================================================================================================
KTreeItem::KTreeItem(QListView *lv):QListViewItem(lv)
{	m_llDataSize = 0LL;
	m_llUsedSize = 0LL;
	m_bDataSizeValid = false;
	m_bUsedSizeValid = false;

	//((KTreeView *) listView()) -> slotFolderSelected(this);
	//connect( this, SIGNAL( folderSelected( QString strDir ) ), this, SLOT( slotFolderSelected( QString strDir ) ) );
}

// ===========================================================================================================================
KTreeItem::~KTreeItem()
{
}

// ===========================================================================================================================
void KTreeItem::setDataSize(long long llSize)
{	m_bDataSizeValid = true;
	m_llDataSize = llSize;
}

// ===========================================================================================================================
void KTreeItem::setUsedSize(long long llSize)
{	m_bUsedSizeValid = true;
	m_llUsedSize = llSize;
	showSizes();
}

// ===========================================================================================================================
int KTreeItem::getDataSize(long long *llSize)
{	if (m_bDataSizeValid == false)
	{	*llSize = 0;
		return false;
	}
	else
	{	*llSize = m_llDataSize;
		return true;
  }
}

// ===========================================================================================================================
int KTreeItem::getUsedSize(long long *llSize)
{	if (m_bUsedSizeValid == false)
	{	*llSize = 0;
		return false;
	}
	else
	{	*llSize = m_llUsedSize;
		return true;
  }
}

// ===========================================================================================================================
int KTreeItem::getLosenSize(long long *llSize)
{	if (m_bUsedSizeValid == false || m_bDataSizeValid == false)
	{	*llSize = 0;
		return false;
	}
	else
	{	*llSize = m_llUsedSize - m_llDataSize;
		return true;
  }
}

// ===========================================================================================================================
void KTreeItem::setType(int nType)
{	m_bTypeValid = true;
	m_nType = nType;
}

// ===========================================================================================================================
int KTreeItem::getType(int *nType)
{	if (m_bTypeValid == false)
	{	*nType = 0;
		return false;
	}
	else
	{	*nType = m_nType;
		return true;
  }
}

// ===========================================================================================================================
void KTreeItem::decreaseUsedSize(LLSIZE llSize)
{	
	QString strSize;
    
	if (m_bUsedSizeValid == true)
	{
		m_llUsedSize -= llSize;
		strSize = formatSize(m_llUsedSize);
		setText(1, strSize);
	}
}

// ===========================================================================================================================
void KTreeItem::decreaseDataSize(LLSIZE llSize)
{	
	if (m_bDataSizeValid == true)
	{
		m_llDataSize -= llSize;
		showSizes();
	}
	
}


// ===========================================================================================================================
void KTreeItem::increaseUsedSize(LLSIZE llSize)
{	
    if (m_bUsedSizeValid == true)
    {
	m_llUsedSize += llSize;
	showSizes();
    }
}

// ===========================================================================================================================
void KTreeItem::increaseDataSize(LLSIZE llSize)
{	
	if (m_bDataSizeValid == true)
		m_llDataSize += llSize;
	
}

// ===========================================================================================================================
void KTreeItem::showSizes()
{	
    QString strSize;

    strSize = formatSize(m_llUsedSize);
    setText(1, strSize);        
}

//===========================================================================================================================
void KTreeItem::decreaseSizeInAllParents(LLSIZE llUsedSize, LLSIZE llDataSize)
{
    KTreeItem *kti;
    QListViewItem *lvi;

    lvi = (QListViewItem *) this;
    
    //printf("decreasing main: (%s)\n", text(0).data());
    
    while ((lvi = lvi->parent()))
    {
	kti = (KTreeItem *)lvi;
	kti -> decreaseUsedSize(llUsedSize);
	kti -> decreaseDataSize(llDataSize);    
	//printf("   -(%s)\n", lvi->text(0).data());
    }
}

//===========================================================================================================================
void KTreeItem::increaseSizeInAllParents(LLSIZE llUsedSize, LLSIZE llDataSize)
{
    KTreeItem *kti;
    QListViewItem *lvi;
    
    lvi = (QListViewItem *) this;

    while ((lvi = lvi->parent()))
    {
	kti = (KTreeItem *)lvi;
	kti -> increaseUsedSize(llUsedSize);
	kti -> increaseDataSize(llDataSize);    
    }
}
