/***************************************************************************
                          kstatsdlg.cpp  -  description
                             -------------------
    begin                : Tue Dec 28 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : dupoux@dupoux.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qvbox.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qwhatsthis.h>

#include "kgraphspace.h"
#include "kstatsdlg.h"
#include "resource.h"
#include "filelib.h"

// ===========================================================================================================================
KStatsDlg::KStatsDlg(QWidget *parent, KTypesStats *kts) : QTabDialog(parent, 0, true)
{
	m_kts = kts;
	
	setCaption(i18n("Main directory stats"));
	setMinimumSize(500,350);
	resize(500,350);
	setOkButton(i18n("Close"));
	
	// Create pages
	initPage1();
	//initPage2();
	//initPage3();
	addInfosPage1();
	
	connect(this,SIGNAL(applyButtonPressed()),this,SLOT(accept()));
}

// ===========================================================================================================================
KStatsDlg::~KStatsDlg()
{
}
	
// ===========================================================================================================================
void KStatsDlg::initPage1()
{
    QVBox *tab1 = new QVBox(this);
    tab1 -> setMargin(5);

    // Create ListView
    m_lvStats = new QListView(tab1,"m_lviStats");
    m_lvStats -> addColumn(i18n("Type"));
    m_lvStats -> addColumn(i18n("Number"));
    m_lvStats -> addColumn(i18n("Size"));
    m_lvStats -> addColumn(i18n("Bytes"));
    m_lvStats -> setColumnAlignment(1, Qt::AlignRight);
    m_lvStats -> setColumnAlignment(2, Qt::AlignRight);
    m_lvStats -> setColumnAlignment(3, Qt::AlignRight);
    m_lvStats -> setShowSortIndicator(true);

    addTab(tab1, i18n("Files types"));
}

// ===========================================================================================================================
void KStatsDlg::addInfosPage1()
{
	KTypeItem *ts;
	QListViewItem *lvi;
	QString strNumber, strSize, strBytes;
    
	for (ts = m_kts->getData()->first(); ts != 0 ; ts = m_kts->getData()->next())
	{
		if (ts->nCount > 0) // If item not empty
		{	
			strNumber.sprintf("%.10d", ts->nCount);
			strSize = formatSize(ts->llUsedSize);
			strBytes.sprintf("%.10lu", (DWORD)ts->llUsedSize);
			lvi = new QListViewItem(m_lvStats, ts->strType, strNumber, strSize, strBytes);
		}
	}
	
	m_lvStats -> setSorting (3);
}

