/***************************************************************************
                          koptionsdlg.cpp  -  description
                             -------------------
    begin                : Tue Dec 28 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : dupoux@dupoux.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qvbox.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qwhatsthis.h>

#include "kgraphspace.h"
#include "koptionsdlg.h"
#include "resource.h"

// ===========================================================================================================================
KOptionsDlg::KOptionsDlg(QWidget *parent, const char *name, KSettings settings) : QTabDialog(parent,name,true)
{
	setCaption(i18n("KGraphSpace options"));
	setMinimumSize(500,350);
	resize(500,350);
	setOkButton(i18n("Ok"));
	setDefaultButton(i18n("Default values"));
	setCancelButton(i18n("Cancel"));
	
	// Create pages
	initPage1();
	//initPage2();
	//initPage3();
	
	// Get current settings
	m_settings = settings;
	setValues(); // Fill widgets with current values

	connect(this,SIGNAL(applyButtonPressed()),this,SLOT(slotOk()));
	connect(this,SIGNAL(defaultButtonPressed()),this,SLOT(slotDefaults()));
}

// ===========================================================================================================================
KOptionsDlg::~KOptionsDlg()
{
}
	
// ===========================================================================================================================
void KOptionsDlg::slotOk()
{
	// ************************ PAGE 1 ****************************
	m_settings.bAutoRefresh = m_checkAutoRefresh -> isChecked();
	m_settings.bDeleteAfterCompress = m_checkDeleteAfterCompress -> isChecked();
	m_settings.nOtherPct = m_spinOtherPct -> text().toInt();
	m_settings.nRefreshFreq = m_spinRefreshFreq -> text().toInt();
	
	accept();
}

// ===========================================================================================================================
void KOptionsDlg::slotDefaults() // Set defaults values for all options of the dialog
{
    // -------------------- PAGE 1 ---------------------
    m_checkAutoRefresh -> setChecked(OPTIONS_DEFAULT_AUTOREFRESH);
    m_checkDeleteAfterCompress -> setChecked(OPTIONS_DEFAULT_DELETEAFTERCOMPRESS);
    m_spinRefreshFreq -> setValue(OPTIONS_DEFAULT_REFRESHFREQ);
    m_spinOtherPct -> setValue(OPTIONS_DEFAULT_OTHERPCT);
}

// ===========================================================================================================================
void KOptionsDlg::setValues() // Copy current values to widgets
{
    // -------------------- PAGE 1 ---------------------
    m_checkAutoRefresh -> setChecked (m_settings.bAutoRefresh );
    m_checkDeleteAfterCompress -> setChecked (m_settings.bDeleteAfterCompress );
    m_spinRefreshFreq -> setValue (m_settings.nRefreshFreq );
    m_spinOtherPct-> setValue (m_settings.nOtherPct );
}

// ===========================================================================================================================
void  KOptionsDlg::initPage1()
{
    QVBox *tab1 = new QVBox(this);
    tab1 -> setMargin(5);

    // Create check boxes
    m_checkAutoRefresh = new QCheckBox(i18n("Automatic refresh"), tab1,"m_checkAutoRefresh");
    m_checkDeleteAfterCompress = new QCheckBox(i18n("Delete files and folders after compress"),tab1,"m_checkDeleteAfterCompress");
    
    QButtonGroup *bg1 = new QButtonGroup(3, QGroupBox::Horizontal, i18n("Refresh frequency"), tab1);
    m_label1 = new QLabel(i18n("Check for files and directories changes every"), bg1);
    m_spinRefreshFreq = new QSpinBox(3, 1000, 1, bg1, "m_spinRefreshFreq");
    m_label2 = new QLabel(i18n("seconds. (can use a lot of CPU if time to small)"), bg1);
    
    QButtonGroup *bg2 = new QButtonGroup(2, QGroupBox::Horizontal, i18n("Pie drawing properties"), tab1);
    m_label3 = new QLabel(i18n("Maximal percent of size of a file/dir moved into <b>OTHER</b>"), bg2);
    m_spinOtherPct = new QSpinBox(0, 25, 1, bg2, "m_spinOtherPct");
        
    // Create help QWhatsThis
    QWhatsThis::add(m_checkAutoRefresh, i18n("If enabled, KGraphSpace will check for disk changes sometimes, and update the tree and the pie"));
    QWhatsThis::add(m_checkDeleteAfterCompress, i18n("The files/dirs you will compress in .gz/.bz2 with the popup menu will be deleted."));
    QWhatsThis::add(m_spinRefreshFreq, i18n("Time KGraphSpace must wait between two checks for disk changes. If the time is too short and there are too many files/dirs in the tree, the CPU can be overload. You must restart KGraphSpace to have this options change active."));
    QWhatsThis::add(m_spinOtherPct, i18n("In the pie chart, KGraphSpace move small files/dirs to a special part: <b>OTHERS</b>. You can write the percent of size the file must have not to be moved to Others."));
    
    addTab(tab1, i18n("General"));
}
