/***************************************************************************
                          knewexploredlg.cpp  -  description
                             -------------------
    begin                : Sat Nov 13 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : dupoux@dupoux.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kgraphspace.h"
#include "knewexploredlg.h"
#include "resource.h"
#include <kfiledialog.h>
#include <kconfig.h>
#include <kmessagebox.h>

// ===========================================================================================================================
KNewExploreDlg::KNewExploreDlg(QWidget *parent, const char *name) : QDialog(parent,name,true)
{
    initDialog();
    loadComboValues();

    connect(m_btnExplore,SIGNAL(clicked()),this,SLOT(slotExplore()));
    connect(m_btnExit,SIGNAL(clicked()),this,SLOT(reject()));
    connect(m_btnBrowse,SIGNAL(clicked()),this,SLOT(slotBrowse()));
    connect(m_radioRoot, SIGNAL(clicked()), SLOT(slotRadio1Clicked()));
    connect(m_radioHome, SIGNAL(clicked()), SLOT(slotRadio2Clicked()));
    connect(m_radioOther, SIGNAL(clicked()), SLOT(slotRadio3Clicked()));

    selectRadio(Home);
}

// ===========================================================================================================================
KNewExploreDlg::~KNewExploreDlg()
{
}

// ===========================================================================================================================
void KNewExploreDlg::slotBrowse()
{
    QString strDir;

    strDir = KFileDialog::getExistingDirectory(QString::null, this, i18n("Directory to explore..."));
    if (strDir.isEmpty())
    	return ;

    m_comboDirectory -> setEditText(strDir.data());
}

// ===========================================================================================================================
void KNewExploreDlg::slotExplore()
{
	// Check the is no error
	m_strDir = m_comboDirectory -> currentText();
	if (m_nRadioCurSel == Other && m_strDir.isEmpty())
	{	
	    KMessageBox::error(parentWidget(), i18n("If you choose an other directory, you must set its path"));
  	    return;
	}

	// Copy the selected path into m_strDir
	if (m_nRadioCurSel == Root)
	{	m_strDir.sprintf("/");
	}

	if (m_nRadioCurSel == Home)
	{	m_strDir.sprintf("/home/");
	}

	if (m_nRadioCurSel == Other)
	{	m_strDir = m_comboDirectory -> currentText();
	}

	// Check the last char of szDir is '/'
	if (m_strDir.right(1) != "/")
		m_strDir += "/";
	
	// Copy text into variables
	addCurrentStringToCombo();
	saveComboValues();
	accept();
}

// ===========================================================================================================================
void KNewExploreDlg::addCurrentStringToCombo()
{
	// Get strings from combo Boxes and Insert items to Combo boxes
	bool bAlready;

	// Check string is not already in the combo
	bAlready = false;

	for (int j=0; j < m_comboDirectory -> count(); j++)
	{	if ( strcmp(m_strDir.data(), m_comboDirectory -> text(j)) == 0 )
			bAlready = true;
	}

	if (!bAlready) // Add it
	{	if (m_comboDirectory -> count() >= MAX_STRINGSINCOMBO) // If full
			m_comboDirectory -> removeItem(9);
		m_comboDirectory -> insertItem(m_strDir.data(), 0);
	}
}

// ===========================================================================================================================
void KNewExploreDlg::loadComboValues()
{
  ///////////////////////////////////////////////////////////////////
  // read the config file entries
  KConfig *config = kapp->config();
	QString str, strTemp;
	int i;

	// Combo box informations
	config->setGroup("Directories");
	for(i = 0; i < MAX_STRINGSINCOMBO; i++)
	{	strTemp.setNum(i+1);
		str = config->readEntry(strTemp, "");		
		if (!str.isEmpty())
			m_comboDirectory -> insertItem(str.data());
  }

}

// ===========================================================================================================================
void KNewExploreDlg::saveComboValues()
{
  ///////////////////////////////////////////////////////////////////
  // save the config file entries
  KConfig *config = kapp->config();
	QString str, strTemp;
	int i;

	// Combo box informations
	config->setGroup("Directories");
  for(i = 0; i < (int) m_comboDirectory -> count(); i++)
	{	strTemp.setNum(i+1);
		config->writeEntry(strTemp.data(), m_comboDirectory -> text(i));
  }

}

// ===========================================================================================================================
void KNewExploreDlg::slotRadio1Clicked()
{
  selectRadio(Root);
}

// ===========================================================================================================================
void KNewExploreDlg::slotRadio2Clicked()
{
  selectRadio(Home);
}

// ===========================================================================================================================
void KNewExploreDlg::slotRadio3Clicked()
{
  selectRadio(Other);
}

// ===========================================================================================================================
void KNewExploreDlg::selectRadio(int nRadio)
{
	m_radioRoot -> setChecked(nRadio == Root);
	m_radioHome -> setChecked(nRadio == Home);
	m_radioOther -> setChecked(nRadio == Other);
	
	m_comboDirectory -> setEnabled(nRadio == Other);
	m_btnBrowse -> setEnabled(nRadio == Other);

	m_nRadioCurSel = nRadio;
}


