/***************************************************************************
                          kgraphspaceview.h  -  description
                             -------------------
    begin                : dim nov  7 11:19:47 CET 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : dupoux@dupoux.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KGRAPHSPACEVIEW_H
#define KGRAPHSPACEVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qwidget.h>
#include <qlistview.h>
#include <qsplitter.h>

#include "ktreeview.h"
#include "kdrawview.h"

class KGraphSpaceDoc;
class KPopupMenu;
class QPixmap;

/** The KGraphSpaceView class provides the view widget for the KGraphSpaceApp instance.	
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As KGraphSpaceView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the KGraphSpaceApp class to manipulate and display
 * the document structure provided by the KGraphSpaceDoc class.
 * 	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class KGraphSpaceView : public QSplitter
{
  Q_OBJECT
  public:
    
    /** Constructor for the main view */
    KGraphSpaceView(QWidget *parent=0,const char *name=0);
    /** Destructor for the main view */
    ~KGraphSpaceView();
    void init();

    /** returns a pointer to the document connected to the view instance. Mind that this method requires a KGraphSpaceApp instance as a parent
     * widget to get to the window document pointer by calling the KGraphSpaceApp::getDocument() method.
     *
     * @see KGraphSpaceApp#getDocument
     */
    KGraphSpaceDoc *getDocument() const;

    /** contains the implementation for printing functionality */
    void print(QPrinter *pPrinter);
	
    KDrawView *m_vwDraw;
    KTreeView *m_vwDir;

private:
    QPixmap m_pmFile;
    QPixmap m_pmFolder;
    KPopupMenu *m_kpmFile;
    KPopupMenu *m_kpmFolder;

public:
    QPixmap getFilePixmap() {return m_pmFile;}	
    QPixmap getFolderPixmap() {return m_pmFolder;}
    KPopupMenu *getFilePopup() {return m_kpmFile;}
    KPopupMenu *getFolderPopup() {return m_kpmFolder;}

};

#endif // KGRAPHSPACEVIEW_H
