/***************************************************************************
                          kgraphspaceview.cpp  -  description
                             -------------------
    begin                : dim nov  7 11:19:47 CET 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : dupoux@dupoux.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qprinter.h>
#include <qpainter.h>
#include <qpixmap.h>

#include <kstddirs.h>
#include <kpopupmenu.h>
#include <kiconloader.h>

// application specific includes
#include "kgraphspaceview.h"
#include "kgraphspacedoc.h"
#include "kgraphspace.h"

// ===========================================================================================================================
KGraphSpaceView::KGraphSpaceView(QWidget *parent /*=0*/,const char *name /*=0*/):QSplitter(Horizontal,parent,name)
{
   m_vwDir = new KTreeView(this,"treeview");
   m_vwDraw = new KDrawView(this,"drawview");

   // Load pixmaps PNG of the tree
   m_pmFile.load(locate("data","kgraphspace/pics/file.png"));
   m_pmFolder.load(locate("data","kgraphspace/pics/folder.png"));

   // Create popup menus
   m_kpmFile = new KPopupMenu(this);
   m_kpmFile->setTitle(i18n("File properties"));
   m_kpmFile->insertItem(i18n("Open with..."), getDocument(), SLOT(slotPopupFileOpenWith()));
   m_kpmFile->insertSeparator();
   m_kpmFile->insertItem(SmallIcon(locate("data","kgraphspace/pics/compress.png")),i18n("Compress in .gz"), getDocument(), SLOT(slotPopupFileCompressGz()));
   m_kpmFile->insertItem(SmallIcon(locate("data","kgraphspace/pics/compress.png")),i18n("Compress in .bz2"), getDocument(), SLOT(slotPopupFileCompressBz2()));
   m_kpmFile->insertSeparator();
   m_kpmFile->insertItem(i18n("Move to Trash"), getDocument(), SLOT(slotPopupMoveToTrash()));
   m_kpmFile->insertItem(SmallIcon(locate("data","kgraphspace/pics/delete.png")),i18n("Delete"), getDocument(), SLOT(slotPopupDelete()));
   m_kpmFile->insertSeparator();
   m_kpmFile->insertItem(i18n("Properties ..."), getDocument(), SLOT(slotPopupProperties()));

   m_kpmFolder = new KPopupMenu(this);
   m_kpmFolder->setTitle(i18n("Folder properties"));
   m_kpmFolder->insertItem(SmallIcon(locate("data","kgraphspace/pics/compress.png")),i18n("Compress in .tar.gz"), getDocument(), SLOT(slotPopupFolderCompressGz()));
   m_kpmFolder->insertItem(SmallIcon(locate("data","kgraphspace/pics/compress.png")),i18n("Compress in .tar.bz2"), getDocument(), SLOT(slotPopupFolderCompressBz2()));
   m_kpmFolder->insertSeparator();
   m_kpmFolder->insertItem(SmallIcon(locate("data","kgraphspace/pics/konqueror.png")), i18n("Open with Konqueror"), getDocument(), SLOT(slotPopupFolderOpenInKonqueror()));
   m_kpmFolder->insertItem(SmallIcon(locate("data","kgraphspace/pics/konsole.png")), i18n("Open with Konsole"), getDocument(), SLOT(slotPopupFolderOpenInKonsole()));
   m_kpmFolder->insertSeparator();
   m_kpmFolder->insertItem(i18n("Move to Trash"), getDocument(), SLOT(slotPopupMoveToTrash()));
   m_kpmFolder->insertItem(SmallIcon(locate("data","kgraphspace/pics/delete.png")),i18n("Delete"), getDocument(), SLOT(slotPopupDelete()));
   m_kpmFolder->insertSeparator();
   m_kpmFolder->insertItem(i18n("Properties ..."), getDocument(), SLOT(slotPopupProperties()));

}

// ===========================================================================================================================
void KGraphSpaceView::init()
{
}

// ===========================================================================================================================
KGraphSpaceView::~KGraphSpaceView()
{
}

// ===========================================================================================================================
KGraphSpaceDoc *KGraphSpaceView::getDocument() const
{
  KGraphSpaceApp *theApp=(KGraphSpaceApp *) parentWidget();
  return theApp->getDocument();
}

// ===========================================================================================================================
void KGraphSpaceView::print(QPrinter *pPrinter)
{
  QPainter printpainter;
  printpainter.begin(pPrinter);
	
  // TODO: add your printing code here

  printpainter.end();
}



