/***************************************************************************
                          kgraphspacedoc.h  -  description
                             -------------------
    begin                : dim nov  7 11:19:47 CET 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : dupoux@dupoux.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KGRAPHSPACEDOC_H
#define KGRAPHSPACEDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>
#include <qlistview.h>

// include files for KDE
#include <kprogress.h>
#include <kprocess.h>

// include files for app
#include "resource.h"
#include "ktypesstats.h"

// forward declaration of the KGraphSpace classes
class KGraphSpaceView;
class KTreeView;
class KDrawView;
class KGraphSpaceApp;
class QProgressDialog;
class KProcess;
class KDirWatch;

class KGraphSpaceDoc : public QObject
{
  Q_OBJECT

    public:
  /** Constructor for the fileclass of the application */
  KGraphSpaceDoc(QWidget *parent, const char *name=0);
  /** Destructor for the fileclass of the application */
  ~KGraphSpaceDoc();
  /** deletes the document's contents */
  void deleteContents();
  /** initializes the document generally */
  bool newDocument(QString strDir);
  /** returns the title of the document */
  const QString &getTitle() const;
  /** Explore the root path and create the tree */
  int diskExplore(QProgressDialog *progress);
  /** Give the number of sub-directories of a directory */
  int getNbChildsDirsInDir(const char *szDir);
  /** return true if there are no files and no dirs in the main directory */
  bool isDirectoryEmpty(const QString strPath);
  /**  set the good refresh mode from options */
  void setAutoRefresh();
  void addView(KGraphSpaceView* m_pView);
  void removeView(KGraphSpaceView* m_pView);
  void slotUpdateAllViews(KGraphSpaceView* pSender);

 public:	
  /** the list of the views currently connected to the document */
  static QList<KGraphSpaceView>* viewList;	

 private:
  KGraphSpaceApp *m_app;
  QString m_strCurrentItemPath;
  int m_nCurrentItemType;
  QString m_strCurrentItemName;
  KProcess m_proc;
  KDirWatch *m_kdwWatch;
  KTypesStats *m_stats;
  QString m_strRoot;
    
 public:	
  int diskExploreRecursive(QListViewItem *lvParent, QProgressDialog *progress, const char *szDir, LLSIZE *llDirDataSize, LLSIZE *llDirUsedSize, bool bIsRoot);
  KDrawView *getDrawView();
  KTreeView *getTreeView();
  KGraphSpaceView *getMainView();
  void setCurrentItem(QString strPath, QString strName, int nType);
  int addNewFiles(QListViewItem *lvParent, const char *szDir);
  int addNewDirectories(QListViewItem *lvParent, const char *szDir);
  int removeDeletedFilesAndDirs(QListViewItem *lvParent, const char *szDir);
  KTypesStats *getStats() {return m_stats;};
    
  public slots:
    void slotProcessExited(KProcess *proc);
  void slotUpdateDirChanged(const QString &strDir);

  void slotPopupFileCompressGz();
  void slotPopupFileCompressBz2();
  void slotPopupFolderCompressGz();
  void slotPopupFolderCompressBz2();
  void slotPopupDelete();
  void slotPopupMoveToTrash();
  void slotPopupProperties();
  void slotPopupFolderOpenInKonqueror();
  void slotPopupFolderOpenInKonsole();
  void slotPopupFileOpenWith();
};

#endif // KGRAPHSPACEDOC_H

