/***************************************************************************
                          kgraphspacedoc.cpp  -  description
                             -------------------
    begin                : dim nov  7 11:19:47 CET 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : dupoux@dupoux.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qwidget.h>
#include <qpixmap.h>
#include <qprogressdialog.h>
#include <qfileinfo.h>
#include <qdir.h>

// include files for KDE
#include <kapp.h>
#include <kmessagebox.h>
#include <kpropsdlg.h>
#include <krun.h>
#include <kprocess.h>
#include <konq_operations.h>
#include <kdirwatch.h>
#include <kdebug.h>
#include <kopenwith.h>

// application specific includes
#include "kgraphspacedoc.h"
#include "kgraphspace.h"
#include "kgraphspaceview.h"
#include "ktreeview.h"
#include "ktreeitem.h"
#include "knewexploredlg.h"
#include "ktypesstats.h"

// standard Linux headers
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <errno.h>
#include <dirent.h>

//#define KGRAPHSPACE_CHECK_FOR_FILESSIZES_CHANGES // To add files with KDirWatch
QList<KGraphSpaceView>* KGraphSpaceDoc::viewList = 0L;

// ===========================================================================================================================
KGraphSpaceDoc::KGraphSpaceDoc(QWidget *parent, const char *name) : QObject(parent, name)
{
   if( !viewList )
      viewList = new QList<KGraphSpaceView>;
   viewList->setAutoDelete(true);
  
   m_app = (KGraphSpaceApp *) parent;

   // Create KDirWatch object
   //m_kdwWatch = new KDirWatch((m_app->getSettings().nRefreshFreq)*1000); // Refresh every 3 sec KDE2.x versions
   m_kdwWatch = new KDirWatch(); // Refresh every 3 sec
   if (m_kdwWatch == 0)
      return;
   m_kdwWatch->setName("watch");
    
   // Create File types stats object
   m_stats = new KTypesStats;
   if (m_stats == 0)
      return;
    
   setAutoRefresh();
	
   connect(m_kdwWatch,SIGNAL(dirty(const QString&)), this, SLOT(slotUpdateDirChanged(const QString&)));
}

// ===========================================================================================================================
KGraphSpaceDoc::~KGraphSpaceDoc()
{
   delete m_kdwWatch;
   delete m_stats;
}

// ===========================================================================================================================
void KGraphSpaceDoc::setAutoRefresh()
{
   if (m_app->getSettings().bAutoRefresh)
      m_kdwWatch->startScan(true, true);
   else
      m_kdwWatch->stopScan();

}
// ===========================================================================================================================
const QString &KGraphSpaceDoc::getTitle() const
{
   return m_strRoot;
}

// ===========================================================================================================================
void KGraphSpaceDoc::addView(KGraphSpaceView* m_pView)
{
   viewList->append(m_pView);
}

// ===========================================================================================================================
void KGraphSpaceDoc::removeView(KGraphSpaceView* m_pView)
{
  viewList->remove(m_pView);
}

// ===========================================================================================================================
void KGraphSpaceDoc::slotUpdateAllViews(KGraphSpaceView* pSender)
{
  KGraphSpaceView* w;
  if(viewList)
    {
      for( w = viewList->first(); w; w = viewList->next() )
	{ 
	  if( w != pSender)
	    w->repaint();
	}
    }
  
}

// ===========================================================================================================================
bool KGraphSpaceDoc::newDocument(QString strDir)
{
   // Get path of the directory to explore
   if (strDir.isEmpty())
   {	KNewExploreDlg dlg(m_app);

   if (dlg.exec() == QDialog::Rejected) // If Cancel
      return false;
	    
   m_strRoot = dlg.m_strDir;
   }
   else
      m_strRoot = strDir;
    
   // Delete old data
   deleteContents();

   return true;
}

// ===========================================================================================================================
void KGraphSpaceDoc::deleteContents()
{
}

// ===========================================================================================================================
int KGraphSpaceDoc::diskExplore(QProgressDialog *progress)
{
   int nRes;
   int nChilds;

   KTreeItem *kti;
   LLSIZE llRecursiveDataSize, llRecursiveUsedSize;
   QString strSize;
   QString strMess;
   QFileInfo fiDir;
   QDir dir;

   // 1. Set path = absolute (if is relative)
   dir.setPath(m_strRoot);
   m_strRoot = dir.absPath();
   printf("EXPLORE=(%s)\n\n", m_strRoot.data());

   // 2. Delete the final "/" if exists
   /*if (m_strRoot.right(1) == "/")
     m_strRoot.truncate(m_strRoot.length()-1);*/

   // 3. Check m_strRoot is not a file (is a dir)
   fiDir.setFile(m_strRoot);
   if (!fiDir.isDir()) // Only files, not sym links and dirs
   {	strMess.sprintf("(%s) is neither a regular directory, nor a symbolic link to a directory. Unable to explore it.", m_strRoot.data());
   KMessageBox::error(m_app, strMess);
   return -1;
   }
    
   // 4. Check m_strRoot is not an empty directory
   if (isDirectoryEmpty(m_strRoot))
   {	strMess.sprintf("(%s) is an empty directory. Unable to explore it.", m_strRoot.data());
   KMessageBox::error(m_app, strMess);
   return -1;
   }
    
   // 5. Test user can access to the file
   nRes = access(m_strRoot.data(), F_OK | R_OK);
   if (nRes == -1)
   {	strMess.sprintf(i18n("Access denied in the main directory:\n%s"), m_strRoot.data());
   KMessageBox::error(m_app, strMess);
   return -1;
   }
    
   // 6. Add main item to tree
   kti = new KTreeItem(getTreeView());
   CHECK_PTR( kti );
   kti -> setText(0, m_strRoot.data());


   // Get number of child directories to explore (For the progress bar)
   nChilds = getNbChildsDirsInDir(m_strRoot.data());
   progress->setTotalSteps(nChilds);
   //printf ("Childs=%ld\n",nChilds);
   progress->setProgress(0);

   // Add directory to KDirWatch
   m_kdwWatch->addDir(m_strRoot.data());
   printf("**** ADDING KDIRWATCH, DIR (%s)\n", m_strRoot.data());

   // Call recursive function
   nRes = diskExploreRecursive(kti, progress, m_strRoot.data(), &llRecursiveDataSize, &llRecursiveUsedSize, true);
   if (nRes == -1)
   {	return -1;
   }
    
   kti -> setDataSize(llRecursiveDataSize);
   kti -> setUsedSize(llRecursiveUsedSize);

   kti -> setType(KTreeItem::Directory);
   kti -> setOpen(true);
   getTreeView() -> setCurrentItem(kti);
   getTreeView() -> setCurrentDirectory(kti);
   return 0;
}


// ===========================================================================================================================
int KGraphSpaceDoc::diskExploreRecursive(QListViewItem *lvParent, QProgressDialog *progress, const char *szDir, LLSIZE *llDirDataSize, LLSIZE *llDirUsedSize, bool bIsRoot)
{
   //fprintf(stderr,"%s\n", szDir);
   g_app -> processEvents();
	
   // Update the QProgressDialog
   progress->setLabelText(szDir);

   // For the thread
   if (g_bThreadMustStop)
      return -1;

   DIR *dir;
   struct dirent *dp;

   char szCurrentFile[MAXPATHLEN];
   KTreeItem *lvi;
   LLSIZE llRecursiveDataSize, llRecursiveUsedSize;
   LLSIZE llDataSize, llUsedSize;
   int nRes;
   QString strSize;
   struct stat fStat;

   // Init
   *llDirDataSize = 0LL;
   *llDirUsedSize = 0LL;

   // 1. -*-*-*-*-*-*-*-*-*- First, list all files -*-*-*-*-*-*-*-*-*-

   // Check we have the access to in this dir
   nRes = access(szDir, F_OK | R_OK | X_OK);
   if (nRes == -1)
   {	return -1;
   }
    
   // Open directory
   dir = opendir(szDir);
   if (dir == NULL)
   { 	//fprintf(stderr, "error 001 in %s\n",szDir);
      return -1;	
   }

   while ((dp = readdir(dir)) != NULL)
   {
      // Get nature of the file (directory, symlink, ...)
      //kDebugInfo("LAST=%c=%ld\n", szDir[strlen(szDir)-1], szDir[strlen(szDir)-1]);
      if (szDir[strlen(szDir)-1] == '/')
	 sprintf(szCurrentFile, "%s%s", szDir, dp->d_name);
      else
	 sprintf(szCurrentFile, "%s/%s", szDir, dp->d_name);
				
      lstat(szCurrentFile, &fStat);
	
      if (S_ISREG(fStat.st_mode) && (strcmp(dp -> d_name, ".") != 0) && (strcmp(dp -> d_name, "..") != 0)) // Only files, not sym links and dirs
      {
	 // Size of the file
	 llDataSize = (LLSIZE) fStat.st_size;
	 llUsedSize = (LLSIZE) (fStat.st_blocks * 512); // IS IT RIGHT ? (sys/stat.h)

	 // Add Item to tree
	 lvi = new KTreeItem(lvParent);
	 CHECK_PTR( lvi );
	 lvi -> setText(0, dp -> d_name);
	 lvi -> setPixmap(0, getMainView()->getFilePixmap());
	 lvi -> setDataSize(llDataSize);
	 lvi -> setUsedSize(llUsedSize);
	 lvi -> setType(KTreeItem::File);

#ifdef KGRAPHSPACE_CHECK_FOR_FILESSIZES_CHANGES
	 // Add file to KDirWatch
	 m_kdwWatch -> addDir(szCurrentFile);
#endif
	 // Size
	 *llDirDataSize += llDataSize;
	 *llDirUsedSize += llUsedSize;

	 // Add file to "Files types stats"
	 m_stats->addFile(dp->d_name, llUsedSize, llDataSize);
      }
   }

   // Close directory
   closedir(dir);

   // 2. -*-*-*-*-*-*-*-*-*- Second, list all dir -*-*-*-*-*-*-*-*-*-

   // Open directory
   dir = opendir(szDir);
   if (dir == NULL)
   {	//fprintf(stderr, "error 002\n");
      return -1;	
   }

   while ((dp = readdir(dir)) != NULL)
   {
      // Get nature of the file (directory, symlink, ...)
      if (szDir[strlen(szDir)-1] == '/')
	 sprintf(szCurrentFile, "%s%s", szDir, dp->d_name);
      else
	 sprintf(szCurrentFile, "%s/%s", szDir, dp->d_name);
      lstat(szCurrentFile, &fStat);
	
      if (S_ISDIR(fStat.st_mode) && (strcmp(dp -> d_name, ".") != 0) && (strcmp(dp -> d_name, "..") != 0) && (!S_ISLNK(fStat.st_mode))) // Only directories
      {
	 if (bIsRoot)
	 {	progress->setProgress(progress->progress()+1);
	 }
	    
	 // Add Item to tree
	 lvi = new KTreeItem(lvParent);
	 CHECK_PTR( lvi );
	 lvi -> setText(0, dp -> d_name);
	 lvi -> setPixmap(0, getMainView() -> getFolderPixmap());
	    
	 // Add directory to KDirWatch
	 m_kdwWatch->addDir(szCurrentFile);
	 printf("**** ADDING KDIRWATCH, DIR (%s)\n", szCurrentFile);

	 nRes = diskExploreRecursive(lvi, progress, szCurrentFile, &llRecursiveDataSize, &llRecursiveUsedSize, false);
	 if (g_bThreadMustStop)
	    return -1;
	 if (nRes != -1) // If no error
	 {
	    *llDirDataSize += llRecursiveDataSize;
	    *llDirUsedSize += llRecursiveUsedSize;
	    lvi -> setDataSize(llRecursiveDataSize);
	    lvi -> setUsedSize(llRecursiveUsedSize);
	    lvi -> setType(KTreeItem::Directory);
	 }
      }
   }

   // Close directory
   closedir(dir);

   return 0;
}

// ===========================================================================================================================
int KGraphSpaceDoc::getNbChildsDirsInDir(const char *szDir)
{
   DIR *dir;
   struct dirent *dp;
   int nChilds = 0;
   int nRes;
   struct stat fStat;
   QString strDir;

   // Check we have the access to in this dir
   nRes = access(szDir, F_OK | R_OK | X_OK);
   if (nRes == -1)
   {	return -1;
   }
    
   // Open directory
   dir = opendir(szDir);
   if (dir == NULL)
   {  	return -1;	
   }

   while ((dp = readdir(dir)) != NULL)
   {	
      // Get nature of the file (directory, symlink, ...)

      if (szDir[strlen(szDir)-1] == '/')
	 strDir.sprintf("%s%s", szDir, dp->d_name);
      else
	 strDir.sprintf("%s/%s", szDir, dp->d_name);

      lstat(strDir.data(), &fStat);
	
      if (S_ISDIR(fStat.st_mode) && (strcmp(dp -> d_name, ".") != 0) && (strcmp(dp -> d_name, "..") != 0) && (!S_ISLNK(fStat.st_mode))) // Only directories
	 nChilds++;
   }
    
   // Close directory
   closedir(dir);

   return nChilds;
}

// ===========================================================================================================================
bool KGraphSpaceDoc::isDirectoryEmpty(const QString strPath)
{
   DIR *dir;
   struct dirent *dp;
   struct stat fStat;
   QString strFilename;

   // Open directory
   dir = opendir(strPath.data());
   if (dir == NULL)
   {  	return true; // dir empty = true
   }

   while ((dp = readdir(dir)) != NULL)
   {	
      // Get nature of the file (directory, symlink, ...)
      if (strPath.right(1) == "/")
	 strFilename.sprintf ("%s%s",strPath.data(), dp -> d_name);
      else
	 strFilename.sprintf ("%s/%s",strPath.data(), dp -> d_name);

      lstat(strFilename.data(), &fStat);
	
      if ((S_ISDIR(fStat.st_mode) || S_ISREG(fStat.st_mode)) && (strcmp(dp -> d_name, ".") != 0) && (strcmp(dp -> d_name, "..") != 0) && (!S_ISLNK(fStat.st_mode))) // Only directories
      {
	 closedir(dir);
	 return false; // dir not empty (at least a dir or file)
      }
   }
    
   // Close directory
   closedir(dir);

   return true;
}
// ===========================================================================================================================
void KGraphSpaceDoc::slotPopupFileCompressGz()
{
   QString strCommand;
    
   // Compress but don't delete original (done after if need)
   strCommand.sprintf("gzip -c %s > %s.gz", m_strCurrentItemPath.data(), m_strCurrentItemPath.data());
    
   m_proc.clearArguments();
   m_proc << "sh" << "-c" << strCommand.data();
   connect(&m_proc,SIGNAL(processExited(KProcess *)),this,SLOT(slotProcessExited(KProcess *)));
    
   g_bThreadRunning = true;
   QApplication::setOverrideCursor(waitCursor);
   m_proc.start(); //KProcess::NotifyOnExit);
}

// ===========================================================================================================================
void KGraphSpaceDoc::slotPopupFileCompressBz2()
{
    QString strCommand;

    // Compress but don't delete original (done after if need)
    strCommand.sprintf("bzip2 -c %s > %s.bz2", m_strCurrentItemPath.data(), m_strCurrentItemPath.data());

    m_proc.clearArguments();
    m_proc << "sh" << "-c" << strCommand.data();
    connect(&m_proc,SIGNAL(processExited(KProcess *)),this,SLOT(slotProcessExited(KProcess *)));
    
    g_bThreadRunning = true;
    QApplication::setOverrideCursor(waitCursor);
    m_proc.start(); //KProcess::NotifyOnExit);
}

// ===========================================================================================================================
void KGraphSpaceDoc::slotPopupFolderCompressGz()
{
   QString strCommand;
    
   strCommand.sprintf("cd %s/.. && tar cfz %s.tar.gz %s", m_strCurrentItemPath.data(), m_strCurrentItemName.data(), m_strCurrentItemName.data());
   m_proc.clearArguments();
   m_proc << "sh" << "-c" << strCommand.data();
   connect(&m_proc,SIGNAL(processExited(KProcess *)),this,SLOT(slotProcessExited(KProcess *)));
    
   g_bThreadRunning = true;
   QApplication::setOverrideCursor(waitCursor);
   m_proc.start(); //KProcess::NotifyOnExit);
}

// ===========================================================================================================================
void KGraphSpaceDoc::slotPopupFolderCompressBz2()
{
    QString strCommand;
    
    strCommand.sprintf("cd %s/.. && tar cf %s.tar %s && bzip2 %s.tar", m_strCurrentItemPath.data(), m_strCurrentItemName.data(), m_strCurrentItemName.data(), m_strCurrentItemName.data());
    m_proc.clearArguments();
    m_proc << "sh" << "-c" << strCommand.data();
    connect(&m_proc,SIGNAL(processExited(KProcess *)),this,SLOT(slotProcessExited(KProcess *)));
    
    g_bThreadRunning = true;
    QApplication::setOverrideCursor(waitCursor);
    m_proc.start(); //KProcess::NotifyOnExit);
}


// ===========================================================================================================================
void KGraphSpaceDoc::slotPopupDelete()
{
   KURL::List urlList;
    
   urlList.append(m_strCurrentItemPath.data());
   KonqOperations::del((QWidget *)m_app, KonqOperations::DEL, urlList);
}

// ===========================================================================================================================
void KGraphSpaceDoc::slotPopupMoveToTrash()
{
   KURL::List urlList;
    
   urlList.append(m_strCurrentItemPath.data());
   KonqOperations::del((QWidget *)m_app, KonqOperations::TRASH, urlList);
}

// ===========================================================================================================================
void KGraphSpaceDoc::slotProcessExited(KProcess */*proc*/)
{
   QApplication::restoreOverrideCursor();

   // Delete compressed (file/dir) if need
   if (m_app->getSettings().bDeleteAfterCompress)
   {	slotPopupDelete();    
   }

   g_bThreadRunning = false;

   // Update views
   getDrawView()->repaint();
}

// ===========================================================================================================================
void KGraphSpaceDoc::setCurrentItem(QString strPath, QString strName, int nType)
{
   // Delete the final "/" of the path if present
   if (strPath.right(1) == "/")
      m_strCurrentItemPath = strPath.left(strPath.length()-1);
   else
      m_strCurrentItemPath = strPath;
	
   m_strCurrentItemName = strName;
   m_nCurrentItemType = nType;
}


// ===========================================================================================================================
int KGraphSpaceDoc::addNewFiles(QListViewItem *lvParent, const char *szDir)
{
   DIR *dir;
   struct dirent *dp;

   char szCurrentFile[MAXPATHLEN];
   KTreeItem *kti;
   QListViewItem *lviCurrent;
   LLSIZE llDataSize, llUsedSize;
   int nRes;
   QString strSize;
   struct stat fStat;

   // 1. -*-*-*-*-*-*-*-*-*- First, list all files -*-*-*-*-*-*-*-*-*-
   // Open directory
   dir = opendir(szDir);
   if (dir == NULL)
   { 	//fprintf(stderr, "error 001 in %s\n",szDir);
      return -1;	
   }	

   while ((dp = readdir(dir)) != NULL)
   {
      // Get nature of the file (directory, symlink, ...)
      if (szDir[strlen(szDir)-1] == '/')
	 sprintf(szCurrentFile, "%s%s", szDir, dp->d_name);
      else
	 sprintf(szCurrentFile, "%s/%s", szDir, dp->d_name);
	
      lstat(szCurrentFile, &fStat);
	
      if (S_ISREG(fStat.st_mode) && (strcmp(dp -> d_name, ".") != 0) && (strcmp(dp -> d_name, "..") != 0)) // Only files, not sym links and dirs
      {
	 if (!getTreeView()->getLviFromPath(szCurrentFile)) // If file is not already in the tree
	 {
	    printf("UPDATE: ADDING File (%s)\n", szCurrentFile);
	    
	    // Size of the file
	    llDataSize = (LLSIZE) fStat.st_size;
	    llUsedSize = (LLSIZE) (fStat.st_blocks * 512); // IS IT RIGHT ? (sys/stat.h)

	    // Add Item to tree
	    kti = new KTreeItem(lvParent);
	    CHECK_PTR( kti );
	    kti -> setText(0, dp -> d_name);
	    kti -> setPixmap(0, getMainView()->getFilePixmap());
	    kti -> setDataSize(llDataSize);
	    kti -> setUsedSize(llUsedSize);
	    kti -> setType(KTreeItem::File);

#ifdef KGRAPHSPACE_CHECK_FOR_FILESSIZES_CHANGES	
	    // Add file to KDirWatch
	    m_kdwWatch -> addDir(szCurrentFile);
#endif		
    
	    // Add file type to stats
	    m_stats->addFile(dp->d_name, llUsedSize, llDataSize);
		
	    // Update parents directory sizes 
	    kti -> increaseSizeInAllParents(llUsedSize, llDataSize);
	 }
      }
   }

   // Close directory
   closedir(dir);
    
   // 2. -*-*-*-*-*-*-*-*-*- Second, list all dir -*-*-*-*-*-*-*-*-*-

   // Open directory
   dir = opendir(szDir);
   if (dir == NULL)
   {	//fprintf(stderr, "error 002\n");
      return -1;	
   }

   while ((dp = readdir(dir)) != NULL)
   {
      // Get nature of the file (directory, symlink, ...)
      if (szDir[strlen(szDir)-1] == '/')
	 sprintf(szCurrentFile, "%s%s", szDir, dp->d_name);
      else
	 sprintf(szCurrentFile, "%s/%s", szDir, dp->d_name);
      lstat(szCurrentFile, &fStat);
	
      if (S_ISDIR(fStat.st_mode) && (strcmp(dp -> d_name, ".") != 0) && (strcmp(dp -> d_name, "..") != 0) && (!S_ISLNK(fStat.st_mode))) // Only directories
      {
	    
	 if ((lviCurrent = getTreeView()->getLviFromPath(szCurrentFile))) // If item is not already in the tree		
	 {	
	    printf("- checking dir (%s)\n", szCurrentFile);
	    nRes = addNewFiles(lviCurrent, szCurrentFile); 
	 }
	    
      }
   }

   // Close directory
   closedir(dir);
   return 0;
}

// ===========================================================================================================================
int KGraphSpaceDoc::addNewDirectories(QListViewItem *lvParent, const char *szDir)
{
   DIR *dir;
   struct dirent *dp;

   char szCurrentFile[MAXPATHLEN];
   KTreeItem *kti;
   int nRes;
   QString strSize;
   struct stat fStat;

   // -*-*-*-*-*-*-*-*-*- Second, list all dir -*-*-*-*-*-*-*-*-*-

   // Open directory
   dir = opendir(szDir);
   if (dir == NULL)
   {	//fprintf(stderr, "error 002\n");
      return -1;	
   }

   while ((dp = readdir(dir)) != NULL)
   {
      // Get nature of the file (directory, symlink, ...)
      if (szDir[strlen(szDir)-1] == '/')
	 sprintf(szCurrentFile, "%s%s", szDir, dp->d_name);
      else
	 sprintf(szCurrentFile, "%s/%s", szDir, dp->d_name);
      lstat(szCurrentFile, &fStat);
	
      if (S_ISDIR(fStat.st_mode) && (strcmp(dp -> d_name, ".") != 0) && (strcmp(dp -> d_name, "..") != 0) && (!S_ISLNK(fStat.st_mode))) // Only directories
      {
	 if (!getTreeView()->getLviFromPath(szCurrentFile)) // If item is not already in the tree		
	 {	
	    printf("UPDATE: ADDING Dir (%s)\n", szCurrentFile);

	    // Add Item to tree
	    kti = new KTreeItem(lvParent);
	    CHECK_PTR( kti );
	    kti -> setText(0, dp -> d_name);
	    kti -> setPixmap(0, getMainView() -> getFolderPixmap());
	    kti -> setDataSize(0LL);
	    kti -> setUsedSize(0LL);
	    kti -> setType(KTreeItem::Directory);
	    
	    // Add directory to KDirWatch
	    m_kdwWatch->addDir(szCurrentFile);
	    printf("**** ADDING KDIRWATCH, DIR (%s)\n", szCurrentFile);

	    nRes = addNewDirectories(kti, szCurrentFile);
	 }
	    
      }
   }

   // Close directory
   closedir(dir);
   return 0;
}

// ===========================================================================================================================
int KGraphSpaceDoc::removeDeletedFilesAndDirs(QListViewItem *lvParent, const char *szDir)
{
   QListViewItem *lvi;
   QString strFilename;
   QFileInfo fiFile;
   LLSIZE llDataSize, llUsedSize;
   KTreeItem *kti;
    
   lvi = lvParent->firstChild();
   while (lvi)
   {
      kti = (KTreeItem *) lvi;
      kti->getUsedSize(&llUsedSize);
      kti->getDataSize(&llDataSize);
	
      if (szDir[strlen(szDir)-1] == '/')
	 strFilename.sprintf("%s%s", szDir, lvi->text(0).data());
      else
	 strFilename.sprintf("%s/%s", szDir, lvi->text(0).data());

		
      fiFile.setFile(strFilename);
	
      // Do it now, after lvi will be deleted
      lvi = lvi->nextSibling();
	
      // If file/dir was deleted
      if (!fiFile.exists())
      {
	 // Delete file from "Files types stats"
	 m_stats->removeFile(strFilename.data(), llUsedSize, llDataSize);

	 kti->decreaseSizeInAllParents(llUsedSize, llDataSize);
	 delete kti; // Remove item from tree
      }
   }

   return 0;
}

// ===========================================================================================================================
void KGraphSpaceDoc::slotUpdateDirChanged(const QString &strPath)
{
   //if (g_bThreadRunning) // Ignore message if doing an operation
   //	return;

   printf("Directory (%s) was updated\n",strPath.data());
    
   // A new directory or file was created in strPath
   // Then, rexplore the directory, and add missing dirs and files
   KTreeItem *kti;
   QListViewItem *lvi;
   //LLSIZE llDataSize, llUsedSize;
   int nType;

   lvi = getTreeView()->getLviFromPath(strPath.data());
   if (!lvi) // If error
      return;

   kti = (KTreeItem *) lvi;
   kti->getType(&nType);
    
   // ---------------------------------------------------------
   if (nType == KTreeItem::Directory) // IF IT IS A DIRECTORY
   {
      // 1. Check for new directories (all them to tree and to KDirWatch)
      addNewDirectories(lvi, strPath.data());
    
      // 2. Add new files to tree
      addNewFiles(lvi, strPath.data());
	
      // 3. Remove deleted files from the tree
      removeDeletedFilesAndDirs(lvi, strPath.data());	
   }
#ifdef KGRAPHSPACE_CHECK_FOR_FILESSIZES_CHANGES
   else if (nType == KTreeItem::File) // IF IT IS A FILE
   {
      LLSIZE llOldDataSize;
      LLSIZE llNewDataSize;
      LLSIZE llOldUsedSize;
      LLSIZE llNewUsedSize;
      struct stat fStat;
	
      // Get new size of file
      lstat(strPath.data(), &fStat);
      llNewDataSize = (LLSIZE) fStat.st_size;
      llNewUsedSize = (LLSIZE) (fStat.st_blocks * 512); // IS IT RIGHT ? (sys/stat.h)
      kti->getUsedSize(&llOldUsedSize); 
      kti->getDataSize(&llOldDataSize);
	
      kti->setDataSize(llNewDataSize);
      kti->setUsedSize(llNewUsedSize);

      // Update file type to stats
      m_stats->removeFile(strPath.data(), llOldUsedSize, llOldDataSize);
      m_stats->addFile(strPath.data(), llNewUsedSize, llNewDataSize);
		
      // Update parents dir
      kti->decreaseSizeInAllParents(llOldUsedSize, llOldDataSize);    
      kti->increaseSizeInAllParents(llNewUsedSize, llNewDataSize);    
   } 
#endif

   // Update the graph view
   getDrawView()->drawWindow();
}

// ===========================================================================================================================
KDrawView *KGraphSpaceDoc::getDrawView()
{
   return m_app->getDrawView();
}

// ===========================================================================================================================
KTreeView *KGraphSpaceDoc::getTreeView()
{
   return m_app->getTreeView();
}

// ===========================================================================================================================
KGraphSpaceView *KGraphSpaceDoc::getMainView()
{
   return m_app->getMainView();
}

// ===========================================================================================================================
void KGraphSpaceDoc::slotPopupProperties() // Files & Folders
{
   //printf ("=============> Current path = %s\n", m_strCurrentItemPath.data());

   KURL url(m_strCurrentItemPath);
   (void) new KPropertiesDialog(url);
}

// ===========================================================================================================================
void KGraphSpaceDoc::slotPopupFolderOpenInKonqueror()
{
   (void) new KRun(m_strCurrentItemPath);
}

// ===========================================================================================================================
void KGraphSpaceDoc::slotPopupFolderOpenInKonsole()
{
   QString strCommand;
   strCommand.sprintf("cd \"%s\" ; konsole &", m_strCurrentItemPath.data());
   system(strCommand.data());
}

// ===========================================================================================================================
void KGraphSpaceDoc::slotPopupFileOpenWith()
{
   if (m_strCurrentItemPath.isEmpty())
      return;
	
   KURL::List kurls;
   kurls.append(m_strCurrentItemPath);
	
   KFileOpenWithHandler dlg;
   dlg.displayOpenWithDialog(kurls);
}

