/***************************************************************************
                          kgraphspace.h  -  description
                             -------------------
    begin                : dim nov  7 11:19:47 CET 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : dupoux@dupoux.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KGRAPHSPACE_H
#define KGRAPHSPACE_H
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for KDE 
#include <kapp.h>
#include <kmainwindow.h>
#include <qprogressdialog.h>
#include <klocale.h>

// App includes
#include "ksettings.h"
#include "resource.h"

// forward declaration of the KGraphSpace classes
class KGraphSpaceDoc;
class KGraphSpaceView;
class KDrawView;
class KTreeView;
class KAboutKGraphSpace;

// Global variables
extern KApplication *g_app;
extern bool g_bThreadRunning;
extern bool g_bThreadMustStop;

// ---------------------------------------
class KGraphSpaceApp : public KMainWindow
{
  Q_OBJECT

 public:
  KGraphSpaceApp(QString strDir);
  ~KGraphSpaceApp();
  KGraphSpaceDoc *getDocument() const;

 protected:
  void saveOptions();
  void readOptions();
  void initGUI();
  void initStatusBar();
  void initDocument(QString strDir);
  void initView();

 public slots:
  void diskExplore();
  void slotFileConfigureToolbars();
  void slotFilePrint();
  void slotFileQuit();
  void slotStatusMsg(const QString &text);
  void slotFileDirUp();
  void slotFileSave();
  void slotStopExploring() { g_bThreadMustStop = true; }
  void showAboutApplication();
  void updateCommands();
  void slotFilePreferences();
  void slotFileStats();
  void appHelpActivated();
  void contextHelpActivated();
  void aboutKDE();
  void reportBug();

 private:
  QProgressDialog* m_pb;
  KConfig *m_config;
  KSettings m_settings;
  KGraphSpaceView *m_view;
  KGraphSpaceDoc *m_doc;

 public:
  KDrawView *getDrawView();
  KTreeView *getTreeView();
  KGraphSpaceView *getMainView();
  KSettings getSettings() { return m_settings;}

 private:
  KAboutKGraphSpace *m_dlgAbout;
};
 
#endif // KGRAPHSPACE_H
