/***************************************************************************
                          kgraphspace.cpp  -  description
                             -------------------
    begin                : dim nov  7 11:19:47 CET 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : dupoux@dupoux.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for QT
#include <qdir.h>
#include <qstrlist.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qmessagebox.h>
#include <qwhatsthis.h>
#include <qxembed.h>

// include files for KDE
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kstddirs.h>
#include <kstdaction.h>
#include <kaboutdialog.h>
#include <kedittoolbar.h>
#include <kaction.h>
#include <kaboutkde.h>
#include <kbugreport.h>
#include <kstatusbar.h>

// application specific includes
#include "kgraphspace.h"
#include "kgraphspaceview.h"
#include "kgraphspacedoc.h"
#include "resource.h"
#include "ktreeitem.h"
#include "koptionsdlg.h"
#include "kstatsdlg.h"
#include "kaboutkgraphspace.h"

bool g_bThreadRunning = false;
bool g_bThreadMustStop = false;

// ===========================================================================================================================
KGraphSpaceApp::KGraphSpaceApp(QString strDir)
{
   m_config=kapp->config();
   m_dlgAbout = NULL;

   ///////////////////////////////////////////////////////////////////
      // call inits to invoke all other construction parts
      initGUI();

      readOptions();

      initDocument(strDir);
      initView();

      // Run the operation
      diskExplore();
      updateCommands();
}

// ===========================================================================================================================
KGraphSpaceApp::~KGraphSpaceApp()
{

}

// ===========================================================================================================================
void KGraphSpaceApp::updateCommands() // Gray and ungray commands when need
{
   // Is the current item not root ?
   actionCollection()->action("dirup")->setEnabled(((!g_bThreadRunning) && (getTreeView()->currentItem() != getTreeView()->firstChild())));

   // Others
   actionCollection()->action("file_print")->setEnabled(!g_bThreadRunning);
   actionCollection()->action("file_save")->setEnabled(!g_bThreadRunning);
   actionCollection()->action("stats")->setEnabled(!g_bThreadRunning);
   actionCollection()->action("preferences")->setEnabled(!g_bThreadRunning);
   actionCollection()->action("file_quit")->setEnabled(!g_bThreadRunning);
}


// ===========================================================================================================================
void KGraphSpaceApp::initGUI()
{
   // File menufile_
   KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection(), "file_quit");
   KStdAction::print(this, SLOT(slotFilePrint()), actionCollection(), "file_print");
   KStdAction::save(this, SLOT(slotFileSave()), actionCollection(), "file_save");
   (void) new KAction(i18n("&Parent directory"), "dirup", 0, this, SLOT(slotFileDirUp()), actionCollection(), "dirup");
   (void) new KAction(i18n("&Show directory stats..."), "stats", 0, this, SLOT(slotFileStats()), actionCollection(), "stats");

   // Settings
   KStdAction::preferences(this, SLOT(slotFilePreferences()), actionCollection(), "preferences");
   KStdAction::configureToolbars(this, SLOT(slotFileConfigureToolbars()), actionCollection(), "toolbars");

   // Help menu
   setHelpMenuEnabled(false);
   KStdAction::aboutApp(this, SLOT(showAboutApplication(void)), actionCollection());
   KStdAction::helpContents(this, SLOT(appHelpActivated()), actionCollection());
   KStdAction::whatsThis(this, SLOT(contextHelpActivated()), actionCollection());
   KStdAction::reportBug(this, SLOT(reportBug()), actionCollection());
   KStdAction::aboutKDE(this, SLOT(aboutKDE()), actionCollection());

   // Init statusbar
   statusBar()->insertItem(i18n(IDS_STATUS_DEFAULT), ID_STATUS_MSG);

   // Create GUI
   createGUI();
}

// ===========================================================================================================================
void KGraphSpaceApp::initDocument(QString strDir)
{
   int nRes;

   m_doc = new KGraphSpaceDoc(this);
   nRes = m_doc->newDocument(strDir);
   if (nRes == false)
      slotFileQuit();	
}

// ===========================================================================================================================
void KGraphSpaceApp::diskExplore()
{
   // Progress Dialog
   g_bThreadRunning = true;
   g_bThreadMustStop = false;
	
   // Empty the tree view
   getTreeView()->clear();
    
   int nRes;

   m_pb = new QProgressDialog(i18n("Exploring"), i18n("Cancel"), 100, this, "WaitDlg");
   if (m_pb == 0)
      return;
    
   m_pb -> setCaption(i18n("Exploring disk, please wait..."));
   m_pb -> setAutoClose(false);
   m_pb -> show();

   connect(m_pb, SIGNAL(cancelled()), this, SLOT(slotStopExploring()));
    
   nRes = m_doc -> diskExplore(m_pb);
   if (nRes == -1)
   {	
      g_bThreadRunning = false;
      delete m_pb;
      slotFileQuit();
   }
   // Select root item
   getTreeView() -> setSelected(getTreeView()->firstChild(), true);
   updateCommands();

   delete m_pb; // Destroy the Progress Dialog
   g_bThreadRunning = false;    
}

// ===========================================================================================================================
void KGraphSpaceApp::initView()
{
   ////////////////////////////////////////////////////////////////////
   // create the main widget here that is managed by KTMainWindow's view-region and
   // connect the widget to your document to display document contents.

   m_view = new KGraphSpaceView(this, "view");

   m_doc->addView(m_view); //setView(m_view);
   setCentralWidget(m_view);
   m_view -> init();
   m_view -> setAcceptDrops(false);

   QString caption=kapp->caption();	
   setCaption(caption+": "+m_doc->getTitle());
}

// ===========================================================================================================================
KGraphSpaceDoc *KGraphSpaceApp::getDocument() const
{
  return m_doc;
}

// ===========================================================================================================================
void KGraphSpaceApp::slotFileConfigureToolbars()
{
   KEditToolbar edit(actionCollection());
	
   if (edit.exec() == true)
   {	createGUI();
   }
   updateCommands();
}

// ===========================================================================================================================
void KGraphSpaceApp::slotFilePreferences()
{
   KOptionsDlg dlg(this, 0, m_settings);
	
   if (dlg.exec() == QDialog::Rejected) // If Cancel
      return ;

   m_settings = dlg.getSettings();
   saveOptions();
    
   // Update current actions if need
   m_doc->setAutoRefresh();
	
   saveOptions();
   updateCommands();
}

// ===========================================================================================================================
void KGraphSpaceApp::slotFileStats()
{
   KStatsDlg dlg(this, m_doc->getStats());
   dlg.exec();
	
   slotStatusMsg(i18n("Ready."));
}

// ===========================================================================================================================
void KGraphSpaceApp::saveOptions()
{	
   m_config->setGroup("General Options");
   m_config->writeEntry("Geometry", size());

   m_config->setGroup("General settings");
   m_config->writeEntry("AutoRefresh", m_settings.bAutoRefresh);
   m_config->writeEntry("DeleteAfterCompress", m_settings.bDeleteAfterCompress);
   m_config->writeEntry("RefreshFreq", (int) m_settings.nRefreshFreq);
   m_config->writeEntry("OtherPct", (int) m_settings.nOtherPct);

   m_config->sync();
}


// ===========================================================================================================================
void KGraphSpaceApp::readOptions()
{
   m_config->setGroup("General Options");

   // Size of main window
   QSize size=m_config->readSizeEntry("Geometry");
   if(!size.isEmpty())
   {
      resize(size);
   }

   // General settings
   m_config->setGroup("General settings");
   m_settings.bAutoRefresh = m_config->readBoolEntry("AutoRefresh", OPTIONS_DEFAULT_AUTOREFRESH);
   m_settings.bDeleteAfterCompress = m_config->readBoolEntry("DeleteAfterCompress", OPTIONS_DEFAULT_DELETEAFTERCOMPRESS);
   m_settings.nRefreshFreq = m_config->readNumEntry("RefreshFreq", OPTIONS_DEFAULT_REFRESHFREQ);
   m_settings.nOtherPct = m_config->readNumEntry("OtherPct", OPTIONS_DEFAULT_OTHERPCT);
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

// ===========================================================================================================================
void KGraphSpaceApp::slotFilePrint()
{
   slotStatusMsg(i18n("Printing..."));

   QPrinter printer;
		
   printer.setPrintProgram("KGraphSpace");
   printer.setDocName(getTreeView() -> currentDirectory()->text(0));

   if (printer.setup(this))
   {	getDrawView()->printGraph(&printer);
   }

   slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
   updateCommands();
}


// ===========================================================================================================================
void KGraphSpaceApp::slotFileQuit()
{
   slotStatusMsg(i18n("Exiting..."));
   saveOptions();
    
   // close the first window, the list makes the next one the first again.
   // This ensures that queryClose() is called on each window to ask for closing
   /*KTMainWindow* w;
     if(memberList)
     {
     for(w=memberList->first(); w!=0; w=memberList->first())
     {
     // only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
     // the window and the application stay open.
     if(!w->close())
     break;
     }
     }*/
   //delete this; // Else, the app is not closed !!!
  
   kapp->quit();
   exit(1);

   //slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

// ===========================================================================================================================
void KGraphSpaceApp::showAboutApplication(void)
{
   if(m_dlgAbout == NULL)
   {	m_dlgAbout = new KAboutKGraphSpace(this, 0, false);
   if(m_dlgAbout == NULL) { return; }
   }

   if(m_dlgAbout->isVisible() == false)
   {
      m_dlgAbout->show();
   }
   else
   {
      m_dlgAbout->raise();
   }

   // Update menu & toolbar commands
   updateCommands();
}

// ===========================================================================================================================
void KGraphSpaceApp::slotFileDirUp()
{
   QListViewItem *lvi;
   lvi = getTreeView() -> currentItem();

   if ((lvi == 0) || (lvi == getTreeView() -> firstChild()))	
      return;

   getTreeView() -> setCurrentItem( lvi -> parent() );
   getTreeView() -> setSelected(lvi -> parent(), true);

   // Redraw graph
   getDrawView() -> drawWindow();
   updateCommands();
}

// ===========================================================================================================================
void KGraphSpaceApp::slotFileSave()
{
   int nRes;
   QString strFilename;
   QString strFilter;
   QString strFormat;
   QPixmap pm;
    
   pm = QPixmap::grabWidget(getDrawView());
   if (pm.isNull())
      return;
    
   // Select file
   strFilter.sprintf("*.png|PNG (Portable Network Graphics) format files\n*.bmp|BMP files\n*|All files");
   KFileDialog dlg(QString::null, strFilter, (QWidget *) this, i18n("Save pie chart as image"), true);
   strFilename = dlg.getSaveFileName(QString::null, strFilter, (QWidget *) this, i18n("Save pie chart as image"));
   strFormat = dlg.currentFilter();
   if (strFilename.isEmpty() || strFormat.isEmpty())
      return;
    
   if (strFormat == "*.png")
   {
      nRes = pm.save(strFilename, "PNG");
   }
   if (strFormat == "*.bmp")
   {
      nRes = pm.save(strFilename, "PNG");
   }

   updateCommands();
}

// ===========================================================================================================================
void KGraphSpaceApp::slotStatusMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG);
}

// ===========================================================================================================================
KTreeView *KGraphSpaceApp::getTreeView()
{	
   return m_view->m_vwDir;
}

// ===========================================================================================================================
KDrawView *KGraphSpaceApp::getDrawView()
{	
   return m_view->m_vwDraw;
}

// ===========================================================================================================================
KGraphSpaceView *KGraphSpaceApp::getMainView()
{	
   return m_view;
}

// ===========================================================================================================================
void KGraphSpaceApp::appHelpActivated()
{
   kapp->invokeHelp();
}

// ===========================================================================================================================
void KGraphSpaceApp::contextHelpActivated()
{
   QWhatsThis::enterWhatsThisMode();
   QWidget* w = QApplication::widgetAt( QCursor::pos(), TRUE );
   while ( w && !w->isTopLevel() && !w->inherits("QXEmbed")  )
      w = w->parentWidget();
   if ( w && w->inherits("QXEmbed") )
      (( QXEmbed*) w )->enterWhatsThisMode();
}

// ===========================================================================================================================
void KGraphSpaceApp::aboutKDE()
{
   KAboutKDE dlg(this, "aboutkde", true);
   dlg.show();
}

// ===========================================================================================================================
void KGraphSpaceApp::reportBug()
{
   KBugReport dlg(this, true);
   dlg.show();
}
