/***************************************************************************
                          kdrawview.h  -  description
                             -------------------
    begin                : Thu Nov 11 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : dupoux@dupoux.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KGRAPHSPACEDRAW_H
#define KGRAPHSPACEDRAW_H

#include <qwidget.h>
#include <qregion.h>
#include <qtooltip.h>
#include <qprinter.h>

#include "resource.h"
#include "ktreeitem.h"
#include "kgraphpart.h"

class KTreeView;
class KGraphSpaceApp;
class KGraphSpaceView;


// ===========================================================================================================================
class KDrawView : public QWidget
{
	Q_OBJECT

public: 
	KDrawView(QWidget * parent, const char *name);
	~KDrawView();
	void drawGraph(QPainter *qp, bool bPrinting);
	int convertTreeToClass();
	int getRegionNumber(QPoint pt);
	void drawWindow();
	KTreeView *getTreeView();
	KGraphSpaceView *getMainView();
  int printGraph(QPrinter *printer);

protected:
	void mouseReleaseEvent( QMouseEvent *);
	void mouseMoveEvent ( QMouseEvent * );
	void mouseDoubleClickEvent ( QMouseEvent * );
	void paintEvent ( QPaintEvent * );

private:
	KGraphSpaceApp *m_app;
	KGraphPart m_kgpPart[PARTS_MAXNB];
	QRegion m_qrRegion[PARTS_MAXNB];
	int m_nCurPartNum;
};

#endif


