//  Copyright (c) 2017 Hartmut Kaiser
//
//  SPDX-License-Identifier: BSL-1.0
//  Distributed under the Boost Software License, Version 1.0. (See accompanying
//  file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <hpx/config.hpp>

#include <hpx/local/future.hpp>
#include <hpx/local/init.hpp>

#include <array>

int hpx_main()
{
    std::array<hpx::future<int>, 2> future_array{
        {hpx::make_ready_future(0), hpx::make_ready_future(0)}};

    hpx::wait_any(future_array);

    return hpx::local::finalize();
}

int main(int argc, char* argv[])
{
    return hpx::local::init(hpx_main, argc, argv);
}
