//  Copyright (c) 2015-2016 Hartmut Kaiser
//  Copyright (c)      2017 Taeguk Kwon
//
//  SPDX-License-Identifier: BSL-1.0
//  Distributed under the Boost Software License, Version 1.0. (See accompanying
//  file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

// make inspect happy: hpxinspect:nominmax

#pragma once

#include <hpx/config.hpp>
#include <hpx/datastructures/tagged.hpp>

namespace hpx { namespace parallel { inline namespace v1 {
    HPX_DEFINE_TAG_SPECIFIER(in)       // defines tag::in
    HPX_DEFINE_TAG_SPECIFIER(out)      // defines tag::out
    HPX_DEFINE_TAG_SPECIFIER(begin)    // defines tag::begin
    HPX_DEFINE_TAG_SPECIFIER(end)      // defines tag::end
    HPX_DEFINE_TAG_SPECIFIER(in1)      // defines tag::in1
    HPX_DEFINE_TAG_SPECIFIER(in2)      // defines tag::in2
    HPX_DEFINE_TAG_SPECIFIER(out1)     // defines tag::out1
    HPX_DEFINE_TAG_SPECIFIER(out2)     // defines tag::out2

#if defined(HPX_MSVC)
#pragma push_macro("min")
#pragma push_macro("max")
#undef min
#undef max
#endif

    HPX_DEFINE_TAG_SPECIFIER(min)    // defines tag::min
    HPX_DEFINE_TAG_SPECIFIER(max)    // defines tag::max

#if defined(HPX_MSVC)
#pragma pop_macro("min")
#pragma pop_macro("max")
#endif
}}}    // namespace hpx::parallel::v1
