/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*
 * GXMame
 *
 * Copyright 2002-2004 Stephane Pontier <shadow_walker@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "common.h"

#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtkcheckbutton.h>
#include <gtk/gtkcombo.h>
#include <gtk/gtkhscale.h>
#include <gtk/gtkhseparator.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkrange.h>
#include <gtk/gtkscale.h>
#include <gtk/gtkspinbutton.h>
#include <gtk/gtktable.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkvseparator.h>

#include "gxmame.h"
#include "options.h"
#include "io.h"
#include "callbacks.h"
#include "interface.h"
#include "gui.h"
#include "keyboard.h"

#define BUFFER_SIZE 1000

static gboolean dirty_options_flag;

/* display */
static GtkWidget *frameskip_combo;
static GtkWidget *frameskipper_combo;
static GtkWidget *maxautoframeskip_combo;
static GtkWidget *effect_entry;
static GtkWidget *arbheight_entry;
static GtkWidget *arbheight_checkbutton;
static GtkWidget *heightscale_spinbutton;
static GtkObject *heightscale_spinbutton_adj;
static GtkWidget *widthscale_spinbutton;
static GtkObject *widthscale_spinbutton_adj;
static GtkWidget *autodouble_checkbutton;
static GtkWidget *dirty_checkbutton;
static GtkWidget *scanlines_checkbutton;
static GtkWidget *throttle_checkbutton;
static GtkWidget *sleepidle_checkbutton;
static GtkWidget *frameskippercombo_entry;
static GtkWidget *frameskip_entry;
static GtkWidget *brightness_hscale;
static GtkWidget *gamma_hscale;
static GtkWidget *rotation_combo_entry;
static GtkWidget *norotate_checkbutton;
static GtkWidget *flipx_checkbutton;
static GtkWidget *flipy_checkbutton;
static GtkWidget *autoframeskip_checkbutton;
static GtkWidget *maxautoframeskip_entry;
static GtkWidget *bpp_combo_entry;
static GtkWidget *fts_label;
static GtkWidget *fs_method_label;
static GtkWidget *maxfs_label;
/* misc */
static GtkWidget *artwork_checkbutton;
/* Renderer */
static GtkObject *gamma_hscale_adj;
static GtkObject *brightness_hscale_adj;
 /* svga */
static GtkWidget *svga_tweak_table;
 /* xfx */
static GtkWidget *fxgkeepaspect_checkbutton;
static GtkWidget *fx_entry;
static GtkWidget *planar_checkbutton;
static GtkWidget *linear_checkbutton;
static GtkWidget *tweaked_mode_checkbutton;
static GtkWidget *centerx_spinbutton;
static GtkObject *centerx_spinbutton_adj;
static GtkWidget *centery_spinbutton;
static GtkObject *centery_spinbutton_adj;
 /* SDL */
static GtkWidget *render_mode_checkbutton;
static GtkWidget *phcursor_checkbutton;
static GtkWidget *sdl_modes_label;
static GtkWidget *sdl_modes_combo;
static GtkWidget *sdl_modes_spinbutton;
static GtkObject *sdl_modes_spinbutton_adj;
static GtkWidget *fullscreen_checkbutton;
static GtkWidget *doublebuf_checkbutton;
static GtkWidget *sdl_modes_checkbutton;
static GtkWidget *sdl_modes_entry;

/* OpenGL */
static GtkWidget *gltexture_size_spinbutton;
static GtkObject *gltexture_size_spinbutton_adj;
static GtkWidget *glext78_checkbutton;
static GtkWidget *glbilinear_checkbutton;
static GtkWidget *gldrawbitmap_checkbutton;
static GtkWidget *glantialias_checkbutton;
static GtkWidget *glalphablending_checkbutton;
static GtkWidget *gldblbuffer_checkbutton;
static GtkWidget *glforceblitmode_checkbutton;
static GtkWidget *cabview_checkbutton;
static GtkWidget *cabinet_entry;
static GtkWidget *glres_checkbutton;
static GtkWidget *glres_combo;
static GtkWidget *glres_combo_entry;
static GtkWidget *gllib_entry;
static GtkWidget *glulib_entry;
static GtkWidget *glcolormod_checkbutton;
 /* X11 */
static GtkWidget *video_mode_combo;
static GtkWidget *video_mode_combo_entry;
static GtkWidget *xvfullscreen_checkbutton;
static GtkWidget *xsync_checkbutton;
static GtkWidget *privatecmap_checkbutton;
static GtkWidget *xil_checkbutton;
static GtkWidget *mtxil_checkbutton;
static GtkWidget *cursor_checkbutton;
static GtkWidget *mitshm_checkbutton;
static GtkWidget *xvgeom_checkbutton;
static GtkWidget *xvgeom_entry;
static GtkWidget *xvgeom_combo;
static GtkWidget *yuv_entry;
static GtkWidget *yuv_combo;
static GtkWidget *displayaspectratio_entry;
static GtkWidget *disable_mode_entry;
static GtkWidget *keepaspect_checkbutton;

 /* ggi */
static GtkWidget *ggi_res_table;
static GtkWidget *ggilinear_checkbutton;
static GtkWidget *ggi_force_resolution_checkbutton;
static GtkWidget *ggix_spinbutton;
static GtkObject *ggix_spinbutton_adj;
static GtkWidget *ggiy_spinbutton;
static GtkObject *ggiy_spinbutton_adj;
/* Sound */
static GtkWidget *alsa_buffer_label;
static GtkWidget *alsacard_label;
static GtkWidget *alsadevice_label;
static GtkWidget *alsa_frame;
static GtkWidget *arts_frame;
static GtkWidget *qnx_frame;
static GtkWidget *PCM_label;
static GtkWidget *audiodevice_combo;
static GtkWidget *mixerdevice_label;
static GtkWidget *mixerdevice_combo;
static GtkWidget *samplefreq_label;
static GtkWidget *audiodevice_label;
static GtkWidget *samplefreq_combo;
static GtkWidget *volume_frame;
static GtkWidget *bufsize_frame;
static GtkWidget *sound_checkbutton;
static GtkWidget *samples_checkbutton;
static GtkWidget *samplefreq_entry;
static GtkWidget *db_hscale;
static GtkObject *db_hscale_adj;
static GtkWidget *bufsize_hscale;
static GtkObject *bufsize_hscale_adj;
static GtkWidget *audiodevice_combo_entry;
static GtkWidget *mixerdevice_entry;
static GtkWidget *fakesound_checkbutton;
static GtkWidget *mixer_plugin_entry;
static GtkWidget *dsp_plugin_entry;
static GtkWidget *timer_checkbutton;
static GtkWidget *audio_preferred_checkbutton;
static GtkWidget *arts_spinbutton;
static GtkObject *arts_spinbutton_adj;
static GtkWidget *alsa_buffer_spinbutton;
static GtkObject *alsa_buffer_spinbutton_adj;
static GtkWidget *alsacard_spinbutton;
static GtkObject *alsacard_spinbutton_adj;
static GtkWidget *alsadevice_spinbutton;
static GtkObject *alsadevice_spinbutton_adj;
static GtkWidget *pcm_entry;
static GtkWidget *soundfile_entry;
static GtkWidget *soundfile_hbox;
static GtkWidget *audiodevice_hbox;
/* Controllers*/
static GtkWidget *Xinput_joy_frame;
static GtkWidget *joydevname_label;
static GtkWidget *paddevname_label;
static GtkWidget *x11joyname_label;
static GtkWidget *winkeys_checkbutton;
static GtkWidget *mouse_checkbutton;
static GtkWidget *grabmouse_checkbutton;
static GtkWidget *grabkeyboard_checkbutton;
static GtkWidget *XInput_trackball1_entry;
static GtkWidget *XInput_trackball3_entry;
static GtkWidget *XInput_trackball2_entry;
static GtkWidget *XInput_trackball4_entry;
static GtkWidget *usbpspad_checkbutton;
static GtkWidget *hotrod_checkbutton;
static GtkWidget *rapidfire_checkbutton;
static GtkWidget *analogstick_checkbutton;
static GtkWidget *XInput_joystick1_entry;
static GtkWidget *XInput_joystick3_entry;
static GtkWidget *XInput_joystick2_entry;
static GtkWidget *XInput_joystick4_entry;
static GtkWidget *paddevname_entry;
static GtkWidget *x11joyname_entry;
static GtkWidget *hotrodse_checkbutton;
static GtkWidget *joytype_combo_entry;
static GtkWidget *joydevname_entry;
static GtkWidget *config_name_checkbutton;
static GtkWidget *config_name_entry;
static GtkWidget *ctrlr_combo;
static GtkWidget *ctrlr_combo_entry;
static GtkWidget *keymaptype_combo_entry;
static GtkWidget *ugcicoin_checkbutton;
/* Misc */
static GtkWidget *log_label;
static GtkWidget *debug_size_label;
static GtkWidget *debug_size_combo;
static GtkWidget *bios_label;
static GtkWidget *bios_combo;
static GtkWidget *artwork_resolution_combo;
static GtkWidget *artwork_frame;

static GtkWidget *use_backdrops_checkbutton;
static GtkWidget *use_bezels_checkbutton;
static GtkWidget *use_overlays_checkbutton;
static GtkWidget *artcrop_checkbutton;
static GtkWidget *artwork_resolution_combo_entry;
static GtkWidget *keyboard_leds_checkbutton;
static GtkWidget *cheat_checkbutton;
static GtkWidget *debug_checkbutton;
static GtkWidget *debug_size_combo_entry;
static GtkWidget *log_flag_checkbutton;
static GtkWidget *log_entry;
static GtkWidget *additional_options_checkbutton;
static GtkWidget *additional_options_entry;
static GtkWidget *bios_combo_entry;

/* Vector */
static GtkWidget *translucency_checkbutton;
static GtkWidget *beam_hscale;
static GtkWidget *flicker_hscale;
static GtkWidget *intensity_hscale;
static GtkWidget *gldrawbitmapvec_checkbutton;
static GtkWidget *glantialiasvec_checkbutton;
static GtkWidget *antialias_checkbutton;
static GtkWidget *vectorres_entry;
static GtkWidget *vector_fixed_resolution_checkbutton;
static GtkWidget *disclaimer_checkbutton;
static GtkWidget *gameinfo_checkbutton;

const char *bios_version[] = {
	N_("Europe, 1 Slot (also been seen on a 4 slot)"),
	N_("Europe, 4 Slot"),
	N_("US, 2 Slot"),
	N_("US, 6 Slot (V5?)"),
	N_("Asia S3 Ver 6"),
	N_("Japan, Ver 6 VS Bios"),
	N_("Japan, Older"),
	N_("Universe Bios v1.0 (hack)"),
	N_("Universe Bios v1.1 (hack)"),
	N_("Debug (Development) Bios"),
	N_("AES Console (Asia?) Bios"),
	N_("Universe Bios v1.2 (hack)"),
	NULL
};

static GtkWidget *
options_frame_new (const char *text)
{
	PangoFontDescription *font_desc;
	GtkWidget *label;
	GtkWidget *frame = gtk_frame_new (text);

	gtk_container_set_border_width (GTK_CONTAINER (frame), 6);
	gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_NONE);

	label = gtk_frame_get_label_widget (GTK_FRAME (frame));

	font_desc = pango_font_description_new ();
	pango_font_description_set_weight (font_desc,
					   PANGO_WEIGHT_BOLD);
	gtk_widget_modify_font (label, font_desc);
	pango_font_description_free (font_desc);

	return frame;
}

static GtkWidget *
options_frame_create_child (GtkWidget *widget)
{
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *label;

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (hbox), 6);
	gtk_container_add (GTK_CONTAINER (widget), hbox);
	gtk_widget_show (hbox);

	label = gtk_label_new ("    ");
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	gtk_widget_show (label);

	vbox = gtk_vbox_new (FALSE, 6);
	gtk_box_pack_start (GTK_BOX (hbox), vbox, TRUE, TRUE, 0);
	gtk_widget_show (vbox);

	return vbox;
}

static void
button_toggled      (GtkObject       *checkbutton,
                     gpointer         user_data)
{
	gtk_widget_set_sensitive (GTK_WIDGET (user_data), gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checkbutton)));
}

static void
not_button_toggled  (GtkObject       *checkbutton,
                     gpointer         user_data)
{
	gtk_widget_set_sensitive (GTK_WIDGET (user_data), !gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checkbutton)));
}

static void
autoframeskip_toggled   (GtkObject       *autoframeskip_checkbutton,
                         gpointer         user_data)
{
	gtk_widget_set_sensitive (frameskip_combo, !gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (autoframeskip_checkbutton)));
	gtk_widget_set_sensitive (frameskipper_combo, gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (autoframeskip_checkbutton)));
	gtk_widget_set_sensitive (maxautoframeskip_combo, gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (autoframeskip_checkbutton)));
	gtk_widget_set_sensitive (fts_label, !gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (autoframeskip_checkbutton)));
	gtk_widget_set_sensitive (fs_method_label, gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (autoframeskip_checkbutton)));
	gtk_widget_set_sensitive (maxfs_label, gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (autoframeskip_checkbutton)));
}

static void
joystick_choosen      (GtkObject       *combo_entry,
                       gpointer         user_data)
{
	gchar *used_text;
	
	used_text = gtk_editable_get_chars (GTK_EDITABLE (combo_entry), 0, -1);

	if (!g_ascii_strncasecmp ("No joystick", used_text, 10)) {
		gtk_widget_set_sensitive (analogstick_checkbutton, FALSE);
		gtk_widget_set_sensitive (usbpspad_checkbutton, FALSE);
		gtk_widget_set_sensitive (rapidfire_checkbutton, FALSE);
	} else {
		gtk_widget_set_sensitive (analogstick_checkbutton, TRUE);
		gtk_widget_set_sensitive (usbpspad_checkbutton, TRUE);
		gtk_widget_set_sensitive (rapidfire_checkbutton, TRUE);
	}

	/* Fm Town Pad */
	if (!g_ascii_strncasecmp ("FM", used_text, 2)) {
		gtk_widget_set_sensitive (paddevname_label, TRUE);
		gtk_widget_set_sensitive (paddevname_entry, TRUE);
	} else {
		gtk_widget_set_sensitive (paddevname_label, FALSE);
		gtk_widget_set_sensitive (paddevname_entry, FALSE);
	}

	 /* X11 input extension */
	if (!g_ascii_strncasecmp ("X11", used_text, 3)) {
		gtk_widget_set_sensitive (x11joyname_label, TRUE);
		gtk_widget_set_sensitive (x11joyname_entry, TRUE);
	} else {
		gtk_widget_set_sensitive (x11joyname_label, FALSE);
		gtk_widget_set_sensitive (x11joyname_entry, FALSE);
	}

	/* i386 style or new i386 linux 1.x.x driver */
	if (!g_ascii_strncasecmp ("i386", used_text, 4) || 
	    !g_ascii_strncasecmp ("Standard", used_text, 8)) {
		gtk_widget_set_sensitive (joydevname_label, TRUE);
		gtk_widget_set_sensitive (joydevname_entry, TRUE);
	} else {
		gtk_widget_set_sensitive (joydevname_label, FALSE);
		gtk_widget_set_sensitive (joydevname_entry, FALSE);
	}

	g_free (used_text);

}


static void
on_dirty_option     (GtkObject       *object,
                     gpointer         user_data)
{
	dirty_options_flag = TRUE;
	if (user_data)
		gtk_widget_set_sensitive (GTK_WIDGET (user_data), TRUE);
}


static void
combo_init (GtkWidget   *combo,
	    const gchar *option,
	    const gchar *key,
	    gint         value)
{
	GList *combo_items = NULL;
	GtkWidget *entry;
	const gchar **values;
	int i;
	const gchar *str_value;

	entry = GTK_COMBO (combo)->entry;
	values = xmame_get_option_values (current_exec, option);
	if (values) {
		for (i=0; values[i]; i++) {
			combo_items = g_list_append (combo_items, (gpointer) values[i]);
			if (!key && (i == value)) {
				gtk_entry_set_text (GTK_ENTRY (entry), values[i]);
			}
		}
		gtk_combo_set_popdown_strings (GTK_COMBO (combo), combo_items);
		g_list_free (combo_items);

		if (key) {
			str_value = xmame_get_option_key_value (current_exec, option, key);
		} else if (value > -1) {
			str_value = xmame_get_option_value (current_exec, option, value);
		} else {
			str_value = NULL;
		}

		if (str_value)
			gtk_entry_set_text (GTK_ENTRY (entry), str_value);
	}
}

static void
file_or_device (void)
{
	gchar *selected_plugin;
	const gchar *plugin;

	selected_plugin = gtk_editable_get_chars (GTK_EDITABLE (dsp_plugin_entry), 0, -1);
		
	plugin = xmame_get_option_key (current_exec, "dsp-plugin", selected_plugin);
 
	g_free (selected_plugin);

	if (plugin && !strcmp (plugin, "waveout")) {
		gtk_widget_set_sensitive (GTK_WIDGET (soundfile_hbox), TRUE);
		gtk_widget_set_sensitive (GTK_WIDGET (audiodevice_hbox), FALSE);
	} else {
		gtk_widget_set_sensitive (GTK_WIDGET (soundfile_hbox), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (audiodevice_hbox), TRUE);
	}
}
	 
     
void
add_display_options_tab (GtkWidget    *properties_windows,
			 GtkNotebook  *target_notebook,
			 RomEntry     *rom,
			 GameOptions *target,
			 GtkWidget    *apply_button,
			 GtkWidget    *reset_button)
{
	GtkWidget *image;
	GtkWidget *effects_frame;
	GtkWidget *effects_vbox;
	GtkWidget *effect_combo;
	GList *effect_combo_items = NULL;
	GtkWidget *corrections_frame;
	GtkWidget *correction_vbox;
	GtkWidget *gamma_label;
	GtkWidget *brightness_label;
	GtkWidget *display_general_vbox;
	GtkWidget *skipping_frame;
	GtkWidget *frameskip_table;
	GList *frameskip_combo_items = NULL;
	GList *maxautoframeskip_combo_items = NULL;
	GtkWidget *resolution_frame;
	GtkWidget *table11;
	GtkWidget *heightscale_label;
	GtkWidget *widthscale_label;
	GtkWidget *bpp_label;
/*	GtkObject *heightscale_spinbutton_adj; */
	GtkWidget *bpp_combo;
	GList *bpp_combo_items = NULL;
/*	GtkObject *widthscale_spinbutton_adj; */
	GtkWidget *rotation_frame;
	GtkWidget *vbox12;
	GtkWidget *combo;
	GList *combo_items = NULL;
	GtkWidget *display_label;
/*	GtkWidget *percent_label; */
	GtkWidget *hbox7;
	gchar title[BUFFER_SIZE];
	int i;
	GtkWidget *hbox;
	GtkWidget *vbox1;
	GtkWidget *vbox2;
	GtkSizeGroup *group = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);

	xmame_get_options (current_exec);

	dirty_options_flag = FALSE;

	image = gxmame_get_image_from_stock ("gxmame-display-toolbar");

	display_label = gtk_hbox_new (FALSE, 5);
	gtk_box_pack_start (GTK_BOX (display_label), image, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (display_label), gtk_label_new (_("Display")), FALSE, FALSE, 0);
	gtk_widget_show_all (display_label);

	hbox = gtk_hbox_new (FALSE, 12);
	gtk_widget_show (hbox);
	gtk_notebook_append_page (GTK_NOTEBOOK (target_notebook), hbox, display_label);

	vbox1 = gtk_vbox_new (FALSE, 6);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (hbox), vbox1, FALSE, FALSE, 0);
	vbox2 = gtk_vbox_new (FALSE, 6);
	gtk_widget_show (vbox2);
	gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 0);

	effects_frame = options_frame_new (_("Effects"));
	gtk_widget_show (effects_frame);
	gtk_box_pack_start (GTK_BOX (vbox2), effects_frame, FALSE, FALSE, 0);
	effects_frame = options_frame_create_child (effects_frame);

	effects_vbox = gtk_vbox_new (FALSE, 6);
	gtk_widget_show (effects_vbox);
	gtk_container_add (GTK_CONTAINER (effects_frame), effects_vbox);

	effect_combo = gtk_combo_new ();
	gtk_widget_show (effect_combo);
	gtk_box_pack_start (GTK_BOX (effects_vbox), effect_combo, TRUE, FALSE, 0);
	gtk_combo_set_value_in_list (GTK_COMBO (effect_combo), TRUE, FALSE);

	{
		const gchar **values;

		values = xmame_get_option_values (current_exec, "effect");

		if (values) {
			for (i=0; values[i]; i++)
				effect_combo_items = g_list_append (effect_combo_items, (gpointer) values[i]);
		}
	}
	gtk_combo_set_popdown_strings (GTK_COMBO (effect_combo), effect_combo_items);
	g_list_free (effect_combo_items);

	effect_entry = GTK_COMBO (effect_combo)->entry;
	gtk_widget_show (effect_entry);

	{
		const gchar *effect_name;

		effect_name = xmame_get_option_value (current_exec, "effect", target->effect);

		gtk_entry_set_text (GTK_ENTRY (effect_entry), effect_name?effect_name:"");
	}

	scanlines_checkbutton = gtk_check_button_new_with_label (_("Use Scanlines"));
	gtk_widget_show (scanlines_checkbutton);
	gtk_box_pack_start (GTK_BOX (effects_vbox), scanlines_checkbutton, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (scanlines_checkbutton), target->scanlines);

	corrections_frame = options_frame_new (_("Corrections"));
	gtk_widget_show (corrections_frame);
	gtk_box_pack_start (GTK_BOX (vbox2), corrections_frame, FALSE, FALSE, 0);
	corrections_frame = options_frame_create_child (corrections_frame);

	correction_vbox = gtk_vbox_new (FALSE, 6);
	gtk_widget_show (correction_vbox);
	gtk_container_add (GTK_CONTAINER (corrections_frame), correction_vbox);

	gamma_label = gtk_label_new (_("Gamma correction"));
	gtk_widget_show (gamma_label);
	gtk_box_pack_start (GTK_BOX (correction_vbox), gamma_label, FALSE, FALSE, 0);
	gtk_misc_set_alignment (GTK_MISC (gamma_label), 0, 0.5);

	gamma_hscale_adj = gtk_adjustment_new (target->gamma_correction, 0.5, 2, 0.05, 0.05, 0);
	gamma_hscale = gtk_hscale_new (GTK_ADJUSTMENT (gamma_hscale_adj));
	gtk_widget_show (gamma_hscale);
	gtk_box_pack_start (GTK_BOX (correction_vbox), gamma_hscale, TRUE, TRUE, 0);
	gtk_scale_set_value_pos (GTK_SCALE (gamma_hscale), GTK_POS_RIGHT);
	gtk_scale_set_digits (GTK_SCALE (gamma_hscale), 2);

	brightness_label = gtk_label_new (_("Brightness correction"));
	gtk_widget_show (brightness_label);
	gtk_box_pack_start (GTK_BOX (correction_vbox), brightness_label, FALSE, FALSE, 0);
	gtk_misc_set_alignment (GTK_MISC (brightness_label), 0, 0.5);

	hbox7 = gtk_hbox_new (FALSE, 5);
	gtk_widget_show (hbox7);
	gtk_box_pack_start (GTK_BOX (correction_vbox), hbox7, TRUE, TRUE, 0);


	/* FIXME: Detect brightness range */

	/*if (available_options->dos_brightness)
	{*/
		brightness_hscale_adj = gtk_adjustment_new (target->brightness, 0.5, 2, 0.05, 0.05, 0);
		brightness_hscale = gtk_hscale_new (GTK_ADJUSTMENT (brightness_hscale_adj));
		gtk_scale_set_digits (GTK_SCALE (brightness_hscale), 2);
	/*}
	else
	{
		brightness_hscale_adj = gtk_adjustment_new ( ((target->brightness)-0.5)* (100/1.5), 0, 100, 1, 1, 0);
		brightness_hscale = gtk_hscale_new (GTK_ADJUSTMENT (brightness_hscale_adj));
		gtk_scale_set_digits (GTK_SCALE (brightness_hscale), 0);
	}
	*/

	gtk_widget_show (brightness_hscale);
	gtk_box_pack_start (GTK_BOX (hbox7), brightness_hscale, TRUE, TRUE, 0);
	gtk_scale_set_value_pos (GTK_SCALE (brightness_hscale), GTK_POS_RIGHT);

	/*if (!available_options->dos_brightness)
	{
		percent_label = gtk_label_new ("%");
		gtk_widget_show (percent_label);
		gtk_box_pack_start (GTK_BOX (hbox7), percent_label, FALSE, FALSE, 0);
	}*/

	display_general_vbox = options_frame_new (_("Display options"));
	gtk_widget_show (display_general_vbox);
	gtk_box_pack_start (GTK_BOX (vbox1), display_general_vbox, FALSE, FALSE, 0);
	display_general_vbox = options_frame_create_child (display_general_vbox);

	dirty_checkbutton = gtk_check_button_new_with_label (_("Draw only changes"));
	gtk_widget_show (dirty_checkbutton);
	gtk_box_pack_start (GTK_BOX (display_general_vbox), dirty_checkbutton, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (dirty_checkbutton), target->dirty);

	throttle_checkbutton = gtk_check_button_new_with_label (_("Throttle"));
	gtk_widget_show (throttle_checkbutton);
	gtk_box_pack_start (GTK_BOX (display_general_vbox), throttle_checkbutton, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (throttle_checkbutton), target->throttle);

	sleepidle_checkbutton = gtk_check_button_new_with_label (_("Sleep when idle"));
	gtk_widget_show (sleepidle_checkbutton);
	gtk_box_pack_start (GTK_BOX (display_general_vbox), sleepidle_checkbutton, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sleepidle_checkbutton), target->sleepidle);

	skipping_frame = options_frame_new (_("Frame skipping"));
	gtk_widget_show (skipping_frame);
	gtk_box_pack_start (GTK_BOX (vbox2), skipping_frame, FALSE, FALSE, 0);
	skipping_frame = options_frame_create_child (skipping_frame);

	frameskip_table = gtk_vbox_new (FALSE, 6);
	gtk_widget_show (frameskip_table);
	gtk_box_pack_start (GTK_BOX (skipping_frame), frameskip_table, FALSE, FALSE, 0);

	autoframeskip_checkbutton = gtk_check_button_new_with_label (_("Automatic"));
	gtk_widget_show (autoframeskip_checkbutton);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (autoframeskip_checkbutton), target->autoframeskip);
	gtk_box_pack_start (GTK_BOX (frameskip_table), autoframeskip_checkbutton, TRUE, TRUE, 0);

	hbox = gtk_hbox_new (FALSE, 6);
	gtk_widget_show (hbox);
	gtk_box_pack_start (GTK_BOX (frameskip_table), hbox, TRUE, TRUE, 0);

	fts_label = gtk_label_new (_("Frames to skip:"));
	gtk_widget_show (fts_label);
	gtk_box_pack_start (GTK_BOX (hbox), fts_label, FALSE, FALSE, 0);
	gtk_misc_set_alignment (GTK_MISC (fts_label), 0, 0.5);
	gtk_size_group_add_widget (GTK_SIZE_GROUP (group), fts_label);

	frameskip_combo = gtk_combo_new ();
	gtk_widget_show (frameskip_combo);
	gtk_box_pack_start (GTK_BOX (hbox), frameskip_combo, TRUE, TRUE, 0);


	hbox = gtk_hbox_new (FALSE, 6);
	gtk_widget_show (hbox);
	gtk_box_pack_start (GTK_BOX (frameskip_table), hbox, TRUE, TRUE, 0);

	fs_method_label = gtk_label_new (_("Method:"));
	gtk_widget_show (fs_method_label);
	gtk_misc_set_alignment (GTK_MISC (fs_method_label), 0, 0.5);
	gtk_box_pack_start (GTK_BOX (hbox), fs_method_label, FALSE, FALSE, 0);
	gtk_size_group_add_widget (GTK_SIZE_GROUP (group), fs_method_label);

	frameskipper_combo = gtk_combo_new ();
	gtk_widget_show (frameskipper_combo);
	gtk_box_pack_start (GTK_BOX (hbox), frameskipper_combo, TRUE, TRUE, 0);



	hbox = gtk_hbox_new (FALSE, 6);
	gtk_widget_show (hbox);
	gtk_box_pack_start (GTK_BOX (frameskip_table), hbox, TRUE, TRUE, 0);

	maxfs_label = gtk_label_new (_("Max frameskip:"));
	gtk_widget_show (maxfs_label);
	gtk_misc_set_alignment (GTK_MISC (maxfs_label), 0, 0.5);
	gtk_box_pack_start (GTK_BOX (hbox), maxfs_label, FALSE, FALSE, 0);
	gtk_size_group_add_widget (GTK_SIZE_GROUP (group), maxfs_label);

	maxautoframeskip_combo = gtk_combo_new ();
	gtk_widget_show (maxautoframeskip_combo);
	gtk_box_pack_start (GTK_BOX (hbox), maxautoframeskip_combo, TRUE, TRUE, 0);


	frameskip_combo_items = NULL;
	frameskip_combo_items = g_list_append (frameskip_combo_items, (gpointer) g_strdup (_("Draw every frame")));

	for (i = 1; i < 12; i++) {
		g_snprintf (title, BUFFER_SIZE, _("Skip %i of 12 frames"), i);
		frameskip_combo_items = g_list_append (frameskip_combo_items, (gpointer) g_strdup (title));
	}

	gtk_combo_set_popdown_strings (GTK_COMBO (frameskip_combo), frameskip_combo_items);
	g_list_foreach (frameskip_combo_items, (GFunc)g_free, NULL);
	g_list_free (frameskip_combo_items);

	frameskip_entry = GTK_COMBO (frameskip_combo)->entry;
	gtk_widget_show (frameskip_entry);
	gtk_editable_set_editable (GTK_EDITABLE (frameskip_entry), FALSE);

	if (target->frameskip == 0 || target->frameskip > 11)
		g_snprintf (title, BUFFER_SIZE, "%s", _("Draw every frame"));
	else
		g_snprintf (title, BUFFER_SIZE, _("Skip %i of 12 frames"), target->frameskip);

	gtk_entry_set_text (GTK_ENTRY (frameskip_entry), title);
	gtk_widget_set_sensitive (frameskip_combo, ! (target->autoframeskip));


	combo_init (frameskipper_combo, "frameskipper", NULL, target->frameskipper);
	
	frameskippercombo_entry = GTK_COMBO (frameskipper_combo)->entry;
	gtk_widget_show (frameskippercombo_entry);
	gtk_editable_set_editable (GTK_EDITABLE (frameskippercombo_entry), FALSE);
	gtk_widget_set_sensitive (frameskipper_combo, target->autoframeskip && xmame_has_option (current_exec, "frameskipper"));

	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "0");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "1");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "2");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "3");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "4");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "5");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "6");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "7");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "8");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "9");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "10");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "11");
	gtk_combo_set_popdown_strings (GTK_COMBO (maxautoframeskip_combo), maxautoframeskip_combo_items);
	g_list_free (maxautoframeskip_combo_items);

	maxautoframeskip_entry = GTK_COMBO (maxautoframeskip_combo)->entry;
	gtk_widget_show (maxautoframeskip_entry);
	gtk_editable_set_editable (GTK_EDITABLE (maxautoframeskip_entry), FALSE);
	g_snprintf (title, BUFFER_SIZE, "%i", target->maxautoframeskip);
	gtk_entry_set_text (GTK_ENTRY (maxautoframeskip_entry), title);
	gtk_widget_set_sensitive (maxautoframeskip_combo, target->autoframeskip);

	resolution_frame = options_frame_new (_("Resolution"));
	gtk_widget_show (resolution_frame);
	gtk_box_pack_start (GTK_BOX (vbox1), resolution_frame, FALSE, FALSE, 0);
	resolution_frame = options_frame_create_child (resolution_frame);

	table11 = gtk_table_new (2, 5, FALSE);
	gtk_widget_show (table11);
	gtk_box_pack_start (GTK_BOX (resolution_frame), table11, TRUE, TRUE, 0);
	gtk_table_set_row_spacings (GTK_TABLE (table11), 6);
	gtk_table_set_col_spacings (GTK_TABLE (table11), 6);

	heightscale_label = gtk_label_new (_("Height scale:"));
	gtk_widget_show (heightscale_label);
	gtk_table_attach_defaults (GTK_TABLE (table11), heightscale_label, 0, 1, 0, 1);
	gtk_misc_set_alignment (GTK_MISC (heightscale_label), 0, 0.5);

	widthscale_label = gtk_label_new (_("Width scale:"));
	gtk_widget_show (widthscale_label);
	gtk_table_attach_defaults (GTK_TABLE (table11), widthscale_label, 0, 1, 1, 2);
	gtk_misc_set_alignment (GTK_MISC (widthscale_label), 0, 0.5);

	bpp_label = gtk_label_new (_("Bit per pixels:"));
	gtk_widget_show (bpp_label);
	gtk_table_attach_defaults (GTK_TABLE (table11), bpp_label, 0, 1, 2, 3);
	gtk_misc_set_alignment (GTK_MISC (bpp_label), 0, 0.5);

	heightscale_spinbutton_adj = gtk_adjustment_new (target->heightscale, 1, 8, 1, 10, 10);
	heightscale_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (heightscale_spinbutton_adj), 1, 0);
	gtk_widget_show (heightscale_spinbutton);
	gtk_table_attach_defaults (GTK_TABLE (table11), heightscale_spinbutton, 1, 2, 0, 1);
	gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (heightscale_spinbutton), TRUE);

	bpp_combo = gtk_combo_new ();
	gtk_widget_show (bpp_combo);
	gtk_table_attach_defaults (GTK_TABLE (table11), bpp_combo, 1, 2, 2, 3);

	bpp_combo_items = g_list_append (bpp_combo_items, (gpointer) _("Auto"));
	bpp_combo_items = g_list_append (bpp_combo_items, (gpointer) _("8 bits"));
	bpp_combo_items = g_list_append (bpp_combo_items, (gpointer) _("15 bits"));
	bpp_combo_items = g_list_append (bpp_combo_items, (gpointer) _("16 bits"));
	bpp_combo_items = g_list_append (bpp_combo_items, (gpointer) _("32 bits"));
	gtk_combo_set_popdown_strings (GTK_COMBO (bpp_combo), bpp_combo_items);
	g_list_free (bpp_combo_items);

	bpp_combo_entry = GTK_COMBO (bpp_combo)->entry;
	gtk_widget_show (bpp_combo_entry);
	gtk_editable_set_editable (GTK_EDITABLE (bpp_combo_entry), FALSE);
	switch (target->bpp) {
	case (8):
	case (15):
	case (16):
	case (32):
		g_snprintf (title, BUFFER_SIZE, _("%i bits"), target->bpp);
		break;
		/* case (0): or*/
	default:
		g_snprintf (title, BUFFER_SIZE, "%s", _("Auto"));
		break;
	}

	gtk_entry_set_text (GTK_ENTRY (bpp_combo_entry), title);

	widthscale_spinbutton_adj = gtk_adjustment_new (target->widthscale, 1, 8, 1, 10, 10);
	widthscale_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (widthscale_spinbutton_adj), 1, 0);
	gtk_widget_show (widthscale_spinbutton);
	gtk_table_attach_defaults (GTK_TABLE (table11), widthscale_spinbutton, 1, 2, 1, 2);
	gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (widthscale_spinbutton), TRUE);

	arbheight_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY (arbheight_entry), 4);
	gtk_widget_show (arbheight_entry);
	gtk_table_attach_defaults (GTK_TABLE (table11), arbheight_entry, 1, 2, 3, 4);
	g_snprintf (title, BUFFER_SIZE, "%i", target->arbheight);
	gtk_entry_set_text (GTK_ENTRY (arbheight_entry), title);
	gtk_widget_set_sensitive (arbheight_entry, target->arbheight);

	arbheight_checkbutton = gtk_check_button_new_with_label (_("Scale video to height:"));
	gtk_widget_show (arbheight_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (table11), arbheight_checkbutton, 0, 1, 3, 4);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (arbheight_checkbutton), target->arbheight);

	autodouble_checkbutton = gtk_check_button_new_with_label (_("Autodouble"));
	gtk_widget_show (autodouble_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (table11), autodouble_checkbutton, 0, 1, 4, 5);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (autodouble_checkbutton), target->autodouble);

	rotation_frame = options_frame_new (_("Rotation"));
	gtk_widget_show (rotation_frame);
	gtk_box_pack_start (GTK_BOX (vbox1), rotation_frame, FALSE, FALSE, 0);
	rotation_frame = options_frame_create_child (rotation_frame);

	vbox12 = gtk_vbox_new (FALSE, 6);
	gtk_widget_show (vbox12);
	gtk_box_pack_start (GTK_BOX (rotation_frame), vbox12, TRUE, TRUE, 0);

	combo = gtk_combo_new ();
	gtk_widget_show (combo);
	gtk_box_pack_start (GTK_BOX (vbox12), combo, FALSE, FALSE, 0);
	combo_items = g_list_append (combo_items, (gpointer) _("None"));
	combo_items = g_list_append (combo_items, (gpointer) _("Clockwise"));
	combo_items = g_list_append (combo_items, (gpointer) _("Anti-clockwise"));
	gtk_combo_set_popdown_strings (GTK_COMBO (combo), combo_items);
	g_list_free (combo_items);

	rotation_combo_entry = GTK_COMBO (combo)->entry;
	gtk_widget_show (rotation_combo_entry);
	gtk_editable_set_editable (GTK_EDITABLE (rotation_combo_entry), FALSE);

	if (target->ror)
		g_snprintf (title, BUFFER_SIZE, "%s", _("Clockwise"));
	else if (target->rol)
		g_snprintf (title, BUFFER_SIZE, "%s", _("Anti-clockwise"));
	else
		g_snprintf (title, BUFFER_SIZE, "%s", _("None"));
	gtk_entry_set_text (GTK_ENTRY (rotation_combo_entry), title);

	norotate_checkbutton = gtk_check_button_new_with_label (_("Do not apply rotation"));
	gtk_widget_show (norotate_checkbutton);
	gtk_box_pack_start (GTK_BOX (vbox12), norotate_checkbutton, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (norotate_checkbutton), target->norotate);

	flipx_checkbutton = gtk_check_button_new_with_label (_("Flip screen upside-down"));
	gtk_widget_show (flipx_checkbutton);
	gtk_box_pack_start (GTK_BOX (vbox12), flipx_checkbutton, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (flipx_checkbutton), target->flipx);

	flipy_checkbutton = gtk_check_button_new_with_label (_("Flip screen left-right"));
	gtk_widget_show (flipy_checkbutton);
	gtk_box_pack_start (GTK_BOX (vbox12), flipy_checkbutton, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (flipy_checkbutton), target->flipy);
			
	gtk_widget_set_sensitive ( GTK_WIDGET (dirty_checkbutton), xmame_has_option (current_exec, "dirty"));
	gtk_widget_set_sensitive (fts_label, !gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (autoframeskip_checkbutton)));
	gtk_widget_set_sensitive (fs_method_label, gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (autoframeskip_checkbutton)));
	gtk_widget_set_sensitive (maxfs_label, gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (autoframeskip_checkbutton)));

	g_signal_connect (G_OBJECT (dirty_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (dirty_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (throttle_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (throttle_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (sleepidle_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (sleepidle_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (scanlines_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (scanlines_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (norotate_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (norotate_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (flipx_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (flipx_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (flipy_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (flipy_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (autodouble_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (autodouble_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	g_signal_connect (G_OBJECT (autoframeskip_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (autoframeskip_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (arbheight_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (arbheight_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (autoframeskip_checkbutton), "toggled",
				G_CALLBACK (autoframeskip_toggled),
				NULL);
	g_signal_connect_after (G_OBJECT (arbheight_checkbutton), "toggled",
				G_CALLBACK (button_toggled),
				G_OBJECT (arbheight_entry));

	g_signal_connect (G_OBJECT (effect_entry), "changed",
			  G_CALLBACK (on_dirty_option),
			  apply_button);
	g_signal_connect (G_OBJECT (effect_entry), "changed",
			  G_CALLBACK (on_dirty_option),
			  reset_button);
	g_signal_connect (G_OBJECT (rotation_combo_entry), "changed",
			  G_CALLBACK (on_dirty_option),
			  apply_button);
	g_signal_connect (G_OBJECT (rotation_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (frameskip_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (frameskip_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (maxautoframeskip_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (maxautoframeskip_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (bpp_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (bpp_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (arbheight_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (arbheight_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (frameskippercombo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (frameskippercombo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	g_signal_connect (G_OBJECT (gtk_range_get_adjustment (GTK_RANGE (brightness_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment (GTK_RANGE (brightness_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment (GTK_RANGE (gamma_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment (GTK_RANGE (gamma_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	g_signal_connect (G_OBJECT (widthscale_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (widthscale_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (heightscale_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (heightscale_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

}

static GtkWidget *
get_x11_rendering_frame (GameOptions *target,
			 GtkWidget *apply_button,
			 GtkWidget *reset_button)
{
	GtkWidget *x11_frame_parent;
	GtkWidget *x11_frame;
	GtkWidget *x11_table;
	GList *xvgeom_combo_items = NULL;
	GtkWidget *yuv_label;
	GtkWidget *video_mode_label;	

	xmame_get_options (current_exec);

	/* X11 */
	x11_frame_parent = options_frame_new (_("X11 options"));
	x11_frame = options_frame_create_child (x11_frame_parent);

	x11_table = gtk_table_new (9, 1, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (x11_table), 6);
	gtk_table_set_col_spacings (GTK_TABLE (x11_table), 6);
	gtk_widget_show (x11_table);
	gtk_box_pack_start (GTK_BOX (x11_frame), x11_table, FALSE, FALSE, 0);

	/* Video mode label */	
	video_mode_label = gtk_label_new (_("Video mode:"));
	gtk_misc_set_alignment (GTK_MISC (video_mode_label), 0, 0.5);
	gtk_widget_show (video_mode_label);
	gtk_table_attach_defaults (GTK_TABLE (x11_table), video_mode_label, 0, 1, 0, 1);
	
	video_mode_combo = gtk_combo_new ();
	gtk_widget_show (video_mode_combo);
	gtk_table_attach_defaults (GTK_TABLE (x11_table), video_mode_combo, 1, 2, 0, 1);

	video_mode_combo_entry = GTK_COMBO (video_mode_combo)->entry;
	gtk_widget_show (video_mode_combo_entry);

	combo_init (video_mode_combo, "video-mode", NULL, target->x11_mode);

	xvfullscreen_checkbutton = gtk_check_button_new_with_label (_("Fullscreen"));
	gtk_widget_show (xvfullscreen_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (x11_table), xvfullscreen_checkbutton, 0, 2, 1, 2);

	cursor_checkbutton = gtk_check_button_new_with_label (_("Show cursor"));
	gtk_widget_show (cursor_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (x11_table), cursor_checkbutton, 0, 2, 2, 3);

	mitshm_checkbutton = gtk_check_button_new_with_label (_("Use MIT shared memory"));
	gtk_widget_show (mitshm_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (x11_table), mitshm_checkbutton, 0, 2, 3, 4);

	/* XV Geometry */
	xvgeom_checkbutton = gtk_check_button_new_with_label (_("Geometry:"));
	gtk_widget_show (xvgeom_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (x11_table), xvgeom_checkbutton, 0, 1, 4, 5);

	xvgeom_combo = gtk_combo_new ();
	gtk_widget_show (xvgeom_combo);
	gtk_table_attach_defaults (GTK_TABLE (x11_table), xvgeom_combo, 1, 2, 4, 5);
	xvgeom_combo_items = g_list_append (xvgeom_combo_items, (gpointer) "320x200");
	xvgeom_combo_items = g_list_append (xvgeom_combo_items, (gpointer) "640x480");
	xvgeom_combo_items = g_list_append (xvgeom_combo_items, (gpointer) "800x600");
	xvgeom_combo_items = g_list_append (xvgeom_combo_items, (gpointer) "1024x768");
	xvgeom_combo_items = g_list_append (xvgeom_combo_items, (gpointer) "1280x1024");
	xvgeom_combo_items = g_list_append (xvgeom_combo_items, (gpointer) "1600x1200");
	gtk_combo_set_popdown_strings (GTK_COMBO (xvgeom_combo), xvgeom_combo_items);
	g_list_free (xvgeom_combo_items);

	xvgeom_entry = GTK_COMBO (xvgeom_combo)->entry;
	gtk_widget_show (xvgeom_entry);
	gtk_entry_set_text (GTK_ENTRY (xvgeom_entry), "640x480");

	/* Force YUV Mode */
	yuv_label = gtk_label_new (_("Force YUV mode:"));
	gtk_widget_show (yuv_label);
	gtk_table_attach_defaults (GTK_TABLE (x11_table), yuv_label, 0, 1, 5, 6);

	yuv_combo = gtk_combo_new ();
	gtk_widget_show (yuv_combo);
	gtk_table_attach_defaults (GTK_TABLE (x11_table), yuv_combo, 1, 2, 5, 6);

	yuv_entry = GTK_COMBO (yuv_combo)->entry;
	gtk_widget_show (yuv_entry);

	combo_init (yuv_combo, "force-yuv", NULL, target->force_yuv);
	
	/* X Sync */
	xsync_checkbutton = gtk_check_button_new_with_label (_("X Synch"));
	gtk_widget_show (xsync_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (x11_table), xsync_checkbutton, 0, 2, 6, 7);

	/* Private C map */
	privatecmap_checkbutton = gtk_check_button_new_with_label (_("Private colormap"));
	gtk_widget_show (privatecmap_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (x11_table), privatecmap_checkbutton, 0, 2, 7, 8);

	xil_checkbutton = gtk_check_button_new_with_label (_("XIL scaling"));
	gtk_widget_show (xil_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (x11_table), xil_checkbutton, 0, 1, 8, 9);
	
	mtxil_checkbutton = gtk_check_button_new_with_label (_("XIL multi-threading"));
	gtk_widget_show (mtxil_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (x11_table), mtxil_checkbutton, 1, 2, 8, 9);
	
	/* x11 frame */
	gtk_widget_set_sensitive (GTK_WIDGET (mitshm_checkbutton), xmame_has_option (current_exec, "mitshm"));
	gtk_widget_set_sensitive (GTK_WIDGET (xvfullscreen_checkbutton), xmame_has_option (current_exec, "fullscreen"));
	gtk_widget_set_sensitive (GTK_WIDGET (cursor_checkbutton), xmame_has_option (current_exec, "cursor"));
	gtk_widget_set_sensitive (GTK_WIDGET (xsync_checkbutton), xmame_has_option (current_exec, "xsync"));
	gtk_widget_set_sensitive (GTK_WIDGET (xil_checkbutton), xmame_has_option (current_exec, "xil"));
	gtk_widget_set_sensitive (GTK_WIDGET (mtxil_checkbutton), xmame_has_option (current_exec, "mtxil") && target->xil);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cursor_checkbutton), target->cursor);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (mitshm_checkbutton), target->mitshm);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (xvgeom_checkbutton), target->xvgeom_flag);
	gtk_entry_set_text (GTK_ENTRY (xvgeom_entry), target->geometry);

	gtk_widget_set_sensitive (GTK_WIDGET (xvgeom_combo), target->xvgeom_flag /*&& 
								available_options.xvext
								available_options.mitshm && 
								target->mitshm &&
								target->xvext && 
								*/);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (xvfullscreen_checkbutton), target->fullscreen);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (xsync_checkbutton), target->xsync);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (privatecmap_checkbutton), target->privatecmap);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (xil_checkbutton), target->xil);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (mtxil_checkbutton), target->mtxil);

	g_signal_connect (G_OBJECT (video_mode_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (cursor_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (cursor_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (mitshm_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (mitshm_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	g_signal_connect (G_OBJECT (xvgeom_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (xvgeom_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (xvgeom_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (xvgeom_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (yuv_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (yuv_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (xvfullscreen_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (xvfullscreen_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
		
	g_signal_connect_after (G_OBJECT (xvgeom_checkbutton), "toggled",
			    G_CALLBACK (button_toggled),
			    xvgeom_combo);

	g_signal_connect (G_OBJECT (xsync_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (xsync_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (privatecmap_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (privatecmap_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (xil_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (xil_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (xil_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (mtxil_checkbutton));
	g_signal_connect (G_OBJECT (mtxil_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (mtxil_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	return x11_frame_parent;
}

static GtkWidget *
get_xgl_rendering_frame (GameOptions *target,
			 GtkWidget    *apply_button,
			 GtkWidget    *reset_button)
{
	GtkWidget *gl_frame_parent;
	GtkWidget *gl_frame;
	GtkWidget *ogl_table;
	GtkWidget *gltexture_size_label;
	GList *glres_combo_items = NULL;
	GtkWidget *gllib_label;
	GtkWidget *glulib_label;

	xmame_get_options (current_exec);

	gl_frame_parent = options_frame_new (_("OpenGL options"));
	gl_frame = options_frame_create_child (gl_frame_parent);

	ogl_table = gtk_table_new (9, 4, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (ogl_table), 6);
	gtk_table_set_col_spacings (GTK_TABLE (ogl_table), 6);
	gtk_widget_show (ogl_table);
	gtk_container_add (GTK_CONTAINER (gl_frame), ogl_table);

	gltexture_size_label = gtk_label_new (_("Texture size:"));
	gtk_widget_show (gltexture_size_label);
	gtk_table_attach_defaults (GTK_TABLE (ogl_table), gltexture_size_label, 0, 1, 0, 1);
	gtk_misc_set_alignment (GTK_MISC (gltexture_size_label), 0, 0.5);

	gltexture_size_spinbutton_adj = gtk_adjustment_new (target->gltexture_size, 0, 1000, 1, 10, 10);
	gltexture_size_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (gltexture_size_spinbutton_adj), 1, 0);
	gtk_widget_show (gltexture_size_spinbutton);
	gtk_table_attach_defaults (GTK_TABLE (ogl_table), gltexture_size_spinbutton, 1, 2, 0, 1);

	glext78_checkbutton = gtk_check_button_new_with_label (_("GL extension #78"));
	gtk_widget_show (glext78_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (ogl_table), glext78_checkbutton, 0, 1, 1, 2);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glext78_checkbutton), TRUE);
	
	glbilinear_checkbutton = gtk_check_button_new_with_label (_("Bilinear filtering"));
	gtk_widget_show (glbilinear_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (ogl_table), glbilinear_checkbutton, 1, 2, 1, 2);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glbilinear_checkbutton), TRUE);

	gldrawbitmap_checkbutton = gtk_check_button_new_with_label (_("Draw bitmap"));
	gtk_widget_show (gldrawbitmap_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (ogl_table), gldrawbitmap_checkbutton, 0, 1, 2, 3);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gldrawbitmap_checkbutton), TRUE);
	

	glantialias_checkbutton = gtk_check_button_new_with_label (_("Antialiasing"));
	gtk_widget_show (glantialias_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (ogl_table), glantialias_checkbutton, 1, 2, 2, 3);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glantialias_checkbutton), TRUE);

	glalphablending_checkbutton = gtk_check_button_new_with_label (_("Alphablending"));
	gtk_widget_show (glalphablending_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (ogl_table), glalphablending_checkbutton, 0, 1, 3, 4);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glalphablending_checkbutton), TRUE);

	gldblbuffer_checkbutton = gtk_check_button_new_with_label (_("Double buffering"));
	gtk_widget_show (gldblbuffer_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (ogl_table), gldblbuffer_checkbutton, 1, 2, 3, 4);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gldblbuffer_checkbutton), TRUE);

	glforceblitmode_checkbutton = gtk_check_button_new_with_label (_("True color blitter"));
	gtk_widget_show (glforceblitmode_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (ogl_table), glforceblitmode_checkbutton, 1, 2, 4, 5);

	glcolormod_checkbutton = gtk_check_button_new_with_label (_("Color modulation"));
	gtk_widget_show (glcolormod_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (ogl_table), glcolormod_checkbutton, 0, 1, 4, 5);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glcolormod_checkbutton), TRUE);

	cabview_checkbutton = gtk_check_button_new_with_label (_("Cabinet model:"));
	gtk_widget_show (cabview_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (ogl_table), cabview_checkbutton, 0, 1, 5, 6);

	cabinet_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY (cabinet_entry), 20);
	gtk_widget_show (cabinet_entry);
	gtk_table_attach_defaults (GTK_TABLE (ogl_table), cabinet_entry, 1, 2, 5, 6);

	glres_checkbutton = gtk_check_button_new_with_label (_("Resolution"));
	gtk_widget_show (glres_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (ogl_table), glres_checkbutton, 0, 1, 6, 7);

	glres_combo = gtk_combo_new ();
	gtk_widget_show (glres_combo);
	gtk_table_attach_defaults (GTK_TABLE (ogl_table), glres_combo, 1, 2, 6, 7);

	glres_combo_items = g_list_append (glres_combo_items, (gpointer) "320x200");
	glres_combo_items = g_list_append (glres_combo_items, (gpointer) "640x480");
	glres_combo_items = g_list_append (glres_combo_items, (gpointer) "800x600");
	glres_combo_items = g_list_append (glres_combo_items, (gpointer) "1024x768");
	glres_combo_items = g_list_append (glres_combo_items, (gpointer) "1280x1024");
	glres_combo_items = g_list_append (glres_combo_items, (gpointer) "1600x1200");
	gtk_combo_set_popdown_strings (GTK_COMBO (glres_combo), glres_combo_items);
	g_list_free (glres_combo_items);

	glres_combo_entry = GTK_COMBO (glres_combo)->entry;
	gtk_widget_show (glres_combo_entry);
	gtk_entry_set_text (GTK_ENTRY (glres_combo_entry), "640x480");

	gllib_label = gtk_label_new (_("OpenGL library:"));
	gtk_widget_show (gllib_label);
	gtk_table_attach_defaults (GTK_TABLE (ogl_table), gllib_label, 0, 1, 7, 8);
	gtk_misc_set_alignment (GTK_MISC (gllib_label), 0, 0.5);

	gllib_entry = gtk_entry_new ();
	gtk_widget_show (gllib_entry);
	gtk_table_attach_defaults (GTK_TABLE (ogl_table), gllib_entry, 1, 2, 7, 8);

	gtk_entry_set_text (GTK_ENTRY (gllib_entry), "libGL.so.1");

	glulib_label = gtk_label_new (_("GLU library:"));
	gtk_widget_show (glulib_label);
	gtk_table_attach_defaults (GTK_TABLE (ogl_table), glulib_label, 0, 1, 8, 9);
	gtk_misc_set_alignment (GTK_MISC (glulib_label), 0, 0.5);
	
	glulib_entry = gtk_entry_new ();
	gtk_widget_show (glulib_entry);
	gtk_table_attach_defaults (GTK_TABLE (ogl_table), glulib_entry, 1, 2, 8, 9);

	gtk_entry_set_text (GTK_ENTRY (glulib_entry), "libGLU.so.1");

	/* set sensitivity */
	gtk_widget_set_sensitive (gllib_entry, xmame_has_option (current_exec, "gllibname"));
	gtk_widget_set_sensitive (glulib_entry, xmame_has_option (current_exec, "glulibname"));
	gtk_widget_set_sensitive (glext78_checkbutton, xmame_has_option (current_exec, "glext78"));
	gtk_widget_set_sensitive (gldrawbitmap_checkbutton, xmame_has_option (current_exec, "gldrawbitmap"));
	gtk_widget_set_sensitive (glcolormod_checkbutton, xmame_has_option (current_exec, "glcolormod"));
	gtk_widget_set_sensitive (glforceblitmode_checkbutton, xmame_has_option (current_exec, "glforceblitmode"));
	gtk_widget_set_sensitive (GTK_WIDGET (cabinet_entry), target->cabview && 
	                                                    xmame_has_option (current_exec, "cabview"));

	/* Open GL frame */
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gldblbuffer_checkbutton), target->gldblbuffer);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glbilinear_checkbutton), target->glbilinear);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glext78_checkbutton), target->glext78);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glforceblitmode_checkbutton), target->glforceblitmode);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gldrawbitmap_checkbutton), target->gldrawbitmap);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glcolormod_checkbutton), target->glcolormod);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glantialias_checkbutton), target->glantialias);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glalphablending_checkbutton), target->glalphablending);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cabview_checkbutton), target->cabview);
	
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glres_checkbutton), target->glres_flag);
	gtk_entry_set_text (GTK_ENTRY (cabinet_entry), target->cabinet);
	gtk_widget_set_sensitive (GTK_WIDGET (glres_combo), target->glres_flag);
	gtk_entry_set_text (GTK_ENTRY (gllib_entry), target->gllibname);
	gtk_entry_set_text (GTK_ENTRY (glulib_entry), target->glulibname);

	g_signal_connect (G_OBJECT (gldblbuffer_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gldblbuffer_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gltexture_size_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gltexture_size_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (glbilinear_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glbilinear_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (glext78_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glext78_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (glforceblitmode_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glforceblitmode_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gldrawbitmap_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gldrawbitmap_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (glcolormod_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glcolormod_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (glantialias_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glantialias_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (glalphablending_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glalphablending_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (cabview_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (cabview_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (cabview_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (cabinet_entry));
	g_signal_connect (G_OBJECT (cabinet_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (cabinet_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (glres_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glres_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (glres_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (glres_combo));
	g_signal_connect (G_OBJECT (glres_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glres_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gllib_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gllib_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (glulib_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glulib_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	return gl_frame_parent;
}

static GtkWidget *
get_sdl_rendering_frame (GameOptions *target,
			 GtkWidget    *apply_button,
			 GtkWidget    *reset_button)
{
	GtkWidget *sdl_frame_parent;
	GtkWidget *sdl_frame;
	GtkWidget *sdl_table;
	
	xmame_get_options (current_exec);

	sdl_frame_parent = options_frame_new (_("SDL options"));
	sdl_frame = options_frame_create_child (sdl_frame_parent);

	sdl_table = gtk_table_new (4, 2, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (sdl_table), 6);
	gtk_table_set_col_spacings (GTK_TABLE (sdl_table), 6);
	gtk_widget_show (sdl_table);
	gtk_container_add (GTK_CONTAINER (sdl_frame), sdl_table);

	/* Full screen */
	fullscreen_checkbutton = gtk_check_button_new_with_label (_("Full Screen"));
	gtk_widget_show (fullscreen_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (sdl_table), fullscreen_checkbutton, 0, 1, 0, 1);

	/* Double buffering */
	doublebuf_checkbutton = gtk_check_button_new_with_label (_("Double Buffering"));
	gtk_widget_show (doublebuf_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (sdl_table), doublebuf_checkbutton, 0, 1, 1, 2);

	sdl_modes_checkbutton = gtk_check_button_new_with_label (_("Auto Resolution"));
	gtk_widget_show (sdl_modes_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (sdl_table), sdl_modes_checkbutton, 0, 2, 2, 3);

	sdl_modes_label = gtk_label_new (_("SDL Modes:"));
	gtk_widget_show (sdl_modes_label);
	gtk_table_attach_defaults (GTK_TABLE (sdl_table), sdl_modes_label, 0, 1, 3, 4);

	gtk_misc_set_alignment (GTK_MISC (sdl_modes_label), 0.9, 0.5);

	sdl_modes_spinbutton_adj = gtk_adjustment_new (target->modenumber, 0, 15, 1, 10, 10);
	sdl_modes_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (sdl_modes_spinbutton_adj), 1, 0);
	gtk_table_attach_defaults (GTK_TABLE (sdl_table), sdl_modes_spinbutton, 1, 2, 4, 5);
	
	sdl_modes_combo = gtk_combo_new ();
	gtk_table_attach_defaults (GTK_TABLE (sdl_table), sdl_modes_combo, 1, 2, 3, 4);

	combo_init (sdl_modes_combo, "", NULL, target->modenumber);
			
	sdl_modes_entry = GTK_COMBO (sdl_modes_combo)->entry;
	gtk_widget_show (sdl_modes_entry);

	/*** SDL related ***/
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (fullscreen_checkbutton), target->fullscreen);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (doublebuf_checkbutton), target->sdl_doublebuf);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sdl_modes_checkbutton), (target->sdl_auto_mode));

	g_signal_connect (G_OBJECT (fullscreen_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (fullscreen_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (doublebuf_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (doublebuf_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (sdl_modes_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (sdl_modes_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (sdl_modes_checkbutton), "toggled",
				  G_CALLBACK (not_button_toggled),
				  sdl_modes_label);

	/* only show the combobox if sdl_modes exist */
	if (xmame_get_option_value_count (current_exec, "") > 0) {
		gtk_widget_set_sensitive (GTK_WIDGET (sdl_modes_combo), !(target->sdl_auto_mode));
		gtk_widget_show (sdl_modes_combo);
		g_signal_connect (G_OBJECT (sdl_modes_entry), "changed",
				  G_CALLBACK (on_dirty_option),
				    apply_button);
		g_signal_connect (G_OBJECT (sdl_modes_entry), "changed",
				    G_CALLBACK (on_dirty_option),
				    reset_button);
		g_signal_connect_after (G_OBJECT (sdl_modes_checkbutton), "toggled",
					  G_CALLBACK (not_button_toggled),
					  sdl_modes_combo);
	} else {
		gtk_widget_set_sensitive (GTK_WIDGET (sdl_modes_spinbutton), !(target->sdl_auto_mode));
		gtk_widget_show (sdl_modes_spinbutton);
		g_signal_connect (G_OBJECT (sdl_modes_spinbutton), "changed",
				    G_CALLBACK (on_dirty_option),
				    apply_button);
		g_signal_connect (G_OBJECT (sdl_modes_spinbutton), "changed",
				    G_CALLBACK (on_dirty_option),
				    reset_button);
		g_signal_connect_after (G_OBJECT (sdl_modes_checkbutton), "toggled",
					  G_CALLBACK (not_button_toggled),
					  sdl_modes_spinbutton);
	}

	return sdl_frame_parent;
}

static GtkWidget *
get_fx_rendering_frame (GameOptions *target,
			GtkWidget   *apply_button,
			GtkWidget   *reset_button)
{
	GtkWidget *xfx_frame_parent;
	GtkWidget *xfx_frame;
	GtkWidget *fxglide_table;
	GtkWidget *fxresolution_label;
	GtkWidget *fx_combo;
	GList *fx_combo_items = NULL;

	xmame_get_options (current_exec);

	xfx_frame_parent = options_frame_new (_("FX (Glide) options"));
	xfx_frame = options_frame_create_child (xfx_frame_parent);

	fxglide_table = gtk_table_new (2, 2, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (fxglide_table), 6);
	gtk_table_set_col_spacings (GTK_TABLE (fxglide_table), 6);
	gtk_widget_show (fxglide_table);
	gtk_container_add (GTK_CONTAINER (xfx_frame), fxglide_table);

	fxresolution_label = gtk_label_new (_("Resolution:"));
	gtk_widget_show (fxresolution_label);
	gtk_table_attach_defaults (GTK_TABLE (fxglide_table), fxresolution_label, 0, 1, 1, 2);
	gtk_misc_set_alignment (GTK_MISC (fxresolution_label), 0, 0.5);

	fxgkeepaspect_checkbutton = gtk_check_button_new_with_label (_("keep aspect ratio"));
	gtk_widget_show (fxgkeepaspect_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (fxglide_table), fxgkeepaspect_checkbutton, 0, 2, 0, 1);

	fx_combo = gtk_combo_new ();
	gtk_widget_show (fx_combo);
	gtk_table_attach_defaults (GTK_TABLE (fxglide_table), fx_combo, 1, 2, 1, 2);
	fx_combo_items = g_list_append (fx_combo_items, (gpointer) "320x200");
	fx_combo_items = g_list_append (fx_combo_items, (gpointer) "640x480");
	fx_combo_items = g_list_append (fx_combo_items, (gpointer) "800x600");
	fx_combo_items = g_list_append (fx_combo_items, (gpointer) "1024x768");
	fx_combo_items = g_list_append (fx_combo_items, (gpointer) "1280x1024");
	fx_combo_items = g_list_append (fx_combo_items, (gpointer) "1600x1200");
	gtk_combo_set_popdown_strings (GTK_COMBO (fx_combo), fx_combo_items);
	g_list_free (fx_combo_items);

	fx_entry = GTK_COMBO (fx_combo)->entry;
	gtk_widget_show (fx_entry);
	gtk_entry_set_text (GTK_ENTRY (fx_entry), "640x480");

	
	/*** FX glide related ***/
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (fxgkeepaspect_checkbutton), target->fxgkeepaspect);
	gtk_entry_set_text (GTK_ENTRY (fx_entry), target->resolution);
	gtk_widget_set_sensitive (GTK_WIDGET (sdl_modes_label), !(target->sdl_auto_mode));

	g_signal_connect (G_OBJECT (fxgkeepaspect_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (fxgkeepaspect_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (fx_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (fx_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	return xfx_frame_parent;
}

static GtkWidget *
get_photon_rendering_frame (GameOptions *target,
			    GtkWidget  *apply_button,
			    GtkWidget  *reset_button)
{
	GtkWidget *photon_frame_parent;
	GtkWidget *photon_frame;
	GtkWidget *photon_table;
	
	xmame_get_options (current_exec);

	photon_frame_parent = options_frame_new (_("Photon options"));
	photon_frame = options_frame_create_child (photon_frame_parent);

	photon_table = gtk_table_new (2, 1, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (photon_table), 6);
	gtk_table_set_col_spacings (GTK_TABLE (photon_table), 6);
	gtk_widget_show (photon_table);
	gtk_container_add (GTK_CONTAINER (photon_frame), photon_table);

	render_mode_checkbutton = gtk_check_button_new_with_label (_("Full Screen"));
	gtk_widget_show (render_mode_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (photon_table), render_mode_checkbutton, 0, 1, 0, 1);

	phcursor_checkbutton = gtk_check_button_new_with_label (_("Show cursor"));
	gtk_widget_show (phcursor_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (photon_table), phcursor_checkbutton, 0, 1, 1, 2);

	/*** Photon2 related ***/
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (render_mode_checkbutton), target->render_mode);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (phcursor_checkbutton), !(target->phcursor));

	g_signal_connect (G_OBJECT (render_mode_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (render_mode_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (phcursor_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (phcursor_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	return photon_frame_parent;
}

static GtkWidget *
get_ggi_rendering_frame (GameOptions *target,
			 GtkWidget  *apply_button,
			 GtkWidget  *reset_button)
{
	GtkWidget *ggi_frame_parent;
	GtkWidget *ggi_frame;
	GtkWidget *ggi_table;
	GtkWidget *ggix_label;
	GtkWidget *ggiy_label;

	xmame_get_options (current_exec);

	ggi_frame_parent = options_frame_new (_("GGI options"));
	ggi_frame = options_frame_create_child (ggi_frame_parent);

	ggi_table = gtk_table_new (3, 1, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (ggi_table), 6);
	gtk_table_set_col_spacings (GTK_TABLE (ggi_table), 6);
	gtk_widget_show (ggi_table);
	gtk_container_add (GTK_CONTAINER (ggi_frame), ggi_table);

	ggilinear_checkbutton = gtk_check_button_new_with_label (_("linear framebuffer (fast)"));
	gtk_widget_show (ggilinear_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (ggi_table), ggilinear_checkbutton, 0, 1, 0, 1);

	ggi_force_resolution_checkbutton = gtk_check_button_new_with_label (_("Force resolutions"));
	gtk_widget_show (ggi_force_resolution_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (ggi_table), ggi_force_resolution_checkbutton, 0, 1, 1, 2);

	ggi_res_table = gtk_table_new (2, 2, FALSE);
	gtk_widget_show (ggi_res_table);
	gtk_table_attach_defaults (GTK_TABLE (ggi_table), ggi_res_table, 0, 1, 2, 3);

	ggix_label = gtk_label_new ("X:");
	gtk_widget_show (ggix_label);
	gtk_table_attach_defaults (GTK_TABLE (ggi_res_table), ggix_label, 0, 1, 0, 1);
	gtk_misc_set_alignment (GTK_MISC (ggix_label), 0, 0.5);

	ggix_spinbutton_adj = gtk_adjustment_new (target->xres, 320, 2048, 128, 128, 10);
	ggix_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (ggix_spinbutton_adj), 1, 0);
	gtk_widget_show (ggix_spinbutton);
	gtk_table_attach_defaults (GTK_TABLE (ggi_res_table), ggix_spinbutton, 1, 2, 0, 1);

	ggiy_label = gtk_label_new ("Y:");
	gtk_widget_show (ggiy_label);
	gtk_table_attach_defaults (GTK_TABLE (ggi_res_table), ggiy_label, 2, 3, 0, 1);
	gtk_misc_set_alignment (GTK_MISC (ggiy_label), 0, 0.5);

	ggiy_spinbutton_adj = gtk_adjustment_new (target->yres, 200, 2048, 1, 256, 10);
	ggiy_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (ggiy_spinbutton_adj), 1, 0);
	gtk_widget_show (ggiy_spinbutton);
	gtk_table_attach_defaults (GTK_TABLE (ggi_res_table), ggiy_spinbutton, 3, 4, 0, 1);

	/*** GGI related ***/
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ggilinear_checkbutton), target->ggilinear);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ggi_force_resolution_checkbutton), target->ggi_force_resolution);
	gtk_widget_set_sensitive (GTK_WIDGET (ggi_res_table), target->ggi_force_resolution);

	g_signal_connect (G_OBJECT (ggilinear_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (ggilinear_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (ggi_force_resolution_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (ggi_force_resolution_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (ggi_force_resolution_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				 ggi_res_table );
	g_signal_connect (G_OBJECT (ggix_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (ggix_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (ggiy_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (ggiy_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	return ggi_frame_parent;
}

static GtkWidget *
get_svga_rendering_frame (GameOptions *target,
			  GtkWidget *apply_button,
			  GtkWidget *reset_button)
{
	GtkWidget *svga_frame_parent;
	GtkWidget *svga_frame;
	GtkWidget *svga_table;
	GtkWidget *centery_label;
	GtkWidget *centerx_label;
	
	xmame_get_options (current_exec);

	svga_frame_parent = options_frame_new (_("SVGA options"));
	svga_frame = options_frame_create_child (svga_frame_parent);

	svga_table = gtk_table_new (4, 1, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (svga_table), 6);
	gtk_table_set_col_spacings (GTK_TABLE (svga_table), 6);
	gtk_widget_show (svga_table);
	gtk_container_add (GTK_CONTAINER (svga_frame), svga_table);

	planar_checkbutton = gtk_check_button_new_with_label (_("planar (modeX) modes"));
	gtk_widget_show (planar_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (svga_table), planar_checkbutton, 0, 1, 0, 1);

	linear_checkbutton = gtk_check_button_new_with_label (_("linear framebuffer (fast)"));
	gtk_widget_show (linear_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (svga_table), linear_checkbutton, 0, 1, 1, 2);

	tweaked_mode_checkbutton = gtk_check_button_new_with_label (_("Use tweaked VGA modes"));
	gtk_widget_show (tweaked_mode_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (svga_table), tweaked_mode_checkbutton, 0, 1, 2, 3);

	svga_tweak_table = gtk_table_new (2, 2, FALSE);
	gtk_widget_show (svga_tweak_table);
	gtk_table_attach_defaults (GTK_TABLE (svga_table), svga_tweak_table, 0, 1, 3, 4);

	centerx_label = gtk_label_new (_("Center X:"));
	gtk_widget_show (centerx_label);
	gtk_table_attach_defaults (GTK_TABLE (svga_tweak_table), centerx_label, 0, 1, 0, 1);
	gtk_misc_set_alignment (GTK_MISC (centerx_label), 0, 0.5);

	centerx_spinbutton_adj = gtk_adjustment_new (target->centerx, -1000, 1000, 1, 10, 10);
	centerx_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (centerx_spinbutton_adj), 1, 0);
	gtk_widget_show (centerx_spinbutton);
	gtk_table_attach_defaults (GTK_TABLE (svga_tweak_table), centerx_spinbutton, 1, 2, 0, 1);

	centery_label = gtk_label_new (_("Center Y:"));
	gtk_widget_show (centery_label);
	gtk_table_attach_defaults (GTK_TABLE (svga_tweak_table), centery_label, 2, 3, 0, 1);
	gtk_misc_set_alignment (GTK_MISC (centery_label), 0, 0.5);

	centery_spinbutton_adj = gtk_adjustment_new (target->centery, -500, 500, 1, 10, 10);
	centery_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (centery_spinbutton_adj), 1, 0);
	gtk_widget_show (centery_spinbutton);
	gtk_table_attach_defaults (GTK_TABLE (svga_tweak_table), centery_spinbutton, 3, 4, 0, 1);

	/*** SVGA related ***/
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (planar_checkbutton), target->planar);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (linear_checkbutton), target->linear);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (tweaked_mode_checkbutton), target->tweak);
	gtk_widget_set_sensitive (GTK_WIDGET (svga_tweak_table), target->tweak);

	g_signal_connect (G_OBJECT (planar_checkbutton), "toggled",
			  G_CALLBACK (on_dirty_option),
			  apply_button);
	g_signal_connect (G_OBJECT (planar_checkbutton), "toggled",
			  G_CALLBACK (on_dirty_option),
			  reset_button);
	g_signal_connect (G_OBJECT (linear_checkbutton), "toggled",
			  G_CALLBACK (on_dirty_option),
			  apply_button);
	g_signal_connect (G_OBJECT (linear_checkbutton), "toggled",
			  G_CALLBACK (on_dirty_option),
			  reset_button);
	g_signal_connect (G_OBJECT (tweaked_mode_checkbutton), "toggled",
			  G_CALLBACK (on_dirty_option),
			  apply_button);
	g_signal_connect (G_OBJECT (tweaked_mode_checkbutton), "toggled",
			  G_CALLBACK (on_dirty_option),
			  reset_button);
	g_signal_connect_after (G_OBJECT (tweaked_mode_checkbutton), "toggled",
				G_CALLBACK (button_toggled),
				svga_tweak_table);
	g_signal_connect (G_OBJECT (centerx_spinbutton), "changed",
			  G_CALLBACK (on_dirty_option),
			  apply_button);
	g_signal_connect (G_OBJECT (centerx_spinbutton), "changed",
			  G_CALLBACK (on_dirty_option),
			  reset_button);
	g_signal_connect (G_OBJECT (centery_spinbutton), "changed",
			  G_CALLBACK (on_dirty_option),
			  apply_button);
	g_signal_connect (G_OBJECT (centery_spinbutton), "changed",
			  G_CALLBACK (on_dirty_option),
			  reset_button);

	return svga_frame_parent;
}

void
add_rendering_options_tab (GtkWidget    *properties_windows,
                           GtkNotebook  *target_notebook,
                           RomEntry     *rom,
                           GameOptions *target,
                           GtkWidget    *apply_button,
                           GtkWidget    *reset_button)
{
	GtkWidget *image;
	GtkWidget *rendering_table;

	GtkWidget *video_mode_frame;
	GtkWidget *video_mode_table;
	GtkWidget *disablemode_label;
	
	GtkWidget *rendering_label;

	GtkWidget *rendering_frame;
	GtkWidget *rendering_frame2;
	
	gchar *used_text;
	
	xmame_get_options (current_exec);
	dirty_options_flag = FALSE;

	rendering_table = gtk_table_new (4, 1, FALSE);
	gtk_widget_show (rendering_table);
	gtk_container_set_border_width (GTK_CONTAINER (rendering_table), 10);
	gtk_table_set_row_spacings (GTK_TABLE (rendering_table), 6);
	gtk_table_set_col_spacings (GTK_TABLE (rendering_table), 6);

	rendering_frame2 = NULL;

	switch (current_exec->type) {
	case XMAME_EXEC_X11:
	case XMAME_EXEC_XGL:
		rendering_frame = get_x11_rendering_frame (target, apply_button, reset_button);
		rendering_frame2 = get_xgl_rendering_frame (target, apply_button, reset_button);
		break;
	case XMAME_EXEC_SDL:
		rendering_frame = get_sdl_rendering_frame (target, apply_button, reset_button);
		break;
	case XMAME_EXEC_XFX:
	case XMAME_EXEC_SVGAFX:
		rendering_frame = get_fx_rendering_frame (target, apply_button, reset_button);
		break;
	case XMAME_EXEC_PHOTON2:
		rendering_frame = get_photon_rendering_frame (target, apply_button, reset_button);
		break;
	case XMAME_EXEC_GGI:
		rendering_frame = get_ggi_rendering_frame (target, apply_button, reset_button);
		break;
	case XMAME_EXEC_SVGALIB:
		rendering_frame = get_svga_rendering_frame (target, apply_button, reset_button);
		break;
	default:
		rendering_frame = NULL;
		break;
	}

	if (rendering_frame) {
		gtk_widget_show (rendering_frame);
		gtk_table_attach (GTK_TABLE (rendering_table), rendering_frame, 0, 1, 2, 3,
				  (GTK_SHRINK | GTK_FILL),
				  (GTK_SHRINK | GTK_FILL), 0, 0);

		if (rendering_frame2) {
			gtk_widget_show (rendering_frame2);
			gtk_table_attach (GTK_TABLE (rendering_table), rendering_frame2, 1, 2, 2, 3,
					  (GTK_SHRINK | GTK_FILL),
					  (GTK_SHRINK | GTK_FILL), 0, 0);
		}
	}

	/* Video Mode */
	video_mode_frame = options_frame_new (_("Video mode"));
	gtk_widget_show (video_mode_frame);
	gtk_table_attach (GTK_TABLE (rendering_table), video_mode_frame, 0, 1, 3, 4,
			  (GTK_SHRINK | GTK_FILL),
			  (GTK_SHRINK | GTK_FILL), 0, 0);
	video_mode_frame = options_frame_create_child (video_mode_frame);

	video_mode_table = gtk_table_new (2, 2, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (video_mode_table), 6);
	gtk_table_set_col_spacings (GTK_TABLE (video_mode_table), 6);
	gtk_widget_show (video_mode_table);
	gtk_container_add (GTK_CONTAINER (video_mode_frame), video_mode_table);

	keepaspect_checkbutton = gtk_check_button_new_with_label (_("Keep aspect ratio:"));
	gtk_widget_show (keepaspect_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (video_mode_table), keepaspect_checkbutton, 0, 1, 0, 1);

	displayaspectratio_entry = gtk_entry_new ();
	gtk_widget_show (displayaspectratio_entry);
	gtk_table_attach_defaults (GTK_TABLE (video_mode_table), displayaspectratio_entry, 1, 2, 0, 1);
	gtk_entry_set_text (GTK_ENTRY (displayaspectratio_entry), "1.33");

	disablemode_label = gtk_label_new (_("Disable mode:"));
	gtk_widget_show (disablemode_label);
	gtk_table_attach_defaults (GTK_TABLE (video_mode_table), disablemode_label, 0, 1, 1, 2);
	gtk_misc_set_alignment (GTK_MISC (disablemode_label), 0, 0.5);

	disable_mode_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY (disable_mode_entry), 14);
	gtk_widget_show (disable_mode_entry);
	gtk_table_attach_defaults (GTK_TABLE (video_mode_table), disable_mode_entry, 1, 2, 1, 2);

/*end modes*/

	image = gxmame_get_image_from_stock ("gxmame-display-toolbar");

	rendering_label = gtk_hbox_new (FALSE, 5);
	gtk_box_pack_start (GTK_BOX (rendering_label), image, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (rendering_label), gtk_label_new (_("Rendering")), FALSE, FALSE, 0);
	gtk_widget_show_all (rendering_label);

	gtk_notebook_append_page (GTK_NOTEBOOK (target_notebook), rendering_table, rendering_label);

	gtk_widget_set_sensitive (GTK_WIDGET (video_mode_frame), TRUE);
	
	/*** Video Mode related ***/
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (keepaspect_checkbutton), target->keepaspect);
	gtk_widget_set_sensitive (GTK_WIDGET (displayaspectratio_entry), (target->keepaspect));
	used_text = g_strdup_printf ("%f", target->displayaspectratio);
	gtk_entry_set_text (GTK_ENTRY (displayaspectratio_entry), used_text);
	g_free (used_text);
	gtk_entry_set_text (GTK_ENTRY (disable_mode_entry), target->disablemode);

	g_signal_connect (G_OBJECT (keepaspect_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (keepaspect_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (keepaspect_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  displayaspectratio_entry);
	g_signal_connect (G_OBJECT (displayaspectratio_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (displayaspectratio_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (disable_mode_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (disable_mode_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

}


void
add_sound_options_tab (GtkWidget    *properties_windows,
                       GtkNotebook  *target_notebook,
                       RomEntry     *rom,
                       GameOptions *target,
                       GtkWidget    *apply_button,
                       GtkWidget    *reset_button)
{
	GtkWidget *image;
	GList *samplefreq_combo_items = NULL;
	GList *audiodevice_combo_items = NULL;
	GtkWidget *samplerate_hbox;
	GtkWidget *mixerdevice_hbox;
	GList *mixerdevice_combo_items = NULL;
	GtkWidget *mixer_plugin_hbox;
	GtkWidget *mixer_plugin_label;
	GtkWidget *mixer_plugin_combo;
	GtkWidget *dsp_plugin_hbox;
	GtkWidget *dsp_plugin_label;
	GtkWidget *dsp_plugin_combo;
	GtkWidget *arts_table;
	GtkWidget *artsBufferTime_label;
	GtkWidget *qnx_vbox;
	GtkWidget *bufsize_hbox;
	GtkWidget *ms_label;
	GtkWidget *volume_hbox;
	GtkWidget *db_label;
	GtkWidget *alsa_table;
	GtkWidget *alsa_hseparator;
	GtkWidget *sound_label;
	GtkWidget *soundfile_label;
	GtkWidget *soundfile_button;
	GtkWidget *hbox;
	GtkWidget *vbox1;
	GtkWidget *vbox2;
	GtkWidget *frame;
	GtkSizeGroup *group = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	gchar *used_text;
	const gchar *option_value;

	xmame_get_options (current_exec);
	dirty_options_flag = FALSE;

	image = gxmame_get_image_from_stock ("gxmame-sound-toolbar");

	sound_label = gtk_hbox_new (FALSE, 5);
	gtk_box_pack_start (GTK_BOX (sound_label), image, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (sound_label), gtk_label_new (_("Sound")), FALSE, FALSE, 0);
	gtk_widget_show_all (sound_label);

	hbox = gtk_hbox_new (FALSE, 12);
	gtk_widget_show (hbox);
	gtk_notebook_append_page (GTK_NOTEBOOK (target_notebook), hbox, sound_label);

	vbox1 = gtk_vbox_new (FALSE, 6);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (hbox), vbox1, FALSE, FALSE, 0);
	vbox2 = gtk_vbox_new (FALSE, 6);
	gtk_widget_show (vbox2);
	gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 0);

	/* General Sound Options */
	frame = options_frame_new (_("General sound options"));
	gtk_widget_show (frame);
	gtk_box_pack_start (GTK_BOX (vbox1), frame, FALSE, FALSE, 0);
	frame = options_frame_create_child (frame);

	/* Sound enable */
	sound_checkbutton = gtk_check_button_new_with_label (_("Enable sound"));
	gtk_widget_show (sound_checkbutton);
	gtk_box_pack_start (GTK_BOX (frame), sound_checkbutton, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sound_checkbutton), TRUE);

	/* Samples enable */
	samples_checkbutton = gtk_check_button_new_with_label (_("Use samples"));
	gtk_widget_show (samples_checkbutton);
	gtk_box_pack_start (GTK_BOX (frame), samples_checkbutton, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (samples_checkbutton), TRUE);

	/* Fake Sound enable */
	fakesound_checkbutton = gtk_check_button_new_with_label (_("Fake sound"));
	gtk_widget_show (fakesound_checkbutton);
	gtk_box_pack_start (GTK_BOX (frame), fakesound_checkbutton, FALSE, FALSE, 0);

	/* Samplerate */
	samplerate_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (samplerate_hbox);
	gtk_box_pack_start (GTK_BOX (frame), samplerate_hbox, FALSE, FALSE, 0);

	samplefreq_label = gtk_label_new (_("Sample rate:"));
	gtk_widget_show (samplefreq_label);
	gtk_box_pack_start (GTK_BOX (samplerate_hbox), samplefreq_label, FALSE, FALSE, 6);
	gtk_misc_set_alignment (GTK_MISC (samplefreq_label), 0, 0.5);

	samplefreq_combo = gtk_combo_new ();
	gtk_widget_show (samplefreq_combo);
	gtk_box_pack_start (GTK_BOX (samplerate_hbox), samplefreq_combo, FALSE, FALSE, 0);
	samplefreq_combo_items = g_list_append (samplefreq_combo_items, (gpointer) "8000");
	samplefreq_combo_items = g_list_append (samplefreq_combo_items, (gpointer) "11025");
	samplefreq_combo_items = g_list_append (samplefreq_combo_items, (gpointer) "16000");
	samplefreq_combo_items = g_list_append (samplefreq_combo_items, (gpointer) "22050");
	samplefreq_combo_items = g_list_append (samplefreq_combo_items, (gpointer) "44100");
	samplefreq_combo_items = g_list_append (samplefreq_combo_items, (gpointer) "48000");
	gtk_combo_set_popdown_strings (GTK_COMBO (samplefreq_combo), samplefreq_combo_items);
	g_list_free (samplefreq_combo_items);

	samplefreq_entry = GTK_COMBO (samplefreq_combo)->entry;
	gtk_widget_show (samplefreq_entry);
	gtk_entry_set_text (GTK_ENTRY (samplefreq_entry), "22050");

/* Volume */
	volume_frame = options_frame_new (_("Volume attenuation"));
	gtk_widget_show (volume_frame);
	gtk_box_pack_start (GTK_BOX (vbox1), volume_frame, FALSE, FALSE, 0);
	volume_frame = options_frame_create_child (volume_frame);

	volume_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (volume_hbox);
	gtk_container_add (GTK_CONTAINER (volume_frame), volume_hbox);

	db_hscale_adj = gtk_adjustment_new (target->volume, -32, 0, 1, 1, 0);
	db_hscale = gtk_hscale_new (GTK_ADJUSTMENT (db_hscale_adj));
	gtk_widget_show (db_hscale);
	gtk_box_pack_start (GTK_BOX (volume_hbox), db_hscale, TRUE, TRUE, 0);
	gtk_scale_set_value_pos (GTK_SCALE (db_hscale), GTK_POS_RIGHT);
	gtk_scale_set_digits (GTK_SCALE (db_hscale), 0);

	db_label = gtk_label_new ("dB");
	gtk_widget_show (db_label);
	gtk_box_pack_start (GTK_BOX (volume_hbox), db_label, FALSE, FALSE, 0);

/* Buffer Size */
	bufsize_frame = options_frame_new (_("Buffer size"));
	gtk_widget_show (bufsize_frame);
	gtk_box_pack_start (GTK_BOX (vbox1), bufsize_frame, FALSE, FALSE, 0);
	bufsize_frame = options_frame_create_child (bufsize_frame);

	bufsize_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (bufsize_hbox);
	gtk_container_add (GTK_CONTAINER (bufsize_frame), bufsize_hbox);

	bufsize_hscale_adj = gtk_adjustment_new (target->bufsize, 1, 30, 1, 1, 0);
	bufsize_hscale = gtk_hscale_new (GTK_ADJUSTMENT (bufsize_hscale_adj));
	gtk_widget_show (bufsize_hscale);
	gtk_box_pack_start (GTK_BOX (bufsize_hbox), bufsize_hscale, TRUE, TRUE, 0);
	gtk_scale_set_value_pos (GTK_SCALE (bufsize_hscale), GTK_POS_RIGHT);

	ms_label = gtk_label_new (_("frames"));
	gtk_widget_show (ms_label);
	gtk_box_pack_start (GTK_BOX (bufsize_hbox), ms_label, FALSE, FALSE, 0);

/* Audio device  */
	audiodevice_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (audiodevice_hbox);
	gtk_box_pack_start (GTK_BOX (frame), audiodevice_hbox, FALSE, FALSE, 0);

	audiodevice_label = gtk_label_new (_("Audio device:"));
	gtk_widget_show (audiodevice_label);
	gtk_box_pack_start (GTK_BOX (audiodevice_hbox), audiodevice_label, FALSE, FALSE, 0);

	audiodevice_combo = gtk_combo_new ();
	gtk_widget_show (audiodevice_combo);
	gtk_box_pack_start (GTK_BOX (audiodevice_hbox), audiodevice_combo, FALSE, FALSE, 0);
	audiodevice_combo_items = g_list_append (audiodevice_combo_items, (gpointer) "/dev/dsp");
	audiodevice_combo_items = g_list_append (audiodevice_combo_items, (gpointer) "/dev/dsp0");
	audiodevice_combo_items = g_list_append (audiodevice_combo_items, (gpointer) "/dev/dsp1");
	audiodevice_combo_items = g_list_append (audiodevice_combo_items, (gpointer) "/dev/dsp2");
	audiodevice_combo_items = g_list_append (audiodevice_combo_items, (gpointer) "/dev/dsp3");
	audiodevice_combo_items = g_list_append (audiodevice_combo_items, (gpointer) "/dev/audio");
	gtk_combo_set_popdown_strings (GTK_COMBO (audiodevice_combo), audiodevice_combo_items);
	g_list_free (audiodevice_combo_items);

	audiodevice_combo_entry = GTK_COMBO (audiodevice_combo)->entry;
	gtk_widget_show (audiodevice_combo_entry);
	gtk_entry_set_text (GTK_ENTRY (audiodevice_combo_entry), "/dev/dsp");

	/* Mixer device */
	mixerdevice_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (mixerdevice_hbox);
	gtk_box_pack_start (GTK_BOX (frame), mixerdevice_hbox, FALSE, FALSE, 0);

	mixerdevice_label = gtk_label_new (_("Mixer device:"));
	gtk_widget_show (mixerdevice_label);
	gtk_box_pack_start (GTK_BOX (mixerdevice_hbox), mixerdevice_label, FALSE, FALSE, 0);

	mixerdevice_combo = gtk_combo_new ();
	gtk_widget_show (mixerdevice_combo);
	gtk_box_pack_start (GTK_BOX (mixerdevice_hbox), mixerdevice_combo, FALSE, FALSE, 0);
	mixerdevice_combo_items = g_list_append (mixerdevice_combo_items, (gpointer) "/dev/mixer");
	gtk_combo_set_popdown_strings (GTK_COMBO (mixerdevice_combo), mixerdevice_combo_items);
	g_list_free (mixerdevice_combo_items);

	mixerdevice_entry = GTK_COMBO (mixerdevice_combo)->entry;
	gtk_widget_show (mixerdevice_entry);
	gtk_entry_set_text (GTK_ENTRY (mixerdevice_entry), "/dev/mixer");

	frame = options_frame_new (_("Advanced options"));
	gtk_widget_show (frame);
	gtk_box_pack_start (GTK_BOX (vbox1), frame, FALSE, FALSE, 0);
	frame = options_frame_create_child (frame);

	/* DSP plugin */
	dsp_plugin_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (dsp_plugin_hbox);
	gtk_box_pack_start (GTK_BOX (frame), dsp_plugin_hbox, FALSE, FALSE, 0);

	dsp_plugin_label = gtk_label_new (_("DSP Plugin:"));
	gtk_misc_set_alignment (GTK_MISC (dsp_plugin_label), 0, 0.5);
	gtk_widget_show (dsp_plugin_label);
	gtk_box_pack_start (GTK_BOX (dsp_plugin_hbox), dsp_plugin_label, FALSE, FALSE, 0);
	gtk_size_group_add_widget (GTK_SIZE_GROUP (group), dsp_plugin_label);

	dsp_plugin_combo = gtk_combo_new ();
	gtk_widget_show (dsp_plugin_combo);
	gtk_box_pack_start (GTK_BOX (dsp_plugin_hbox), dsp_plugin_combo, TRUE, TRUE, 0);
	
	/* populate the dsp plugin combo */
	combo_init (dsp_plugin_combo, "dsp-plugin", target->dsp_plugin, -1);

	dsp_plugin_entry = GTK_COMBO (dsp_plugin_combo)->entry;
	gtk_widget_show (dsp_plugin_entry);

	/* Mixer plugin */
	mixer_plugin_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (mixer_plugin_hbox);

	gtk_box_pack_start (GTK_BOX (frame), mixer_plugin_hbox, FALSE, FALSE, 0);

	mixer_plugin_label = gtk_label_new (_("Mixer plugin:"));
	gtk_misc_set_alignment (GTK_MISC (mixer_plugin_label), 0, 0.5);
	gtk_widget_show (mixer_plugin_label);
	gtk_box_pack_start (GTK_BOX (mixer_plugin_hbox), mixer_plugin_label, FALSE, FALSE, 0);

	mixer_plugin_combo = gtk_combo_new ();
	gtk_widget_show (mixer_plugin_combo);
	gtk_box_pack_start (GTK_BOX (mixer_plugin_hbox), mixer_plugin_combo, TRUE, TRUE, 0);
	gtk_size_group_add_widget (GTK_SIZE_GROUP (group), mixer_plugin_label);

	/* populate the mixer plugin combo */
	combo_init (mixer_plugin_combo, "sound-mixer-plugin", target->sound_mixer_plugin, -1);

	mixer_plugin_entry = GTK_COMBO (mixer_plugin_combo)->entry;
	gtk_widget_show (mixer_plugin_entry);

/* soundfile */
	soundfile_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (soundfile_hbox);
	gtk_box_pack_start (GTK_BOX (frame), soundfile_hbox, FALSE, FALSE, 0);

	soundfile_label = gtk_label_new (_("Sound file name:"));
	gtk_misc_set_alignment (GTK_MISC (soundfile_label), 0, 0.5);
	gtk_widget_show (soundfile_label);
	gtk_box_pack_start (GTK_BOX (soundfile_hbox), soundfile_label, FALSE, FALSE, 0);
	gtk_size_group_add_widget (GTK_SIZE_GROUP (group), soundfile_label);

	soundfile_entry = gtk_entry_new ();
	gtk_widget_show (soundfile_entry);
	gtk_box_pack_start (GTK_BOX (soundfile_hbox), soundfile_entry, FALSE, TRUE, 0);

	soundfile_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (soundfile_button);
	gtk_box_pack_start (GTK_BOX (soundfile_hbox), soundfile_button, FALSE, FALSE, 0);

/* timer */
	timer_checkbutton = gtk_check_button_new_with_label (_("Timer based audio"));
	gtk_widget_show (timer_checkbutton);
	gtk_box_pack_start (GTK_BOX (frame), timer_checkbutton, FALSE, FALSE, 0);

/* aRTs options */
	arts_frame = options_frame_new (_("aRts options"));
	gtk_widget_show (arts_frame);
	gtk_box_pack_start (GTK_BOX (vbox2), arts_frame, FALSE, FALSE, 0);
	arts_frame = options_frame_create_child (arts_frame);

	arts_table = gtk_table_new (1, 2, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (arts_table), 6);
	gtk_table_set_col_spacings (GTK_TABLE (arts_table), 6);
	gtk_widget_show (arts_table);
	gtk_container_add (GTK_CONTAINER (arts_frame), arts_table);

	arts_spinbutton_adj = gtk_adjustment_new (target->artsBufferTime, 0, 1000, 1, 100, 10);
	arts_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (arts_spinbutton_adj), 1, 0);
	gtk_widget_show (arts_spinbutton);
	gtk_table_attach_defaults (GTK_TABLE (arts_table), arts_spinbutton, 1, 2, 0, 1);

	artsBufferTime_label = gtk_label_new (_("aRts buffer delay time:"));
	gtk_widget_show (artsBufferTime_label);
	gtk_table_attach_defaults (GTK_TABLE (arts_table), artsBufferTime_label, 0, 1, 0, 1);
	gtk_misc_set_alignment (GTK_MISC (artsBufferTime_label), 0, 0.5);

/* QNX options */
	qnx_frame = options_frame_new (_("QNX options"));
	gtk_widget_show (qnx_frame);
	gtk_box_pack_start (GTK_BOX (vbox2), qnx_frame, FALSE, FALSE, 0);
	qnx_frame = options_frame_create_child (qnx_frame);

	qnx_vbox = gtk_vbox_new (FALSE, 6);
	gtk_widget_show (qnx_vbox);
	gtk_container_add (GTK_CONTAINER (qnx_frame), qnx_vbox);

	audio_preferred_checkbutton = gtk_check_button_new_with_label (_("Use preferred device"));
	gtk_widget_show (audio_preferred_checkbutton);
	gtk_box_pack_start (GTK_BOX (qnx_vbox), audio_preferred_checkbutton, FALSE, FALSE, 0);

/* Alsa options */
	alsa_frame = options_frame_new (_("Alsa sound system options"));
	gtk_widget_show (alsa_frame);
	gtk_box_pack_start (GTK_BOX (vbox2), alsa_frame, FALSE, FALSE, 0);
	alsa_frame = options_frame_create_child (alsa_frame);

	alsa_table = gtk_table_new (5, 2, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (alsa_table), 6);
	gtk_table_set_col_spacings (GTK_TABLE (alsa_table), 6);
	gtk_widget_show (alsa_table);
	gtk_container_add (GTK_CONTAINER (alsa_frame), alsa_table);

	PCM_label = gtk_label_new (_("PCM:"));
	gtk_widget_show (PCM_label);
	gtk_table_attach_defaults (GTK_TABLE (alsa_table), PCM_label, 0, 1, 0, 1);
	gtk_misc_set_alignment (GTK_MISC (PCM_label), 0, 0.5);
	
	/*workaround to allow correct translation of "" with gettext */
	used_text = g_strdup_printf (_("Buffer size %s")," (s):");
	alsa_buffer_label = gtk_label_new (used_text);
	g_free (used_text);
	gtk_widget_show (alsa_buffer_label);
	gtk_table_attach_defaults (GTK_TABLE (alsa_table), alsa_buffer_label, 0, 1, 1, 2);
	gtk_misc_set_alignment (GTK_MISC (alsa_buffer_label), 0, 0.5);

	alsa_hseparator = gtk_hseparator_new ();
	gtk_widget_show (alsa_hseparator);
	gtk_table_attach_defaults (GTK_TABLE (alsa_table), alsa_hseparator, 0, 2, 2, 3);

	alsacard_label = gtk_label_new (_("Card ID:"));
	gtk_widget_show (alsacard_label);
	gtk_table_attach_defaults (GTK_TABLE (alsa_table), alsacard_label, 0, 1, 3, 4);
	gtk_misc_set_alignment (GTK_MISC (alsacard_label), 0, 0.5);

	alsadevice_label = gtk_label_new (_("Device #:"));
	gtk_widget_show (alsadevice_label);
	gtk_table_attach_defaults (GTK_TABLE (alsa_table), alsadevice_label, 0, 1, 4, 5);
	gtk_misc_set_alignment (GTK_MISC (alsadevice_label), 0, 0.5);

	alsa_buffer_spinbutton_adj = gtk_adjustment_new (target->alsa_buffer, 0, 5e+06, 1, 500, 10);
	alsa_buffer_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (alsa_buffer_spinbutton_adj), 1, 0);
	gtk_widget_show (alsa_buffer_spinbutton);
	gtk_table_attach_defaults (GTK_TABLE (alsa_table), alsa_buffer_spinbutton, 1, 2, 1, 2);

	alsacard_spinbutton_adj = gtk_adjustment_new (target->alsacard, 0, 32, 1, 10, 10);
	alsacard_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (alsacard_spinbutton_adj), 1, 0);
	gtk_widget_show (alsacard_spinbutton);
	gtk_table_attach_defaults (GTK_TABLE (alsa_table), alsacard_spinbutton, 1, 2, 3, 4);

	alsadevice_spinbutton_adj = gtk_adjustment_new (target->alsadevice, 0, 32, 1, 10, 10);
	alsadevice_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (alsadevice_spinbutton_adj), 1, 0);
	gtk_widget_show (alsadevice_spinbutton);
	gtk_table_attach_defaults (GTK_TABLE (alsa_table), alsadevice_spinbutton, 1, 2, 4, 5);

	pcm_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY (pcm_entry), 20);
	gtk_widget_show (pcm_entry);
	gtk_table_attach_defaults (GTK_TABLE (alsa_table), pcm_entry, 1, 2, 0, 1);

/* end sound options */

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sound_checkbutton), target->sound);
	gtk_widget_set_sensitive (GTK_WIDGET (samples_checkbutton), target->sound);
	gtk_widget_set_sensitive (GTK_WIDGET (volume_frame), target->sound);
	gtk_widget_set_sensitive (GTK_WIDGET (bufsize_frame), target->sound);
	gtk_widget_set_sensitive (GTK_WIDGET (samplefreq_combo), target->sound);
	gtk_widget_set_sensitive (GTK_WIDGET (audiodevice_label), target->sound);
	gtk_widget_set_sensitive (GTK_WIDGET (samplefreq_label), target->sound);
	gtk_widget_set_sensitive (GTK_WIDGET (mixerdevice_label), target->sound);
	gtk_widget_set_sensitive (GTK_WIDGET (audiodevice_combo), target->sound);
	gtk_widget_set_sensitive (GTK_WIDGET (mixerdevice_combo), target->sound);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (samples_checkbutton), target->samples);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (fakesound_checkbutton), target->fakesound);
	used_text = g_strdup_printf ("%i", target->samplefre);
	gtk_entry_set_text (GTK_ENTRY (samplefreq_entry), used_text);

	if (target->audiodevice)
		gtk_entry_set_text (GTK_ENTRY (audiodevice_combo_entry), target->audiodevice);

	if (target->mixerdevice)
		gtk_entry_set_text (GTK_ENTRY (mixerdevice_entry), target->mixerdevice);

	gtk_entry_set_text (GTK_ENTRY (soundfile_entry), target->soundfile);

	if (target->dsp_plugin && !strcmp (target->dsp_plugin, "waveout"))
	{
		gtk_widget_set_sensitive (GTK_WIDGET (soundfile_hbox), TRUE);
		gtk_widget_set_sensitive (GTK_WIDGET (audiodevice_hbox), FALSE);
	}
	else
	{
		gtk_widget_set_sensitive (GTK_WIDGET (soundfile_hbox), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (audiodevice_hbox), TRUE);
	}


	option_value = xmame_get_option_key_value (current_exec, "dsp-plugin",
						   target->dsp_plugin);

	if (option_value) {
		gtk_entry_set_text (GTK_ENTRY (dsp_plugin_entry), 
				    option_value);
	}

	option_value = xmame_get_option_key_value (current_exec, "sound-mixer-plugin",
						   target->sound_mixer_plugin);

	if (option_value) {
		gtk_entry_set_text (GTK_ENTRY (mixer_plugin_entry), 
		option_value);
	}

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (timer_checkbutton), target->timer);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (audio_preferred_checkbutton), target->audio_preferred);

	gtk_entry_set_text (GTK_ENTRY (pcm_entry), target->alsa_pcm);

	gtk_widget_set_sensitive (GTK_WIDGET (qnx_frame),
				  xmame_has_option (current_exec, "audio_preferred"));

	gtk_widget_set_sensitive (GTK_WIDGET (alsa_frame),
				  xmame_get_option_key_value (current_exec, "dsp-plugin", "alsa") != NULL);
	
	gtk_widget_set_sensitive (GTK_WIDGET (arts_frame),
				  xmame_has_option (current_exec, "artsBufferTime"));

	gtk_widget_set_sensitive (GTK_WIDGET (alsacard_label),
				  xmame_has_option (current_exec, "alsacard"));

	gtk_widget_set_sensitive (GTK_WIDGET (alsacard_spinbutton),
				  xmame_has_option (current_exec, "alsacard"));

	gtk_widget_set_sensitive (GTK_WIDGET (alsadevice_label),
				  xmame_has_option (current_exec, "alsadevice"));

	gtk_widget_set_sensitive (GTK_WIDGET (alsadevice_spinbutton),
				  xmame_has_option (current_exec, "alsadevice"));

	gtk_widget_set_sensitive (GTK_WIDGET (alsa_buffer_label),
				  xmame_has_option (current_exec, "alsa-buffer"));

	gtk_widget_set_sensitive (GTK_WIDGET (alsa_buffer_spinbutton),
				  xmame_has_option (current_exec, "alsa-buffer"));

	gtk_widget_set_sensitive (GTK_WIDGET (PCM_label),
				  xmame_has_option (current_exec, "alsa-pcm"));

	gtk_widget_set_sensitive (GTK_WIDGET (pcm_entry),
				  xmame_has_option (current_exec, "alsa-pcm"));

	g_signal_connect (G_OBJECT (sound_checkbutton), "toggled",
			  G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (sound_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (sound_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (samples_checkbutton));
	g_signal_connect_after (G_OBJECT (sound_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (volume_frame));
	g_signal_connect_after (G_OBJECT (sound_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (bufsize_frame));
	g_signal_connect_after (G_OBJECT (sound_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (samplefreq_combo));
	g_signal_connect_after (G_OBJECT (sound_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (audiodevice_combo));
	g_signal_connect_after (G_OBJECT (sound_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (mixerdevice_combo));
	g_signal_connect_after (G_OBJECT (sound_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (samplefreq_label));
	g_signal_connect_after (G_OBJECT (sound_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (audiodevice_label));
	g_signal_connect_after (G_OBJECT (sound_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (mixerdevice_label));
	g_signal_connect (G_OBJECT (samples_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (samples_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (fakesound_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (fakesound_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (samplefreq_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (samplefreq_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment (GTK_RANGE (db_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment (GTK_RANGE (db_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment (GTK_RANGE (bufsize_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment (GTK_RANGE (bufsize_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (audiodevice_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (audiodevice_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (soundfile_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (soundfile_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (mixerdevice_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (mixerdevice_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (dsp_plugin_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (dsp_plugin_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (dsp_plugin_entry), "changed",
			    G_CALLBACK (file_or_device),
			    NULL);
	g_signal_connect (G_OBJECT (mixer_plugin_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (mixer_plugin_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (timer_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (timer_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (arts_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (arts_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (audio_preferred_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (audio_preferred_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (pcm_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (pcm_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (alsa_buffer_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (alsa_buffer_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (alsacard_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (alsacard_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (alsadevice_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (alsadevice_spinbutton), "changed",
			  G_CALLBACK (on_dirty_option),
			  reset_button);
}

void
add_controller_options_tab (GtkWidget    *properties_windows,
			    GtkNotebook  *target_notebook,
			    RomEntry     *rom,
			    GameOptions  *target,
			    GtkWidget    *apply_button,
			    GtkWidget    *reset_button)
{
	GtkWidget *controllers_vbox;
	GtkWidget *keyboard_frame;
	GtkWidget *keyboard_table;
	GtkWidget *keymapping_frame;
	GtkWidget *keymapping_table;
	GtkWidget *ctrlr_frame;
	GtkWidget *ctrlr_table;
	GtkWidget *ctrlr_label;
	GList *ctrlr_combo_items = NULL;
	GList *ctrlr_list = NULL;
	GList *my_list = NULL;
	GtkWidget *keymaptype_label;
	GtkWidget *keymaptype_combo;
	GList *keymaptype_combo_items = NULL;
	GtkWidget *mouse_frame;
	GtkWidget *mouse_table;
	GtkWidget *image;
	GtkWidget *Xinput_trackball_frame;
	GtkWidget *Xinput_trackball_table;
	GtkWidget *XInput_trackball1_label;
	GtkWidget *XInput_trackball2_label;
	GtkWidget *XInput_trackball3_label;
	GtkWidget *XInput_trackball4_label;
	GtkWidget *joystick_frame;
	GtkWidget *joystick_table;
	GtkWidget *joytype_label;
	GtkWidget *xinput_joy_table;
	GtkWidget *XInput_joystick1_label;
	GtkWidget *XInput_joystick2_label;
	GtkWidget *XInput_joystick3_label;
	GtkWidget *XInput_joystick4_label;
	GtkWidget *joytype_combo;
	GList *joytype_combo_items = NULL;
	GtkWidget *control_label;
	int i;
	GtkSizeGroup *group = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);

	xmame_get_options (current_exec);
	dirty_options_flag = FALSE;

	image = gxmame_get_image_from_stock ("gxmame-joystick-toolbar");

	control_label = gtk_hbox_new (FALSE, 5);
	gtk_box_pack_start (GTK_BOX (control_label), image, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (control_label), gtk_label_new (_("Controllers")), FALSE, FALSE, 0);
	gtk_widget_show_all (control_label);

	controllers_vbox = gtk_vbox_new (FALSE, 6);
	gtk_widget_show (controllers_vbox);
	gtk_notebook_append_page (GTK_NOTEBOOK (target_notebook), controllers_vbox, control_label);

/*** Joystick ***/
	joystick_frame = options_frame_new (_("Joystick"));
	gtk_widget_show (joystick_frame);
	gtk_box_pack_start (GTK_BOX (controllers_vbox), joystick_frame, FALSE, FALSE, 0);

	joystick_table = gtk_table_new (5, 7, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (joystick_table), 6);
	gtk_table_set_col_spacings (GTK_TABLE (joystick_table), 6);
	gtk_widget_show (joystick_table);
	gtk_container_add (GTK_CONTAINER (joystick_frame), joystick_table);

	image = gxmame_get_image_from_stock ("gxmame-joystick");
	gtk_widget_show (image);
	gtk_table_attach (GTK_TABLE (joystick_table), image, 0, 1, 0, 5, 0, GTK_EXPAND | GTK_FILL, 0, 0);
	gtk_misc_set_alignment (GTK_MISC (image), 0.5, 0);
	gtk_misc_set_padding (GTK_MISC (image), 5, 5);
	gtk_size_group_add_widget (GTK_SIZE_GROUP (group), image);

/* Joytype */
	joytype_label = gtk_label_new (_("Joystick type:"));
	gtk_widget_show (joytype_label);
	gtk_table_attach_defaults (GTK_TABLE (joystick_table), joytype_label, 1, 2, 0, 1);
	gtk_misc_set_alignment (GTK_MISC (joytype_label), 0, 0.5);

	joytype_combo = gtk_combo_new ();
	gtk_widget_show (joytype_combo);
	gtk_table_attach_defaults (GTK_TABLE (joystick_table), joytype_combo, 2, 4, 0, 1);

	{
		const gchar **joytypes;

		joytypes = xmame_get_option_values (current_exec, "joytype");

		if (joytypes) {
			i = 0;
			while (joytypes[i]) {
				joytype_combo_items = g_list_append (joytype_combo_items, (gpointer) joytypes[i]);
				i++;
			}
		}
	}
	gtk_combo_set_popdown_strings (GTK_COMBO (joytype_combo), joytype_combo_items);
	g_list_free (joytype_combo_items);

	joytype_combo_entry = GTK_COMBO (joytype_combo)->entry;
	gtk_editable_set_editable (GTK_EDITABLE (joytype_combo_entry), FALSE);
	gtk_widget_show (joytype_combo_entry);
	gtk_entry_set_text (GTK_ENTRY (joytype_combo_entry), _("No joystick"));

/* joystick prefix */
	joydevname_label = gtk_label_new (_("Joystick device prefix:"));
	gtk_widget_show (joydevname_label);
	gtk_table_attach_defaults (GTK_TABLE (joystick_table), joydevname_label, 1, 3, 1, 2);
	gtk_misc_set_alignment (GTK_MISC (joydevname_label), 0, 0.5);

	joydevname_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY (joydevname_entry), 20);
	gtk_widget_show (joydevname_entry);
	gtk_table_attach_defaults (GTK_TABLE (joystick_table), joydevname_entry, 3, 4, 1, 2);
	gtk_entry_set_text (GTK_ENTRY (joydevname_entry), "/dev/joy");

/* FM Townpad */
	paddevname_label = gtk_label_new (_("Name of pad device:\n (FM townpad)"));
	gtk_widget_show (paddevname_label);
	gtk_table_attach_defaults (GTK_TABLE (joystick_table), paddevname_label, 1, 3, 2, 3);
	gtk_label_set_justify (GTK_LABEL (paddevname_label), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (paddevname_label), 0, 0.5);

	paddevname_entry = gtk_entry_new ();
	gtk_widget_show (paddevname_entry);
	gtk_table_attach_defaults (GTK_TABLE (joystick_table), paddevname_entry, 3, 4, 2, 3);
	gtk_entry_set_text (GTK_ENTRY (paddevname_entry), "/dev/pad00");

/* X-based joy */
	x11joyname_label = gtk_label_new (_("X-based device:"));
	gtk_widget_show (x11joyname_label);
	gtk_table_attach_defaults (GTK_TABLE (joystick_table), x11joyname_label, 1, 3, 3, 4);
	gtk_misc_set_alignment (GTK_MISC (x11joyname_label), 0, 0.5);

	x11joyname_entry = gtk_entry_new ();
	gtk_widget_show (x11joyname_entry);
	gtk_table_attach_defaults (GTK_TABLE (joystick_table), x11joyname_entry, 3, 4, 3, 4);

/* analog joystick */
	analogstick_checkbutton = gtk_check_button_new_with_label (_("Analog joystick"));
	gtk_widget_show (analogstick_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (joystick_table), analogstick_checkbutton, 5, 6, 0, 1);

/* rapid fire */
	rapidfire_checkbutton = gtk_check_button_new_with_label (_("Rapid-fire"));
	gtk_widget_show (rapidfire_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (joystick_table), rapidfire_checkbutton, 5, 6, 1, 2);

/* USB PAD*/
	usbpspad_checkbutton = gtk_check_button_new_with_label (_("USB PS Game Pads"));
	gtk_widget_show (usbpspad_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (joystick_table), usbpspad_checkbutton, 5, 6, 2, 3);

/* Xinput */
	Xinput_joy_frame = options_frame_new (_("Xinput joystick"));
	gtk_widget_show (Xinput_joy_frame);
	gtk_table_attach_defaults (GTK_TABLE (joystick_table), Xinput_joy_frame, 1, 7, 4, 5);
	Xinput_joy_frame = options_frame_create_child (Xinput_joy_frame);

	xinput_joy_table = gtk_table_new (2, 4, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (xinput_joy_table), 6);
	gtk_table_set_col_spacings (GTK_TABLE (xinput_joy_table), 6);
	gtk_widget_show (xinput_joy_table);
	gtk_container_add (GTK_CONTAINER (Xinput_joy_frame), xinput_joy_table);

	XInput_joystick1_label = gtk_label_new ("1:");
	gtk_widget_show (XInput_joystick1_label);
	gtk_table_attach (GTK_TABLE (xinput_joy_table), XInput_joystick1_label, 0, 1, 0, 1, 0, 0, 0, 0);
	gtk_misc_set_alignment (GTK_MISC (XInput_joystick1_label), 0, 0.5);

	XInput_joystick1_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY (XInput_joystick1_entry), 20);
	gtk_widget_show (XInput_joystick1_entry);
	gtk_table_attach_defaults (GTK_TABLE (xinput_joy_table), XInput_joystick1_entry, 1, 2, 0, 1);

	XInput_joystick2_label = gtk_label_new ("2:");
	gtk_widget_show (XInput_joystick2_label);
	gtk_table_attach (GTK_TABLE (xinput_joy_table), XInput_joystick2_label, 2, 3, 0, 1, 0, 0, 0, 0);
	gtk_misc_set_alignment (GTK_MISC (XInput_joystick2_label), 0, 0.5);

	XInput_joystick3_label = gtk_label_new ("3:");
	gtk_widget_show (XInput_joystick3_label);
	gtk_table_attach (GTK_TABLE (xinput_joy_table), XInput_joystick3_label, 0, 1, 1, 2, 0, 0, 0, 0);
	gtk_misc_set_alignment (GTK_MISC (XInput_joystick3_label), 0, 0.5);

	XInput_joystick4_label = gtk_label_new ("4:");
	gtk_widget_show (XInput_joystick4_label);
	gtk_table_attach (GTK_TABLE (xinput_joy_table), XInput_joystick4_label, 2, 3, 1, 2, 0, 0, 0, 0);
	gtk_misc_set_alignment (GTK_MISC (XInput_joystick4_label), 0, 0.5);

	XInput_joystick3_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY (XInput_joystick3_entry), 20);
	gtk_widget_show (XInput_joystick3_entry);
	gtk_table_attach_defaults (GTK_TABLE (xinput_joy_table), XInput_joystick3_entry, 1, 2, 1, 2);

	XInput_joystick2_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY (XInput_joystick2_entry), 20);
	gtk_widget_show (XInput_joystick2_entry);
	gtk_table_attach_defaults (GTK_TABLE (xinput_joy_table), XInput_joystick2_entry, 3, 4, 0, 1);

	XInput_joystick4_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY (XInput_joystick4_entry), 20);
	gtk_widget_show (XInput_joystick4_entry);
	gtk_table_attach_defaults (GTK_TABLE (xinput_joy_table), XInput_joystick4_entry, 3, 4, 1, 2);

/*** Mouse ***/
	mouse_frame = options_frame_new (_("Mouse / Trackball"));
	gtk_widget_show (mouse_frame);
	gtk_box_pack_start (GTK_BOX (controllers_vbox), mouse_frame, FALSE, FALSE, 0);

	mouse_table = gtk_table_new (2, 3, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (mouse_table), 6);
	gtk_table_set_col_spacings (GTK_TABLE (mouse_table), 6);
	gtk_widget_show (mouse_table);
	gtk_container_add (GTK_CONTAINER (mouse_frame), mouse_table);

	image = gxmame_get_image_from_stock ("gxmame-mouse");
	gtk_widget_show (image);
	gtk_table_attach (GTK_TABLE (mouse_table), image, 0, 1, 0, 2, 0, GTK_EXPAND | GTK_FILL, 0, 0);
	gtk_misc_set_alignment (GTK_MISC (image), 0.5, 0);
	gtk_misc_set_padding (GTK_MISC (image), 5, 5);
	gtk_size_group_add_widget (GTK_SIZE_GROUP (group), image);

/* use mouse */
	mouse_checkbutton = gtk_check_button_new_with_label (_("Use mouse"));
	gtk_widget_show (mouse_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (mouse_table), mouse_checkbutton, 1, 2, 0, 1);

/* grab mouse */
	grabmouse_checkbutton = gtk_check_button_new_with_label (_("Grab mouse"));
	gtk_widget_show (grabmouse_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (mouse_table), grabmouse_checkbutton, 2, 3, 0, 1);

/* Xinput */
	Xinput_trackball_frame = options_frame_new (_("Xinput trackball"));
	gtk_widget_show (Xinput_trackball_frame);
	gtk_table_attach_defaults (GTK_TABLE (mouse_table), Xinput_trackball_frame, 1, 3, 1, 2);
	Xinput_trackball_frame = options_frame_create_child (Xinput_trackball_frame);

	Xinput_trackball_table = gtk_table_new (2, 4, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (Xinput_trackball_table), 6);
	gtk_table_set_col_spacings (GTK_TABLE (Xinput_trackball_table), 6);
	gtk_widget_show (Xinput_trackball_table);
	gtk_container_add (GTK_CONTAINER (Xinput_trackball_frame), Xinput_trackball_table);

	XInput_trackball1_label = gtk_label_new ("1:");
	gtk_widget_show (XInput_trackball1_label);
	gtk_table_attach (GTK_TABLE (Xinput_trackball_table), XInput_trackball1_label, 0, 1, 0, 1, 0, 0, 0, 0);
	gtk_misc_set_alignment (GTK_MISC (XInput_trackball1_label), 0, 0.5);

	XInput_trackball1_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY (XInput_trackball1_entry), 20);
	gtk_widget_show (XInput_trackball1_entry);
	gtk_table_attach_defaults (GTK_TABLE (Xinput_trackball_table), XInput_trackball1_entry, 1, 2, 0, 1);

	XInput_trackball2_label = gtk_label_new ("2:");
	gtk_widget_show (XInput_trackball2_label);
	gtk_table_attach (GTK_TABLE (Xinput_trackball_table), XInput_trackball2_label, 2, 3, 0, 1, 0, 0, 0, 0);
	gtk_misc_set_alignment (GTK_MISC (XInput_trackball2_label), 0, 0.5);

	XInput_trackball3_label = gtk_label_new ("3:");
	gtk_widget_show (XInput_trackball3_label);
	gtk_table_attach (GTK_TABLE (Xinput_trackball_table), XInput_trackball3_label, 0, 1, 1, 2, 0, 0, 0, 0);
	gtk_misc_set_alignment (GTK_MISC (XInput_trackball3_label), 0, 0.5);

	XInput_trackball4_label = gtk_label_new ("4:");
	gtk_widget_show (XInput_trackball4_label);
	gtk_table_attach (GTK_TABLE (Xinput_trackball_table), XInput_trackball4_label, 2, 3, 1, 2, 0, 0, 0, 0);
	gtk_misc_set_alignment (GTK_MISC (XInput_trackball4_label), 0, 0.5);

	XInput_trackball3_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY (XInput_trackball3_entry), 20);
	gtk_widget_show (XInput_trackball3_entry);
	gtk_table_attach_defaults (GTK_TABLE (Xinput_trackball_table), XInput_trackball3_entry, 1, 2, 1, 2);

	XInput_trackball2_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY (XInput_trackball2_entry), 20);
	gtk_widget_show (XInput_trackball2_entry);
	gtk_table_attach_defaults (GTK_TABLE (Xinput_trackball_table), XInput_trackball2_entry, 3, 4, 0, 1);

	XInput_trackball4_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY (XInput_trackball4_entry), 20);
	gtk_widget_show (XInput_trackball4_entry);
	gtk_table_attach_defaults (GTK_TABLE (Xinput_trackball_table), XInput_trackball4_entry, 3, 4, 1, 2);

/*** Keyboard ***/
	keyboard_frame = options_frame_new (_("Keyboard"));
	gtk_widget_show (keyboard_frame);
	gtk_box_pack_start (GTK_BOX (controllers_vbox), keyboard_frame, FALSE, FALSE, 0);

	keyboard_table = gtk_table_new (3, 4, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (keyboard_table), 6);
	gtk_table_set_col_spacings (GTK_TABLE (keyboard_table), 6);
	gtk_widget_show (keyboard_table);
	gtk_container_add (GTK_CONTAINER (keyboard_frame), keyboard_table);

	image = gxmame_get_image_from_stock ("gxmame-keyboard");
	gtk_widget_show (image);
	gtk_table_attach (GTK_TABLE (keyboard_table), image, 0, 1, 0, 3, 0, GTK_EXPAND | GTK_FILL, 0, 0);
	gtk_misc_set_alignment (GTK_MISC (image), 0.5, 0);
	gtk_misc_set_padding (GTK_MISC (image), 5, 5);
	gtk_size_group_add_widget (GTK_SIZE_GROUP (group), image);

/* use config */
 	config_name_checkbutton = gtk_check_button_new_with_label (_("Use config name:"));
 	gtk_widget_show (config_name_checkbutton);
 	gtk_table_attach_defaults (GTK_TABLE (keyboard_table), config_name_checkbutton, 1, 2, 0, 1);

	config_name_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY (config_name_entry), 20);
	gtk_widget_show (config_name_entry);
	gtk_table_attach_defaults (GTK_TABLE (keyboard_table), config_name_entry, 2, 3, 0, 1);

	/* Ctrlr */
	ctrlr_frame = options_frame_new (_("Control Panel"));
	gtk_widget_show (ctrlr_frame);
	gtk_table_attach_defaults (GTK_TABLE (keyboard_table), ctrlr_frame, 3, 4, 0, 3);
	ctrlr_frame = options_frame_create_child (ctrlr_frame);

	ctrlr_table = gtk_table_new (2, 3, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (ctrlr_table), 6);
	gtk_table_set_col_spacings (GTK_TABLE (ctrlr_table), 6);
	gtk_widget_show (ctrlr_table);
	gtk_container_add (GTK_CONTAINER (ctrlr_frame), ctrlr_table);

	ctrlr_label = gtk_label_new (_("Controller:"));
	gtk_widget_show (ctrlr_label);
	gtk_table_attach_defaults (GTK_TABLE (ctrlr_table), ctrlr_label, 0, 1, 0, 1);
	gtk_misc_set_alignment (GTK_MISC (ctrlr_label), 0, 0.5);

	ctrlr_combo = gtk_combo_new ();
	gtk_widget_show (ctrlr_combo);
	gtk_table_attach_defaults (GTK_TABLE (ctrlr_table), ctrlr_combo, 1, 2, 0, 1);
	gtk_combo_set_value_in_list (GTK_COMBO (ctrlr_combo), TRUE, FALSE);
	/* Getting ctrlr list */
	ctrlr_list = get_ctrlr_list ();

	ctrlr_combo_items = g_list_append (ctrlr_combo_items, (gpointer) _("None"));
	for (my_list = g_list_first (ctrlr_list);
			 (my_list != NULL);
			my_list = g_list_next (my_list))
	{
		ctrlr_combo_items = g_list_append (ctrlr_combo_items, (gpointer) _(g_strdup (my_list->data)));
	}
	gtk_combo_set_popdown_strings (GTK_COMBO (ctrlr_combo), ctrlr_combo_items);
	g_list_free (ctrlr_combo_items);
	g_list_free (ctrlr_list);

	ctrlr_combo_entry = GTK_COMBO (ctrlr_combo)->entry;
	gtk_editable_set_editable (GTK_EDITABLE (ctrlr_combo_entry), FALSE);
	gtk_widget_show (ctrlr_combo_entry);

/* HotRod */
	hotrod_checkbutton = gtk_check_button_new_with_label (_("HotRod support"));
	gtk_widget_show (hotrod_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (ctrlr_table), hotrod_checkbutton, 0, 2, 1, 2);

/* HotRod Second Edition */
	hotrodse_checkbutton = gtk_check_button_new_with_label (_("HotRod SE support"));
	gtk_widget_show (hotrodse_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (ctrlr_table), hotrodse_checkbutton, 0, 2, 2, 3);

/* grab keyboard */
	grabkeyboard_checkbutton = gtk_check_button_new_with_label (_("Grab keyboard"));
	gtk_widget_show (grabkeyboard_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (keyboard_table), grabkeyboard_checkbutton, 1, 2, 1, 2);

/* winkeys */
	winkeys_checkbutton = gtk_check_button_new_with_label (_("Enable Windows keys"));
	gtk_widget_show (winkeys_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (keyboard_table), winkeys_checkbutton, 2, 3, 1, 2);

/* key mapping... one day maybe :-) */
	keymapping_frame = options_frame_new (_("Key mapping"));
	gtk_widget_show (keymapping_frame);
	gtk_table_attach_defaults (GTK_TABLE (keyboard_table), keymapping_frame, 1, 3, 2, 3);
	keymapping_frame = options_frame_create_child (keymapping_frame);

	keymapping_table = gtk_table_new (2, 1, FALSE);
	gtk_widget_show (keymapping_table);
	gtk_container_add (GTK_CONTAINER (keymapping_frame), keymapping_table);

	keymaptype_label = gtk_label_new (_("Keyboard Layout type:"));
	gtk_widget_show (keymaptype_label);
	gtk_table_attach_defaults (GTK_TABLE (keymapping_table), keymaptype_label, 0, 1, 0, 1);
	gtk_misc_set_alignment (GTK_MISC (keymaptype_label), 0, 0.5);

	keymaptype_combo = gtk_combo_new ();
	gtk_widget_show (keymaptype_combo);
	gtk_table_attach_defaults (GTK_TABLE (keymapping_table), keymaptype_combo, 1, 2, 0, 1);
	gtk_combo_set_value_in_list (GTK_COMBO (keymaptype_combo), TRUE, FALSE);
	keymaptype_combo_items = g_list_append (keymaptype_combo_items, (gpointer) _("Default layout"));
	for (i=0;x11_keymaps_layout[i].shortname;i++)
	 {
	   keymaptype_combo_items = g_list_append (keymaptype_combo_items,
					 (gpointer) _(x11_keymaps_layout[i].name));
	 }
	gtk_combo_set_popdown_strings (GTK_COMBO (keymaptype_combo), keymaptype_combo_items);
	g_list_free (keymaptype_combo_items);

	keymaptype_combo_entry = GTK_COMBO (keymaptype_combo)->entry;
	gtk_editable_set_editable (GTK_EDITABLE (keymaptype_combo_entry), FALSE);
	gtk_widget_show (keymaptype_combo_entry);

/* ugcicoin */
	ugcicoin_checkbutton = gtk_check_button_new_with_label (_("UGCI (tm) Coin/Play support"));
	gtk_widget_show (ugcicoin_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (joystick_table), ugcicoin_checkbutton, 5, 7, 3, 4);

/* end controllers*/

	gtk_widget_set_sensitive (paddevname_label, FALSE);
	gtk_widget_set_sensitive (paddevname_entry, FALSE);
	gtk_widget_set_sensitive (x11joyname_label, FALSE);
	gtk_widget_set_sensitive (x11joyname_entry, FALSE);
	gtk_widget_set_sensitive (joydevname_label, FALSE);
	gtk_widget_set_sensitive (joydevname_entry, FALSE);

	switch (target->joytype)
	{
		case (0): /* no joystick */
			gtk_widget_set_sensitive (analogstick_checkbutton, FALSE);
			gtk_widget_set_sensitive (usbpspad_checkbutton, FALSE);
			gtk_widget_set_sensitive (rapidfire_checkbutton, FALSE);
			break;
		case (1): /* i386 style */
		case (4): /* new i386 linux 1.x.x driver */
			gtk_widget_set_sensitive (joydevname_label, TRUE);
			gtk_widget_set_sensitive (joydevname_entry, TRUE);
			break;
		case (2): /* Fm Town Pad */
			gtk_widget_set_sensitive (paddevname_label, TRUE);
			gtk_widget_set_sensitive (paddevname_entry, TRUE);
			break;
		case (3): /* X11 input extension */
			gtk_widget_set_sensitive (x11joyname_label, TRUE);
			gtk_widget_set_sensitive (x11joyname_entry, TRUE);
			break;
	}

	{
		const gchar *joyname;

		joyname = xmame_get_option_value (current_exec, "joytype", target->joytype);

		gtk_entry_set_text (GTK_ENTRY (joytype_combo_entry), joyname?joyname:"No joystick");
	}

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (analogstick_checkbutton), target->analogstick);
	gtk_entry_set_text (GTK_ENTRY (ctrlr_combo_entry), target->ctrlr);
	
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (hotrod_checkbutton), target->hotrod);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (hotrodse_checkbutton), target->hotrodse);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (usbpspad_checkbutton), target->usbpspad);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rapidfire_checkbutton), target->rapidfire);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ugcicoin_checkbutton), target->ugcicoin);
	gtk_entry_set_text (GTK_ENTRY (joydevname_entry), target->joydevname);
	gtk_entry_set_text (GTK_ENTRY (paddevname_entry), target->paddevname);
	gtk_entry_set_text (GTK_ENTRY (x11joyname_entry), target->x11joyname);
/*	gtk_entry_set_text (GTK_ENTRY (XInput_joystick1_entry), target->XInput_joystick1);
	gtk_entry_set_text (GTK_ENTRY (XInput_joystick2_entry), target->XInput_joystick2);
	gtk_entry_set_text (GTK_ENTRY (XInput_joystick3_entry), target->XInput_joystick3);
	gtk_entry_set_text (GTK_ENTRY (XInput_joystick4_entry), target->XInput_joystick4);*/
	
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (mouse_checkbutton), target->mouse);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (grabmouse_checkbutton), target->grabmouse);
	gtk_entry_set_text (GTK_ENTRY (XInput_trackball1_entry), target->XInput_trackball1);
	gtk_entry_set_text (GTK_ENTRY (XInput_trackball2_entry), target->XInput_trackball2);
	gtk_entry_set_text (GTK_ENTRY (XInput_trackball3_entry), target->XInput_trackball3);
	gtk_entry_set_text (GTK_ENTRY (XInput_trackball4_entry), target->XInput_trackball4);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (grabkeyboard_checkbutton), target->grabkeyboard);
	
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (winkeys_checkbutton), target->winkeys);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (config_name_checkbutton), target->cfgname_flag);
	gtk_entry_set_text (GTK_ENTRY (config_name_entry), target->cfgname);

	gtk_widget_set_sensitive (GTK_WIDGET (ctrlr_combo), 
				  xmame_has_option (current_exec, "ctrlr"));

	gtk_widget_set_sensitive (hotrod_checkbutton,
				  xmame_has_option (current_exec, "hotrod"));

	gtk_widget_set_sensitive (hotrodse_checkbutton,
				  xmame_has_option (current_exec, "hotrodse"));

	gtk_widget_set_sensitive (GTK_WIDGET (Xinput_joy_frame), FALSE);

	gtk_widget_set_sensitive (GTK_WIDGET (grabmouse_checkbutton),
				  target->mouse && xmame_has_option (current_exec, "grabmouse"));

	gtk_widget_set_sensitive (GTK_WIDGET (grabkeyboard_checkbutton),
				  xmame_has_option (current_exec, "grabkeyboard"));

	gtk_widget_set_sensitive (GTK_WIDGET (config_name_checkbutton),
				  (xmame_has_option (current_exec, "cfgname") ||
				   xmame_has_option (current_exec, "cfg_directory")));

	gtk_widget_set_sensitive (GTK_WIDGET (config_name_entry), 
				  target->cfgname_flag && 
				  (xmame_has_option (current_exec, "cfgname") ||
				   xmame_has_option (current_exec, "cfg_directory")));

	for (i=0;x11_keymaps_layout[i].shortname;i++)
	{
		if (strcmp (x11_keymaps_layout[i].shortname, target->keymap) == 0)
			gtk_entry_set_text (GTK_ENTRY (keymaptype_combo_entry), _(x11_keymaps_layout[i].name));
	}

	g_signal_connect (G_OBJECT (joytype_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (joytype_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (joytype_combo_entry), "changed",
			          G_CALLBACK (joystick_choosen),
			          NULL);
	g_signal_connect (G_OBJECT (analogstick_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (analogstick_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (hotrod_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (hotrod_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (hotrodse_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (hotrodse_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (usbpspad_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (usbpspad_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (rapidfire_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (rapidfire_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (ugcicoin_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (ugcicoin_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (joydevname_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (joydevname_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (paddevname_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (paddevname_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (x11joyname_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (x11joyname_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
/*	g_signal_connect (G_OBJECT (XInput_joystick1_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (XInput_joystick1_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (XInput_joystick2_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (XInput_joystick2_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (XInput_joystick3_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (XInput_joystick3_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (XInput_joystick4_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (XInput_joystick4_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);*/
	g_signal_connect (G_OBJECT (mouse_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (mouse_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	if (xmame_has_option (current_exec, "grabmouse"))
		g_signal_connect_after (G_OBJECT (mouse_checkbutton), "toggled",
				          G_CALLBACK (button_toggled),
				          grabmouse_checkbutton);
	g_signal_connect (G_OBJECT (grabmouse_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (grabmouse_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (XInput_trackball1_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (XInput_trackball1_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (XInput_trackball2_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (XInput_trackball2_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (XInput_trackball3_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (XInput_trackball3_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (XInput_trackball4_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (XInput_trackball4_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (winkeys_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (winkeys_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (grabkeyboard_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (grabkeyboard_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
 	g_signal_connect (G_OBJECT (keymaptype_combo_entry), "changed",
 			    G_CALLBACK (on_dirty_option),
 			    apply_button);
 	g_signal_connect (G_OBJECT (keymaptype_combo_entry), "changed",
 			    G_CALLBACK (on_dirty_option),
 			    reset_button);
	if (xmame_has_option (current_exec, "cfgname") || xmame_has_option (current_exec, "cfg_directory"))
	{
		g_signal_connect (G_OBJECT (config_name_checkbutton), "toggled",
				    G_CALLBACK (on_dirty_option),
				    apply_button);
		g_signal_connect (G_OBJECT (config_name_checkbutton), "toggled",
				    G_CALLBACK (on_dirty_option),
				    reset_button);
		g_signal_connect (G_OBJECT (config_name_entry), "changed",
				    G_CALLBACK (on_dirty_option),
				    apply_button);
		g_signal_connect (G_OBJECT (config_name_entry), "changed",
				    G_CALLBACK (on_dirty_option),
				    reset_button);
		g_signal_connect_after (G_OBJECT (config_name_checkbutton), "toggled",
				          G_CALLBACK (button_toggled),
				          config_name_entry);
	}
	if (xmame_has_option (current_exec, "ctrlr")) {
		g_signal_connect (G_OBJECT (ctrlr_combo_entry), "changed",
				  G_CALLBACK (on_dirty_option),
				  apply_button);
		g_signal_connect (G_OBJECT (ctrlr_combo_entry), "changed",
				  G_CALLBACK (on_dirty_option),
				  reset_button);
	}

}


void
add_misc_options_tab (GtkWidget *properties_windows,
		      GtkNotebook  *target_notebook,
		      RomEntry     *rom,
		      GameOptions  *target,
		      GtkWidget    *apply_button,
		      GtkWidget    *reset_button)
{
	GtkWidget *image;
	GtkWidget *misc_vbox;
	GtkWidget *artwork_table;
	GtkWidget *artwork_resolution_combo;
	GList *artwork_resolution_combo_items = NULL;
	GtkWidget *other_misc_frame;
	GtkWidget *other_misc_table;
	GtkWidget *misc_label;
	GtkWidget *label;
	GList *debug_size_combo_items = NULL;
	GList *bios_combo_items = NULL;

	int i;
	gchar title[BUFFER_SIZE];
	
	xmame_get_options (current_exec);	
	dirty_options_flag = FALSE;

	image = gxmame_get_image_from_stock ("gxmame-general-toolbar");

	misc_label = gtk_hbox_new (FALSE, 5);
	gtk_box_pack_start (GTK_BOX (misc_label), image, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (misc_label), gtk_label_new (_("Miscellaneous")), FALSE, FALSE, 0);
	gtk_widget_show_all (misc_label);

	misc_vbox = gtk_vbox_new (FALSE, 6);
	gtk_widget_show (misc_vbox);
	gtk_notebook_append_page (GTK_NOTEBOOK (target_notebook), misc_vbox, misc_label);

	/* artwork resolution */
	artwork_frame = options_frame_new (_("Artwork"));
	gtk_widget_show (artwork_frame);
	gtk_box_pack_start (GTK_BOX (misc_vbox), artwork_frame, FALSE, FALSE, 0);
	artwork_frame = options_frame_create_child (artwork_frame);

	artwork_table = gtk_table_new (2, 5, FALSE);
	gtk_widget_show (artwork_table);
	gtk_container_add (GTK_CONTAINER (artwork_frame), artwork_table);

	/* additional artwork */
	artwork_checkbutton = gtk_check_button_new_with_label (_("Use additional game artwork:"));
	gtk_widget_show (artwork_checkbutton);
	gtk_table_attach (GTK_TABLE (artwork_table), artwork_checkbutton, 0, 1, 0, 1, GTK_FILL, 0, 0, 0);

	use_backdrops_checkbutton = gtk_check_button_new_with_label (_("Backdrops"));
	gtk_widget_show (use_backdrops_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (artwork_table), use_backdrops_checkbutton, 1, 2, 0, 1);

	use_bezels_checkbutton = gtk_check_button_new_with_label (_("Bezels"));
	gtk_widget_show (use_bezels_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (artwork_table), use_bezels_checkbutton, 1, 2, 1, 2);

	use_overlays_checkbutton = gtk_check_button_new_with_label (_("Overlays"));
	gtk_widget_show (use_overlays_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (artwork_table), use_overlays_checkbutton, 1, 2, 2, 3);

	label = gtk_label_new (_("Artwork resolution:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (artwork_table), label, 0, 1, 3, 4, GTK_FILL, 0, 0, 0);

	artwork_resolution_combo = gtk_combo_new ();
	gtk_widget_show (artwork_resolution_combo);
	gtk_table_attach_defaults (GTK_TABLE (artwork_table), artwork_resolution_combo, 1, 2, 3, 4);
	artwork_resolution_combo_items = g_list_append (artwork_resolution_combo_items, (gpointer) _("Auto"));
	artwork_resolution_combo_items = g_list_append (artwork_resolution_combo_items, (gpointer) _("Standard"));
	artwork_resolution_combo_items = g_list_append (artwork_resolution_combo_items, (gpointer) _("High"));
	gtk_combo_set_popdown_strings (GTK_COMBO (artwork_resolution_combo), artwork_resolution_combo_items);
	g_list_free (artwork_resolution_combo_items);

	artwork_resolution_combo_entry = GTK_COMBO (artwork_resolution_combo)->entry;
	gtk_widget_show (artwork_resolution_combo_entry);
	gtk_editable_set_editable (GTK_EDITABLE (artwork_resolution_combo_entry), FALSE);
	gtk_entry_set_text (GTK_ENTRY (artwork_resolution_combo_entry), _("Auto"));

	/* artwork crop */
	artcrop_checkbutton = gtk_check_button_new_with_label (_("Crop artwork"));
	gtk_widget_show (artcrop_checkbutton);
	gtk_table_attach (GTK_TABLE (artwork_table), artcrop_checkbutton, 0, 1, 4, 5, GTK_FILL, 0, 0, 0);

	other_misc_frame = options_frame_new (_("Other options"));
	gtk_widget_show (other_misc_frame);
	gtk_box_pack_start (GTK_BOX (misc_vbox), other_misc_frame, FALSE, FALSE, 0);
	other_misc_frame = options_frame_create_child (other_misc_frame);

/* misc options */
	other_misc_table = gtk_table_new (3, 8, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (other_misc_table), 6);
	gtk_table_set_col_spacings (GTK_TABLE (other_misc_table), 6);
	gtk_widget_show (other_misc_table);
	gtk_container_add (GTK_CONTAINER (other_misc_frame), other_misc_table);

	keyboard_leds_checkbutton = gtk_check_button_new_with_label (_("Use keyboard LEDs as game indicators"));
	gtk_widget_show (keyboard_leds_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (other_misc_table), keyboard_leds_checkbutton, 0, 1, 0, 1);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (keyboard_leds_checkbutton), TRUE);

	additional_options_checkbutton = gtk_check_button_new_with_label (_("Use additional options:"));
	gtk_widget_show (additional_options_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (other_misc_table), additional_options_checkbutton, 0, 1, 1, 2);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (additional_options_checkbutton), TRUE);

	additional_options_entry = gtk_entry_new ();
	gtk_widget_show (additional_options_entry);
	gtk_table_attach_defaults (GTK_TABLE (other_misc_table), additional_options_entry, 1, 3, 1, 2);
	
	debug_checkbutton = gtk_check_button_new_with_label (_("Debug windows (for developers)"));
	gtk_widget_show (debug_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (other_misc_table), debug_checkbutton, 0, 1, 2, 3);

	debug_size_label = gtk_label_new (_("Window size:"));
	gtk_widget_show (debug_size_label);
	gtk_table_attach_defaults (GTK_TABLE (other_misc_table), debug_size_label, 1, 2, 2, 3);
	gtk_misc_set_alignment (GTK_MISC (debug_size_label), 0, 0.5);

	debug_size_combo = gtk_combo_new ();
	gtk_widget_show (debug_size_combo);
	gtk_table_attach_defaults (GTK_TABLE (other_misc_table), debug_size_combo, 2, 3, 2, 3);
	debug_size_combo_items = g_list_append (debug_size_combo_items, (gpointer) "640x480");
	debug_size_combo_items = g_list_append (debug_size_combo_items, (gpointer) "800x600");
	debug_size_combo_items = g_list_append (debug_size_combo_items, (gpointer) "1024x768");
	debug_size_combo_items = g_list_append (debug_size_combo_items, (gpointer) "1280x1024");
	debug_size_combo_items = g_list_append (debug_size_combo_items, (gpointer) "1600x1200");
	gtk_combo_set_popdown_strings (GTK_COMBO (debug_size_combo), debug_size_combo_items);
	g_list_free (debug_size_combo_items);

	debug_size_combo_entry = GTK_COMBO (debug_size_combo)->entry;
	gtk_widget_show (debug_size_combo_entry);
	gtk_entry_set_text (GTK_ENTRY (debug_size_combo_entry), "640x480");

	log_flag_checkbutton = gtk_check_button_new_with_label (_("Log debug info"));
	gtk_widget_show (log_flag_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (other_misc_table), log_flag_checkbutton, 0, 1, 3, 4);

	log_label = gtk_label_new (_("File:"));
	gtk_widget_show (log_label);
	gtk_table_attach_defaults (GTK_TABLE (other_misc_table), log_label, 1, 2, 3, 4);
	gtk_misc_set_alignment (GTK_MISC (log_label), 0, 0.5);

	log_entry = gtk_entry_new ();
	gtk_widget_show (log_entry);
	gtk_table_attach_defaults (GTK_TABLE (other_misc_table), log_entry, 2, 3, 3, 4);

	disclaimer_checkbutton = gtk_check_button_new_with_label (_("Skip disclaimer info"));
	gtk_widget_show (disclaimer_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (other_misc_table), disclaimer_checkbutton, 0, 1, 4, 5);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (disclaimer_checkbutton), TRUE);

	gameinfo_checkbutton = gtk_check_button_new_with_label (_("Skip game info"));
	gtk_widget_show (gameinfo_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (other_misc_table), gameinfo_checkbutton, 0, 1, 5, 6);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gameinfo_checkbutton), TRUE);

	cheat_checkbutton = gtk_check_button_new_with_label (_("Enable game cheats"));
	gtk_widget_show (cheat_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (other_misc_table), cheat_checkbutton, 0, 1, 6, 7);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cheat_checkbutton), TRUE);


/********************************************/
	
	bios_label = gtk_label_new (_("Neo-Geo Bios:"));
	gtk_widget_show (bios_label);
	gtk_table_attach_defaults (GTK_TABLE (other_misc_table), bios_label, 0, 1, 7, 8);
	gtk_misc_set_alignment (GTK_MISC (bios_label), 0, 0.5);

	bios_combo = gtk_combo_new ();
	gtk_widget_show (bios_combo);
	gtk_table_attach_defaults (GTK_TABLE (other_misc_table), bios_combo, 1, 2, 7, 8);
	gtk_combo_set_value_in_list (GTK_COMBO (bios_combo), TRUE, FALSE);
/*	bios_combo_items = g_list_append (bios_combo_items, (gpointer) _("bios")); */
	i = 0;
	do {
		bios_combo_items = g_list_append (bios_combo_items, (gpointer) _(bios_version[i]));
		i++;
	} while (bios_version[i]);
	gtk_combo_set_popdown_strings (GTK_COMBO (bios_combo), bios_combo_items);
	g_list_free (bios_combo_items);

	bios_combo_entry = GTK_COMBO (bios_combo)->entry;
	gtk_editable_set_editable (GTK_EDITABLE (bios_combo_entry), FALSE);
	gtk_widget_show (bios_combo_entry);

/********************************************/
	
/* end misc options */
	
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (artwork_checkbutton), target->artwork);
	/* the use_backdrops option will be used for all new backdrop option maybe change after */
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (use_backdrops_checkbutton), target->use_backdrops);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (use_bezels_checkbutton), target->use_bezels);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (use_overlays_checkbutton), target->use_overlays);

	switch (target->artwork_resolution) {
	case (0):
		g_snprintf (title, BUFFER_SIZE, "%s", _("Auto"));
		break;
	case (1):
		g_snprintf (title, BUFFER_SIZE, "%s", _("Standard"));
		break;
	case (2):
		g_snprintf (title, BUFFER_SIZE, "%s", _("High"));
		break;
	}

	gtk_entry_set_text (GTK_ENTRY (artwork_resolution_combo_entry), title);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (artcrop_checkbutton), target->artwork_crop);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (keyboard_leds_checkbutton), target->keyboard_leds);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cheat_checkbutton), target->cheat);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (disclaimer_checkbutton), target->skip_disclaimer);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gameinfo_checkbutton), target->skip_gameinfo);

	i = 0;
	do {
		if (i == target->bios)
			gtk_entry_set_text (GTK_ENTRY (bios_combo_entry), _(bios_version[i]));
		i++;
	} while (bios_version[i]);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (debug_checkbutton), target->debug);
	gtk_entry_set_text (GTK_ENTRY (debug_size_combo_entry), target->debug_size);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (additional_options_checkbutton), target->use_additional_options);
	
	gtk_entry_set_text (GTK_ENTRY (additional_options_entry), target->additional_options);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (log_flag_checkbutton), target->log_flag);
	
	gtk_entry_set_text (GTK_ENTRY (log_entry), target->log);
	
	gtk_widget_set_sensitive (GTK_WIDGET (artwork_resolution_combo),
				  xmame_has_option (current_exec, "artwork_resolution") && target->artwork);

	gtk_widget_set_sensitive (GTK_WIDGET (use_backdrops_checkbutton),
				  xmame_has_option (current_exec, "use_backdrops") && target->artwork);
	gtk_widget_set_sensitive (GTK_WIDGET (use_bezels_checkbutton),
				  xmame_has_option (current_exec, "use_backdrops") && target->artwork);
	gtk_widget_set_sensitive (GTK_WIDGET (use_overlays_checkbutton),
				  xmame_has_option (current_exec, "use_backdrops") && target->artwork);

	gtk_widget_set_sensitive (GTK_WIDGET (artcrop_checkbutton),
				  xmame_has_option (current_exec, "artwork_crop") && target->artwork);

	gtk_widget_set_sensitive (GTK_WIDGET (keyboard_leds_checkbutton),
				  xmame_has_option (current_exec, "keyboard_leds"));
	
	gtk_widget_set_sensitive (GTK_WIDGET (disclaimer_checkbutton),
				  xmame_has_option (current_exec, "skip_disclaimer"));

	gtk_widget_set_sensitive (GTK_WIDGET (gameinfo_checkbutton),
				  xmame_has_option (current_exec, "skip_gameinfo"));

	gtk_widget_set_sensitive (GTK_WIDGET (bios_label),
				  xmame_has_option (current_exec, "bios"));

	gtk_widget_set_sensitive (GTK_WIDGET (bios_combo),
				  xmame_has_option (current_exec, "bios"));

	gtk_widget_set_sensitive (GTK_WIDGET (debug_checkbutton), 
				  xmame_has_option (current_exec, "debug"));

	gtk_widget_set_sensitive (GTK_WIDGET (debug_size_label), 
				  xmame_has_option (current_exec, "debug") && target->debug);
	gtk_widget_set_sensitive (GTK_WIDGET (debug_size_combo),
				  xmame_has_option (current_exec, "debug") && target->debug);

	gtk_widget_set_sensitive (GTK_WIDGET (additional_options_entry), target->use_additional_options);
	gtk_widget_set_sensitive (GTK_WIDGET (log_label), target->log_flag);
	gtk_widget_set_sensitive (GTK_WIDGET (log_entry), target->log_flag);

	g_signal_connect (G_OBJECT (artwork_checkbutton), "toggled",
			  G_CALLBACK (on_dirty_option),
			  apply_button);
	g_signal_connect (G_OBJECT (artwork_checkbutton), "toggled",
			  G_CALLBACK (on_dirty_option),
			  reset_button);
	if (xmame_has_option (current_exec, "use_backdrops")) {
		g_signal_connect_after (G_OBJECT (artwork_checkbutton), "toggled",
					G_CALLBACK (button_toggled),
					use_backdrops_checkbutton);
		g_signal_connect_after (G_OBJECT (artwork_checkbutton), "toggled",
					G_CALLBACK (button_toggled),
					use_bezels_checkbutton);
		g_signal_connect_after (G_OBJECT (artwork_checkbutton), "toggled",
					G_CALLBACK (button_toggled),
					use_overlays_checkbutton);
	}
	if (xmame_has_option (current_exec, "artwork_resolution"))
		g_signal_connect_after (G_OBJECT (artwork_checkbutton), "toggled",
				    	  G_CALLBACK (button_toggled),
				    	  artwork_resolution_combo);
	if (xmame_has_option (current_exec, "artwork_crop"))
		g_signal_connect_after (G_OBJECT (artwork_checkbutton), "toggled",
					G_CALLBACK (button_toggled),
					artcrop_checkbutton);
	g_signal_connect (G_OBJECT (use_backdrops_checkbutton), "toggled",
			  G_CALLBACK (on_dirty_option),
			  apply_button);
	g_signal_connect (G_OBJECT (use_backdrops_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (use_bezels_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (use_bezels_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (use_overlays_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (use_overlays_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (artwork_resolution_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (artwork_resolution_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (artcrop_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (artcrop_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (keyboard_leds_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (keyboard_leds_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (cheat_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (cheat_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (disclaimer_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (disclaimer_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gameinfo_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gameinfo_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	g_signal_connect (G_OBJECT (debug_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (debug_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	if (xmame_has_option (current_exec, "debug")) {
		g_signal_connect (G_OBJECT (debug_checkbutton), "toggled",
				    G_CALLBACK (on_dirty_option),
				    apply_button);
		g_signal_connect (G_OBJECT (debug_checkbutton), "toggled",
				    G_CALLBACK (on_dirty_option),
				    reset_button);
		g_signal_connect_after (G_OBJECT (debug_checkbutton), "toggled",
				    	  G_CALLBACK (button_toggled),
				    	  debug_size_combo);
		g_signal_connect_after (G_OBJECT (debug_checkbutton), "toggled",
				    	  G_CALLBACK (button_toggled),
				    	  debug_size_label);
		g_signal_connect (G_OBJECT (debug_size_combo_entry), "changed",
				    G_CALLBACK (on_dirty_option),
				    apply_button);
		g_signal_connect (G_OBJECT (debug_size_combo_entry), "changed",
				    G_CALLBACK (on_dirty_option),
				    reset_button);
	}
	g_signal_connect (G_OBJECT (additional_options_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (additional_options_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (additional_options_checkbutton), "toggled",
			    	  G_CALLBACK (button_toggled),
			    	  additional_options_entry);
	g_signal_connect (G_OBJECT (additional_options_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (additional_options_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
 	g_signal_connect (G_OBJECT (bios_combo_entry), "changed",
 			    G_CALLBACK (on_dirty_option),
 			    apply_button);
 	g_signal_connect (G_OBJECT (bios_combo_entry), "changed",
 			    G_CALLBACK (on_dirty_option),
 			    reset_button);

	g_signal_connect (G_OBJECT (log_flag_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (log_flag_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (log_flag_checkbutton), "toggled",
			    	  G_CALLBACK (button_toggled),
			    	  log_label);
	g_signal_connect_after (G_OBJECT (log_flag_checkbutton), "toggled",
			    	  G_CALLBACK (button_toggled),
			    	  log_entry);
	g_signal_connect (G_OBJECT (log_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (log_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	g_signal_connect (G_OBJECT (cheat_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (cheat_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (debug_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (debug_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (keyboard_leds_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (keyboard_leds_checkbutton), "toggled",
			  G_CALLBACK (on_dirty_option),
			  reset_button);
}

void
add_vector_options_tab (GtkWidget    *properties_windows,
                        GtkNotebook  *target_notebook,
                        RomEntry     *rom,
                        GameOptions  *target,
                        GtkWidget    *apply_button,
                        GtkWidget    *reset_button)
{
	GtkWidget *image;
	GtkWidget *vector_vbox;
	GtkWidget *beam_label;
	GtkWidget *flicker_label;
	GtkWidget *intensity_label;
	GtkWidget *gl_vector_frame;
	GtkWidget *gl_vector_table;
	GtkWidget *vectorres_combo;
	GList *vectorres_combo_items = NULL;
	GtkWidget *vector_label;
	GtkWidget *frame;
	GtkWidget *vbox;
	GtkWidget *hbox;

	xmame_get_options (current_exec);
	dirty_options_flag = FALSE;
  
	image = gxmame_get_image_from_stock ("gxmame-general-toolbar");

	vector_label = gtk_hbox_new (FALSE, 5);
	gtk_box_pack_start (GTK_BOX (vector_label), image, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vector_label), gtk_label_new (_("Vector")), FALSE, FALSE, 0);
	gtk_widget_show_all (vector_label);

	vector_vbox = gtk_vbox_new (FALSE, 6);
	gtk_widget_show (vector_vbox);
	gtk_notebook_append_page (GTK_NOTEBOOK (target_notebook), vector_vbox, vector_label);

	frame = options_frame_new (_("Vector options"));
	gtk_widget_show (frame);
	gtk_box_pack_start (GTK_BOX (vector_vbox), frame, FALSE, FALSE, 0);
	frame = options_frame_create_child (frame);

/* tranlucencent vectors */
	antialias_checkbutton = gtk_check_button_new_with_label (_("Draw antialiased vectors"));
	gtk_widget_show (antialias_checkbutton);
	gtk_box_pack_start (GTK_BOX (frame), antialias_checkbutton, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (antialias_checkbutton), TRUE);

/* tranlucencent vectors */
	translucency_checkbutton = gtk_check_button_new_with_label (_("Draw tranlucencent vectors"));
	gtk_widget_show (translucency_checkbutton);
	gtk_box_pack_start (GTK_BOX (frame), translucency_checkbutton, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (translucency_checkbutton), TRUE);

/* beam size */
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox);
	gtk_box_pack_start (GTK_BOX (frame), vbox, FALSE, FALSE, 0);

	beam_label = gtk_label_new (_("Beam size"));
	gtk_widget_show (beam_label);
	gtk_box_pack_start (GTK_BOX (vbox), beam_label, FALSE, FALSE, 0);
	gtk_misc_set_alignment (GTK_MISC (beam_label), 0, 0.5);

	beam_hscale = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (target->beam, 1, 16, 0.1, 0, 0)));
	gtk_widget_show (beam_hscale);
	gtk_box_pack_start (GTK_BOX (vbox), beam_hscale, FALSE, FALSE, 0);
	gtk_scale_set_value_pos (GTK_SCALE (beam_hscale), GTK_POS_RIGHT);
	gtk_scale_set_digits (GTK_SCALE (beam_hscale), 2);

/* Flicker */
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox);
	gtk_box_pack_start (GTK_BOX (frame), vbox, FALSE, FALSE, 0);

	flicker_label = gtk_label_new (_("Flicker"));
	gtk_widget_show (flicker_label);
	gtk_box_pack_start (GTK_BOX (vbox), flicker_label, FALSE, FALSE, 0);
	gtk_misc_set_alignment (GTK_MISC (flicker_label), 0, 0.5);

	flicker_hscale = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (target->flicker, 0, 100, 1, 10, 0)));
	gtk_widget_show (flicker_hscale);
	gtk_box_pack_start (GTK_BOX (vbox), flicker_hscale, FALSE, FALSE, 0);
	gtk_scale_set_value_pos (GTK_SCALE (flicker_hscale), GTK_POS_RIGHT);
	gtk_scale_set_digits (GTK_SCALE (flicker_hscale), 0);

/* Intensity */
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox);
	gtk_box_pack_start (GTK_BOX (frame), vbox, FALSE, FALSE, 0);

	intensity_label = gtk_label_new (_("Intensity"));
	gtk_widget_show (intensity_label);
	gtk_box_pack_start (GTK_BOX (vbox), intensity_label, FALSE, FALSE, 0);
	gtk_misc_set_alignment (GTK_MISC (intensity_label), 0, 0.5);

	intensity_hscale = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (target->intensity, 0.5, 3, 0.01, 1, 0)));
	gtk_widget_show (intensity_hscale);
	gtk_box_pack_start (GTK_BOX (vbox), intensity_hscale, FALSE, FALSE, 0);
	gtk_scale_set_value_pos (GTK_SCALE (intensity_hscale), GTK_POS_RIGHT);
	gtk_scale_set_digits (GTK_SCALE (intensity_hscale), 2);

/* Fixed resolution */
	hbox = gtk_hbox_new (FALSE, 6);
	gtk_widget_show (hbox);
	gtk_box_pack_start (GTK_BOX (frame), hbox, FALSE, FALSE, 0);

	vector_fixed_resolution_checkbutton = gtk_check_button_new_with_label (_("Use fixed resolution:"));
	gtk_widget_show (vector_fixed_resolution_checkbutton);
	gtk_box_pack_start (GTK_BOX (hbox), vector_fixed_resolution_checkbutton, FALSE, FALSE, 0);

	vectorres_combo = gtk_combo_new ();
	gtk_widget_show (vectorres_combo);
	gtk_box_pack_start (GTK_BOX (hbox), vectorres_combo, FALSE, FALSE, 0);

	vectorres_combo_items = g_list_append (vectorres_combo_items, (gpointer) "320x200");
	vectorres_combo_items = g_list_append (vectorres_combo_items, (gpointer) "640x480");
	vectorres_combo_items = g_list_append (vectorres_combo_items, (gpointer) "800x600");
	vectorres_combo_items = g_list_append (vectorres_combo_items, (gpointer) "1024x768");
	vectorres_combo_items = g_list_append (vectorres_combo_items, (gpointer) "1280x1024");
	vectorres_combo_items = g_list_append (vectorres_combo_items, (gpointer) "1600x1200");
	gtk_combo_set_popdown_strings (GTK_COMBO (vectorres_combo), vectorres_combo_items);
	g_list_free (vectorres_combo_items);

	vectorres_entry = GTK_COMBO (vectorres_combo)->entry;
	gtk_widget_show (vectorres_entry);
	gtk_entry_set_text (GTK_ENTRY (vectorres_entry), "640x480");

/* Open GL */
	gl_vector_frame = options_frame_new (_("OpenGL options"));
	gtk_widget_show (gl_vector_frame);
	gtk_box_pack_start (GTK_BOX (vector_vbox), gl_vector_frame, FALSE, FALSE, 0);
	gl_vector_frame = options_frame_create_child (gl_vector_frame);

	gl_vector_table = gtk_table_new (2, 1, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (gl_vector_table), 6);
	gtk_table_set_col_spacings (GTK_TABLE (gl_vector_table), 6);
	gtk_widget_show (gl_vector_table);
	gtk_container_add (GTK_CONTAINER (gl_vector_frame), gl_vector_table);

	gldrawbitmapvec_checkbutton = gtk_check_button_new_with_label (_("Draw bitmap"));
	gtk_widget_show (gldrawbitmapvec_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (gl_vector_table), gldrawbitmapvec_checkbutton, 0, 1, 0, 1);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gldrawbitmapvec_checkbutton), TRUE);

	glantialiasvec_checkbutton = gtk_check_button_new_with_label (_("Antialiasing"));
	gtk_widget_show (glantialiasvec_checkbutton);
	gtk_table_attach_defaults (GTK_TABLE (gl_vector_table), glantialiasvec_checkbutton, 0, 1, 1, 2);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glantialiasvec_checkbutton), TRUE);

/* End vector options */
	
	if (! (current_exec->type && (XMAME_EXEC_XGL || XMAME_EXEC_X11)))
		gtk_widget_set_sensitive (GTK_WIDGET (gl_vector_frame), FALSE);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (antialias_checkbutton), target->antialias);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (translucency_checkbutton), target->translucency);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (vector_fixed_resolution_checkbutton), target->vectorres_flag);
	gtk_entry_set_text (GTK_ENTRY (vectorres_entry), target->vectorres);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gldrawbitmapvec_checkbutton), target->gldrawbitmapvec);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glantialiasvec_checkbutton), target->glantialiasvec);
	gtk_widget_set_sensitive (GTK_WIDGET (intensity_label),
		xmame_has_option (current_exec, "intensity"));

	gtk_widget_set_sensitive (GTK_WIDGET (intensity_hscale),
		xmame_has_option (current_exec, "intensity"));
	
	g_signal_connect (G_OBJECT (antialias_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (antialias_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (translucency_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (translucency_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment (GTK_RANGE (flicker_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment (GTK_RANGE (flicker_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment (GTK_RANGE (beam_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment (GTK_RANGE (beam_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment (GTK_RANGE (intensity_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment (GTK_RANGE (intensity_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (vector_fixed_resolution_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (vector_fixed_resolution_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (vectorres_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (vectorres_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gldrawbitmapvec_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gldrawbitmapvec_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (glantialiasvec_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glantialiasvec_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
}


void
save_properties_options (RomEntry    *rom,
			 GameOptions *target)
{
	gchar *used_text;
	int i;

	if (!dirty_options_flag)
		return;

	xmame_get_options (current_exec);
	
	if (!target)
		target = &default_options;

/*** Video Related ***/
		
	used_text = gtk_editable_get_chars (GTK_EDITABLE (bpp_combo_entry), 0, -1);
	if (!strcmp (used_text, _("8 bits")))
		target->bpp = 8;
	else if (!strcmp (used_text, _("15 bits")))
		target->bpp = 15;
	else if (!strcmp (used_text, _("16 bits")))
		target->bpp = 16;
	else if (!strcmp (used_text, _("32 bits")))
		target->bpp = 32;
	else
		target->bpp = 0;

	g_free (used_text);
		
	used_text = gtk_editable_get_chars (GTK_EDITABLE (arbheight_entry), 0, -1);
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (arbheight_checkbutton)))	
		target->arbheight = atoi (used_text);
	else
		target->arbheight = 0;
	g_free (used_text);
		
	target->heightscale = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (heightscale_spinbutton));
	target->widthscale = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widthscale_spinbutton));
		
	used_text = gtk_editable_get_chars (GTK_EDITABLE (effect_entry), 0, -1);
	target->effect = xmame_get_option_value_index (current_exec, "effect", used_text);
	g_free (used_text);
		
	target->autodouble = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (autodouble_checkbutton));
	target->dirty = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (dirty_checkbutton));
	target->scanlines = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (scanlines_checkbutton));
		
	used_text = gtk_editable_get_chars (GTK_EDITABLE (frameskippercombo_entry), 0, -1);

	target->frameskipper = xmame_get_option_value_index (current_exec, "frameskipper", used_text);

	if (target->frameskipper < 0)
		target->frameskipper = 0;

	g_free (used_text);
		
	target->throttle = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (throttle_checkbutton));
	target->sleepidle = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (sleepidle_checkbutton));
	target->autoframeskip = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (autoframeskip_checkbutton));
		
	used_text = gtk_editable_get_chars (GTK_EDITABLE (maxautoframeskip_entry), 0, -1);
	target->maxautoframeskip = atoi (used_text);
	g_free (used_text);
		
	used_text = gtk_editable_get_chars (GTK_EDITABLE (frameskip_entry), 0, -1);
	if (!strcmp (used_text, _("Skip 1 of 12 frames")))
		target->frameskip = 1;
	else if (!strcmp (used_text, _("Skip 2 of 12 frames")))
		target->frameskip = 2;
	else if (!strcmp (used_text, _("Skip 3 of 12 frames")))
		target->frameskip = 3;
	else if (!strcmp (used_text, _("Skip 4 of 12 frames")))
		target->frameskip = 4;
	else if (!strcmp (used_text, _("Skip 5 of 12 frames")))
		target->frameskip = 5;
	else if (!strcmp (used_text, _("Skip 6 of 12 frames")))
		target->frameskip = 6;
	else if (!strcmp (used_text, _("Skip 7 of 12 frames")))
		target->frameskip = 7;
	else if (!strcmp (used_text, _("Skip 8 of 12 frames")))
		target->frameskip = 8;
	else if (!strcmp (used_text, _("Skip 9 of 12 frames")))
		target->frameskip = 9;
	else if (!strcmp (used_text, _("Skip 10 of 12 frames")))
		target->frameskip = 10;
	else if (!strcmp (used_text, _("Skip 11 of 12 frames")))
		target->frameskip = 11;
	else
		target->frameskip = 0;
	g_free (used_text);

	/*if (available_options->dos_brightness) */
		target->brightness = gtk_range_get_adjustment (GTK_RANGE (brightness_hscale))->value;
#if 0
	else
	{
		/* percentage converted to dosmame brightness complient 0.5-2.0 range*/
		target->brightness = (gtk_range_get_adjustment (GTK_RANGE (brightness_hscale))->value)* (1.5/100)+0.5;
	}
#endif
	target->gamma_correction = gtk_range_get_adjustment (GTK_RANGE (gamma_hscale))->value;
	target->norotate = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (norotate_checkbutton));

		
	used_text = gtk_editable_get_chars (GTK_EDITABLE (rotation_combo_entry), 0, -1);
	if (!strcmp (used_text, _("Clockwise")))
	{
		target->ror= 1;target->rol = 0;
	}
	else if (!strcmp (used_text, _("Anti-clockwise")))
	{
		target->ror= 0;target->rol = 1;
	}
	else
	{
		target->ror= 0;target->rol = 0;
	}
	g_free (used_text);
				
	target->flipx = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (flipx_checkbutton));
	target->flipy = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (flipy_checkbutton));
		
	/* from misc tab */
	target->artwork = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (artwork_checkbutton));
		

	/* Rendering Options */

	switch (current_exec->type)
	{
		case XMAME_EXEC_X11:
		case XMAME_EXEC_XGL:
			if (xmame_get_option_value_count (current_exec, "video-mode") > 0)
			{
				int value;

				used_text = gtk_editable_get_chars (GTK_EDITABLE (video_mode_combo_entry), 0, -1);
	
				value = xmame_get_option_value_index (current_exec, "video-mode", used_text);

				if (value >= 0)
					target->x11_mode = value;

				g_free (used_text);
			}

			target->cursor = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cursor_checkbutton));
			target->mitshm = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (mitshm_checkbutton));
			target->xvgeom_flag = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (xvgeom_checkbutton));

			used_text = gtk_editable_get_chars (GTK_EDITABLE (xvgeom_entry), 0, -1);
			strncpy (target->geometry, used_text, 9);
			g_free (used_text);

			used_text = gtk_editable_get_chars (GTK_EDITABLE (yuv_entry), 0, -1);

			target->force_yuv = xmame_get_option_value_index (current_exec, "force-yuv", used_text);

			if (target->force_yuv < 0)
				target->force_yuv = 0;
			
			target->fullscreen = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (xvfullscreen_checkbutton));
			target->xsync = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (xsync_checkbutton));
			target->privatecmap = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (privatecmap_checkbutton));
			target->xil = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (xil_checkbutton));
			target->mtxil = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (mtxil_checkbutton));
		
			target->gldblbuffer = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gldblbuffer_checkbutton));
			target->gltexture_size = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (gltexture_size_spinbutton));
			target->glbilinear = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (glbilinear_checkbutton));
			target->glext78 = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (glext78_checkbutton));
			target->glforceblitmode = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (glforceblitmode_checkbutton));
			target->gldrawbitmap = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gldrawbitmap_checkbutton));
			target->glcolormod = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (glcolormod_checkbutton));
			target->glantialias = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (glantialias_checkbutton));
			target->glalphablending = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (glalphablending_checkbutton));
			target->cabview = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cabview_checkbutton));

			used_text = gtk_editable_get_chars (GTK_EDITABLE (cabinet_entry), 0, -1);
			strncpy (target->cabinet, used_text, 20);
			g_free (used_text);
			target->glres_flag = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (glres_checkbutton));

			used_text = gtk_editable_get_chars (GTK_EDITABLE (glres_combo_entry), 0, -1);
			strncpy (target->glres, used_text, 9);
			g_free (used_text);

			used_text = gtk_editable_get_chars (GTK_EDITABLE (gllib_entry), 0, -1);
			strncpy (target->gllibname, used_text, 20);
			g_free (used_text);

			used_text = gtk_editable_get_chars (GTK_EDITABLE (glulib_entry), 0, -1);
			strncpy (target->glulibname, used_text, 20);
			g_free (used_text);
			break;

		case XMAME_EXEC_SDL:
			target->fullscreen = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (fullscreen_checkbutton));
			target->sdl_doublebuf = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (doublebuf_checkbutton));
			target->sdl_auto_mode = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (sdl_modes_checkbutton));
			target->modenumber = 0;
			/* FIXME
			if (current_exec->sdl_modes_hash_table)
			{
				g_hash_table_foreach (current_exec->sdl_modes_hash_table,
		 	         	  (GHFunc)sdl_modes_combo_comp_inv,
						   target);
			} else {*/
				target->modenumber = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (sdl_modes_spinbutton));
			/*}*/	
			break;

		case XMAME_EXEC_XFX:
		case XMAME_EXEC_SVGAFX:
			target->fxgkeepaspect = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (fxgkeepaspect_checkbutton));
			used_text = gtk_editable_get_chars (GTK_EDITABLE (fx_entry), 0, -1);
			strncpy (target->resolution, used_text, 20);
			g_free (used_text);
			break;

		case XMAME_EXEC_PHOTON2:
			target->render_mode = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (render_mode_checkbutton));
			target->phcursor = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (phcursor_checkbutton));
			break;

		case XMAME_EXEC_GGI:
			target->ggilinear = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (ggilinear_checkbutton));
			target->ggi_force_resolution= gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (ggi_force_resolution_checkbutton));
			target->xres = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (ggix_spinbutton));
			target->yres = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (ggiy_spinbutton));
			break;

		case XMAME_EXEC_SVGALIB:
			target->planar = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (planar_checkbutton));
			target->linear = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (linear_checkbutton));
			target->tweak = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (tweaked_mode_checkbutton));
			target->centerx = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (centerx_spinbutton));
			target->centery = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (centery_spinbutton));
			break;

		case XMAME_EXEC_UNKNOWN:
			/* nothing */
			break;
	}
				
/*** Video Mode related ***/
	target->keepaspect = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (keepaspect_checkbutton));
	used_text = gtk_editable_get_chars (GTK_EDITABLE (displayaspectratio_entry), 0, -1);
	target->displayaspectratio = atof (used_text);
	g_free (used_text);
	used_text = gtk_editable_get_chars (GTK_EDITABLE (disable_mode_entry), 0, -1);
	strncpy (target->disablemode, used_text, 14);
	g_free (used_text);
			
/* Sound */
	target->sound = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (sound_checkbutton));
	target->samples = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (samples_checkbutton));
	target->fakesound = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (fakesound_checkbutton));
	used_text = gtk_editable_get_chars (GTK_EDITABLE (samplefreq_entry), 0, -1);
	target->samplefre = atoi (used_text);
	g_free (used_text);
	target->volume = gtk_range_get_adjustment (GTK_RANGE (db_hscale))->value;
	target->bufsize = gtk_range_get_adjustment (GTK_RANGE (bufsize_hscale))->value;
	used_text = gtk_editable_get_chars (GTK_EDITABLE (audiodevice_combo_entry), 0, -1);
	strncpy (target->audiodevice, used_text, 20);
	g_free (used_text);
	used_text = gtk_editable_get_chars (GTK_EDITABLE (mixerdevice_entry), 0, -1);
	strncpy (target->mixerdevice, used_text, 20);
	g_free (used_text);
	used_text = gtk_editable_get_chars (GTK_EDITABLE (dsp_plugin_entry), 0, -1);
	strncpy (target->dsp_plugin, used_text, 20);
	g_free (used_text);
	if (xmame_get_option_value_count (current_exec, "dsp-plugin") > 0)
	{
		const gchar *value;

		used_text = gtk_editable_get_chars (GTK_EDITABLE (dsp_plugin_entry), 0, -1);
		
		value = xmame_get_option_key (current_exec, "dsp-plugin", used_text);

		if (value)
			strncpy (target->dsp_plugin, value, 20);

		g_free (used_text);
	}

	if (xmame_get_option_value_count (current_exec, "sound-mixer-plugin") > 0)
	{
		const gchar *value;

		used_text = gtk_editable_get_chars (GTK_EDITABLE (mixer_plugin_entry), 0, -1);
	
		value = xmame_get_option_key (current_exec, "sound-mixer-plugin", used_text);

		if (value)
			strncpy (target->sound_mixer_plugin, value, 20);

		g_free (used_text);
	}

	used_text = gtk_editable_get_chars (GTK_EDITABLE (soundfile_entry), 0, -1);
	strncpy (target->soundfile, used_text, 50);
	g_free (used_text);
			
	target->timer = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (timer_checkbutton));
	target->artsBufferTime = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (arts_spinbutton));
	target->audio_preferred = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (audio_preferred_checkbutton));
	used_text = gtk_editable_get_chars (GTK_EDITABLE (pcm_entry), 0, -1);
	strncpy (target->alsa_pcm, used_text, 20);
	g_free (used_text);
	target->alsa_buffer = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (alsa_buffer_spinbutton));
	target->alsacard = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (alsacard_spinbutton));
	target->alsadevice = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (alsadevice_spinbutton));
		
/* controllers */
	used_text = gtk_editable_get_chars (GTK_EDITABLE (joytype_combo_entry), 0, -1);
	target->joytype = 0;


	target->joytype = xmame_get_option_value_index (current_exec, "joytype", used_text);
	g_free (used_text);

	target->analogstick = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (analogstick_checkbutton));
	target->hotrod = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (hotrod_checkbutton));
	target->hotrodse = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (hotrodse_checkbutton));
	used_text = gtk_editable_get_chars (GTK_EDITABLE (ctrlr_combo_entry), 0, -1);
	strncpy (target->ctrlr, used_text, 20);
	g_free (used_text);
	target->usbpspad = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (usbpspad_checkbutton));
	target->rapidfire = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (rapidfire_checkbutton));
	target->ugcicoin = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (ugcicoin_checkbutton));
	used_text = gtk_editable_get_chars (GTK_EDITABLE (joydevname_entry), 0, -1);
	strncpy (target->joydevname, used_text, 20);
	g_free (used_text);
	used_text = gtk_editable_get_chars (GTK_EDITABLE (paddevname_entry), 0, -1);
	strncpy (target->paddevname, used_text, 20);
	g_free (used_text);
	used_text = gtk_editable_get_chars (GTK_EDITABLE (x11joyname_entry), 0, -1);
	strncpy (target->x11joyname, used_text, 20);
	g_free (used_text);
/*	used_text = gtk_editable_get_chars (GTK_EDITABLE (XInput_joystick1_entry), 0, -1);
	strncpy (target->XInput_joystick1, used_text, 20);
	g_free (used_text);
	used_text = gtk_editable_get_chars (GTK_EDITABLE (XInput_joystick2_entry), 0, -1);
	strncpy (target->XInput_joystick2, used_text, 20);
	g_free (used_text);
	used_text = gtk_editable_get_chars (GTK_EDITABLE (XInput_joystick3_entry), 0, -1);
	strncpy (target->XInput_joystick3, used_text, 20);
	g_free (used_text);
	used_text = gtk_editable_get_chars (GTK_EDITABLE (XInput_joystick4_entry), 0, -1);
	strncpy (target->XInput_joystick4, used_text, 20);
	g_free (used_text);*/
	target->mouse = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (mouse_checkbutton));
	target->grabmouse = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (grabmouse_checkbutton));
	used_text = gtk_editable_get_chars (GTK_EDITABLE (XInput_trackball1_entry), 0, -1);
	strncpy (target->XInput_trackball1, used_text, 20);
	g_free (used_text);
	used_text = gtk_editable_get_chars (GTK_EDITABLE (XInput_trackball2_entry), 0, -1);
	strncpy (target->XInput_trackball2, used_text, 20);
	g_free (used_text);
	used_text = gtk_editable_get_chars (GTK_EDITABLE (XInput_trackball3_entry), 0, -1);
	strncpy (target->XInput_trackball3, used_text, 20);
	g_free (used_text);
	used_text = gtk_editable_get_chars (GTK_EDITABLE (XInput_trackball4_entry), 0, -1);
	strncpy (target->XInput_trackball4, used_text, 20);
	g_free (used_text);
	target->winkeys = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (winkeys_checkbutton));
	target->grabkeyboard = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (grabkeyboard_checkbutton));

	used_text = gtk_editable_get_chars (GTK_EDITABLE (keymaptype_combo_entry), 0, -1);
	for (i=0;x11_keymaps_layout[i].shortname;i++)
	 {
	   if (strcmp (_(x11_keymaps_layout[i].name), used_text)==0)
	     strncpy (target->keymap, x11_keymaps_layout[i].shortname, 4);
	 }
	g_free (used_text);

				
/* vector */
	if (rom)
	{
		if (rom->vector)
		{
			target->antialias = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (antialias_checkbutton));
			target->translucency = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (translucency_checkbutton));
			target->beam = gtk_range_get_adjustment (GTK_RANGE (beam_hscale))->value;
			target->flicker = gtk_range_get_adjustment (GTK_RANGE (flicker_hscale))->value;
			target->intensity = gtk_range_get_adjustment (GTK_RANGE (intensity_hscale))->value;
			target->vectorres_flag = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (vector_fixed_resolution_checkbutton));
			used_text = gtk_editable_get_chars (GTK_EDITABLE (vectorres_entry), 0, -1);
			strncpy (target->vectorres, used_text, 9);
			g_free (used_text);
			/* (open gl) */
			target->gldrawbitmapvec = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gldrawbitmapvec_checkbutton));
			target->glantialiasvec = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (glantialiasvec_checkbutton));
		}
	}
	else
	{
		target->antialias = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (antialias_checkbutton));
		target->translucency = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (translucency_checkbutton));
		target->beam = gtk_range_get_adjustment (GTK_RANGE (beam_hscale))->value;
		target->flicker = gtk_range_get_adjustment (GTK_RANGE (flicker_hscale))->value;
		target->intensity = gtk_range_get_adjustment (GTK_RANGE (intensity_hscale))->value;
		target->vectorres_flag = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (vector_fixed_resolution_checkbutton));
		used_text = gtk_editable_get_chars (GTK_EDITABLE (vectorres_entry), 0, -1);
		strncpy (target->vectorres, used_text, 9);
		g_free (used_text);
		/* (open gl) */
		target->gldrawbitmapvec = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gldrawbitmapvec_checkbutton));
		target->glantialiasvec = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (glantialiasvec_checkbutton));
	}
			
		
/* misc */
	/*artwork*/
	target->artwork = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (artwork_checkbutton));
	target->use_backdrops = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (use_backdrops_checkbutton));
	target->use_bezels = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (use_bezels_checkbutton));
	target->use_overlays = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (use_overlays_checkbutton));
	used_text = gtk_editable_get_chars (GTK_EDITABLE (artwork_resolution_combo_entry), 0, -1);
	if (!strcmp (used_text, _("Standard")))
		target->artwork_resolution = 1;
	else if (!strcmp (used_text, _("High")))
		target->artwork_resolution = 2;
	else
		target->artwork_resolution = 0;
	g_free (used_text);
	target->artwork_crop = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (artcrop_checkbutton));
	/* misc */
	target->keyboard_leds = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (keyboard_leds_checkbutton));
	target->cheat = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cheat_checkbutton));
	target->debug = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (debug_checkbutton));
	target->skip_disclaimer = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (disclaimer_checkbutton));
	target->skip_gameinfo = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gameinfo_checkbutton));
	used_text = gtk_editable_get_chars (GTK_EDITABLE (debug_size_combo_entry), 0, -1);
	strncpy (target->debug_size, used_text, 20);
	g_free (used_text);
	target->use_additional_options = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (additional_options_checkbutton));
	/* here I'm using directly the additional option because I don't know its length */
	g_free (target->additional_options);
	target->additional_options = gtk_editable_get_chars (GTK_EDITABLE (additional_options_entry), 0, -1);
	target->log_flag = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (log_flag_checkbutton));
	used_text = gtk_editable_get_chars (GTK_EDITABLE (log_entry), 0, -1);
	strncpy (target->log, used_text, 20);
	g_free (used_text);
	target->cfgname_flag = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (config_name_checkbutton));
	used_text = gtk_editable_get_chars (GTK_EDITABLE (config_name_entry), 0, -1);
	strncpy (target->cfgname, used_text, 20);
	g_free (used_text);
		
	used_text = gtk_editable_get_chars (GTK_EDITABLE (bios_combo_entry), 0, -1);
	i=0;
	do {
		if (strcmp (_(bios_version[i]), used_text) == 0)
			target->bios = i;
		i++;
	} while (bios_version[i]);
	g_free (used_text);
		
	dirty_options_flag = FALSE;
}

void
load_properties_options (RomEntry  *rom,
			 GtkWidget *properties_window)
{
	gchar title[BUFFER_SIZE];
	gchar *used_text;
	const gchar *tmp_text;
	GameOptions *target = NULL;
	int i;

	xmame_get_options (current_exec);

	if (rom)
		target = load_options (rom);
	
	if (!target)
		target = &default_options;
	
	g_object_set_data (G_OBJECT (properties_window), "opts", target);

	/***********/
	/* Display */
	/***********/	
	{
		const gchar *effect_name;

		effect_name = xmame_get_option_value (current_exec, "effect", target->effect);

		gtk_entry_set_text (GTK_ENTRY (effect_entry), effect_name?effect_name:"");
	}		
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (scanlines_checkbutton), target->scanlines);

	gtk_adjustment_set_value (GTK_ADJUSTMENT (gamma_hscale_adj) , target->gamma_correction);

	/* FIXME */
	/*if (available_options->dos_brightness)*/
		gtk_adjustment_set_value (GTK_ADJUSTMENT (brightness_hscale_adj) , target->brightness);
	/*else
		gtk_adjustment_set_value (GTK_ADJUSTMENT (brightness_hscale_adj) , ( (target->brightness)-0.5)* (100/1.5));*/

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (dirty_checkbutton), target->dirty);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (throttle_checkbutton), target->throttle);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sleepidle_checkbutton), target->sleepidle);


	if (target->frameskip == 0 || target->frameskip > 11)
		g_snprintf (title, BUFFER_SIZE, "%s", _("Draw every frame"));
	else
		g_snprintf (title, BUFFER_SIZE, _("Skip %i of 12 frames"), target->frameskip);

	gtk_entry_set_text (GTK_ENTRY (frameskip_entry), title);
	gtk_widget_set_sensitive (frameskip_combo, ! (target->autoframeskip));


	tmp_text = xmame_get_option_value (current_exec, "frameskipper", target->frameskip);

	if (tmp_text)
		gtk_entry_set_text (GTK_ENTRY (frameskippercombo_entry), tmp_text);
	else
		gtk_entry_set_text (GTK_ENTRY (frameskippercombo_entry), _("Not available"));

	gtk_widget_set_sensitive (frameskipper_combo, target->autoframeskip);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (autoframeskip_checkbutton), target->autoframeskip);

	g_snprintf (title, BUFFER_SIZE, "%i", target->maxautoframeskip);
	gtk_entry_set_text (GTK_ENTRY (maxautoframeskip_entry), title);
	gtk_widget_set_sensitive (maxautoframeskip_combo, target->autoframeskip);

	gtk_adjustment_set_value (GTK_ADJUSTMENT (heightscale_spinbutton_adj), target->heightscale);

	switch (target->bpp)
	{
		case 8:
		case 15:
		case 16:
		case 32:
			g_snprintf (title, BUFFER_SIZE, _("%i bits"), target->bpp);
			break;
		default:
			g_snprintf (title, BUFFER_SIZE, "%s", _("Auto"));
			break;
	}
	gtk_entry_set_text (GTK_ENTRY (bpp_combo_entry), title);
	gtk_adjustment_set_value (GTK_ADJUSTMENT (widthscale_spinbutton_adj) , target->widthscale);

	g_snprintf (title, BUFFER_SIZE, "%i", target->arbheight);
	gtk_entry_set_text (GTK_ENTRY (arbheight_entry), title);
	gtk_widget_set_sensitive (arbheight_entry, target->arbheight);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (arbheight_checkbutton), target->arbheight);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (autodouble_checkbutton), target->autodouble);

	if (target->ror)
		g_snprintf (title, BUFFER_SIZE, "%s", _("Clockwise"));
	else if (target->rol)
		g_snprintf (title, BUFFER_SIZE, "%s", _("Anti-clockwise"));
	else
		g_snprintf (title, BUFFER_SIZE, "%s", _("None"));
	gtk_entry_set_text (GTK_ENTRY (rotation_combo_entry), title);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (norotate_checkbutton), target->norotate);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (flipx_checkbutton), target->flipx);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (flipy_checkbutton), target->flipy);

	/*************/
	/* Rendering */
	/*************/

	switch (current_exec->type)
	{
		case XMAME_EXEC_X11: /* X11 */
		case XMAME_EXEC_XGL: /* Open GL */
			{
				const gchar *video_mode;
				video_mode = xmame_get_option_value (current_exec, "video-mode", target->x11_mode);

				gtk_entry_set_text (GTK_ENTRY (video_mode_combo_entry), video_mode?video_mode:"");
			}

			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cursor_checkbutton), target->cursor);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (mitshm_checkbutton), target->mitshm);
			gtk_widget_set_sensitive (GTK_WIDGET (mitshm_checkbutton),
				xmame_has_option (current_exec, "mitshm"));

			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (xvgeom_checkbutton), target->xvgeom_flag);
			gtk_entry_set_text (GTK_ENTRY (xvgeom_entry), target->geometry);

			gtk_widget_set_sensitive (GTK_WIDGET (xvgeom_combo), target->xvgeom_flag /*&&
								available_options.xvext
								available_options.mitshm &&
								target->mitshm &&
								target->xvext &&
								*/);


			{
				const gchar *yuv_mode;

				yuv_mode = xmame_get_option_value (current_exec, "force-yuv", target->force_yuv);

				if (yuv_mode)
					gtk_entry_set_text (GTK_ENTRY (yuv_entry), yuv_mode);
				else
					gtk_entry_set_text (GTK_ENTRY (yuv_entry), _("Not Available"));
			}

			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (xvfullscreen_checkbutton), target->fullscreen);
			gtk_widget_set_sensitive (GTK_WIDGET (xvfullscreen_checkbutton),
				xmame_has_option (current_exec, "fullscreen"));

			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (xsync_checkbutton), target->xsync);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (privatecmap_checkbutton), target->privatecmap);

			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (xil_checkbutton), target->xil);
			gtk_widget_set_sensitive (GTK_WIDGET (xil_checkbutton), 
				xmame_has_option (current_exec, "xil"));
			
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (mtxil_checkbutton), target->mtxil);
			gtk_widget_set_sensitive (GTK_WIDGET (mtxil_checkbutton),
				xmame_has_option (current_exec, "mtxil"));
		
			/* Open GL */
			gtk_adjustment_set_value (GTK_ADJUSTMENT (sdl_modes_spinbutton_adj) , target->modenumber);
			gtk_adjustment_set_value (GTK_ADJUSTMENT (gltexture_size_spinbutton_adj) , target->gltexture_size);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gldblbuffer_checkbutton), target->gldblbuffer);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glbilinear_checkbutton), target->glbilinear);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glext78_checkbutton), target->glext78);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glforceblitmode_checkbutton), target->glforceblitmode);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gldrawbitmap_checkbutton), target->gldrawbitmap);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glcolormod_checkbutton), target->glcolormod);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glantialias_checkbutton), target->glantialias);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glalphablending_checkbutton), target->glalphablending);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cabview_checkbutton), target->cabview);
			gtk_widget_set_sensitive (GTK_WIDGET (cabinet_entry), target->cabview);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glres_checkbutton), target->glres_flag);
			gtk_entry_set_text (GTK_ENTRY (cabinet_entry), target->cabinet);
			gtk_widget_set_sensitive (GTK_WIDGET (glres_combo), target->glres_flag);
			gtk_entry_set_text (GTK_ENTRY (gllib_entry), target->gllibname);
			gtk_entry_set_text (GTK_ENTRY (glulib_entry), target->glulibname);
			break;

		case XMAME_EXEC_SDL:	/* SDL */
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (fullscreen_checkbutton), target->fullscreen);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (doublebuf_checkbutton), target->sdl_doublebuf);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sdl_modes_checkbutton), (target->sdl_auto_mode));
			if (xmame_get_option_value_count (current_exec, "modenumber") > 0)
			{
				gtk_widget_set_sensitive (GTK_WIDGET (sdl_modes_combo), ! (target->sdl_auto_mode));
			}
			else
			{
				gtk_widget_set_sensitive (GTK_WIDGET (sdl_modes_spinbutton), ! (target->sdl_auto_mode));
			}
			break;

		case XMAME_EXEC_XFX:
		case XMAME_EXEC_SVGAFX:	/* FX Glide */
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (fxgkeepaspect_checkbutton), target->fxgkeepaspect);
			gtk_entry_set_text (GTK_ENTRY (fx_entry), target->resolution);
			gtk_widget_set_sensitive (GTK_WIDGET (sdl_modes_label), ! (target->sdl_auto_mode));
			break;

		case XMAME_EXEC_PHOTON2: /* Photon 2 */
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (render_mode_checkbutton), target->render_mode);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (phcursor_checkbutton), ! (target->phcursor));
			break;

		case XMAME_EXEC_GGI:
			gtk_adjustment_set_value (GTK_ADJUSTMENT (ggix_spinbutton_adj), target->xres);
			gtk_adjustment_set_value (GTK_ADJUSTMENT (ggiy_spinbutton_adj), target->yres);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ggilinear_checkbutton), target->ggilinear);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ggi_force_resolution_checkbutton), target->ggi_force_resolution);
			gtk_widget_set_sensitive (GTK_WIDGET (ggi_res_table), target->ggi_force_resolution);
			break;

		case XMAME_EXEC_SVGALIB:
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (planar_checkbutton), target->planar);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (linear_checkbutton), target->linear);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (tweaked_mode_checkbutton), target->tweak);
			gtk_widget_set_sensitive (GTK_WIDGET (svga_tweak_table), target->tweak);
			gtk_adjustment_set_value (GTK_ADJUSTMENT (centerx_spinbutton_adj), target->centerx);
			gtk_adjustment_set_value (GTK_ADJUSTMENT (centery_spinbutton_adj), target->centery);
			break;
		case XMAME_EXEC_UNKNOWN:
			/* do nothing */
			break;
	}

	/*** Video Mode related ***/
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (keepaspect_checkbutton), target->keepaspect);
	gtk_widget_set_sensitive (GTK_WIDGET (displayaspectratio_entry), (target->keepaspect));
	used_text = g_strdup_printf ("%f", target->displayaspectratio);
	gtk_entry_set_text (GTK_ENTRY (displayaspectratio_entry), used_text);
	g_free (used_text);
	gtk_entry_set_text (GTK_ENTRY (disable_mode_entry), target->disablemode);

	/*********/
	/* Sound */
	/*********/

	gtk_adjustment_set_value (GTK_ADJUSTMENT (db_hscale_adj), target->volume);
	gtk_adjustment_set_value (GTK_ADJUSTMENT (bufsize_hscale_adj), target->bufsize);

	gtk_adjustment_set_value (GTK_ADJUSTMENT (arts_spinbutton_adj), target->artsBufferTime);
	gtk_adjustment_set_value (GTK_ADJUSTMENT (alsa_buffer_spinbutton_adj), target->alsa_buffer);
	gtk_adjustment_set_value (GTK_ADJUSTMENT (alsacard_spinbutton_adj), target->alsacard);
	gtk_adjustment_set_value (GTK_ADJUSTMENT (alsadevice_spinbutton_adj), target->alsadevice);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sound_checkbutton), target->sound);
	gtk_widget_set_sensitive (GTK_WIDGET (samples_checkbutton), target->sound);
	gtk_widget_set_sensitive (GTK_WIDGET (volume_frame), target->sound);
	gtk_widget_set_sensitive (GTK_WIDGET (bufsize_frame), target->sound);
	gtk_widget_set_sensitive (GTK_WIDGET (samplefreq_combo), target->sound);
	gtk_widget_set_sensitive (GTK_WIDGET (audiodevice_label), target->sound);
	gtk_widget_set_sensitive (GTK_WIDGET (samplefreq_label), target->sound);
	gtk_widget_set_sensitive (GTK_WIDGET (mixerdevice_label), target->sound);
	gtk_widget_set_sensitive (GTK_WIDGET (audiodevice_combo), target->sound);
	gtk_widget_set_sensitive (GTK_WIDGET (mixerdevice_combo), target->sound);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (samples_checkbutton), target->samples);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (fakesound_checkbutton), target->fakesound);
	used_text = g_strdup_printf ("%i", target->samplefre);
	gtk_entry_set_text (GTK_ENTRY (samplefreq_entry), used_text);
	gtk_entry_set_text (GTK_ENTRY (audiodevice_combo_entry), target->audiodevice);
	gtk_entry_set_text (GTK_ENTRY (mixerdevice_entry), target->mixerdevice);

	gtk_entry_set_text (GTK_ENTRY (soundfile_entry), target->soundfile);
	if (!strcmp (target->dsp_plugin, "waveout"))
	{
		gtk_widget_set_sensitive (GTK_WIDGET (soundfile_hbox), TRUE);
		gtk_widget_set_sensitive (GTK_WIDGET (audiodevice_hbox), FALSE);
	}
	else
	{
		gtk_widget_set_sensitive (GTK_WIDGET (soundfile_hbox), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (audiodevice_hbox), TRUE);
	}

	{
		const gchar *dsp;
		dsp = xmame_get_option_key_value (current_exec, "dsp-plugin", target->dsp_plugin);

		gtk_entry_set_text (GTK_ENTRY (dsp_plugin_entry), dsp?dsp:target->dsp_plugin);
	}

	{
		const gchar *mixer;
		mixer = xmame_get_option_key_value (current_exec, "sound-mixer-plugin", target->sound_mixer_plugin);

		gtk_entry_set_text (GTK_ENTRY (mixer_plugin_entry), mixer?mixer:target->sound_mixer_plugin);
	}
	
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (timer_checkbutton), target->timer);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (audio_preferred_checkbutton), target->audio_preferred);
	gtk_entry_set_text (GTK_ENTRY (pcm_entry), target->alsa_pcm);

	gtk_widget_set_sensitive (GTK_WIDGET (qnx_frame), xmame_has_option (current_exec, "audio_preferred"));
	gtk_widget_set_sensitive (GTK_WIDGET (alsa_frame), xmame_get_option_key_value (current_exec, "dsp-plugin", "alsa") != NULL);

	{
	gboolean has_arts;

	has_arts = 
		 (xmame_get_option_key_value (current_exec, "dsp-plugin", "arts") != NULL) ||
		 (xmame_get_option_key_value (current_exec, "dsp-plugin", "arts_smotek") != NULL) ||		
		 (xmame_get_option_key_value (current_exec, "dsp-plugin", "arts_teira") != NULL);

	gtk_widget_set_sensitive (GTK_WIDGET (arts_frame), has_arts);
	}
	gtk_widget_set_sensitive (GTK_WIDGET (alsacard_label), xmame_has_option (current_exec, "alsacard"));
	gtk_widget_set_sensitive (GTK_WIDGET (alsacard_spinbutton), xmame_has_option (current_exec, "alsacard"));
	gtk_widget_set_sensitive (GTK_WIDGET (alsadevice_label), xmame_has_option (current_exec, "alsadevice"));
	gtk_widget_set_sensitive (GTK_WIDGET (alsadevice_spinbutton), xmame_has_option (current_exec, "alsadevice"));
	gtk_widget_set_sensitive (GTK_WIDGET (alsa_buffer_label), xmame_has_option (current_exec, "alsa-buffer"));
	gtk_widget_set_sensitive (GTK_WIDGET (alsa_buffer_spinbutton), xmame_has_option (current_exec, "alsa-buffer"));
	gtk_widget_set_sensitive (GTK_WIDGET (PCM_label), xmame_has_option (current_exec, "alsa-pcm"));
	gtk_widget_set_sensitive (GTK_WIDGET (pcm_entry), xmame_has_option (current_exec, "alsa-pcm"));

	/**************/
	/* Controller */
	/**************/

	gtk_widget_set_sensitive (paddevname_label, FALSE);
	gtk_widget_set_sensitive (paddevname_entry, FALSE);
	gtk_widget_set_sensitive (x11joyname_label, FALSE);
	gtk_widget_set_sensitive (x11joyname_entry, FALSE);
	gtk_widget_set_sensitive (joydevname_label, FALSE);
	gtk_widget_set_sensitive (joydevname_entry, FALSE);
	gtk_widget_set_sensitive (hotrod_checkbutton, FALSE);
	gtk_widget_set_sensitive (hotrodse_checkbutton, FALSE);
	switch (target->joytype)
	{
		case 0:
			gtk_widget_set_sensitive (analogstick_checkbutton, FALSE);
			gtk_widget_set_sensitive (hotrod_checkbutton, TRUE);
			gtk_widget_set_sensitive (hotrodse_checkbutton, TRUE);
			gtk_widget_set_sensitive (usbpspad_checkbutton, FALSE);
			gtk_widget_set_sensitive (rapidfire_checkbutton, FALSE);
			break;
		case 1:
			gtk_widget_set_sensitive (joydevname_label, TRUE);
			gtk_widget_set_sensitive (joydevname_entry, TRUE);
			break;
		case 2:
			gtk_widget_set_sensitive (paddevname_label, TRUE);
			gtk_widget_set_sensitive (paddevname_entry, TRUE);
			break;
		case 3:
			gtk_widget_set_sensitive (x11joyname_label, TRUE);
			gtk_widget_set_sensitive (x11joyname_entry, TRUE);
			break;
		case 4:
			gtk_widget_set_sensitive (joydevname_label, TRUE);
			gtk_widget_set_sensitive (joydevname_entry, TRUE);
			break;
	}

	if (target->joytype > 7)
		target->joytype = 0;

	{
		const gchar *joyname;

		joyname = xmame_get_option_value (current_exec, "joytype", target->joytype);

		gtk_entry_set_text (GTK_ENTRY (joytype_combo_entry), joyname?joyname:"No joystick");
	}

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (analogstick_checkbutton), target->analogstick);
	gtk_entry_set_text (GTK_ENTRY (ctrlr_combo_entry), target->ctrlr);
	gtk_widget_set_sensitive (GTK_WIDGET (ctrlr_combo), xmame_has_option (current_exec, "ctrlr"));
	gtk_widget_set_sensitive (hotrod_checkbutton, xmame_has_option (current_exec, "hotrod"));
	gtk_widget_set_sensitive (hotrodse_checkbutton, xmame_has_option (current_exec, "hotrodse"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (hotrod_checkbutton), target->hotrod);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (hotrodse_checkbutton), target->hotrodse);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (usbpspad_checkbutton), target->usbpspad);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rapidfire_checkbutton), target->rapidfire);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ugcicoin_checkbutton), target->ugcicoin);
	gtk_entry_set_text (GTK_ENTRY (joydevname_entry), target->joydevname);
	gtk_entry_set_text (GTK_ENTRY (paddevname_entry), target->paddevname);
	gtk_entry_set_text (GTK_ENTRY (x11joyname_entry), target->x11joyname);
/*	gtk_entry_set_text (GTK_ENTRY (XInput_joystick1_entry), target->XInput_joystick1);
	gtk_entry_set_text (GTK_ENTRY (XInput_joystick2_entry), target->XInput_joystick2);
	gtk_entry_set_text (GTK_ENTRY (XInput_joystick3_entry), target->XInput_joystick3);
	gtk_entry_set_text (GTK_ENTRY (XInput_joystick4_entry), target->XInput_joystick4);*/
	gtk_widget_set_sensitive (GTK_WIDGET (Xinput_joy_frame), FALSE);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (mouse_checkbutton), target->mouse);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (grabmouse_checkbutton), target->grabmouse);
	gtk_widget_set_sensitive (GTK_WIDGET (grabmouse_checkbutton), target->mouse && xmame_has_option (current_exec, "grabmouse"));
	gtk_entry_set_text (GTK_ENTRY (XInput_trackball1_entry), target->XInput_trackball1);
	gtk_entry_set_text (GTK_ENTRY (XInput_trackball2_entry), target->XInput_trackball2);
	gtk_entry_set_text (GTK_ENTRY (XInput_trackball3_entry), target->XInput_trackball3);
	gtk_entry_set_text (GTK_ENTRY (XInput_trackball4_entry), target->XInput_trackball4);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (grabkeyboard_checkbutton), target->grabkeyboard);
	gtk_widget_set_sensitive (GTK_WIDGET (grabkeyboard_checkbutton), xmame_has_option (current_exec, "grabkeyboard"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (winkeys_checkbutton), target->winkeys);
	gtk_widget_set_sensitive (GTK_WIDGET (config_name_checkbutton), 
		xmame_has_option (current_exec, "cfgname") || xmame_has_option (current_exec, "cfg_directory"));

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (config_name_checkbutton), target->cfgname_flag);
	gtk_widget_set_sensitive (GTK_WIDGET (config_name_entry), 
		target->cfgname_flag && 
			 (xmame_has_option (current_exec, "cfgname") || xmame_has_option (current_exec, "cfg_directory")));

	gtk_entry_set_text (GTK_ENTRY (config_name_entry), target->cfgname);

	for (i=0;x11_keymaps_layout[i].shortname;i++)
	{
		if (strcmp (x11_keymaps_layout[i].shortname, target->keymap) == 0)
			gtk_entry_set_text (GTK_ENTRY (keymaptype_combo_entry), _(x11_keymaps_layout[i].name));
	}

	/********/
	/* Misc */
	/********/

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (artwork_checkbutton), target->artwork);
	/* the use_backdrops option will be used for all new backdrop option maybe change after */

	gtk_widget_set_sensitive (GTK_WIDGET (use_backdrops_checkbutton), xmame_has_option (current_exec, "use_backdrops") && target->artwork);
	gtk_widget_set_sensitive (GTK_WIDGET (use_bezels_checkbutton), xmame_has_option (current_exec, "use_backdrops") && target->artwork);
	gtk_widget_set_sensitive (GTK_WIDGET (use_overlays_checkbutton), xmame_has_option (current_exec, "use_backdrops") && target->artwork);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (use_backdrops_checkbutton), target->use_backdrops);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (use_bezels_checkbutton), target->use_bezels);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (use_overlays_checkbutton), target->use_overlays);
	switch (target->artwork_resolution) {
	case (0):
		g_snprintf (title, BUFFER_SIZE, "%s", _("Auto"));
		break;
	case (1):
		g_snprintf (title, BUFFER_SIZE, "%s", _("Standard"));
		break;
	case (2):
		g_snprintf (title, BUFFER_SIZE, "%s", _("High"));
		break;
	}
	gtk_entry_set_text (GTK_ENTRY (artwork_resolution_combo_entry), title);
	gtk_widget_set_sensitive (GTK_WIDGET (artwork_resolution_combo), 
				  xmame_has_option (current_exec, "artwork_resolution") && target->artwork);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (artcrop_checkbutton), target->artwork_crop);

	gtk_widget_set_sensitive (GTK_WIDGET (artcrop_checkbutton), xmame_has_option (current_exec, "artwork_crop") && target->artwork);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (keyboard_leds_checkbutton), target->keyboard_leds);
	gtk_widget_set_sensitive (GTK_WIDGET (keyboard_leds_checkbutton), xmame_has_option (current_exec, "keyboard_leds"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cheat_checkbutton), target->cheat);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (disclaimer_checkbutton), target->skip_disclaimer);
	gtk_widget_set_sensitive (GTK_WIDGET (disclaimer_checkbutton), xmame_has_option (current_exec, "skip_disclaimer"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gameinfo_checkbutton), target->skip_gameinfo);
	gtk_widget_set_sensitive (GTK_WIDGET (gameinfo_checkbutton), xmame_has_option (current_exec, "skip_gameinfo"));
	gtk_widget_set_sensitive (GTK_WIDGET (bios_label), xmame_has_option (current_exec, "bios"));
	gtk_widget_set_sensitive (GTK_WIDGET (bios_combo), xmame_has_option (current_exec, "bios"));
	i=0;
	do {
		if (i == target->bios)
			gtk_entry_set_text (GTK_ENTRY (bios_combo_entry), _(bios_version[i]));
		i++;
	} while (bios_version[i]);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (debug_checkbutton), target->debug);
	gtk_widget_set_sensitive (GTK_WIDGET (debug_checkbutton), xmame_has_option (current_exec, "debug"));
	gtk_widget_set_sensitive (GTK_WIDGET (debug_size_label), xmame_has_option (current_exec, "debug") && target->debug);
	gtk_widget_set_sensitive (GTK_WIDGET (debug_size_combo), xmame_has_option (current_exec, "debug") && target->debug);
	gtk_entry_set_text (GTK_ENTRY (debug_size_combo_entry), target->debug_size);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (additional_options_checkbutton), target->use_additional_options);
	gtk_widget_set_sensitive (GTK_WIDGET (additional_options_entry), target->use_additional_options);
	gtk_entry_set_text (GTK_ENTRY (additional_options_entry), target->additional_options);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (log_flag_checkbutton), target->log_flag);
	gtk_widget_set_sensitive (GTK_WIDGET (log_label), target->log_flag);
	gtk_widget_set_sensitive (GTK_WIDGET (log_entry), target->log_flag);
	gtk_entry_set_text (GTK_ENTRY (log_entry), target->log);
	
	dirty_options_flag = FALSE;
}
