/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*
 * GXMame
 *
 * Copyright 2002-2004 Stephane Pontier <shadow_walker@users.sourceforge.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "common.h"

#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtkcellrenderertext.h>
#include <gtk/gtkeditable.h>
#include <gtk/gtkentry.h>
#include <gtk/gtkfilechooserdialog.h>
#include <gtk/gtkhseparator.h>
#include <gtk/gtklabel.h>
#include <gtk/gtknotebook.h>
#include <gtk/gtkscrolledwindow.h>
#include <gtk/gtkstock.h>
#include <gtk/gtktable.h>
#include <gtk/gtkvbox.h>

#include "gui.h"
#include "directories.h"
#include "io.h"
#include "game_options.h"

static void
on_dir_browse_button_clicked        (GtkButton       *button,
                                        gpointer         user_data);

static void
on_file_browse_button_clicked       (GtkButton       *button,
                                        gpointer         user_data);

static void
on_samples_add_button_clicked          (GtkButton       *button,
                                        gpointer         user_data);

static void
on_samples_remove_button_clicked       (GtkButton       *button,
                                        gpointer         user_data);

static void
on_roms_add_button_clicked             (GtkButton       *button,
                                        gpointer         user_data);

static void
on_roms_remove_button_clicked          (GtkButton       *button,
                                        gpointer         user_data);

static void
on_xmame_execs_add_button_clicked             (GtkButton       *button,
                                        gpointer         user_data);

static void
on_xmame_execs_remove_button_clicked          (GtkButton       *button,
					       gpointer         user_data);

static void
directories_selection_close_window       (GtkWidget *widget);

static void
directories_selection_save_changes       (GtkWidget *widget);

static void
directories_selection_save_and_close     (GtkWidget *widget);

static void
on_xmame_execs_tree_view_select          (GtkTreeSelection *selection, gpointer data);

static void
on_roms_path_tree_view_select            (GtkTreeSelection *selection, gpointer data);

static void
on_samples_path_tree_view_select         (GtkTreeSelection *selection, gpointer data);


static GtkWidget *directories_selection;

static GtkWidget *xmame_execs_entry;
static GtkTreeView *xmame_execs_tree_view;
static GtkTreeModel *xmame_execs_tree_model;

static GtkWidget *roms_path_entry;
static GtkTreeView *roms_path_tree_view;
static GtkTreeModel *roms_path_tree_model;

static GtkWidget *samples_path_entry;
static GtkTreeView *samples_path_tree_view;
static GtkTreeModel *samples_path_tree_model;

static GtkWidget *cfg_directory_entry;
static GtkWidget *nvram_directory_entry;
static GtkWidget *memcard_directory_entry;
static GtkWidget *state_directory_entry;
static GtkWidget *ctrlr_directory_entry;
static GtkWidget *inipath_entry;
static GtkWidget *diffdir_path_entry;

static GtkWidget *snapshot_path_entry;
static GtkWidget *artwork_path_entry;
static GtkWidget *input_path_entry;
static GtkWidget *cheatfile_path_entry;
static GtkWidget *hiscorefile_path_entry;
static GtkWidget *historyfile_path_entry;
static GtkWidget *mameinfofile_path_entry;
static GtkWidget *hiscore_path_entry;

static GtkWidget *common_path_entry;
static GtkWidget *flyer_path_entry;
static GtkWidget *cabinet_path_entry;
static GtkWidget *marquee_path_entry;
static GtkWidget *title_path_entry;
static GtkWidget *icons_path_entry;

static GtkWidget *directories_selection_apply_button;

/* gboolean refresh_game_list; */


static GtkWidget *
options_frame_new (const char *text)
{
	PangoFontDescription *font_desc;
	GtkWidget *label;
	GtkWidget *frame = gtk_frame_new (text);

	gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_NONE);

	label = gtk_frame_get_label_widget (GTK_FRAME (frame));

	font_desc = pango_font_description_new ();
	pango_font_description_set_weight (font_desc,
					   PANGO_WEIGHT_BOLD);
	gtk_widget_modify_font (label, font_desc);
	pango_font_description_free (font_desc);

	return frame;
}

static GtkWidget *
options_frame_create_child (GtkWidget *widget)
{
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *label;

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (widget), hbox);
	gtk_widget_show (hbox);

	label = gtk_label_new ("    ");
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	gtk_widget_show (label);

	vbox = gtk_vbox_new (FALSE, 6);
	gtk_box_pack_start (GTK_BOX (hbox), vbox, TRUE, TRUE, 0);
	gtk_widget_show (vbox);

	return vbox;
}

void
create_folderselection (gpointer current_entry,
			gboolean select_dir)
{
	GtkWidget *filechooser;
	gchar *temp_text;

	if (select_dir) {
		filechooser = gtk_file_chooser_dialog_new (_("Browse for Folder"),
							   GTK_WINDOW (directories_selection),
							   GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
							   GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
							   GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
							   NULL);
	} else {
		filechooser = gtk_file_chooser_dialog_new (_("Browse for File"),
							   GTK_WINDOW (directories_selection),
							   GTK_FILE_CHOOSER_ACTION_OPEN,
							   GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
							   GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
							   NULL);
	}
         
	temp_text = gtk_editable_get_chars (GTK_EDITABLE (current_entry), 0, -1);      
	gtk_file_chooser_set_filename (GTK_FILE_CHOOSER (filechooser), temp_text);    
	g_free (temp_text);
	if (gtk_dialog_run (GTK_DIALOG (filechooser)) == GTK_RESPONSE_ACCEPT) {
		GXMAME_DEBUG ("selected: {%s}", gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (filechooser)));
		gtk_entry_set_text (GTK_ENTRY (current_entry), gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (filechooser)));
	}
	gtk_widget_destroy (filechooser);
}

static void
directories_selection_response (GtkWidget *dialog,
				gint       response_id,
				gpointer   user_data)
{
	switch (response_id) {
	case GTK_RESPONSE_OK:
		directories_selection_save_and_close (dialog);
		break;
	case GTK_RESPONSE_APPLY:
		directories_selection_save_changes (dialog);
		break;
	case GTK_RESPONSE_CANCEL:
	default:
		directories_selection_close_window (dialog);
		break;
	}
}

GtkWidget *
create_directories_selection (void)
{
	GtkWidget *directories_notebook;
	GtkWidget *gxmame_tab_label;
	GtkWidget *xmame_tab_label1;
	GtkWidget *xmame_tab_label2;
	GtkWidget *gxmame_directory_frame;
	GtkWidget *gxmame_directory_table;
	GtkWidget *xmame_directory_frame;
	GtkWidget *xmame_directory_table;
	GtkWidget *xmame_addit_path_frame;
	GtkWidget *xmame_addit_path_table;
	GtkWidget *xmame_user_path_frame;
	GtkWidget *xmame_user_path_table;
	
	/* GXMame */
	GtkWidget *common_browse_button;
	GtkWidget *catver_path_label;
	GtkWidget *xmame_execs_entry_vbox;
	GtkWidget *xmame_execs_path_scrolledwindow;
	GtkWidget *xmame_execs_path_viewport;
	GtkWidget *xmame_execs_label;
	GtkWidget *xmame_execs_path_button_vbox;
	GtkWidget *xmame_execs_browse_button;
	GtkWidget *xmame_execs_add_button;
	GtkWidget *xmame_execs_remove_button;
	GtkWidget *icons_browse_button;
	GtkWidget *icons_label;
	GtkWidget *flyer_label;
	GtkWidget *flyer_browse_button;
	GtkWidget *cabinet_label;
	GtkWidget *cabinet_browse_button;
	GtkWidget *marquee_label;
	GtkWidget *marquee_browse_button;
	GtkWidget *title_label;
	GtkWidget *title_browse_button;
	
	/* XMame basic */
	GtkWidget *rompath_entry_vbox;
	GtkWidget *rompath_scrolledwindow;
	GtkWidget *rompath_viewport;
	GtkWidget *rompath_label;
	GtkWidget *rompath_button_vbox;
	GtkWidget *roms_browse_button;
	GtkWidget *roms_add_button;
	GtkWidget *roms_remove_button;
	GtkWidget *samplepath_entry_vbox;
	GtkWidget *samplepath_scrolledwindow;
	GtkWidget *samplepath_button_vbox;
	GtkWidget *samples_browse_button;
	GtkWidget *samples_add_button;
	GtkWidget *samples_remove_button;
	GtkWidget *samplepath_viewport;
	GtkWidget *sample_label;
	GtkWidget *diffdirs_browse_button;
	GtkWidget *diffdir_label;
	GtkWidget *artwork_label;
	GtkWidget *artwork_browse_button;
	
	/* XMame additional */
	GtkWidget *snapshot_label;
	GtkWidget *snapshots_browse_button;
	GtkWidget *historyfile_label;
	GtkWidget *historyfile_browse_button;
	GtkWidget *mameinfofile_label;
	GtkWidget *mameinfofile_browse_button;
	
	GtkWidget *cheatfile_label;
	GtkWidget *cheatfile_browse_button;
	GtkWidget *hiscorefile_label;
	GtkWidget *hiscorefile_browse_button;
	GtkWidget *ctrlr_directory_label;
	GtkWidget *ctrlr_directory_browse_button;

	/* User resources */
	GtkWidget *hiscore_label;
	GtkWidget *hiscore_browse_button;
	GtkWidget *input_label;
	GtkWidget *input_browse_button;
	GtkWidget *cfg_directory_label;
	GtkWidget *cfg_directory_browse_button;
	GtkWidget *nvram_directory_label;
	GtkWidget *nvram_directory_browse_button;
	GtkWidget *memcard_directory_label;
	GtkWidget *memcard_directory_browse_button;
	GtkWidget *state_directory_label;
	GtkWidget *state_directory_browse_button;
	GtkWidget *inipath_label;
	GtkWidget *inipath_browse_button;


	GtkWidget *vseparator1;
	GtkWidget *vseparator2;
	/*GtkWidget *hseparator1;*/

	GtkWidget *directories_selection_cancel_button;
	GtkWidget *directories_selection_ok_button;
	gint i;
	GtkAccelGroup *accel_group;

	GtkTreeIter iter;
	GtkTreeModel *store;
	GtkTreeView *treeview;
	GtkTreeViewColumn *column;
	GtkCellRenderer *renderer;
	GtkTreeSelection *select;
	gchar **xmame_executables_array;

/*	refresh_game_list=FALSE; */

	accel_group = gtk_accel_group_new ();

	directories_selection = gtk_dialog_new ();
	gtk_dialog_set_has_separator (GTK_DIALOG (directories_selection), FALSE);
	gtk_window_set_title (GTK_WINDOW (directories_selection), _("Directories Selection"));
	gtk_window_set_transient_for (GTK_WINDOW (directories_selection), GTK_WINDOW (MainWindow));
	gtk_window_set_modal (GTK_WINDOW (directories_selection), TRUE);


	directories_notebook = gtk_notebook_new ();
	gtk_widget_show (directories_notebook);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (directories_selection)->vbox), directories_notebook, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (directories_notebook), 8);
	
	gxmame_directory_frame = options_frame_new (_("Path to xmame and various support files"));
	gtk_widget_show (gxmame_directory_frame);
	gtk_container_set_border_width (GTK_CONTAINER (gxmame_directory_frame), 5);

	gxmame_tab_label = gtk_label_new (_("GXMame Directories"));
	gtk_widget_show (gxmame_tab_label);

	gtk_notebook_append_page (GTK_NOTEBOOK (directories_notebook),
				  gxmame_directory_frame,
				  gxmame_tab_label);
	gxmame_directory_frame = options_frame_create_child (gxmame_directory_frame);

	gxmame_directory_table = gtk_table_new (3, 3, FALSE);
	gtk_widget_show (gxmame_directory_table);
	gtk_container_add (GTK_CONTAINER (gxmame_directory_frame), gxmame_directory_table);
	gtk_container_set_border_width (GTK_CONTAINER (gxmame_directory_table), 2);
	gtk_table_set_row_spacings (GTK_TABLE (gxmame_directory_table), 5);
	gtk_table_set_col_spacings (GTK_TABLE (gxmame_directory_table), 5);

/*	xmame_title_frame_label = gtk_label_new (_("Path to xmame and various config files"));
	gtk_widget_show (xmame_title_frame_label);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), xmame_title_frame_label, 0, 6, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (xmame_title_frame_label), 0.5, 0.5);
*/

/* Xmame executables Path */
	xmame_execs_label = gtk_label_new (_("Xmame executables:"));
	gtk_widget_show (xmame_execs_label);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), xmame_execs_label, 0, 1, 0, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (xmame_execs_label), 0, 0);
	gtk_misc_set_padding (GTK_MISC (xmame_execs_label), 0, 5);

	xmame_execs_entry_vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (xmame_execs_entry_vbox);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), xmame_execs_entry_vbox, 1, 2, 0, 3,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

	xmame_execs_entry = gtk_entry_new ();
	gtk_box_pack_start (GTK_BOX (xmame_execs_entry_vbox), xmame_execs_entry, FALSE, FALSE, 0);
	gtk_widget_show (xmame_execs_entry);

	xmame_execs_path_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (xmame_execs_path_scrolledwindow);
	gtk_box_pack_start (GTK_BOX (xmame_execs_entry_vbox), xmame_execs_path_scrolledwindow, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (xmame_execs_path_scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	xmame_execs_path_viewport = gtk_viewport_new (NULL, NULL);
	gtk_widget_show (xmame_execs_path_viewport);
	gtk_container_add (GTK_CONTAINER (xmame_execs_path_scrolledwindow), xmame_execs_path_viewport);

	/* XMame Exe List */
	store = (GtkTreeModel *) gtk_list_store_new (1,
						     G_TYPE_STRING);
	xmame_executables_array = xmame_table_get_all ();

	for (i = 0; xmame_executables_array[i] != NULL; i++) {
		gtk_list_store_append (GTK_LIST_STORE (store), &iter);  /* Acquire an iterator */
		gtk_list_store_set (GTK_LIST_STORE (store), &iter,
				    0,                   xmame_executables_array[i],
				    -1);
	}

	xmame_execs_tree_model = store;
	treeview = GTK_TREE_VIEW (gtk_tree_view_new ());
	gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (treeview), FALSE);
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (" ", renderer,
							   "text", 0,
							   NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
	gtk_tree_view_set_model (GTK_TREE_VIEW (treeview), GTK_TREE_MODEL (store));
	xmame_execs_tree_view = treeview;
	gtk_widget_show_all (GTK_WIDGET (xmame_execs_tree_view));
	gtk_container_add (GTK_CONTAINER (xmame_execs_path_viewport), GTK_WIDGET (xmame_execs_tree_view));


	xmame_execs_path_button_vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (xmame_execs_path_button_vbox);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), xmame_execs_path_button_vbox, 2, 3, 0, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL), 0, 0);

	xmame_execs_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (xmame_execs_browse_button);
	gtk_box_pack_start (GTK_BOX (xmame_execs_path_button_vbox), xmame_execs_browse_button, FALSE, FALSE, 2);

	xmame_execs_add_button = gtk_button_new_from_stock (GTK_STOCK_ADD);
	gtk_widget_show (xmame_execs_add_button);
	gtk_box_pack_start (GTK_BOX (xmame_execs_path_button_vbox), xmame_execs_add_button, FALSE, FALSE, 2);

	xmame_execs_remove_button = gtk_button_new_from_stock (GTK_STOCK_REMOVE);
	gtk_widget_show (xmame_execs_remove_button);
	gtk_box_pack_start (GTK_BOX (xmame_execs_path_button_vbox), xmame_execs_remove_button, FALSE, FALSE, 2);

/* common path (catver)*/
	catver_path_label = gtk_label_new (_("Catver path:"));
	gtk_widget_show (catver_path_label);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), catver_path_label, 0, 1, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (catver_path_label), 0, 0.5);

	common_path_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (common_path_entry), gui_prefs.catverDirectory);
	gtk_widget_show (common_path_entry);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), common_path_entry, 1, 2, 3, 4,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	common_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (common_browse_button);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), common_browse_button, 2, 3, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);


/* separators */	
	vseparator2 = gtk_hseparator_new ();
	gtk_widget_show (vseparator2);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), vseparator2, 0, 3, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);
	
/* Flyers directory */
	flyer_label = gtk_label_new (_("Flyers path:"));
	gtk_widget_show (flyer_label);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), flyer_label, 0, 1, 5, 6,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (flyer_label), 0, 0.5);

	flyer_path_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (flyer_path_entry), gui_prefs.FlyerDirectory);
	gtk_widget_show (flyer_path_entry);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), flyer_path_entry, 1, 2, 5, 6,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	flyer_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (flyer_browse_button);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), flyer_browse_button, 2, 3, 5, 6,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* Cabinets directory */
	cabinet_label = gtk_label_new (_("Cabinets path:"));
	gtk_widget_show (cabinet_label);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), cabinet_label, 0, 1, 6, 7,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (cabinet_label), 0, 0.5);

	cabinet_path_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (cabinet_path_entry), gui_prefs.CabinetDirectory);
	gtk_widget_show (cabinet_path_entry);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), cabinet_path_entry, 1, 2, 6, 7,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	cabinet_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (cabinet_browse_button);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), cabinet_browse_button, 2, 3, 6, 7,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* Marquees directory */
	marquee_label = gtk_label_new (_("Marquees path:"));
	gtk_widget_show (marquee_label);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), marquee_label, 0, 1, 7, 8,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (marquee_label), 0, 0.5);

	marquee_path_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (marquee_path_entry), gui_prefs.MarqueeDirectory);
	gtk_widget_show (marquee_path_entry);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), marquee_path_entry, 1, 2, 7, 8,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	marquee_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (marquee_browse_button);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), marquee_browse_button, 2, 3, 7, 8,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* Titles directory */
	title_label = gtk_label_new (_("Title screenshots path:"));
	gtk_widget_show (title_label);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), title_label, 0, 1, 8, 9,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (title_label), 0, 0.5);

	title_path_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (title_path_entry), gui_prefs.TitleDirectory);
	gtk_widget_show (title_path_entry);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), title_path_entry, 1, 2, 8, 9,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	title_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (title_browse_button);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), title_browse_button, 2, 3, 8, 9,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* Icons directory */
	icons_label = gtk_label_new (_("Icons path:"));
	gtk_widget_show (icons_label);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), icons_label, 0, 1, 9, 10,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (icons_label), 0, 0.5);

	icons_path_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (icons_path_entry), gui_prefs.IconDirectory);
	gtk_widget_show (icons_path_entry);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), icons_path_entry, 1, 2, 9, 10,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	icons_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (icons_browse_button);
	gtk_table_attach (GTK_TABLE (gxmame_directory_table), icons_browse_button, 2, 3, 9, 10,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);


/*  second frame */
	xmame_directory_frame = options_frame_new (_("Paths to files needed for x-mame"));
	gtk_widget_show (xmame_directory_frame);
	gtk_container_set_border_width (GTK_CONTAINER (xmame_directory_frame), 5);
	xmame_tab_label1 = gtk_label_new (_("XMame basic paths"));
	gtk_widget_show (xmame_tab_label1);
	gtk_notebook_append_page (GTK_NOTEBOOK (directories_notebook),
				  xmame_directory_frame,
				  xmame_tab_label1);
	xmame_directory_frame = options_frame_create_child (xmame_directory_frame);

	xmame_directory_table = gtk_table_new (4, 3, FALSE);
	gtk_widget_show (xmame_directory_table);
	gtk_container_add (GTK_CONTAINER (xmame_directory_frame), xmame_directory_table);
	gtk_container_set_border_width (GTK_CONTAINER (xmame_directory_table), 2);
	gtk_table_set_row_spacings (GTK_TABLE (xmame_directory_table), 5);
	gtk_table_set_col_spacings (GTK_TABLE (xmame_directory_table), 5);

/*	wmame_title_frame_label = gtk_label_new (_("path to files needed for x-mame"));
	gtk_widget_show (wmame_title_frame_label);
	gtk_table_attach (GTK_TABLE (xmame_directory_table), wmame_title_frame_label, 0, 7, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (wmame_title_frame_label), 0.5, 0.5);
*/	

/* Romspath directories*/
	rompath_label = gtk_label_new (_("ROMs paths:"));
	gtk_widget_show (rompath_label);
	gtk_table_attach (GTK_TABLE (xmame_directory_table), rompath_label, 0, 1, 1, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (rompath_label), 0, 0);
	gtk_misc_set_padding (GTK_MISC (rompath_label), 0, 5);

	rompath_entry_vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (rompath_entry_vbox);
	gtk_table_attach (GTK_TABLE (xmame_directory_table), rompath_entry_vbox, 1, 2, 1, 5,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

	roms_path_entry = gtk_entry_new ();
	gtk_widget_show (roms_path_entry);
	gtk_box_pack_start (GTK_BOX (rompath_entry_vbox), roms_path_entry, FALSE, FALSE, 0);

	rompath_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (rompath_scrolledwindow);
	gtk_box_pack_start (GTK_BOX (rompath_entry_vbox), rompath_scrolledwindow, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (rompath_scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	rompath_viewport = gtk_viewport_new (NULL, NULL);
	gtk_widget_show (rompath_viewport);
	gtk_container_add (GTK_CONTAINER (rompath_scrolledwindow), rompath_viewport);

	/* Roms Path List */
	store = (GtkTreeModel *) gtk_list_store_new (1,
						     G_TYPE_STRING);
	for (i = 0; gui_prefs.RomPath[i] != NULL; i++) {
		gtk_list_store_append (GTK_LIST_STORE (store), &iter);  /* Acquire an iterator */
		gtk_list_store_set (GTK_LIST_STORE (store), &iter,
				    0,                   gui_prefs.RomPath[i],
				    -1);
	}

	roms_path_tree_model = store;
	treeview = GTK_TREE_VIEW (gtk_tree_view_new ());
	gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (treeview), FALSE);
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (" ", renderer,
							   "text", 0,
							   NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
	gtk_tree_view_set_model (GTK_TREE_VIEW (treeview), GTK_TREE_MODEL (store));
	roms_path_tree_view = treeview;
	gtk_widget_show_all (GTK_WIDGET (roms_path_tree_view));
	gtk_container_add (GTK_CONTAINER (rompath_viewport), GTK_WIDGET (roms_path_tree_view));


	rompath_button_vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (rompath_button_vbox);
	gtk_table_attach (GTK_TABLE (xmame_directory_table), rompath_button_vbox, 2, 3, 1, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL), 0, 0);

	roms_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (roms_browse_button);
	gtk_box_pack_start (GTK_BOX (rompath_button_vbox), roms_browse_button, FALSE, FALSE, 2);

	roms_add_button = gtk_button_new_from_stock (GTK_STOCK_ADD);
	gtk_widget_show (roms_add_button);
	gtk_box_pack_start (GTK_BOX (rompath_button_vbox), roms_add_button, FALSE, FALSE, 2);

	roms_remove_button = gtk_button_new_from_stock (GTK_STOCK_REMOVE);
	gtk_widget_show (roms_remove_button);
	gtk_box_pack_start (GTK_BOX (rompath_button_vbox), roms_remove_button, FALSE, FALSE, 2);

/* samplespath directories*/
	sample_label = gtk_label_new (_("Samples paths:"));
	gtk_widget_show (sample_label);
	gtk_table_attach (GTK_TABLE (xmame_directory_table), sample_label, 0, 1, 6, 10,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (sample_label), 0, 0);
	gtk_misc_set_padding (GTK_MISC (sample_label), 0, 5);

	samplepath_entry_vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (samplepath_entry_vbox);
	gtk_table_attach (GTK_TABLE (xmame_directory_table), samplepath_entry_vbox, 1, 2, 6, 10,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

	samples_path_entry = gtk_entry_new ();
	gtk_widget_show (samples_path_entry);
	gtk_box_pack_start (GTK_BOX (samplepath_entry_vbox), samples_path_entry, FALSE, FALSE, 0);

	samplepath_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (samplepath_scrolledwindow);
	gtk_box_pack_start (GTK_BOX (samplepath_entry_vbox), samplepath_scrolledwindow, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (samplepath_scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	samplepath_viewport = gtk_viewport_new (NULL, NULL);
	gtk_widget_show (samplepath_viewport);
	gtk_container_add (GTK_CONTAINER (samplepath_scrolledwindow), samplepath_viewport);

	/* Samples Path List */
	store = (GtkTreeModel *) gtk_list_store_new (1,
						     G_TYPE_STRING);
	for (i = 0; gui_prefs.SamplePath[i] != NULL; i++) {
		gtk_list_store_append (GTK_LIST_STORE (store), &iter);  /* Acquire an iterator */
		gtk_list_store_set (GTK_LIST_STORE (store), &iter,
				    0,                   gui_prefs.SamplePath[i],
				    -1);
	}
	samples_path_tree_model = store;
	treeview = GTK_TREE_VIEW (gtk_tree_view_new ());
	gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (treeview), FALSE);
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (" ", renderer,
							   "text", 0,
							   NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
	gtk_tree_view_set_model (GTK_TREE_VIEW (treeview), GTK_TREE_MODEL (store));
	samples_path_tree_view = treeview;
	gtk_widget_show_all (GTK_WIDGET (samples_path_tree_view));
	gtk_container_add (GTK_CONTAINER (samplepath_viewport), GTK_WIDGET (samples_path_tree_view));


	samplepath_button_vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (samplepath_button_vbox);
	gtk_table_attach (GTK_TABLE (xmame_directory_table), samplepath_button_vbox, 2, 3, 6, 10,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL), 0, 0);

	samples_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (samples_browse_button);
	gtk_box_pack_start (GTK_BOX (samplepath_button_vbox), samples_browse_button, FALSE, FALSE, 2);

	samples_add_button = gtk_button_new_from_stock (GTK_STOCK_ADD);
	gtk_widget_show (samples_add_button);
	gtk_box_pack_start (GTK_BOX (samplepath_button_vbox), samples_add_button, FALSE, FALSE, 2);

	samples_remove_button = gtk_button_new_from_stock (GTK_STOCK_REMOVE);
	gtk_widget_show (samples_remove_button);
	gtk_box_pack_start (GTK_BOX (samplepath_button_vbox), samples_remove_button, FALSE, FALSE, 2);

/* Artwork directory */
	artwork_label = gtk_label_new (_("Artwork path:"));
	gtk_widget_show (artwork_label);
	gtk_table_attach (GTK_TABLE (xmame_directory_table), artwork_label, 0, 1, 10, 11,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (artwork_label), 0, 0.5);

	artwork_path_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (artwork_path_entry), gui_prefs.ArtworkDirectory);
	gtk_widget_show (artwork_path_entry);
	gtk_table_attach (GTK_TABLE (xmame_directory_table), artwork_path_entry, 1, 2, 10, 11,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	artwork_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (artwork_browse_button);
	gtk_table_attach (GTK_TABLE (xmame_directory_table), artwork_browse_button, 2, 3, 10, 11,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	
/*  third frame */	
	xmame_addit_path_frame = options_frame_new (_("Paths to additional files needed for x-mame"));
	gtk_widget_show (xmame_addit_path_frame);
	gtk_container_set_border_width (GTK_CONTAINER (xmame_addit_path_frame), 5);
	xmame_tab_label2 = gtk_label_new (_("XMame additional paths"));
	gtk_widget_show (xmame_tab_label2);
	gtk_notebook_append_page (GTK_NOTEBOOK (directories_notebook),
				  xmame_addit_path_frame,
				  xmame_tab_label2);
	xmame_addit_path_frame = options_frame_create_child (xmame_addit_path_frame);

	xmame_addit_path_table = gtk_table_new (4, 3, FALSE);
	gtk_widget_show (xmame_addit_path_table);
	gtk_container_add (GTK_CONTAINER (xmame_addit_path_frame), xmame_addit_path_table);
	gtk_container_set_border_width (GTK_CONTAINER (xmame_addit_path_table), 2);
	gtk_table_set_row_spacings (GTK_TABLE (xmame_addit_path_table), 5);
	gtk_table_set_col_spacings (GTK_TABLE (xmame_addit_path_table), 5);
		
/* Snapshot directory */
	snapshot_label = gtk_label_new (_("Snapshots path:"));
	gtk_widget_show (snapshot_label);
	gtk_table_attach (GTK_TABLE (xmame_addit_path_table), snapshot_label, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (snapshot_label), 0, 0.5);

	snapshot_path_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (snapshot_path_entry), gui_prefs.SnapshotDirectory);
	gtk_widget_show (snapshot_path_entry);
	gtk_table_attach (GTK_TABLE (xmame_addit_path_table), snapshot_path_entry, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	snapshots_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (snapshots_browse_button);
	gtk_table_attach (GTK_TABLE (xmame_addit_path_table), snapshots_browse_button, 2, 3, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	
/* historyfile File */
	historyfile_label = gtk_label_new (_("History file:"));
	gtk_widget_show (historyfile_label);
	gtk_table_attach (GTK_TABLE (xmame_addit_path_table), historyfile_label, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (historyfile_label), 0, 0.5);

	historyfile_path_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (historyfile_path_entry), gui_prefs.HistoryFile);
	gtk_widget_show (historyfile_path_entry);
	gtk_table_attach (GTK_TABLE (xmame_addit_path_table), historyfile_path_entry, 1, 2, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	historyfile_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (historyfile_browse_button);
	gtk_table_attach (GTK_TABLE (xmame_addit_path_table), historyfile_browse_button, 2, 3, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* mameinfofile File */
	mameinfofile_label = gtk_label_new (_("Mame info file:"));
	gtk_widget_show (mameinfofile_label);
	gtk_table_attach (GTK_TABLE (xmame_addit_path_table), mameinfofile_label, 0, 1, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (mameinfofile_label), 0, 0.5);

	mameinfofile_path_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (mameinfofile_path_entry), gui_prefs.MameInfoFile);
	gtk_widget_show (mameinfofile_path_entry);
	gtk_table_attach (GTK_TABLE (xmame_addit_path_table), mameinfofile_path_entry, 1, 2, 2, 3,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	mameinfofile_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (mameinfofile_browse_button);
	gtk_table_attach (GTK_TABLE (xmame_addit_path_table), mameinfofile_browse_button, 2, 3, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	vseparator1 = gtk_hseparator_new ();
	gtk_widget_show (vseparator1);
	gtk_table_attach (GTK_TABLE (xmame_addit_path_table), vseparator1, 0, 3, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* Cheat File */
	cheatfile_label = gtk_label_new (_("Cheat file:"));
	gtk_widget_show (cheatfile_label);
	gtk_table_attach (GTK_TABLE (xmame_addit_path_table), cheatfile_label, 0, 1, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (cheatfile_label), 0, 0.5);

	cheatfile_path_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (cheatfile_path_entry), gui_prefs.CheatFile);
	gtk_widget_show (cheatfile_path_entry);
	gtk_table_attach (GTK_TABLE (xmame_addit_path_table), cheatfile_path_entry, 1, 2, 4, 5,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	cheatfile_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (cheatfile_browse_button);
	gtk_table_attach (GTK_TABLE (xmame_addit_path_table), cheatfile_browse_button, 2, 3, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* hiscorefile File */
	hiscorefile_label = gtk_label_new (_("High score file:"));
	gtk_widget_show (hiscorefile_label);
	gtk_table_attach (GTK_TABLE (xmame_addit_path_table), hiscorefile_label, 0, 1, 5, 6,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (hiscorefile_label), 0, 0.5);

	hiscorefile_path_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (hiscorefile_path_entry), gui_prefs.HiscoreFile);
	gtk_widget_show (hiscorefile_path_entry);
	gtk_table_attach (GTK_TABLE (xmame_addit_path_table), hiscorefile_path_entry, 1, 2, 5, 6,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	hiscorefile_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (hiscorefile_browse_button);
	gtk_table_attach (GTK_TABLE (xmame_addit_path_table), hiscorefile_browse_button, 2, 3, 5, 6,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* ctrlr Directory */
	ctrlr_directory_label = gtk_label_new (_("Controller directory:"));
	gtk_widget_show (ctrlr_directory_label);
	gtk_table_attach (GTK_TABLE (xmame_addit_path_table), ctrlr_directory_label, 0, 1, 6, 7,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (ctrlr_directory_label), 0, 0.5);

	ctrlr_directory_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (ctrlr_directory_entry), gui_prefs.CtrlrDirectory);
	gtk_widget_show (ctrlr_directory_entry);
	gtk_table_attach (GTK_TABLE (xmame_addit_path_table), ctrlr_directory_entry, 1, 2, 6, 7,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	ctrlr_directory_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (ctrlr_directory_browse_button);
	gtk_table_attach (GTK_TABLE (xmame_addit_path_table), ctrlr_directory_browse_button, 2, 3, 6, 7,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	
	
/*  fourth frame */	
	xmame_user_path_frame = options_frame_new (_("Paths to user resources"));
	gtk_widget_show (xmame_user_path_frame);
	gtk_container_set_border_width (GTK_CONTAINER (xmame_user_path_frame), 5);
	xmame_tab_label2 = gtk_label_new (_("User resources"));
	gtk_widget_show (xmame_tab_label2);
	gtk_notebook_append_page (GTK_NOTEBOOK (directories_notebook),
				  xmame_user_path_frame,
				  xmame_tab_label2);
	xmame_user_path_frame = options_frame_create_child (xmame_user_path_frame);

	xmame_user_path_table = gtk_table_new (4, 3, FALSE);
	gtk_widget_show (xmame_user_path_table);
	gtk_container_add (GTK_CONTAINER (xmame_user_path_frame), xmame_user_path_table);
	gtk_container_set_border_width (GTK_CONTAINER (xmame_user_path_table), 2);
	gtk_table_set_row_spacings (GTK_TABLE (xmame_user_path_table), 5);
	gtk_table_set_col_spacings (GTK_TABLE (xmame_user_path_table), 5);
		
/* hiscores directory */
	hiscore_label = gtk_label_new (_("High score path:"));
	gtk_widget_show (hiscore_label);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), hiscore_label, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (hiscore_label), 0, 0.5);

	hiscore_path_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (hiscore_path_entry), gui_prefs.HiscoreDirectory);
	gtk_widget_show (hiscore_path_entry);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), hiscore_path_entry, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	hiscore_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (hiscore_browse_button);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), hiscore_browse_button, 2, 3, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	
/* input directory */
	input_label = gtk_label_new (_("Recorded games path:"));
	gtk_widget_show (input_label);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), input_label, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (input_label), 0, 0.5);

	input_path_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (input_path_entry), gui_prefs.InputDirectory);
	gtk_widget_show (input_path_entry);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), input_path_entry, 1, 2, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	input_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (input_browse_button);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), input_browse_button, 2, 3, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* cfg_directory directory */
	cfg_directory_label = gtk_label_new (_("Games configuration path:"));
	gtk_widget_show (cfg_directory_label);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), cfg_directory_label, 0, 1, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (cfg_directory_label), 0, 0.5);

	cfg_directory_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (cfg_directory_entry), gui_prefs.ConfigDirectory);
	gtk_widget_show (cfg_directory_entry);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), cfg_directory_entry, 1, 2, 2, 3,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	cfg_directory_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (cfg_directory_browse_button);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), cfg_directory_browse_button, 2, 3, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* nvram_directory directory */
	nvram_directory_label = gtk_label_new (_("NVRam path:"));
	gtk_widget_show (nvram_directory_label);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), nvram_directory_label, 0, 1, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (nvram_directory_label), 0, 0.5);

	nvram_directory_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (nvram_directory_entry), gui_prefs.NVRamDirectory);
	gtk_widget_show (nvram_directory_entry);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), nvram_directory_entry, 1, 2, 3, 4,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	nvram_directory_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (nvram_directory_browse_button);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), nvram_directory_browse_button, 2, 3, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* memcard_directory directory */
	memcard_directory_label = gtk_label_new (_("Memory cards path:"));
	gtk_widget_show (memcard_directory_label);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), memcard_directory_label, 0, 1, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (memcard_directory_label), 0, 0.5);

	memcard_directory_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (memcard_directory_entry), gui_prefs.MemCardDirectory);
	gtk_widget_show (memcard_directory_entry);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), memcard_directory_entry, 1, 2, 4, 5,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	memcard_directory_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (memcard_directory_browse_button);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), memcard_directory_browse_button, 2, 3, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* state_directory directory */
	state_directory_label = gtk_label_new (_("Game status path:"));
	gtk_widget_show (state_directory_label);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), state_directory_label, 0, 1, 5, 6,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (state_directory_label), 0, 0.5);

	state_directory_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (state_directory_entry), gui_prefs.StateDirectory);
	gtk_widget_show (state_directory_entry);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), state_directory_entry, 1, 2, 5, 6,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	state_directory_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (state_directory_browse_button);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), state_directory_browse_button, 2, 3, 5, 6,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	
/* inipath */
	inipath_label = gtk_label_new (_("INI files path:"));
	gtk_widget_show (inipath_label);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), inipath_label, 0, 1, 6, 7,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (inipath_label), 0, 0.5);

	inipath_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (inipath_entry), gui_prefs.inipath);
	gtk_widget_show (inipath_entry);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), inipath_entry, 1, 2, 6, 7,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	inipath_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (inipath_browse_button);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), inipath_browse_button, 2, 3, 6, 7,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	
/* diffdir directory */
	diffdir_label = gtk_label_new (_("Diff path:"));
	gtk_widget_show (diffdir_label);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), diffdir_label, 0, 1, 7, 8,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (diffdir_label), 0, 0.5);

	diffdir_path_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (diffdir_path_entry), gui_prefs.DiffDirectory);
	gtk_widget_show (diffdir_path_entry);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), diffdir_path_entry, 1, 2, 7, 8,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	diffdirs_browse_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_show (diffdirs_browse_button);
	gtk_table_attach (GTK_TABLE (xmame_user_path_table), diffdirs_browse_button, 2, 3, 7, 8,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	


	

	
/* OK Apply Cancel buttons */

	directories_selection_apply_button = gtk_dialog_add_button (GTK_DIALOG (directories_selection),
								    GTK_STOCK_APPLY,
								    GTK_RESPONSE_APPLY);
	gtk_widget_set_sensitive (directories_selection_apply_button, FALSE);


	directories_selection_cancel_button = gtk_dialog_add_button (GTK_DIALOG (directories_selection),
								     GTK_STOCK_CANCEL,
								     GTK_RESPONSE_CANCEL);

	directories_selection_ok_button = gtk_dialog_add_button (GTK_DIALOG (directories_selection),
								 GTK_STOCK_OK,
								 GTK_RESPONSE_OK);
	/* Button Cicked */
	/* GXMame */
	g_signal_connect (G_OBJECT (xmame_execs_browse_button), "clicked",
			    G_CALLBACK (on_file_browse_button_clicked),
			    xmame_execs_entry);
	g_signal_connect (G_OBJECT (xmame_execs_add_button), "clicked",
			    G_CALLBACK (on_xmame_execs_add_button_clicked),
			    NULL);
	g_signal_connect (G_OBJECT (xmame_execs_remove_button), "clicked",
			    G_CALLBACK (on_xmame_execs_remove_button_clicked),
			    NULL);
	g_signal_connect (G_OBJECT (common_browse_button), "clicked",
			    G_CALLBACK (on_dir_browse_button_clicked),
			    common_path_entry);
	g_signal_connect (G_OBJECT (flyer_browse_button), "clicked",
			    G_CALLBACK (on_dir_browse_button_clicked),
			    flyer_path_entry);
	g_signal_connect (G_OBJECT (cabinet_browse_button), "clicked",
			    G_CALLBACK (on_dir_browse_button_clicked),
			    cabinet_path_entry);
	g_signal_connect (G_OBJECT (marquee_browse_button), "clicked",
			    G_CALLBACK (on_dir_browse_button_clicked),
			    marquee_path_entry);
	g_signal_connect (G_OBJECT (title_browse_button), "clicked",
			    G_CALLBACK (on_dir_browse_button_clicked),
			    title_path_entry);
	g_signal_connect (G_OBJECT (icons_browse_button), "clicked",
			    G_CALLBACK (on_dir_browse_button_clicked),
			    icons_path_entry);
	/* XMame basic */
	g_signal_connect (G_OBJECT (samples_browse_button), "clicked",
			    G_CALLBACK (on_dir_browse_button_clicked),
			    samples_path_entry);
	g_signal_connect (G_OBJECT (samples_add_button), "clicked",
			    G_CALLBACK (on_samples_add_button_clicked),
			    NULL);
	g_signal_connect (G_OBJECT (samples_remove_button), "clicked",
			    G_CALLBACK (on_samples_remove_button_clicked),
			    NULL);
	g_signal_connect (G_OBJECT (roms_browse_button), "clicked",
			    G_CALLBACK (on_dir_browse_button_clicked),
			    roms_path_entry);
	g_signal_connect (G_OBJECT (roms_add_button), "clicked",
			    G_CALLBACK (on_roms_add_button_clicked),
			    NULL);
	g_signal_connect (G_OBJECT (roms_remove_button), "clicked",
			    G_CALLBACK (on_roms_remove_button_clicked),
			    NULL);
	g_signal_connect (G_OBJECT (diffdirs_browse_button), "clicked",
			    G_CALLBACK (on_dir_browse_button_clicked),
			    diffdir_path_entry);
	g_signal_connect (G_OBJECT (artwork_browse_button), "clicked",
			    G_CALLBACK (on_dir_browse_button_clicked),
			    artwork_path_entry);
	/* XMame additional */
	g_signal_connect (G_OBJECT (snapshots_browse_button), "clicked",
			    G_CALLBACK (on_dir_browse_button_clicked),
			    snapshot_path_entry);
	g_signal_connect (G_OBJECT (historyfile_browse_button), "clicked",
			    G_CALLBACK (on_file_browse_button_clicked),
			    historyfile_path_entry);
	g_signal_connect (G_OBJECT (mameinfofile_browse_button), "clicked",
			    G_CALLBACK (on_file_browse_button_clicked),
			    mameinfofile_path_entry);
	g_signal_connect (G_OBJECT (cheatfile_browse_button), "clicked",
			    G_CALLBACK (on_file_browse_button_clicked),
			    cheatfile_path_entry);
	g_signal_connect (G_OBJECT (hiscorefile_browse_button), "clicked",
			    G_CALLBACK (on_file_browse_button_clicked),
			    hiscorefile_path_entry);
	g_signal_connect (G_OBJECT (ctrlr_directory_browse_button), "clicked",
			    G_CALLBACK (on_file_browse_button_clicked),
			    ctrlr_directory_entry);
	/* User Resources */
	g_signal_connect (G_OBJECT (hiscore_browse_button), "clicked",
			    G_CALLBACK (on_dir_browse_button_clicked),
			    hiscore_path_entry);
	g_signal_connect (G_OBJECT (input_browse_button), "clicked",
			    G_CALLBACK (on_dir_browse_button_clicked),
			    input_path_entry);
	g_signal_connect (G_OBJECT (cfg_directory_browse_button), "clicked",
			    G_CALLBACK (on_file_browse_button_clicked),
			    cfg_directory_entry);
	g_signal_connect (G_OBJECT (nvram_directory_browse_button), "clicked",
			    G_CALLBACK (on_file_browse_button_clicked),
			    nvram_directory_entry);
	g_signal_connect (G_OBJECT (memcard_directory_browse_button), "clicked",
			    G_CALLBACK (on_file_browse_button_clicked),
			    memcard_directory_entry);
	g_signal_connect (G_OBJECT (state_directory_browse_button), "clicked",
			    G_CALLBACK (on_file_browse_button_clicked),
			    state_directory_entry);
	g_signal_connect (G_OBJECT (inipath_browse_button), "clicked",
			    G_CALLBACK (on_file_browse_button_clicked),
			    inipath_entry);

	/* XMame Execs List */
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (xmame_execs_tree_view));
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	g_signal_connect (G_OBJECT (select), "changed",
				G_CALLBACK (on_xmame_execs_tree_view_select),
				xmame_execs_entry);

	/* Roms Path List */
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (samples_path_tree_view));
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	g_signal_connect (G_OBJECT (select), "changed",
				G_CALLBACK (on_samples_path_tree_view_select),
				samples_path_entry);

	/* Samples Path List */
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (roms_path_tree_view));
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	g_signal_connect (G_OBJECT (select), "changed",
				G_CALLBACK (on_roms_path_tree_view_select),
				roms_path_entry);

	/* Dialog */
	g_signal_connect (G_OBJECT (directories_selection), "response",
			  G_CALLBACK (directories_selection_response),
			  NULL);

	/* Entry Changed */
	/* GXMame */
	g_signal_connect_swapped (G_OBJECT (flyer_path_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));
	g_signal_connect_swapped (G_OBJECT (cabinet_path_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));
	g_signal_connect_swapped (G_OBJECT (marquee_path_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));
	g_signal_connect_swapped (G_OBJECT (title_path_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));
	g_signal_connect_swapped (G_OBJECT (icons_path_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));
	g_signal_connect_swapped (G_OBJECT (common_path_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));

	/* XMame basic */
	g_signal_connect_swapped (G_OBJECT (diffdir_path_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));
	g_signal_connect_swapped (G_OBJECT (artwork_path_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));
	/* XMame additional */
	g_signal_connect_swapped (G_OBJECT (snapshot_path_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));
	g_signal_connect_swapped (G_OBJECT (mameinfofile_path_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));
	g_signal_connect_swapped (G_OBJECT (historyfile_path_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));
	g_signal_connect_swapped (G_OBJECT (hiscorefile_path_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));
	g_signal_connect_swapped (G_OBJECT (cheatfile_path_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));
	g_signal_connect_swapped (G_OBJECT (ctrlr_directory_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));
	/* User Resources */
	g_signal_connect_swapped (G_OBJECT (hiscore_path_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));
	g_signal_connect_swapped (G_OBJECT (input_path_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));
	g_signal_connect_swapped (G_OBJECT (cfg_directory_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));
	g_signal_connect_swapped (G_OBJECT (nvram_directory_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));
	g_signal_connect_swapped (G_OBJECT (memcard_directory_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));
	g_signal_connect_swapped (G_OBJECT (state_directory_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));
	g_signal_connect_swapped (G_OBJECT (inipath_entry), "changed",
			    G_CALLBACK (gtk_widget_set_sensitive),
			    G_OBJECT (directories_selection_apply_button));

	gtk_window_add_accel_group (GTK_WINDOW (directories_selection), accel_group);
	
	return directories_selection;
}




void
on_dir_browse_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	create_folderselection (user_data, TRUE);
}


void
on_file_browse_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	create_folderselection (user_data, FALSE);
}


void
on_xmame_execs_add_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkTreeIter iter;
	gchar *temp_text, *text;
	gint i, size;
	gboolean already_exist = FALSE;

	temp_text = gtk_editable_get_chars (GTK_EDITABLE (xmame_execs_entry), 0, -1);
	if (strcmp (temp_text, "")) {
		/* Check if what we are trying to add is not already in the list */
		already_exist = FALSE;
		size = gtk_tree_model_iter_n_children (GTK_TREE_MODEL (xmame_execs_tree_model), NULL);
		if (size) {
			for (i = 0; i < size; i++) {
				gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (xmame_execs_tree_model), &iter, NULL, i);
				gtk_tree_model_get (xmame_execs_tree_model, &iter, 0, &text, -1);
				if (!strcmp (text, temp_text))
					already_exist = TRUE;
			}
		}

		if (!already_exist) {
			gtk_list_store_append (GTK_LIST_STORE (xmame_execs_tree_model), &iter);  /* Acquire an iterator */
			gtk_list_store_set (GTK_LIST_STORE (xmame_execs_tree_model), &iter,
					    0,                   temp_text,
					    -1);
			gtk_widget_set_sensitive (directories_selection_apply_button, TRUE);
		} else {
			gxmame_message (WARNING, GTK_WINDOW (directories_selection), _("Executable already in the list."));
		}
	}
	g_free (temp_text);
}

void
on_xmame_execs_remove_button_clicked (GtkButton       *button,
				      gpointer         user_data)
{
	GtkTreeIter iter;

	GtkTreeSelection *select;
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (xmame_execs_tree_view));
	if (gtk_tree_selection_get_selected (select, &xmame_execs_tree_model, &iter)) {
		gtk_tree_selection_unselect_all (select);
		gtk_list_store_remove (GTK_LIST_STORE (xmame_execs_tree_model), &iter);
		gtk_widget_set_sensitive (directories_selection_apply_button, TRUE);
	}
}

void
on_roms_add_button_clicked (GtkButton       *button,
			    gpointer         user_data)
{
	GtkTreeIter iter;
	gchar *temp_text, *text;
	gint i, size;
	gboolean already_exist = FALSE;

	temp_text = gtk_editable_get_chars (GTK_EDITABLE (roms_path_entry), 0, -1);
	if (strcmp (temp_text, "")) {
		/* Check if what we are trying to add is not already in the list */
		already_exist = FALSE;
		size = gtk_tree_model_iter_n_children (GTK_TREE_MODEL (roms_path_tree_model), NULL);
		if (size) {
			for (i = 0; i < size; i++) {
				gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (roms_path_tree_model), &iter, NULL, i);
				gtk_tree_model_get (roms_path_tree_model, &iter, 0, &text, -1);
				if (!strcmp (text,temp_text))
					already_exist = TRUE;
			}
		}

		if (!already_exist) {
			gtk_list_store_append (GTK_LIST_STORE (roms_path_tree_model), &iter);  /* Acquire an iterator */
			gtk_list_store_set (GTK_LIST_STORE (roms_path_tree_model), &iter,
					    0,                   temp_text,
					    -1);
			gtk_widget_set_sensitive (directories_selection_apply_button, TRUE);
		} else {
			gxmame_message (WARNING, GTK_WINDOW (directories_selection), _("Rom Path already in the list."));
		}
	}
	g_free (temp_text);
}

void
on_roms_remove_button_clicked (GtkButton       *button,
			       gpointer         user_data)
{
	GtkTreeIter iter;

	GtkTreeSelection *select;
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (roms_path_tree_view));
	if (gtk_tree_selection_get_selected (select, &roms_path_tree_model, &iter)) {
		gtk_tree_selection_unselect_all (select);
		gtk_list_store_remove (GTK_LIST_STORE (roms_path_tree_model), &iter);
		gtk_widget_set_sensitive (directories_selection_apply_button, TRUE);
	}
}

void
on_samples_add_button_clicked (GtkButton       *button,
			       gpointer         user_data)
{
	GtkTreeIter iter;
	gchar *temp_text, *text;
	gint i, size;
	gboolean already_exist = FALSE;

	temp_text = gtk_editable_get_chars (GTK_EDITABLE (samples_path_entry), 0, -1);
	if (strcmp (temp_text, "")) {
		/* Check if what we are trying to add is not already in the list */
		already_exist = FALSE;
		size = gtk_tree_model_iter_n_children (GTK_TREE_MODEL (samples_path_tree_model), NULL);
		if (size) {
			for (i = 0; i < size; i++) {
				gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (samples_path_tree_model), &iter, NULL, i);
				gtk_tree_model_get (samples_path_tree_model, &iter, 0, &text, -1);
				if (!strcmp (text,temp_text))
					already_exist = TRUE;
			}
		}

		if (!already_exist) {
			gtk_list_store_append (GTK_LIST_STORE (samples_path_tree_model), &iter);  /* Acquire an iterator */
			gtk_list_store_set (GTK_LIST_STORE (samples_path_tree_model), &iter,
					    0,                   temp_text,
					    -1);
			gtk_widget_set_sensitive (directories_selection_apply_button, TRUE);
		} else {
			gxmame_message (WARNING, GTK_WINDOW (directories_selection), _("Sample Path already in the list."));
		}
	}
	g_free (temp_text);
}

void
on_samples_remove_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkTreeIter iter;

	GtkTreeSelection *select;
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (samples_path_tree_view));
	if (gtk_tree_selection_get_selected (select, &samples_path_tree_model, &iter)) {
		gtk_tree_selection_unselect_all (select);
		gtk_list_store_remove (GTK_LIST_STORE (samples_path_tree_model), &iter);
		gtk_widget_set_sensitive (directories_selection_apply_button, TRUE);
	}
}

void
directories_selection_close_window (GtkWidget *widget)
{
	if (GTK_IS_WIDGET (widget))
		gtk_widget_destroy (widget);
}

#if 0
static gboolean
remove_hash_value (gpointer key,
		   gpointer value,
		   gpointer user_data)
{
	g_free (value);
	return TRUE;
}
#endif

void
directories_selection_save_changes (GtkWidget *widget)
{
	GtkTreeIter iter;
	int size;
	gint i;
	gchar *text = NULL;
	gboolean changed_flag;

	gtk_widget_set_sensitive (directories_selection_apply_button, FALSE);

	/* free the main config paths*/
	/* GXMame */
	g_free (gui_prefs.FlyerDirectory);
	g_free (gui_prefs.CabinetDirectory);
	g_free (gui_prefs.MarqueeDirectory);
	g_free (gui_prefs.TitleDirectory);
	g_free (gui_prefs.IconDirectory);
	/* XMame basic */
	g_strfreev (gui_prefs.SamplePath);
	g_free (gui_prefs.DiffDirectory);
	g_free (gui_prefs.ArtworkDirectory);
	/* XMame additional */
	g_free (gui_prefs.SnapshotDirectory);
	g_free (gui_prefs.HistoryFile);
	g_free (gui_prefs.MameInfoFile);
	g_free (gui_prefs.CheatFile);
	g_free (gui_prefs.HiscoreFile);
	/* User Resources */
	g_free (gui_prefs.HiscoreDirectory);
	g_free (gui_prefs.InputDirectory);
	g_free (gui_prefs.ConfigDirectory);
	g_free (gui_prefs.NVRamDirectory);
	g_free (gui_prefs.MemCardDirectory);
	g_free (gui_prefs.StateDirectory);
	g_free (gui_prefs.inipath);


	/* and replace them by the new ones*/
	/* GXMame */
	if (strcmp (gui_prefs.catverDirectory, gtk_editable_get_chars (GTK_EDITABLE (common_path_entry), 0, -1))) {
		GXMAME_DEBUG ("catver changed %s - %s",gui_prefs.catverDirectory, gtk_editable_get_chars (GTK_EDITABLE (common_path_entry), 0, -1));
		g_free (gui_prefs.catverDirectory);
		gui_prefs.catverDirectory = gtk_editable_get_chars (GTK_EDITABLE (common_path_entry), 0, -1);
		/* Updating with the new catver file */
		g_list_foreach (game_list.versions, (GFunc)g_free, NULL);
		g_list_free (game_list.versions);
		game_list.versions = NULL;
		load_catver_ini ();

		create_filterslist_content ();

		/* Updating the UI if necessary */
		if ( (current_filter->type == CATEGORY) || (current_filter->type == MAMEVER)
		     || (gui_prefs.FolderID == CATEGORIES) || (gui_prefs.FolderID == VERSIONS) ) {
			gui_prefs.FolderID = AVAILABLE;
			gxmame_message (WARNING, GTK_WINDOW (directories_selection), _("Current Folder may not exist after loading the new catver file.\nMoving to the \"Available\" game folder"));
			create_gamelist_content ();
		} else if ( (gui_prefs.current_mode == DETAILS || gui_prefs.current_mode == DETAILS_TREE)
			  && (gui_prefs.ColumnShown[MAMEVER]==TRUE || gui_prefs.ColumnShown[CATEGORY] == TRUE)) {
			create_gamelist_content ();
		}
	}

	gui_prefs.FlyerDirectory = gtk_editable_get_chars (GTK_EDITABLE (flyer_path_entry), 0, -1);
	gui_prefs.CabinetDirectory = gtk_editable_get_chars (GTK_EDITABLE (cabinet_path_entry), 0, -1);
	gui_prefs.MarqueeDirectory = gtk_editable_get_chars (GTK_EDITABLE (marquee_path_entry), 0, -1);
	gui_prefs.TitleDirectory = gtk_editable_get_chars (GTK_EDITABLE (title_path_entry), 0, -1);
	gui_prefs.IconDirectory = gtk_editable_get_chars (GTK_EDITABLE (icons_path_entry), 0, -1);

	/* XMame additional */
	gui_prefs.SnapshotDirectory = gtk_editable_get_chars (GTK_EDITABLE (snapshot_path_entry), 0, -1);
	gui_prefs.HistoryFile = gtk_editable_get_chars (GTK_EDITABLE (historyfile_path_entry), 0, -1);
	gui_prefs.MameInfoFile = gtk_editable_get_chars (GTK_EDITABLE (mameinfofile_path_entry), 0, -1);
	gui_prefs.HiscoreFile = gtk_editable_get_chars (GTK_EDITABLE (hiscorefile_path_entry), 0, -1);
	gui_prefs.CheatFile = gtk_editable_get_chars (GTK_EDITABLE (cheatfile_path_entry), 0, -1);
	/* If the ctrlr directory has changed, we reload the default options */
	if (!gtk_editable_get_chars (GTK_EDITABLE (ctrlr_directory_entry), 0, -1)
	    || strcmp (gui_prefs.CtrlrDirectory, gtk_editable_get_chars (GTK_EDITABLE (ctrlr_directory_entry), 0, -1)))
	{
		g_free (gui_prefs.CtrlrDirectory);
		gui_prefs.CtrlrDirectory = gtk_editable_get_chars (GTK_EDITABLE (ctrlr_directory_entry), 0, -1);
		load_options (NULL);
	}

	/* User Resources */
	gui_prefs.HiscoreDirectory = gtk_editable_get_chars (GTK_EDITABLE (hiscore_path_entry), 0, -1);
	gui_prefs.InputDirectory = gtk_editable_get_chars (GTK_EDITABLE (input_path_entry), 0, -1);
	gui_prefs.ConfigDirectory = gtk_editable_get_chars (GTK_EDITABLE (cfg_directory_entry), 0, -1);
	gui_prefs.NVRamDirectory = gtk_editable_get_chars (GTK_EDITABLE (nvram_directory_entry), 0, -1);
	gui_prefs.MemCardDirectory = gtk_editable_get_chars (GTK_EDITABLE (memcard_directory_entry), 0, -1);
	gui_prefs.StateDirectory = gtk_editable_get_chars (GTK_EDITABLE (state_directory_entry), 0, -1);
	gui_prefs.inipath = gtk_editable_get_chars (GTK_EDITABLE (inipath_entry), 0, -1);


	/* XMame basic */
	gui_prefs.DiffDirectory = gtk_editable_get_chars (GTK_EDITABLE (diffdir_path_entry), 0, -1);
	gui_prefs.ArtworkDirectory = gtk_editable_get_chars (GTK_EDITABLE (artwork_path_entry), 0, -1);

	/* Transform the list content into a array of char terminated by a NULL element */
	/* Samples Path */
	size = gtk_tree_model_iter_n_children (GTK_TREE_MODEL (samples_path_tree_model),NULL);
	if (size) {
		gui_prefs.SamplePath = g_new (gchar *, (size+1));
		for (i = 0; i < size; i++) {
			gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (samples_path_tree_model), &iter, NULL, i);
			gtk_tree_model_get (samples_path_tree_model, &iter, 0, &text, -1);
			gui_prefs.SamplePath[i] = g_strdup (text);
		}
		gui_prefs.SamplePath[size] = NULL;
	} else {
		gui_prefs.SamplePath = g_new (gchar *, 1);
		gui_prefs.SamplePath[0] = NULL;
	}

	/* Roms Path */
	size = gtk_tree_model_iter_n_children (GTK_TREE_MODEL (roms_path_tree_model), NULL);
	changed_flag = FALSE;
	i = 0;
	while (gui_prefs.RomPath[i])
		i++;
	if (i == size) {
		for (i = 0; i < size; i++) {
			gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (roms_path_tree_model), &iter, NULL, i);
			gtk_tree_model_get (roms_path_tree_model, &iter, 0, &text, -1);
			if (strcmp (gui_prefs.RomPath[i], text))
				changed_flag = TRUE;
		}
	} else {
		changed_flag = TRUE;
	}

	if (changed_flag) {
		GXMAME_DEBUG ("rom path changed");
		if (size) {
			g_strfreev (gui_prefs.RomPath);
			gui_prefs.RomPath = g_new (gchar *, (size + 1));
			for (i = 0; i < size; i++) {
				gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (roms_path_tree_model), &iter, NULL, i);
				gtk_tree_model_get (roms_path_tree_model, &iter, 0, &text, -1);
				gui_prefs.RomPath[i] = g_strdup (text);
			}
			gui_prefs.RomPath[size] = NULL;
		} else {
			gui_prefs.RomPath = g_new (gchar *, 1);
			gui_prefs.RomPath[0] = NULL;
		}
		/* Do we perform the quickcheck? */
		/*
		GtkWidget *dialog;
		gint result;
		dialog = gtk_message_dialog_new (GTK_WINDOW (directories_selection),
						GTK_DIALOG_MODAL,
						GTK_MESSAGE_WARNING,
						GTK_BUTTONS_YES_NO,
						_("The Rom Path has been modified.\nDo you want to refresh the gamelist after the directory window is closed?"));
		result = gtk_dialog_run (GTK_DIALOG (dialog));
		switch (result)
		{
			case GTK_RESPONSE_YES:
				refresh_game_list=TRUE;
				break;
			default:
				break;
		}
		gtk_widget_destroy (dialog);
		*/
	}


	/* XMame Executables */
	current_exec = NULL;
	xmame_table_free ();
	xmame_table_init ();
	size = gtk_tree_model_iter_n_children (GTK_TREE_MODEL (xmame_execs_tree_model),NULL);
	for (i = 0; i < size; i++) {
		gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (xmame_execs_tree_model), &iter, NULL, i);
		gtk_tree_model_get (xmame_execs_tree_model, &iter, 0, &text, -1);
		xmame_table_add (text);
	}

	GXMAME_DEBUG ("Setting current executable to the 1st one");

	/* remove and destroy the submenu */
	add_exec_menu ();

	/* here we should already have a valid executable except if mame is not present in path */
	if (!current_exec) {
		gxmame_message (ERROR, GTK_WINDOW (directories_selection), _("No valid xmame executables found"));
	}
}




void
directories_selection_save_and_close (GtkWidget *widget)
{
	directories_selection_save_changes (widget);
	directories_selection_close_window (widget);
}

void
on_xmame_execs_tree_view_select         (GtkTreeSelection *selection, gpointer user_data)
{
	GtkTreeIter iter;
	gchar *text;

	if (gtk_tree_selection_get_selected (selection, &xmame_execs_tree_model, &iter)) {
		gtk_tree_model_get (xmame_execs_tree_model, &iter, 0, &text, -1);
		gtk_entry_set_text (GTK_ENTRY (user_data), text);
	}
}

void
on_roms_path_tree_view_select         (GtkTreeSelection *selection, gpointer user_data)
{
	GtkTreeIter iter;
	gchar *text;

	if (gtk_tree_selection_get_selected (selection, &roms_path_tree_model, &iter)) {
		gtk_tree_model_get (roms_path_tree_model, &iter, 0, &text, -1);
		gtk_entry_set_text (GTK_ENTRY (user_data), text);
	}
}

void
on_samples_path_tree_view_select         (GtkTreeSelection *selection, gpointer user_data)
{
	GtkTreeIter iter;
	gchar *text;

	if (gtk_tree_selection_get_selected (selection, &samples_path_tree_model, &iter)) {
		gtk_tree_model_get (samples_path_tree_model, &iter, 0, &text, -1);
		gtk_entry_set_text (GTK_ENTRY (user_data), text);
	}
}
